/*****************************************************************
/
/ File   :   T0Hndlr.c
/ Author :   David Corcoran
/ Date   :   October 15, 1999
/ Purpose:   This provides a T=0 handler.
/            See http://www.linuxnet.com for more information.
/ License:   See file LICENSE
/
******************************************************************/

#ifndef TARGET_OSX
#include "config.h"
#endif
#include "pcscdefines.h"
#include "T0Hndlr.h"
#include "AdmHndlr.h"
#include <string.h>

ULONG T0_ExchangeData( DWORD Lun, DWORD slotIndex, PUCHAR pRequest, ULONG RequestLen,
                       PUCHAR pReply, PULONG pReplyLen ) {

  ULONG rv;
  UCHAR ucTxBuffer[MAX_BUFFER_SIZE*2]; /* For byte splitting */
  
  ucTxBuffer[0] = 0x01;
  ucTxBuffer[1] = slotIndex == 0 ? 0xA0 : 0xB0;
  ucTxBuffer[2] = RequestLen / 256;
  ucTxBuffer[3] = RequestLen % 256;
  memcpy(&ucTxBuffer[4], pRequest, RequestLen);

  Adm_SetWWT( Lun, 60 );

  rv = Adm_Transmit( Lun, ucTxBuffer, RequestLen+4, pReply, pReplyLen );

  return rv;
}


