// This code conforms with the UFC specification version 2.1.0+
// and was automatically generated by FFC version 1.1.0+.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __POISSON3D_5_H
#define __POISSON3D_5_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class poisson3d_5_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  poisson3d_5_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~poisson3d_5_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 5, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 56;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923452, 0.00609788120679252, 0.00352061335622801, 0.00248944957812476, 0.00705946233325035, 0.00546823600997146, 0.00446479600584761, 0.00315708753234941, 0.00257775117585288, 0.00182274533665716, -0.00298267418725715, -0.00252081977982931, -0.00218309396769447, -0.00195261860521384, -0.00169101731601733, -0.00138070985681772, -0.0011273448773449, -0.000976309302606943, -0.000797153207506487, -0.000563672438672445, 0.00278687112460007, 0.00245778931055955, 0.00219831358911339, 0.00207721109304567, 0.00185791408306669, 0.00160900079398463, 0.00160900079398464, 0.00143913406048031, 0.00124632665582739, 0.00101762145320215, 0.000928957041533368, 0.000830884437218254, 0.000719567030240159, 0.000587524019939406, 0.000415442218609135, -0.00705593524717797, -0.00638233357089079, -0.00582624677716565, -0.00562868913761196, -0.00513826668309062, -0.00459580543596521, -0.00475711057319694, -0.00434262794914382, -0.00388416451811044, -0.00336378514516178, -0.00368484200521178, -0.00336378514516176, -0.00300866089851429, -0.00260557676948629, -0.00212744452363026, -0.00212744452363026, -0.00194208225905519, -0.00173705117965752, -0.00150433044925714, -0.00122828066840393, -0.000868525589828762};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923487, -0.00609788120679259, 0.00352061335622804, 0.00248944957812477, 0.0070594623332504, -0.0054682360099715, -0.00446479600584757, 0.00315708753234942, 0.00257775117585286, 0.00182274533665716, 0.00298267418725716, -0.00252081977982929, -0.00218309396769447, 0.00195261860521384, 0.00169101731601731, 0.00138070985681772, -0.00112734487734488, -0.000976309302606918, -0.000797153207506475, -0.000563672438672439, 0.00278687112460003, -0.00245778931055953, -0.00219831358911339, 0.00207721109304566, 0.00185791408306669, 0.00160900079398462, -0.00160900079398463, -0.0014391340604803, -0.0012463266558274, -0.00101762145320216, 0.00092895704153335, 0.000830884437218259, 0.000719567030240153, 0.000587524019939406, 0.000415442218609129, 0.00705593524717798, -0.00638233357089082, -0.00582624677716566, 0.00562868913761197, 0.00513826668309062, 0.0045958054359652, -0.00475711057319694, -0.00434262794914382, -0.00388416451811044, -0.00336378514516178, 0.00368484200521179, 0.00336378514516178, 0.00300866089851429, 0.00260557676948629, 0.00212744452363026, -0.00212744452363027, -0.00194208225905521, -0.00173705117965753, -0.00150433044925715, -0.00122828066840393, -0.000868525589828762};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923503, 0.0, -0.00704122671245617, 0.00248944957812476, 0.0, 0.0, 0.0, 0.00947126259704828, -0.00515550235170574, 0.00182274533665714, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00450937950937953, -0.00292892790782074, 0.00159430641501298, -0.000563672438672429, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00464478520766671, -0.00332353774887302, 0.00215870109072045, -0.00117504803987881, 0.000415442218609134, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0127646671417816, -0.0097104112952761, 0.00694820471863011, -0.00451299134777143, 0.00245656133680785, -0.000868525589828767};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923512, 0.0, 0.0, -0.00746834873437425, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0109364720199429, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00563672438672438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00623163327913695, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734309, 0.0, 0.03747187483114, -0.0289614183593723, 0.0, 0.0, 0.0, 0.0284137877911448, 0.00515550235170569, -0.00619733414463433, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0315656565656565, -0.0113902751970807, 0.00265717735835488, -0.00018789081289079, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0232239260383337, -0.00166176887443655, -0.00647610327216137, 0.00646276421933346, -0.00290809553026392, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0213629048496074, -0.0277928188745204, 0.0243701532779658, -0.0157219925555703, 0.00607967912880134};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734309, 0.0, -0.028757485335526, 0.05360943398437, 0.0, 0.0, 0.0, -0.0189425251940965, 0.0154665070551172, 0.0153110608279201, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00450937950937952, 0.0370997534990628, -0.0281660799985623, 0.0108976671476671, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0299118397398575, -0.00431740218144093, -0.0123380044187275, 0.00872428659079177, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0312669212338356, -0.0487403065559316, 0.041270230458372, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734309, 0.0, 0.0409576306293855, -0.0449826285156207, 0.0, 0.0, 0.0, 0.0189425251940966, -0.00515550235170566, -0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00455611007883225, 0.0356061766019561, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0302218152700864, 0.00411266813957584, -0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0379091273212801, -0.0550269739444961, 0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0, -0.0148144621425437, 0.0449826285156208, 0.0, 0.0, 0.0, 0.0, 0.0206220094068229, 0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0106287094334197, 0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.020563340697879, 0.0145404776513197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0343918587153101, -0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0324515955311977, -0.0187359374155699, -0.0289614183593722, 0.0211783869997511, -0.0164047080299144, 0.00446479600584756, 0.00947126259704831, -0.00257775117585287, -0.00619733414463433, 0.0208787193108001, -0.0176457384588052, -0.00848980987436739, 0.0136683302364968, 0.00657617845117845, 0.0023011830946962, -0.00789141414141415, -0.0037967583990269, -0.00132858867917748, -0.00018789081289079, 0.0139343556230002, -0.0122889465527977, -0.00109915679455668, 0.0103860554652283, 0.000928957041533339, -0.00482700238195388, -0.00804500396992314, -0.000719567030240154, 0.00373897996748219, 0.00559691799261186, 0.00464478520766674, 0.000415442218609136, -0.00215870109072048, -0.00323138210966669, -0.00290809553026392, 0.0, 0.0, 0.0128177429097644, 0.0, -0.0113041867027994, -0.0183832217438608, 0.0, 0.00955378148811639, 0.0155366580724417, 0.0181644397838736, 0.0, -0.00740032731935591, -0.0120346435940572, -0.014070114555226, -0.0136156449512337, 0.0, 0.00427258096992147, 0.00694820471863013, 0.00812338442598859, 0.00786099627778514, 0.00607967912880134};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734312, -0.0249047128495239, 0.0143787426677629, 0.05360943398437, -0.0141189246665007, 0.0109364720199429, 0.0133943880175427, -0.00631417506469885, -0.00773325352755858, 0.0153110608279201, -0.00298267418725716, 0.00252081977982934, 0.0276525235907967, -0.00195261860521384, -0.0214195526695527, -0.0243925408037797, 0.00112734487734488, 0.0123665844996876, 0.0140830399992811, 0.0108976671476671, 0.0, 0.0, 0.0197848223020205, 0.0, -0.0167212267476002, -0.00321800158796925, 0.0, 0.0129522065443228, 0.00249265331165477, -0.0106850252586227, 0.0, -0.00747795993496439, -0.0014391340604803, 0.00616900220936372, 0.00872428659079177, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0206811244618434, 0.0, 0.0, -0.017478740331497, -0.0363288795677472, 0.0, 0.0, 0.0135389740433143, 0.0281402291104519, 0.0357410679969885, 0.0, 0.0, -0.00781673030845889, -0.0162467688519772, -0.020635115229186, -0.018239037386404};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734311, 0.0354703486038675, -0.0204788153146928, -0.0449826285156207, 0.0141189246665008, -0.0109364720199429, -0.00446479600584754, 0.00631417506469884, 0.00257775117585279, -0.0211438459052229, 0.0, 0.0, 0.00339592394974695, 0.0, -0.00263047138047138, 0.0308358534689291, 0.0, 0.00151870335961074, -0.017803088300978, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0225260111157848, 0.0, 0.0, -0.0174485731815835, 0.00356167508620756, 0.0, 0.0, 0.0100739384233621, -0.0020563340697879, -0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0282557952193589, 0.0, 0.0, 0.0, -0.0218868448636848, -0.047654757329318, 0.0, 0.0, 0.0, 0.01263637577376, 0.027513486972248, 0.0303983956440067};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.010023442173431, -0.0128297005588457, 0.00740723107127189, 0.0449826285156207, 0.0, 0.0, 0.0178591840233902, 0.0, -0.0103110047034114, 0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00920473237878475, 0.0, 0.0, -0.00531435471670986, 0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0178083754310377, 0.0, 0.0, 0.0, -0.0102816703489396, 0.0145404776513196, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0297842233308238, 0.0, 0.0, 0.0, 0.0, -0.017195929357655, -0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734309, 0.0324515955311979, -0.0335503995581135, -0.00801060507812417, 0.0211783869997512, 0.00109364720199426, -0.0169662248222207, -0.00568275755822896, 0.00567105258687628, 0.00838462854862288, 0.0208787193108001, -0.0109235523792603, -0.0162519217595033, 0.00499002532443533, 0.00958243145743146, 0.0108922666482286, -0.00187890812890814, -0.00466458889023306, -0.00558007245254537, -0.00469727032227031, 0.0139343556230002, -0.00245778931055954, -0.0120907247401236, -0.00415442218609133, 0.00464478520766674, 0.00965400476390777, 0.00643600317593853, -0.000719567030240145, -0.00498530662330958, -0.006614539445814, -0.00464478520766673, -0.000415442218609137, 0.00215870109072044, 0.00323138210966672, 0.00290809553026393, 0.0, 0.0127646671417816, -0.00116524935543313, -0.0202632808954031, -0.00719357335632687, 0.00183832217438609, 0.0228341307513453, 0.0112908326677739, 0.00310733161448834, -0.00201827108709707, -0.020635115229186, -0.01143686949355, -0.00481385743762287, -0.000521115353897262, 0.00170195561890421, 0.0127646671417816, 0.00737991258440982, 0.00347410235931507, 0.000902598269554291, -0.000491312267361578, -0.000868525589828769};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734312, -0.0249047128495239, 0.0553363732971483, -0.00431340273437462, -0.0141189246665008, 0.01531106082792, 0.00803663281052559, 0.00883984509057836, -0.0159820572902877, 0.000729098134662842, -0.00298267418725715, 0.0277290175781224, -0.00145539597846296, -0.0301571095694136, -0.0116492303992304, 0.00352848074520084, 0.0191648629148629, 0.00976309302606916, 0.00132858867917747, -0.00263047138047138, 0.0, 0.0196623144844763, -0.00219831358911338, -0.0072702388256598, -0.0148633126645336, 0.00402250198496158, -0.00724050357293082, 0.0129522065443227, 0.00685479660705068, -0.00457929653940971, 0.00928957041533346, -0.00664707549774609, -0.0057565362419212, -0.00029376200996971, 0.00290809553026395, 0.0, 0.0, 0.0, 0.0202632808954031, -0.00411061334647249, 0.00045958054359652, -0.0399597288148543, -0.00303983956440069, 0.00427258096992148, -0.00100913554354853, 0.0464290092656685, 0.00908221989193679, -0.00270779480866285, -0.00234501909253766, 0.00127646671417817, -0.031911667854454, -0.00776832903622087, 0.000868525589828756, 0.00180519653910858, 0.000245656133680792, -0.000868525589828773};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734311, 0.0354703486038674, -0.0492363006502187, -0.00431340273437458, 0.0141189246665008, -0.00656188321196576, -0.00982255121286466, -0.0164168551682169, 0.0149509568199466, 0.000729098134662877, 0.0, 0.0033610930397724, -0.000485131992821009, 0.0282044909641998, -0.0124007936507936, 0.0029148319199485, -0.0353234728234728, 0.00889526253486301, 0.00239145962251946, -0.00263047138047138, 0.0, 0.0, 0.0, 0.0218107164769794, -0.00557374224920009, 0.000804500396992311, -0.00402250198496155, -0.014391340604803, 0.00934744991870547, -0.00254405363300537, -0.0092895704153335, 0.0141250354327105, -0.00287826812096064, -0.00381890612960613, 0.00290809553026391, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0266398192099028, -0.00911951869320202, 0.00233049871086625, -0.000336378514516179, -0.0515877880729651, 0.00840946286290446, 0.00300866089851429, -0.00286613444643492, 0.000850977809452106, 0.0425488904726053, -0.00388416451811045, -0.00347410235931507, 0.00120346435940572, 0.000982624534723146, -0.000868525589828758};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.010023442173431, -0.0128297005588457, 0.0448791059024117, -0.00801060507812426, 0.0, 0.0174983552319087, -0.00357183680467802, 0.0132597676358676, -0.0175287079957995, 0.0083846285486229, 0.0, 0.0, 0.0, 0.00867830491206152, -0.00300625300625301, 0.000613648825252303, 0.0225468975468976, -0.019200749617936, 0.0122230158484327, -0.00469727032227033, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0160900079398463, -0.00719567030240152, 0.00249265331165479, -0.000508810726601086, 0.00464478520766674, -0.0108014976838374, 0.0107935054536023, -0.00734405024924252, 0.00290809553026394, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0257938940364826, -0.0134551405806471, 0.00601732179702859, -0.00208446141558904, 0.000425488904726059, -0.031911667854454, 0.0135945758133865, -0.00347410235931504, -0.000902598269554292, 0.0017195929357655, -0.000868525589828772};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734314, -0.0324515955311979, -0.0187359374155699, -0.0289614183593722, 0.0211783869997512, 0.0164047080299144, -0.00446479600584759, 0.00947126259704827, -0.00257775117585287, -0.00619733414463428, -0.0208787193108001, -0.0176457384588052, -0.00848980987436741, -0.0136683302364968, -0.00657617845117843, -0.0023011830946962, -0.00789141414141415, -0.00379675839902689, -0.00132858867917749, -0.000187890812890804, 0.0139343556230002, 0.0122889465527977, 0.00109915679455668, 0.0103860554652283, 0.000928957041533344, -0.00482700238195389, 0.00804500396992313, 0.000719567030240155, -0.0037389799674822, -0.00559691799261186, 0.00464478520766673, 0.000415442218609135, -0.00215870109072046, -0.0032313821096667, -0.00290809553026394, 0.0, 0.0, 0.0128177429097644, 0.0, 0.0113041867027994, 0.0183832217438608, 0.0, 0.0095537814881164, 0.0155366580724417, 0.0181644397838736, 0.0, 0.00740032731935589, 0.0120346435940572, 0.014070114555226, 0.0136156449512337, 0.0, 0.00427258096992147, 0.00694820471863012, 0.00812338442598859, 0.00786099627778515, 0.00607967912880135};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734309, 0.0249047128495239, 0.014378742667763, 0.0536094339843698, -0.0141189246665007, -0.0109364720199429, -0.0133943880175427, -0.00631417506469886, -0.0077332535275586, 0.01531106082792, 0.00298267418725715, 0.00252081977982933, 0.0276525235907967, 0.00195261860521382, 0.0214195526695527, 0.0243925408037797, 0.00112734487734487, 0.0123665844996876, 0.0140830399992811, 0.0108976671476671, 0.0, 0.0, -0.0197848223020205, 0.0, -0.0167212267476002, -0.00321800158796925, 0.0, -0.0129522065443228, -0.00249265331165476, 0.0106850252586226, 0.0, -0.00747795993496438, -0.0014391340604803, 0.00616900220936374, 0.00872428659079181, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0206811244618434, 0.0, 0.0, -0.017478740331497, -0.0363288795677472, 0.0, 0.0, -0.0135389740433143, -0.0281402291104519, -0.0357410679969884, 0.0, 0.0, -0.00781673030845888, -0.0162467688519772, -0.020635115229186, -0.018239037386404};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734312, -0.0354703486038674, -0.0204788153146927, -0.0449826285156206, 0.0141189246665007, 0.0109364720199429, 0.00446479600584754, 0.00631417506469883, 0.00257775117585287, -0.0211438459052229, 0.0, 0.0, 0.00339592394974696, 0.0, 0.00263047138047138, -0.0308358534689291, 0.0, 0.00151870335961076, -0.0178030883009781, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0225260111157848, 0.0, 0.0, 0.0174485731815835, -0.00356167508620757, 0.0, 0.0, 0.0100739384233621, -0.00205633406978792, -0.0145404776513197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0282557952193589, 0.0, 0.0, 0.0, 0.0218868448636848, 0.047654757329318, 0.0, 0.0, 0.0, 0.01263637577376, 0.0275134869722481, 0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734309, 0.0128297005588457, 0.00740723107127184, 0.0449826285156208, 0.0, 0.0, -0.0178591840233902, 0.0, -0.0103110047034115, 0.0211438459052229, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00920473237878478, 0.0, 0.0, -0.00531435471670987, 0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0178083754310377, 0.0, 0.0, 0.0, -0.0102816703489396, 0.0145404776513197, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0297842233308237, 0.0, 0.0, 0.0, 0.0, -0.017195929357655, -0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734307, -0.0324515955311978, -0.0335503995581136, -0.00801060507812425, 0.0211783869997512, -0.00109364720199428, 0.0169662248222207, -0.00568275755822894, 0.00567105258687627, 0.00838462854862292, -0.0208787193108001, -0.0109235523792603, -0.0162519217595033, -0.00499002532443533, -0.00958243145743146, -0.0108922666482287, -0.00187890812890813, -0.00466458889023304, -0.00558007245254535, -0.00469727032227032, 0.0139343556230002, 0.00245778931055953, 0.0120907247401236, -0.00415442218609134, 0.00464478520766674, 0.00965400476390777, -0.00643600317593851, 0.000719567030240153, 0.00498530662330959, 0.00661453944581401, -0.00464478520766677, -0.000415442218609121, 0.00215870109072045, 0.00323138210966672, 0.00290809553026392, 0.0, 0.0127646671417816, -0.00116524935543312, 0.0202632808954031, 0.00719357335632687, -0.00183832217438608, 0.0228341307513453, 0.0112908326677739, 0.00310733161448834, -0.00201827108709707, 0.020635115229186, 0.0114368694935501, 0.00481385743762287, 0.000521115353897252, -0.00170195561890421, 0.0127646671417816, 0.00737991258440981, 0.00347410235931507, 0.000902598269554277, -0.000491312267361576, -0.000868525589828769};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734306, 0.024904712849524, 0.0553363732971482, -0.00431340273437463, -0.0141189246665008, -0.0153110608279201, -0.00803663281052559, 0.00883984509057835, -0.0159820572902877, 0.000729098134662837, 0.00298267418725713, 0.0277290175781224, -0.00145539597846299, 0.0301571095694136, 0.0116492303992304, -0.00352848074520083, 0.0191648629148629, 0.00976309302606917, 0.00132858867917747, -0.00263047138047135, 0.0, -0.0196623144844763, 0.00219831358911336, -0.00727023882565977, -0.0148633126645335, 0.00402250198496157, 0.00724050357293085, -0.0129522065443228, -0.00685479660705068, 0.00457929653940969, 0.00928957041533352, -0.00664707549774611, -0.00575653624192119, -0.000293762009969712, 0.00290809553026392, 0.0, 0.0, 0.0, -0.0202632808954031, 0.00411061334647247, -0.00045958054359652, -0.0399597288148542, -0.00303983956440067, 0.00427258096992149, -0.00100913554354853, -0.0464290092656685, -0.00908221989193682, 0.00270779480866286, 0.00234501909253766, -0.00127646671417816, -0.031911667854454, -0.00776832903622085, 0.000868525589828735, 0.00180519653910859, 0.000245656133680784, -0.000868525589828764};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734315, -0.0354703486038674, -0.0492363006502187, -0.00431340273437459, 0.0141189246665008, 0.00656188321196577, 0.00982255121286466, -0.016416855168217, 0.0149509568199466, 0.000729098134662873, 0.0, 0.00336109303977241, -0.000485131992820998, -0.0282044909641998, 0.0124007936507936, -0.00291483191994852, -0.0353234728234728, 0.008895262534863, 0.00239145962251946, -0.0026304713804714, 0.0, 0.0, 0.0, 0.0218107164769794, -0.00557374224920008, 0.000804500396992315, 0.00402250198496156, 0.014391340604803, -0.00934744991870546, 0.00254405363300538, -0.00928957041533351, 0.0141250354327105, -0.00287826812096063, -0.00381890612960613, 0.00290809553026392, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0266398192099028, -0.00911951869320202, 0.00233049871086625, -0.000336378514516176, 0.0515877880729651, -0.00840946286290444, -0.00300866089851428, 0.00286613444643492, -0.000850977809452104, 0.0425488904726053, -0.00388416451811045, -0.00347410235931505, 0.00120346435940571, 0.000982624534723157, -0.000868525589828761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.010023442173431, 0.0128297005588456, 0.0448791059024117, -0.00801060507812422, 0.0, -0.0174983552319087, 0.00357183680467806, 0.0132597676358676, -0.0175287079957995, 0.00838462854862291, 0.0, 0.0, 0.0, -0.00867830491206145, 0.00300625300625302, -0.000613648825252332, 0.0225468975468975, -0.019200749617936, 0.0122230158484327, -0.00469727032227032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0160900079398463, 0.00719567030240155, -0.00249265331165478, 0.000508810726601092, 0.00464478520766676, -0.0108014976838374, 0.0107935054536023, -0.00734405024924251, 0.00290809553026393, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0257938940364825, 0.0134551405806471, -0.00601732179702859, 0.00208446141558904, -0.000425488904726056, -0.031911667854454, 0.0135945758133865, -0.00347410235931504, -0.000902598269554288, 0.00171959293576549, -0.000868525589828771};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734305, -0.0452812960900435, -0.0113287063442981, -0.00801060507812424, -0.00141189246665006, 0.0164047080299143, 0.0133943880175427, 0.0145226026488074, 0.0118576554089232, 0.00838462854862293, -0.00894802256177148, -0.0142846454190327, -0.0123708658169354, -0.014536160727703, -0.0125886844636845, -0.0102786178229764, -0.00939454064454066, -0.00813591085505764, -0.00664294339588734, -0.00469727032227033, -0.00836061337380013, 0.00245778931055955, 0.00219831358911339, 0.00830884437218262, 0.00743165633226679, 0.0064360031759385, 0.00965400476390778, 0.00863480436288184, 0.00747795993496439, 0.00610572871921294, 0.00650269929073342, 0.00581619106052785, 0.00503696921168106, 0.00411266813957582, 0.00290809553026392, 0.0352796762358899, 0.0191470007126724, 0.017478740331497, 0.00788016479265676, 0.00719357335632689, 0.00643412761035129, 0.000951422114639382, 0.000868525589828756, 0.000776832903622077, 0.000672757029032345, -0.00221090520312707, -0.00201827108709705, -0.00180519653910857, -0.00156334606169178, -0.00127646671417816, -0.00212744452363026, -0.00194208225905521, -0.00173705117965752, -0.00150433044925714, -0.00122828066840393, -0.000868525589828761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734311, 0.0603750614533914, -0.00610007264692973, -0.00431340273437458, -0.00564756986660035, -0.0218729440398858, -0.0178591840233902, 0.00126283501293976, 0.00103110047034114, 0.000729098134662857, 0.0417574386216002, 0.0168054651988621, 0.0145539597846298, -0.000867830491206141, -0.000751563251563245, -0.000613648825252303, -0.00526094276094275, -0.00455611007883229, -0.00372004830169691, -0.00263047138047139, 0.00557374224920013, -0.0196623144844763, -0.0175865087129071, -0.0103860554652283, -0.00928957041533348, -0.00804500396992314, 0.00321800158796925, 0.00287826812096061, 0.00249265331165479, 0.00203524290640428, 0.00650269929073342, 0.00581619106052785, 0.00503696921168108, 0.00411266813957583, 0.00290809553026394, -0.0705593524717798, -0.0127646671417816, -0.0116524935543313, 0.00450295131008955, 0.00411061334647247, 0.00367664434877214, 0.00380568845855755, 0.00347410235931508, 0.00310733161448836, 0.00269102811612943, -0.00073696840104236, -0.000672757029032368, -0.000601732179702867, -0.000521115353897261, -0.000425488904726046, -0.00212744452363026, -0.00194208225905521, -0.00173705117965753, -0.00150433044925714, -0.00122828066840394, -0.000868525589828775};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0100234421734313, -0.0603750614533913, -0.00610007264692978, -0.0043134027343746, -0.00564756986660027, 0.0218729440398858, 0.0178591840233902, 0.00126283501293979, 0.00103110047034115, 0.000729098134662848, -0.0417574386216002, 0.0168054651988621, 0.0145539597846299, 0.000867830491206125, 0.000751563251563236, 0.000613648825252299, -0.00526094276094275, -0.00455611007883226, -0.0037200483016969, -0.00263047138047137, 0.00557374224920005, 0.0196623144844763, 0.0175865087129071, -0.0103860554652283, -0.00928957041533348, -0.00804500396992315, -0.00321800158796927, -0.00287826812096063, -0.0024926533116548, -0.00203524290640429, 0.00650269929073343, 0.00581619106052785, 0.00503696921168108, 0.00411266813957581, 0.00290809553026392, 0.0705593524717798, -0.0127646671417816, -0.0116524935543313, -0.00450295131008957, -0.00411061334647248, -0.00367664434877215, 0.00380568845855754, 0.00347410235931504, 0.00310733161448834, 0.00269102811612942, 0.000736968401042369, 0.000672757029032362, 0.000601732179702872, 0.000521115353897267, 0.000425488904726048, -0.00212744452363027, -0.00194208225905522, -0.00173705117965754, -0.00150433044925714, -0.00122828066840393, -0.000868525589828761};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0100234421734308, 0.0452812960900435, -0.011328706344298, -0.00801060507812424, -0.00141189246665008, -0.0164047080299144, -0.0133943880175427, 0.0145226026488074, 0.0118576554089232, 0.00838462854862291, 0.0089480225617715, -0.0142846454190328, -0.0123708658169354, 0.014536160727703, 0.0125886844636845, 0.0102786178229763, -0.00939454064454067, -0.00813591085505764, -0.00664294339588734, -0.00469727032227033, -0.0083606133738001, -0.00245778931055954, -0.00219831358911341, 0.00830884437218264, 0.00743165633226679, 0.00643600317593851, -0.00965400476390776, -0.00863480436288184, -0.00747795993496438, -0.00610572871921294, 0.00650269929073343, 0.00581619106052784, 0.00503696921168106, 0.00411266813957582, 0.00290809553026394, -0.0352796762358899, 0.0191470007126724, 0.017478740331497, -0.00788016479265674, -0.00719357335632688, -0.00643412761035129, 0.000951422114639399, 0.000868525589828759, 0.00077683290362209, 0.000672757029032359, 0.00221090520312706, 0.00201827108709707, 0.00180519653910857, 0.00156334606169177, 0.00127646671417816, -0.00212744452363025, -0.00194208225905521, -0.00173705117965752, -0.00150433044925714, -0.00122828066840393, -0.000868525589828767};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769579, 0.0679219441350653, -0.00435719474780706, -0.00308100195312481, 0.0705946233325039, -0.0328094160598287, -0.0267887760350854, 0.0126283501293977, 0.03608851646194, -0.00729098134662863, 0.0298267418725716, 0.0151249186789759, 0.0130985638061668, -0.0325436434202305, -0.0229226791726792, -0.0248527774227189, 0.0248015873015873, 0.0169226945785198, 0.0164744996218006, 0.0142797017797018, 0.0, 0.0245778931055954, 0.0219831358911339, -0.0363511941282991, -0.00743165633226679, -0.0345935170706696, 0.0362025178646541, 0.0, 0.0130864298861876, 0.0335815079556711, -0.0232239260383337, 0.00166176887443656, -0.00359783515120076, -0.0146881004984851, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0226083734055987, -0.00459580543596521, 0.0, -0.0334382352084074, -0.0194208225905522, 0.00908221989193682, 0.0, 0.0333014729371016, 0.0270779480866286, 0.00703505727761298, -0.0102117337134253, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598858, 0.0019652490694463, 0.00607967912880137};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.021478804657352, 0.00377344134083707, 0.00217859737390362, -0.0215670136718729, 0.0, 0.0984282481794863, -0.0312535720409329, -0.0852413633734345, -0.01804425823097, 0.0309866707231716, 0.0, 0.0453747560369276, -0.0116431678277039, 0.0, 0.0236742424242425, -0.00138070985681773, -0.0202922077922078, -0.0335199527228374, -0.000797153207506565, 0.00394570707070709, 0.0, 0.0, 0.0, 0.036351194128299, 0.024152883079867, -0.00724050357293084, -0.0603375297744235, 0.0, -0.039259289658563, 0.0188259968842399, 0.0464478520766673, -0.0108014976838374, 0.0259044130886455, 0.010869194368879, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0334382352084074, -0.0155366580724417, 0.00302740663064559, 0.0, -0.0555024548951693, 0.0, 0.0164151336477636, -0.00680782247561685, 0.0, 0.0427258096992147, 0.00694820471863017, -0.0108311792346515, -0.00393049813889261, 0.00607967912880133};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 30:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769576, 0.0301875307266956, 0.0610007264692972, -0.00308100195312476, 0.0, 0.0218729440398858, 0.0178591840233903, 0.0757701007763862, -0.0412440188136457, -0.00729098134662861, 0.0, 0.0, 0.0, 0.0520698294723689, -0.0127765752765753, 0.00184094647575701, -0.00901875901875899, 0.0286384062098029, -0.0297603864135752, 0.0142797017797018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0402250198496157, 0.0143913406048031, -0.0137095932141014, 0.00407048581280862, -0.0464478520766673, 0.0182794576188018, -0.0345392174515273, 0.0364264892362429, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0370016365967795, -0.030086608985143, 0.014070114555226, -0.00340391123780845, 0.0, -0.0427258096992148, 0.0243187165152054, 0.0, -0.00982624534723142, 0.00607967912880138};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 31:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573525, 0.00377344134083671, -0.0196073763651313, 0.00924300585937413, 0.0, -0.010936472019943, 0.102690308134494, 0.00947126259704831, -0.0695992817480271, -0.060150596109686, 0.0, -0.00504163955965856, 0.0465726713108155, 0.00650872868404609, 0.0214195526695526, -0.007824022521967, -0.00450937950937951, -0.0289638426440052, -0.0263060558477138, 0.000563672438672422, 0.0, 0.0, 0.0, 0.0, 0.0334424534952005, 0.0289620142917234, 0.0, -0.0431740218144092, -0.00249265331165473, -0.0605484764655283, 0.0, 0.0299118397398575, -0.00431740218144092, 0.0185070066280912, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0349574806629939, -0.0121096265225824, 0.0, 0.0, -0.0451299134777144, -0.0281402291104519, 0.023827378664659, 0.0, 0.0, 0.0312669212338355, 0.0270779480866286, 0.0, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 32:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573522, -0.0150937653633479, 0.0130715842434209, 0.00924300585937416, 0.0, -0.010936472019943, -0.00892959201169518, 0.00947126259704832, 0.123732056440937, -0.060150596109686, 0.0, 0.0, 0.0, -0.00650872868404607, 0.0574945887445887, -0.0266937238984759, 0.00676406926406928, 0.0126920209338899, 0.00637722566005185, 0.000563672438672456, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0431740218144092, 0.0199412264932384, -0.0142467003448302, 0.0, -0.0448677596097863, 0.0215870109072046, -0.0616900220936373, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0451299134777144, -0.0375203054806026, 0.0119136893323295, 0.0, 0.0, -0.0469003818507533, 0.0162467688519772, 0.020635115229186, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 33:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769579, 0.0301875307266958, 0.0174287789912278, 0.0585390371093695, 0.0, 0.021872944039886, 0.0178591840233904, -0.0189425251940966, 0.0103110047034114, 0.083846285486229, 0.0, 0.0, 0.0, 0.0, 0.00526094276094282, 0.0533874477969518, 0.0, -0.00455611007883231, 0.0308232573569172, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.034897146363167, 0.0284934006896603, 0.0, 0.0, -0.0302218152700865, 0.0164506725583033, -0.0643935438844155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0437736897273697, -0.023827378664659, 0.0, 0.0, 0.0, -0.0379091273212801, -0.013756743486124, 0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 34:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769583, -0.0679219441350653, -0.00435719474780707, -0.00308100195312477, 0.0705946233325039, 0.0328094160598287, 0.0267887760350855, 0.0126283501293977, 0.03608851646194, -0.00729098134662866, -0.0298267418725716, 0.0151249186789759, 0.0130985638061669, 0.0325436434202305, 0.0229226791726792, 0.024852777422719, 0.0248015873015873, 0.0169226945785198, 0.0164744996218006, 0.0142797017797018, 0.0, -0.0245778931055953, -0.0219831358911338, -0.036351194128299, -0.00743165633226677, -0.0345935170706695, -0.0362025178646541, 0.0, -0.0130864298861876, -0.0335815079556711, -0.0232239260383336, 0.00166176887443654, -0.00359783515120075, -0.0146881004984851, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, -0.0226083734055987, 0.00459580543596522, 0.0, -0.0334382352084074, -0.0194208225905522, 0.00908221989193681, 0.0, -0.0333014729371016, -0.0270779480866286, -0.00703505727761297, 0.0102117337134253, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598856, 0.0019652490694463, 0.00607967912880137};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 35:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573524, -0.00377344134083693, 0.0021785973739036, -0.021567013671873, 0.0, -0.0984282481794864, 0.031253572040933, -0.0852413633734345, -0.0180442582309701, 0.0309866707231716, 0.0, 0.0453747560369275, -0.0116431678277039, 0.0, -0.0236742424242424, 0.00138070985681771, -0.0202922077922078, -0.0335199527228374, -0.000797153207506521, 0.00394570707070709, 0.0, 0.0, 0.0, 0.036351194128299, 0.024152883079867, -0.00724050357293081, 0.0603375297744236, 0.0, 0.039259289658563, -0.0188259968842399, 0.0464478520766673, -0.0108014976838374, 0.0259044130886455, 0.010869194368879, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0334382352084074, -0.0155366580724417, 0.00302740663064559, 0.0, 0.0555024548951694, 0.0, -0.0164151336477637, 0.00680782247561685, 0.0, 0.0427258096992147, 0.00694820471863021, -0.0108311792346515, -0.0039304981388926, 0.00607967912880134};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 36:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769576, -0.0301875307266958, 0.0610007264692973, -0.00308100195312474, 0.0, -0.0218729440398859, -0.0178591840233903, 0.0757701007763862, -0.0412440188136456, -0.00729098134662862, 0.0, 0.0, 0.0, -0.0520698294723689, 0.0127765752765753, -0.00184094647575696, -0.009018759018759, 0.0286384062098028, -0.0297603864135752, 0.0142797017797018, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0402250198496158, -0.0143913406048031, 0.0137095932141013, -0.00407048581280862, -0.0464478520766673, 0.0182794576188018, -0.0345392174515273, 0.0364264892362429, -0.0178640154001927, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0370016365967796, 0.0300866089851429, -0.014070114555226, 0.00340391123780843, 0.0, -0.0427258096992147, 0.0243187165152053, 0.0, -0.00982624534723144, 0.00607967912880138};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 37:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573522, -0.00377344134083705, -0.0196073763651313, 0.00924300585937418, 0.0, 0.0109364720199429, -0.102690308134494, 0.00947126259704827, -0.0695992817480271, -0.060150596109686, 0.0, -0.00504163955965866, 0.0465726713108155, -0.0065087286840461, -0.0214195526695527, 0.007824022521967, -0.00450937950937952, -0.0289638426440052, -0.0263060558477138, 0.000563672438672415, 0.0, 0.0, 0.0, 0.0, 0.0334424534952005, 0.0289620142917233, 0.0, 0.0431740218144092, 0.00249265331165476, 0.0605484764655282, 0.0, 0.0299118397398575, -0.00431740218144093, 0.0185070066280912, 0.0461140862656136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0349574806629939, -0.0121096265225824, 0.0, 0.0, 0.0451299134777144, 0.0281402291104519, -0.0238273786646589, 0.0, 0.0, 0.0312669212338355, 0.0270779480866286, 0.0, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 38:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573522, 0.0150937653633479, 0.0130715842434208, 0.00924300585937413, 0.0, 0.0109364720199429, 0.00892959201169517, 0.00947126259704832, 0.123732056440937, -0.0601505961096861, 0.0, 0.0, 0.0, 0.00650872868404611, -0.0574945887445887, 0.0266937238984759, 0.00676406926406923, 0.0126920209338899, 0.00637722566005184, 0.00056367243867249, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0431740218144092, -0.0199412264932383, 0.0142467003448302, 0.0, -0.0448677596097863, 0.0215870109072046, -0.0616900220936373, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0451299134777144, 0.0375203054806026, -0.0119136893323295, 0.0, 0.0, -0.0469003818507533, 0.0162467688519772, 0.020635115229186, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 39:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769578, -0.0301875307266957, 0.0174287789912279, 0.0585390371093694, 0.0, -0.0218729440398858, -0.0178591840233903, -0.0189425251940966, 0.0103110047034114, 0.0838462854862291, 0.0, 0.0, 0.0, 0.0, -0.00526094276094278, -0.0533874477969518, 0.0, -0.00455611007883227, 0.0308232573569172, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0348971463631671, -0.0284934006896603, 0.0, 0.0, -0.0302218152700864, 0.0164506725583033, -0.0643935438844155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0437736897273697, 0.023827378664659, 0.0, 0.0, 0.0, -0.0379091273212801, -0.013756743486124, 0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 40:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769575, -0.0377344134083696, -0.0566435317214905, -0.00308100195312484, 0.0423567739995023, 0.0546823600997146, 0.0446479600584757, 0.0378850503881931, 0.00515550235170577, -0.00729098134662863, 0.0417574386216002, -0.00504163955965862, 0.0295930515620807, -0.0247331689993752, 0.0101461038961039, 0.0266937238984759, -0.0202922077922078, 0.0021695762280154, 0.0132858867917747, 0.0142797017797018, -0.0557374224920008, -0.0245778931055954, -0.00219831358911337, -0.00519302773261414, -0.0130053985814668, -0.0168945083368385, 0.00402250198496158, -0.0158304746652834, -0.026796023100289, -0.0295110221428625, 0.00464478520766674, -0.0108014976838375, -0.0194283098164841, -0.0217383887377579, -0.0178640154001927, 0.0, 0.0, -0.0512709716390577, 0.0, -0.0226083734055987, -0.0367664434877216, 0.0, -0.0047768907440582, -0.00776832903622085, -0.00908221989193678, 0.0, 0.00370016365967797, 0.00601732179702859, 0.00703505727761299, 0.00680782247561684, 0.0, 0.00427258096992148, 0.0069482047186301, 0.00812338442598856, 0.00786099627778516, 0.00607967912880135};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 41:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.021478804657352, 0.0, -0.00435719474780707, -0.0215670136718729, -0.127070321998507, 0.0, 0.0, 0.0284137877911449, 0.0360885164619399, 0.0309866707231715, 0.0, 0.0453747560369276, -0.0422064833754265, 0.0, 0.0, 0.0, -0.0202922077922078, -0.00618329224984381, 0.00159430641501297, 0.00394570707070707, 0.0836061337380012, 0.0, 0.0, -0.0103860554652283, 0.024152883079867, 0.0434430214375849, 0.0, 0.0, 0.0, 0.0, 0.00464478520766672, -0.0108014976838374, -0.0194283098164842, -0.0217383887377578, -0.0178640154001927, 0.0, 0.0, 0.0769064574585865, 0.0, 0.0, 0.0, 0.0, -0.0095537814881164, -0.0155366580724417, -0.0181644397838736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00427258096992146, 0.00694820471863015, 0.00812338442598858, 0.00786099627778516, 0.00607967912880134};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 42:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769579, 0.0377344134083696, -0.0566435317214904, -0.00308100195312478, 0.0423567739995022, -0.0546823600997145, -0.0446479600584756, 0.0378850503881931, 0.0051555023517058, -0.00729098134662851, -0.0417574386216002, -0.0050416395596586, 0.0295930515620806, 0.0247331689993752, -0.0101461038961039, -0.0266937238984758, -0.0202922077922078, 0.00216957622801541, 0.0132858867917747, 0.0142797017797018, -0.0557374224920007, 0.0245778931055953, 0.00219831358911336, -0.00519302773261413, -0.0130053985814668, -0.0168945083368386, -0.00402250198496157, 0.0158304746652834, 0.026796023100289, 0.0295110221428625, 0.00464478520766677, -0.0108014976838375, -0.0194283098164841, -0.0217383887377579, -0.0178640154001927, 0.0, 0.0, -0.0512709716390576, 0.0, 0.0226083734055987, 0.0367664434877216, 0.0, -0.00477689074405818, -0.00776832903622087, -0.00908221989193679, 0.0, -0.00370016365967796, -0.00601732179702859, -0.00703505727761299, -0.00680782247561685, 0.0, 0.0042725809699215, 0.00694820471863008, 0.00812338442598856, 0.00786099627778518, 0.00607967912880136};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 43:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573523, -0.0188672067041848, 0.00653579212171045, 0.00924300585937416, 0.0141189246665007, 0.0, -0.111619900146189, -0.0031570875323494, -0.0541327746929101, -0.060150596109686, -0.00894802256177143, -0.0025208197798293, -0.0276525235907967, 0.000650872868404632, 0.0360750360750361, -0.0188697013765088, 0.00112734487734485, 0.0374251899332651, 0.0199288301876619, 0.000563672438672442, 0.0, 0.0, 0.0593544669060614, 0.0, 0.0167212267476002, 0.00321800158796921, 0.0, -0.00431740218144091, 0.0224338798048931, 0.0463017761206981, 0.0, -0.00747795993496438, 0.018708742786244, 0.0431830154655461, 0.0461140862656136, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0620433733855302, 0.0, 0.0, 0.017478740331497, 0.0363288795677472, 0.0, 0.0, -0.00451299134777146, -0.00938007637015062, -0.0119136893323295, 0.0, 0.0, -0.00781673030845886, -0.0162467688519772, -0.020635115229186, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 44:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573521, 0.0188672067041847, 0.00653579212171044, 0.00924300585937423, 0.0141189246665008, 0.0, 0.111619900146189, -0.00315708753234941, -0.0541327746929101, -0.0601505961096861, 0.00894802256177156, -0.00252081977982931, -0.0276525235907967, -0.000650872868404613, -0.0360750360750361, 0.0188697013765088, 0.0011273448773449, 0.0374251899332651, 0.019928830187662, 0.000563672438672456, 0.0, 0.0, -0.0593544669060614, 0.0, 0.0167212267476002, 0.00321800158796925, 0.0, 0.00431740218144092, -0.0224338798048931, -0.0463017761206981, 0.0, -0.00747795993496436, 0.018708742786244, 0.0431830154655461, 0.0461140862656137, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0620433733855302, 0.0, 0.0, 0.0174787403314969, 0.0363288795677472, 0.0, 0.0, 0.00451299134777145, 0.00938007637015066, 0.0119136893323295, 0.0, 0.0, -0.00781673030845888, -0.0162467688519772, -0.0206351152291861, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 45:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769577, 0.0, -0.0348575579824555, 0.0585390371093695, -0.0282378493330015, 0.0, 0.0, 0.00631417506469885, -0.0206220094068228, 0.083846285486229, 0.0, 0.0, -0.00679184789949391, 0.0, 0.0, 0.0, 0.0, 0.0015187033596108, -0.0616465147138344, -0.0319414381914382, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0450520222315696, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0100739384233622, -0.0329013451166065, -0.0643935438844154, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0565115904387178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.01263637577376, 0.027513486972248, 0.0303983956440068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 46:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769581, -0.0377344134083696, -0.0217859737390348, -0.0523770332031201, 0.0423567739995023, 0.0546823600997146, 0.0446479600584757, 0.0, 0.0257775117585286, 0.0291639253865144, 0.0417574386216002, 0.0285692908380655, -0.00921750786359887, 0.0273366604729936, -0.00789141414141413, -0.0248527774227189, 0.0187890812890813, -0.00347132196482459, -0.0143487577351167, -0.015031265031265, -0.0557374224920008, -0.00491557862111905, -0.0241814494802472, -0.0197335053839337, -0.00928957041533348, -0.00241350119097693, -0.0394205194526234, -0.0158304746652834, -0.000623163327913707, 0.00712335017241507, -0.0325134964536671, -0.0141250354327105, -0.00215870109072047, 0.00411266813957583, 0.00540074884191869, 0.0, -0.0510586685671264, 0.00466099742173249, -0.0405265617908061, -0.0143871467126537, 0.00367664434877214, -0.0114170653756726, -0.00564541633388696, -0.00155366580724415, 0.00100913554354854, 0.0103175576145931, 0.00571843474677502, 0.00240692871881143, 0.000260557676948618, -0.000850977809452114, 0.0127646671417816, 0.00737991258440983, 0.00347410235931509, 0.000902598269554292, -0.00049131226736157, -0.000868525589828748};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 47:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573521, 0.0, -0.0217859737390347, 0.0030810019531248, -0.127070321998507, 0.0, 0.0, 0.0473563129852413, 0.0257775117585286, 0.0127592173566001, 0.0, -0.0352914769176103, 0.0509388592462045, 0.0, 0.0, 0.0, 0.00225468975468974, -0.00943765659186685, -0.0143487577351166, -0.0129644660894661, 0.0836061337380012, 0.0, 0.0, 0.0477758551400501, 0.00928957041533348, -0.0144810071458617, 0.0, 0.0, 0.0, 0.0, -0.0325134964536671, -0.0141250354327105, -0.00215870109072047, 0.00411266813957583, 0.00540074884191877, 0.0, 0.0765880028506896, -0.00699149613259875, 0.0, 0.0, 0.0, -0.0228341307513453, -0.011290832667774, -0.00310733161448838, 0.00201827108709704, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0127646671417816, 0.00737991258440981, 0.00347410235931506, 0.000902598269554269, -0.000491312267361589, -0.000868525589828803};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 48:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.0787556170769581, 0.0377344134083697, -0.0217859737390348, -0.0523770332031201, 0.0423567739995023, -0.0546823600997145, -0.0446479600584757, 0.0, 0.0257775117585286, 0.0291639253865145, -0.0417574386216002, 0.0285692908380655, -0.00921750786359893, -0.0273366604729936, 0.00789141414141414, 0.0248527774227189, 0.0187890812890813, -0.00347132196482459, -0.0143487577351166, -0.015031265031265, -0.0557374224920008, 0.00491557862111907, 0.0241814494802472, -0.0197335053839337, -0.00928957041533349, -0.00241350119097694, 0.0394205194526234, 0.0158304746652834, 0.000623163327913704, -0.00712335017241507, -0.0325134964536671, -0.0141250354327105, -0.00215870109072045, 0.0041126681395758, 0.00540074884191868, 0.0, -0.0510586685671264, 0.0046609974217325, 0.0405265617908061, 0.0143871467126537, -0.00367664434877216, -0.0114170653756727, -0.00564541633388696, -0.00155366580724416, 0.00100913554354855, -0.010317557614593, -0.00571843474677502, -0.00240692871881143, -0.000260557676948628, 0.000850977809452107, 0.0127646671417816, 0.00737991258440984, 0.00347410235931506, 0.000902598269554289, -0.000491312267361559, -0.000868525589828739};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 49:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.0214788046573522, -0.0188672067041848, 0.0108929868695174, 0.00308100195312465, 0.0141189246665008, -0.109364720199429, 0.0223239800292378, -0.0789271883087356, -0.0128887558792643, 0.0127592173566001, -0.00894802256177147, -0.0277290175781224, 0.00145539597846299, -0.00585785581564149, 0.0383297258297259, -0.0124263887113595, 0.0191648629148629, 0.0348216984596467, 0.00717437886755837, -0.0129644660894661, 0.0, 0.0589869434534289, -0.00659494076734012, 0.00727023882565975, 0.0148633126645336, -0.0040225019849616, 0.0506835250105158, -0.00431740218144091, -0.00810112326287806, 0.00356167508620759, 0.0650269929073342, -0.00166176887443651, -0.0115130724838425, -0.00205633406978793, 0.00540074884191875, 0.0, 0.0, 0.0, 0.0607898426862092, -0.0123318400394175, 0.0013787416307896, 0.0399597288148543, 0.00303983956440067, -0.00427258096992151, 0.00100913554354852, -0.0154763364218896, -0.00302740663064561, 0.000902598269554316, 0.000781673030845898, -0.000425488904726051, -0.031911667854454, -0.00776832903622089, 0.000868525589828735, 0.00180519653910857, 0.000245656133680779, -0.000868525589828785};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 50:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {-0.021478804657352, 0.0188672067041847, 0.0108929868695173, 0.00308100195312463, 0.0141189246665008, 0.109364720199429, -0.0223239800292377, -0.0789271883087356, -0.0128887558792643, 0.0127592173566001, 0.0089480225617715, -0.0277290175781224, 0.00145539597846297, 0.00585785581564149, -0.0383297258297259, 0.0124263887113595, 0.019164862914863, 0.0348216984596467, 0.00717437886755831, -0.0129644660894661, 0.0, -0.0589869434534289, 0.00659494076734013, 0.00727023882565982, 0.0148633126645336, -0.00402250198496154, -0.0506835250105159, 0.00431740218144093, 0.00810112326287807, -0.00356167508620756, 0.0650269929073343, -0.00166176887443652, -0.0115130724838424, -0.00205633406978791, 0.00540074884191871, 0.0, 0.0, 0.0, -0.0607898426862092, 0.0123318400394175, -0.00137874163078959, 0.0399597288148542, 0.00303983956440069, -0.00427258096992146, 0.00100913554354852, 0.0154763364218896, 0.00302740663064561, -0.000902598269554309, -0.000781673030845882, 0.000425488904726061, -0.031911667854454, -0.00776832903622087, 0.000868525589828761, 0.00180519653910858, 0.000245656133680792, -0.000868525589828766};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 51:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.078755617076958, 0.0, 0.0435719474780695, -0.0523770332031201, -0.0282378493330015, 0.0, 0.0, 0.0631417506469885, -0.0515550235170571, 0.0291639253865144, 0.0, -0.00672218607954478, 0.000970263985642006, 0.0, 0.0, 0.0, -0.0601250601250601, -0.0125835421224891, 0.0286975154702332, -0.015031265031265, 0.0, 0.0, 0.0, -0.0436214329539588, 0.0111474844984002, -0.00160900079398465, 0.0, 0.0, 0.0, 0.0, -0.0650269929073343, 0.031573608614294, -0.00287826812096059, -0.00822533627915168, 0.00540074884191872, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0532796384198057, 0.018239037386404, -0.00466099742173253, 0.000672757029032364, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0425488904726053, -0.00388416451811041, -0.00347410235931508, 0.00120346435940574, 0.000982624534723167, -0.000868525589828753};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 52:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.10739402328676, -0.188672067041848, -0.108929868695174, -0.0770250488281179, -0.0705946233325038, -0.0546823600997147, -0.0446479600584758, -0.0315708753234942, -0.0257775117585285, -0.0182274533665715, 0.0894802256177148, -0.0151249186789758, -0.0130985638061669, 0.0585785581564149, -0.028183621933622, 0.0690354928408859, 0.0744047619047619, 0.00976309302606916, 0.039857660375324, 0.0597492784992785, 0.0, 0.0737336793167861, 0.0659494076734016, 0.0363511941282991, 0.00743165633226678, 0.0345935170706695, -0.0120675059548847, 0.0431740218144092, 0.0155790831978424, -0.0254405363300539, -0.0232239260383337, 0.0465295284842228, 0.0251848460584054, -0.0146881004984851, -0.0328199352701215, 0.0, 0.0, 0.0, 0.0, 0.0678251202167962, -0.0137874163078956, 0.0, 0.0334382352084074, 0.0194208225905521, -0.00908221989193679, 0.0, -0.0111004909790339, -0.00902598269554285, -0.00234501909253765, 0.0034039112378084, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598858, 0.0019652490694463, 0.00607967912880138};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 53:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.107394023286761, 0.188672067041848, -0.108929868695174, -0.0770250488281178, -0.0705946233325039, 0.0546823600997148, 0.0446479600584758, -0.0315708753234942, -0.0257775117585286, -0.0182274533665716, -0.0894802256177149, -0.0151249186789758, -0.0130985638061668, -0.058578558156415, 0.0281836219336219, -0.0690354928408859, 0.0744047619047618, 0.00976309302606914, 0.039857660375324, 0.0597492784992785, 0.0, -0.0737336793167861, -0.0659494076734016, 0.036351194128299, 0.00743165633226679, 0.0345935170706696, 0.0120675059548846, -0.0431740218144092, -0.0155790831978425, 0.0254405363300539, -0.0232239260383337, 0.0465295284842228, 0.0251848460584053, -0.014688100498485, -0.0328199352701215, 0.0, 0.0, 0.0, 0.0, -0.0678251202167963, 0.0137874163078956, 0.0, 0.0334382352084074, 0.0194208225905522, -0.0090822198919368, 0.0, 0.0111004909790338, 0.00902598269554287, 0.00234501909253764, -0.00340391123780842, 0.0, -0.0213629048496074, -0.0191075629762328, -0.00812338442598857, 0.00196524906944628, 0.00607967912880138};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 54:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.107394023286761, 0.0, 0.217859737390348, -0.0770250488281177, 0.0, 0.0, 0.0, -0.0947126259704828, 0.0515550235170571, -0.0182274533665715, 0.0, -0.0907495120738551, 0.0232863356554078, 0.0, 0.0, 0.0, -0.0946969696969696, -0.0227805503941613, -0.0797153207506479, 0.0597492784992785, 0.0, 0.0, 0.0, -0.0727023882565981, -0.0483057661597341, 0.0144810071458617, 0.0, 0.0, 0.0, 0.0, 0.0464478520766673, -0.0781031370985168, 0.0431740218144092, 0.0293762009969702, -0.0328199352701214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0668764704168148, 0.0310733161448835, -0.00605481326129119, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0427258096992147, 0.00694820471863014, -0.0108311792346515, -0.00393049813889261, 0.00607967912880134};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 55:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.10739402328676, 0.0, 0.0, 0.231075146484353, 0.0, 0.0, 0.0, 0.0, 0.0, -0.109364720199429, 0.0, 0.0100832791193172, -0.093145342621631, 0.0, 0.0, 0.0, -0.00450937950937961, -0.104139658944738, 0.0, -0.0924422799422799, 0.0, 0.0, 0.0, 0.0, -0.066884906990401, -0.0579240285834467, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0299118397398574, -0.0647610327216138, 0.0, 0.0835038859404355, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0699149613259878, 0.0242192530451648, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0312669212338355, 0.0270779480866287, 0.0, -0.0182390373864041};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 56; r++)
    {
      evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923452, 0.00609788120679252, 0.00352061335622801, 0.00248944957812476, 0.00705946233325035, 0.00546823600997146, 0.00446479600584761, 0.00315708753234941, 0.00257775117585288, 0.00182274533665716, -0.00298267418725715, -0.00252081977982931, -0.00218309396769447, -0.00195261860521384, -0.00169101731601733, -0.00138070985681772, -0.0011273448773449, -0.000976309302606943, -0.000797153207506487, -0.000563672438672445, 0.00278687112460007, 0.00245778931055955, 0.00219831358911339, 0.00207721109304567, 0.00185791408306669, 0.00160900079398463, 0.00160900079398464, 0.00143913406048031, 0.00124632665582739, 0.00101762145320215, 0.000928957041533368, 0.000830884437218254, 0.000719567030240159, 0.000587524019939406, 0.000415442218609135, -0.00705593524717797, -0.00638233357089079, -0.00582624677716565, -0.00562868913761196, -0.00513826668309062, -0.00459580543596521, -0.00475711057319694, -0.00434262794914382, -0.00388416451811044, -0.00336378514516178, -0.00368484200521178, -0.00336378514516176, -0.00300866089851429, -0.00260557676948629, -0.00212744452363026, -0.00212744452363026, -0.00194208225905519, -0.00173705117965752, -0.00150433044925714, -0.00122828066840393, -0.000868525589828762};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033678, -2.48689957516035e-14, 0.0, 0.0, 1.04360964314765e-14, -1.77635683940025e-14, -1.46549439250521e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.48787232534531e-14, 0.0, -3.19744231092045e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.41948691584548e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.4210854715202e-14, -1.15463194561016e-14, 0.0, 1.54888466424096e-14, 0.0, 0.0, 0.0, -1.50990331349021e-14, -2.30926389122033e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, -4.08562073062058e-14, 8.36660026534077, -1.18321595661994, 0.0, -2.53130849614536e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, -3.28626015289046e-14, 0.0, -1.90958360235527e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, -2.8421709430404e-14, 0.0, 8.69482604771367, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -4.9737991503207e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394698, 0.0, -3.34664010613629, -2.36643191323984, 15.4919333848297, 0.0, 2.30926389122033e-14, 0.692820323027545, 0.565685424949236, 0.4, 0.0, -2.8421709430404e-14, -1.4210854715202e-14, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0},
      {2.89768209427166e-14, 4.89897948556636, 2.1316282072803e-14, 0.0, 1.06581410364015e-14, 14.1985914794391, -0.828078671210806, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 1.68753899743024e-14, 2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, -2.1316282072803e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, -2.1316282072803e-14, 0.0, 0.0, 0.0, 14.3427433120128, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, -4.08562073062058e-14, 0.0, 1.73194791841524e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {3.6, -2.04281036531029e-14, 8.76356092008267, -1.549193338483, 0.0, -1.06581410364015e-14, 0.0, 9.52470471983255, -1.48131215963607, 0.261861468283193, 0.0, -1.4210854715202e-14, 0.0, -2.1316282072803e-14, -1.4210854715202e-14, 0.0, 1.4210854715202e-14, -1.77635683940025e-14, 2.1316282072803e-14, -2.79776202205539e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 1.11022302462516e-14, 0.0, 0.0, -1.29896093881143e-14},
      {3.11769145362399, -2.95319324550292e-14, 3.16227766016838, 4.91934955049954, 0.0, -2.75612865863195e-14, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 1.06581410364015e-14, -2.22044604925031e-14, -1.50990331349021e-14, -3.71369601737115e-14, 0.0, 0.0, -3.90798504668055e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, -1.24344978758018e-14, 0.0, 0.0, -1.95399252334028e-14, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, -1.19904086659517e-14, 7.66811580507232, 0.0, 0.0, 2.38697950294409e-14, 0.0, -1.77635683940025e-14, 10.3691851174526, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.22124532708767e-14, -1.24344978758018e-14, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.55111512312578e-14, 11.6057691494799, 0.0, 0.0, 0.0, -4.20458932936039, -3.43303281162796, 0.0, 0.0, 0.0, 19.6214168703486, -1.77635683940025e-14, -1.59872115546023e-14, 0.61167774184119, 0.529728463363962, 0.432521479156773, 0.0, 0.0, 1.90958360235527e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1878460182374e-14, 0.0, -1.06581410364015e-14, 1.24344978758018e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479106, 0.0, 3.54562104171168, -2.50713268211202, 4.78713553878169, 0.0, 2.01505478969466e-14, -5.56626745075489, -1.04880884817015, 0.741619848709564, 0.0, 18.8034951158402, -0.603122387046459, 0.0, -2.75335310107039e-14, 0.0, 1.68183573174417, 0.701283781217668, 0.132137494528686, -0.0934353184302177, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095214, 1.46549439250521e-14, -1.58564993434419, 4.48489528465112, 4.28174419288837, 0.0, 2.8421709430404e-14, 0.191485421551263, -3.75233260785876, -4.31161222746203, 0.0, -1.24344978758018e-14, 18.8807171866293, 0.0, -2.8421709430404e-14, 1.77635683940025e-14, 0.0, 0.844371341865036, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.95079541199084e-14, 2.59512887494073, 2.8421709430404e-14, 1.59872115546023e-14, 1.4210854715202e-14, 10.0285307284481, -0.76764947357873, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061159, 0.0967147429123472, 2.1316282072803e-14, 2.1316282072803e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989599, 0.0, 0.0, 0.0, 3.92428337406972, 5.49285249860479, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662718, 0.0, 2.8421709430404e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278145, 0.0, 0.0, 0.0, 0.0, 8.91928088068606, 0.0, 0.0, 0.0, 0.0, 0.0, 3.01980662698043e-14, 0.0, 0.0, 16.8558564884488, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483828, 0.0, 8.12403840463598, -1.6413036132966, 1.06581410364015e-14, 0.0, -1.77635683940025e-14, 11.7728501222092, -2.40312296813957, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741915, 0.302765035409783, -0.061167774184141, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.57571741713036e-14, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 2.62012633811537e-14, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990516, 2.93605316083771, 0.0, -1.28785870856518e-14, 0.0, 2.63248931621765, 9.82591326180785, -2.8226127713774, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 1.38777878078145e-14, 11.6081867662439, -3.09487177319466, 0.683876505540219, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.28785870856518e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.83741910575463e-14, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, -1.24344978758018e-14, 1.26565424807268e-14, -1.28785870856518e-14},
      {2.29782505861523, 0.0, 1.49829835452876, 5.50917601898537, 0.0, 0.0, 0.0, 0.0, 6.64803945320938, 4.13676892548486, 0.0, -1.15463194561016e-14, 0.0, 0.0, -2.1316282072803e-14, -2.1316282072803e-14, 0.0, 0.0, 12.5636136423841, -3.55352656109505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0},
      {1.87616630392939, 1.15463194561016e-14, 0.0, 6.22830929985769, 0.0, 0.0, 3.90798504668055e-14, 0.0, -1.77635683940025e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722506, 0.0, -4.41087092453691, -3.11895674167864, 16.6749979177077, 1.02140518265514e-14, 0.0, 2.13065307820925, 1.73967095350099, 1.23013312825381, -1.4210854715202e-14, -4.36653943835008, -3.7815340802378, 0.0, 2.48689957516035e-14, 1.24344978758018e-14, -0.557935943461974, -0.483186700722504, -0.394520289089682, -0.278967971730994, 23.6981011897578, 0.0, 0.0, 0.490653381462664, 0.438853725736261, 0.380058475033041, 0.0, 0.0, 0.0, 0.0, 0.0626933893908879, 0.0560746721671604, 0.048562090605635, 0.0396507809422171, 0.0280373360835759, -1.06581410364015e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.91050664139875, -1.04360964314765e-14, 0.0, 0.0, 10.5706241650195, -2.725540575477, 2.28705943072782e-14, 0.0, 0.0, 4.67332857821917, -4.44089209850063e-14, 0.0, -7.86705867811457, -2.39719223514613, 0.618094504365247, 0.0, 0.0, 1.64313007644523e-14, 0.0, 0.0, 23.1055548876599, -0.469687194424181, 0.0, 0.0, 0.0, 1.62065746295905, 0.790669146636831, 0.240926884676766, -0.062120835029098, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.62012633811537e-14, 0.0, 1.77635683940025e-14, 1.11022302462516e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {3.81916720471054e-14, 6.30840061880562, 1.59872115546023e-14, -1.59872115546023e-14, 0.0, -1.5236235005501, 11.1963004093827, 0.0, 0.0, 0.0, 4.26614580154031, 0.0, -2.48689957516035e-14, 0.132992762321612, -4.72217953828915, -6.67684597013015, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 1.06581410364015e-14, 0.0, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560579, 1.11125127955291, 1.19087439227729, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 1.15463194561016e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {3.85449644663773, 2.30926389122033e-14, 5.98171817966648, -2.48806675764059, 1.90029237516521, 1.95399252334028e-14, 0.0, -0.339934634239501, -2.35922146606162, 0.981306762925323, 0.0, 9.9522670305624, -0.43094580368566, 0.0, 0.0, 2.48689957516035e-14, -6.45364422706454, 0.0770899289327254, 0.535021138879209, -0.222539456105663, 0.0, 1.02140518265514e-14, 0.0, 21.5273297444417, -1.00024047132727, 0.0433116829031313, 0.0, 0.0, 0.0, 0.0, 2.75066129615, 0.648615649442922, -0.00774782937530727, -0.0537716476536625, 0.0223660568773498, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274496, 2.22044604925031e-14, 1.92724822331888, 2.72554057547701, 1.73472166622177, 0.0, 4.2632564145606e-14, -2.01705689521107, 3.4205262752974, -4.03112887414928, 0.0, 4.08831086321546, 5.37643791520785, 0.0, -3.5527136788005e-14, 2.22044604925031e-14, 0.365669640132043, -6.25148194071026, -2.03981013744546, 1.8080332206528, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.2652152389098, 0.0, 0.0, 0.0, 0.0, 0.0, 1.98456380761455, 1.4711357857929, 0.363818136386334, -0.294009452979941, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0},
      {3.14718316987776, 0.0, -0.861891607371339, 6.09449400220043, 1.55158222708542, 1.24344978758018e-14, 0.0, 0.0693888666488744, -3.05941170815567, 1.802775637732, 0.0, 1.7874590696465e-14, 9.03122156537879, 0.0, -2.22044604925031e-14, 3.19744231092045e-14, 0.0, 0.403888506800969, -3.67461994579464, -5.49650682721195, 0.0, 0.0, 0.0, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.97421573396055, 1.78974858569576, 1.80791908794929, 0.0, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, -1.06581410364015e-14, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-2.8421709430404e-14, 1.54523626091312, 0.0, 0.0, 0.0, 6.71778024562962, -0.609449400220045, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 14.6593983227032, -1.52344936219871, 0.138210132827959, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864222, -0.0138906409944113, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {3.73034936274053e-14, 1.41060126129512, 1.59872115546023e-14, 1.4210854715202e-14, 0.0, 3.63405410063598, 2.50356888118885, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 3.56857028479908, 11.2630554128779, -1.49298814645065, 0.0, -1.4210854715202e-14, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124152, 0.266287609379576, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14},
      {-4.88498130835069e-14, 1.2616801237611, -1.59872115546023e-14, -1.4210854715202e-14, 0.0, 1.42204860051344, 4.4785201637531, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 8.27725128825315, 5.37909280973864, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.9654813226339, -2.61992366301005, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 1.77635683940025e-14, 0.0, -1.4210854715202e-14},
      {-2.97539770599542e-14, 1.09264703862701, 1.50990331349021e-14, 0.0, 0.0, -1.4210854715202e-14, 5.38682254607083, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.3988810110277e-14, -2.26485497023532e-14, 0.0, -1.33226762955019e-14, 13.4377817958113, 1.06581410364015e-14, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752222, 1.4210854715202e-14, 7.37120708415868, -1.62882203585591, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050879, 0.642416074439624, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882094426, -2.72522906732404, 0.659300804656283, -0.145686271816937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846549, 0.273895826790434, -0.0662622240310455, 0.0146420212340158, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {2.30350221379958, 0.0, 4.41588043316396, 1.78428514239951, 0.0, 0.0, -3.01980662698043e-14, 4.26614580154033, 7.83741028656787, -2.63899331455874, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 2.23427840700305, 13.2221027072096, -4.67379217909108, 1.1836355846623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 12.1258851598178, -3.11150358274814, 0.833612074594097, -0.192474367616154, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.66453525910038e-14, 1.84297022087776e-14, -1.56541446472147e-14, 1.64313007644523e-14, 0.0},
      {2.06031501455086, 1.4210854715202e-14, 2.25696201807216, 3.9897828696483, 0.0, 0.0, 2.39808173319034e-14, 0.953939201416929, 8.01142041980428, 1.18019368870417, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.77635683940025e-14, 1.4210854715202e-14, -1.06581410364015e-14, 5.55254896421457, 9.62241374388481, -3.59830837050571, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239956, 0.0, 0.814411017927968, 5.06770487035906, 0.0, 0.0, 2.48689957516035e-14, 0.0, 4.01510046524761, 6.5867230574027, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, -1.77635683940025e-14, 10.0159311874144, 2.8329331450074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 14.0929454377398, -4.55552790213387, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0},
      {1.45686271816935, 1.06581410364015e-14, 0.0, 5.07816454066241, -1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 10.0142755247554, 0.0, 0.0, 3.90798504668055e-14, 0.0, -2.30926389122033e-14, 0.0, 0.0, 2.19824158875781e-14, 1.77635683940025e-14, 13.8784813613723, 0.0, 0.0, 0.0, 0.0, -1.37667655053519e-14, -1.06581410364015e-14, 0.0, 1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 12.5535587278944, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.45439216225896e-14, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505168, -2.48689957516035e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.49637247037759e-14, 0.0, -3.01980662698043e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.61248608016089, -1.08012344973465, -0.763762615825974, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.2456883730947, 4.18330013267038, -0.591607978309975, 0.0, -1.4210854715202e-14, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -2.8421709430404e-14, 0.0, 1.0325074129014e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.44051437445114e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, -1.4210854715202e-14, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106461, -1.4210854715202e-14, 9.66091783079297, 0.683130051063949, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.68753899743024e-14, 0.0, 1.4210854715202e-14, 0.0, -1.15463194561016e-14, -1.4210854715202e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, -2.30926389122033e-14, 0.0, 7.52994023880669, 0.0, -1.02140518265514e-14, -1.59872115546023e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -3.90798504668055e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697347, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113257, 0.346410161513768, 0.282842712474613, 0.2, 0.0, -1.59872115546023e-14, -1.59872115546023e-14, 0.0, -1.68753899743024e-14, -1.47659662275146e-14, 0.0, 1.33226762955019e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278316, 2.82842712474622, -0.999999999999997, 9.16515138991168, 7.09929573971952, -0.414039335605381, -2.04939015319193, -0.478091443733767, 0.169030850945705, 2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 1.86517468137026e-14, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355963, -0.408248290463877, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671766, 0.0, 0.0, 0.0, 0.0, 0.0, -4.2632564145606e-14, 0.0, 0.0, -1.59872115546023e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.26565424807268e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000005, -5.69209978830307, 4.38178046004135, -0.77459666924149, 1.77635683940025e-14, 10.998181667894, 0.962140470884736, 4.76235235991627, -0.74065607981803, 0.1309307341416, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752581, 1.58113883008417, 2.45967477524976, 0.0, -1.02140518265514e-14, 9.25820099772553, 0.0, 5.34522483824848, -1.20948631362953, 0.0, 0.0, 1.59872115546023e-14, -1.33226762955019e-14, 0.0, -5.06261699229071e-14, 0.0, 1.4210854715202e-14, -3.19744231092045e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, -1.17683640610267e-14, -1.64313007644523e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 1.19348975147204e-14, 0.0, 0.0, 5.18459255872628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270666, -2.8421709430404e-14, -3.16227766016839, -2.23606797749981, 0.0, 0.0, -2.48689957516035e-14, 13.7477270848675, 0.534522483824869, 0.377964473009236, -2.8421709430404e-14, -2.15938378289593e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 2.84494650060196e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.85407245112401e-14, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.6514837167011, -2.8401877872188, 0.0, 0.0, 2.8421709430404e-14, 1.15463194561016e-14, 12.3442679969673, 1.39659449751036, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.24344978758018e-14, -3.99680288865056e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.20454076850487, 1.28785870856518e-14, 0.0, 6.64078308635358, 0.0, 0.0, 2.08721928629529e-14, 0.0, -1.24344978758018e-14, 8.97997772825744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473997, -2.01017818278146, -1.42141062443802, 8.14215222512714, -2.1022946646802, -1.71651640581397, 0.728256234341417, 0.594618725379069, 0.420458932936041, 9.81070843517429, -1.18450885369838, -1.02581475831037, 0.305838870920597, 0.264864231681972, 0.21626073957838, -0.105945692672785, -0.0917516612761684, -0.0749149177264175, -0.0529728463363923, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239559, 3.07059789431498, 1.77281052085585, -1.25356634105601, 2.39356776939085, 6.30376871403132, -0.908295106229227, -2.78313372537745, -0.524404424085072, 0.370809924354783, 11.1242977306435, 9.4017475579201, -0.301561193523241, -2.42752078113805, -0.794200206656987, 0.114434427054269, 0.840917865872093, 0.350641890608839, 0.0660687472643508, -0.0467176592151073, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047606, 2.74642624930239, -0.792824967172102, 2.24244764232555, 2.14087209644418, -0.331662479035535, 6.4992307237088, 0.095742710775629, -1.87616630392938, -2.15580611373101, 1.06581410364015e-14, 0.0, 9.44035859331467, 0.0, -1.46249406456536, -2.04706526287664, 0.0, 0.422185670932525, 0.590936840285275, 0.522319308773337, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01585406753202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551273, 1.29756443747036, 3.74574588632199, -1.05945692672795, -8.09173593712688, 5.01426536422408, -0.383824736789381, 1.80936716113938, -1.10800657553488, 0.313391585264006, 0.0, 12.7134831207354, 1.01946290306867, 8.20651806648289, -0.631738055305803, 0.0483573714561754, -2.84282124887605, -0.227958835180086, 0.139595707137602, -0.0394836284566153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715532, 1.160576914948, 1.34011878852097, 1.89521416591739, 2.53311402559511, 1.96214168703485, 2.74642624930243, -0.566421515598881, 3.17129986868835, -1.82198870938951, 0.0, -1.11022302462516e-14, 11.1699829238239, -1.06581410364015e-14, 8.65223156827826, -0.865042958313582, 0.0, -2.49768411251821, -0.998865569685881, 0.441440386136652, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -2.48689957516035e-14, -1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824669, 3.55615782880926, 0.0, 0.0, 4.45964044034303, 0.0, -0.858258202906998, 2.67027285925185, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422439, 0.0, 0.0, -1.62195554683795, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 7.03562363973514, 4.06201920231801, -0.820651806648293, 0.0, -6.79705818718656, -2.08116553882676, 5.8864250611046, -1.20156148406977, 0.242752078113808, 0.0, -2.1316282072803e-14, 0.0, 14.8323969741913, 0.856348838577661, 0.262202212042544, 5.13809303146608, -0.741619848709579, 0.151382517704904, -0.0305838870920607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02060590481778e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815182, 2.07610309995257, 1.46802658041886, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090391, -1.41130638568869, 0.0, 0.0, -1.24344978758018e-14, 0.0, 13.4039795085887, 2.01017818278148, 0.0, 5.80409338312194, -1.54743588659734, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 1.02695629777827e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4432899320127e-14, 0.0, 0.0, -1.62092561595273e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 1.29756443747035, 0.749149177264378, 2.75458800949268, 0.0, 0.0, 5.75737105184055, 0.0, 3.32401972660469, 2.06838446274243, 0.0, -1.28785870856518e-14, 0.0, 0.0, -1.59872115546023e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119206, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.938083151964694, 0.0, 0.0, 3.11415464992884, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964689, 1.89521416591739, 0.0, 0.0, 0.0, -3.39852909359327, -2.77488738510234, -0.560611910581399, 0.0, 1.4210854715202e-14, 0.0, 1.77635683940025e-14, 0.0, 0.0, 17.7988763690296, 0.428174419288845, 0.349602949390066, 0.0706304617818807, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 1.77635683940025e-14, -1.49829835452876, 4.2378277069118, -1.29340982368831e-14, 1.24344978758018e-14, -3.10862446895044e-14, 3.79967103839267, -3.54562104171167, -4.07409060843205, 1.4210854715202e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, 1.77635683940025e-14, 0.0, 16.7549743857359, 1.11676565710086, 0.987090711415302, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, -2.66453525910038e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0},
      {-1.32664991614215, 1.95399252334028e-14, 1.73008591662713, -3.18072425757421, 0.0, 0.0, 0.0, 0.0, 7.67649473578738, -2.38836465270395, 0.0, 0.0, 2.8421709430404e-14, 0.0, 0.0, 2.48689957516035e-14, 0.0, 0.0, 14.5072114368499, 2.05162951662075, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630363, 0.0, 0.0, 3.73034936274053e-14, 0.0, -1.24344978758018e-14, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361256, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910462, 0.869835476750492, 0.615066564126904, 10.333118277332, -2.18326971917504, -1.8907670401189, 0.724780051083752, 0.62767793639472, 0.512496888990055, -0.278967971730977, -0.241593350361244, -0.197260144544827, -0.139483985865489, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516521, -0.0814411017927967, -0.0728431359084678, -0.0630840061880518, -0.0515078753637661, 0.0313466946954453, 0.0280373360835799, 0.0242810453028185, 0.0198253904711074, 0.0140186680417875, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725406, 3.45525332069938, 0.997445717412056, -1.4106012612951, 3.2320935276425, 5.28531208250978, -1.3627702877385, -2.89087233497828, -0.393397896234713, 0.556348640264176, 2.33666428910958, 9.02784807228866, -0.732969916135154, -3.93352933905728, -1.19859611757306, 0.309047252182632, 1.64018416088946, 0.655588223176217, 0.0892142571199757, -0.126168012376112, 13.0996183150503, 11.55277744383, -0.234843597212092, -2.44096975264613, -0.907332870306506, 0.0736662483163188, 0.810328731479524, 0.395334573318416, 0.120463442338386, -0.031060417514547, -0.311895674167857, -0.164844710568314, -0.0658890955530745, -0.00896637020658053, 0.0126803623514053, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482413, 3.15420030940281, -1.09264703862701, 1.54523626091313, 2.95048422176041, -0.761811750275046, 5.59815020469136, 0.263899331455872, -1.93925611658551, -2.28543525082517, 2.13307290077016, -0.257539376818862, 9.14446135479763, 0.0664963811608028, -2.36108976914459, -3.33842298506508, -0.0230350221379902, 0.817905488277889, 1.15646364545771, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.3977187881547, -2.15192884958004, 0.0, 0.360889439280293, 0.555625639776453, 0.595437196138646, 0.0, -0.125015768949699, -0.192474367616155, -0.206265495285708, -0.166687691932939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331884, 1.82834820066015, 2.99085908983325, -1.24403337882029, 0.950146187582618, 5.74064456311311, -0.721110255092816, -0.169967317119732, -1.17961073303081, 0.490653381462656, -10.3037210107158, 4.97613351528118, -0.215472901842828, 5.78174466995661, -1.3018558182182, 0.163532434528636, -3.22682211353225, 0.0385449644663654, 0.267510569439617, -0.111269728052835, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663636, 0.0216558414515651, -3.5732138395088, -0.581087203147984, 0.130841432732455, -0.0164356280722688, 1.37533064807501, 0.324307824721448, -0.00387391468765075, -0.0268858238268341, 0.0111830284386727, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637251, 1.66904592079258, 0.963624111659453, 1.3627702877385, 0.867360833110876, 2.28430636201793, 2.96226264871975, -1.00852844760553, 1.7102631376487, -2.01556443707463, 2.41867732448957, 2.04415543160773, 2.68821895760391, -0.527798662911733, 7.07977053255616, -1.7665273979248, 0.182834820066026, -3.12574097035513, -1.01990506872272, 0.904016610326403, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.6326076194549, 0.0, -2.8644711213756, -1.66605356688627, 0.31507574846809, 0.0, 0.992281903807282, 0.735567892896452, 0.181909068193165, -0.147004726489971, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, -2.04281036531029e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458435, -0.430945803685674, 3.04724700110021, 0.775791113542706, -0.120185042515456, 5.29905651979673, 0.0346944333244417, -1.52970585407783, 0.901387818866002, 0.0, 0.0, 4.51561078268941, 0.0, -0.699555414372428, 6.36462844462229, 0.0, 0.201944253400487, -1.83730997289732, -2.74825341360597, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980271, 0.894874292847878, 0.903959543974647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585588, 0.772618130456575, 3.86595114186568, -1.05140010313426, 9.1544290607646, 3.35889012281482, -0.304724700110037, 3.87851223317103, -1.52475169285614, 0.414677792940099, 0.0, -9.46260092820843, -2.07602937339135, 7.3296991613516, -0.761724681099355, 0.0691050664139841, 0.564240504518073, -0.879563899362193, 0.34578118203621, -0.0940400840863395, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355638, 0.208648802584717, 9.059750638547, -0.736662483163211, 0.0765562109321121, -0.00694532049720742, -3.48709964663733, -0.0567083043941636, 0.0883994979795868, -0.0347523163751426, 0.00945138406569146, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.72639680329212e-14, 0.0, 0.0, 0.0},
      {1.48690428533299, 0.705300630647569, 2.03602754481992, 1.15175110689979, -2.93221479395416, 1.81702705031799, 1.25178444059441, 0.655663160391217, 3.61359041872288, -1.70346285967311, 0.0, 2.7642026565595, -9.08783875864328, 1.78428514239955, 5.63152770643898, -0.746494073225321, -0.618094504365244, 2.03210252328837, -2.1549427706255, 0.76403348456261, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462395, 0.0, 9.68367982311023, -1.32524448062075, 0.133143804689791, 0.0, -3.35452509157129, -0.478206411017788, 0.384353057392897, -0.124241670058193, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880569, 0.728431359084661, 2.57539376818856, 0.917928424547665, 0.711024300256719, 2.23926008187655, -0.205255035576781, 2.585674822114, 0.761811750275065, 0.0, 0.0, 5.34294273196308, 0.0, 4.13862564412656, 2.68954640486934, 0.0, -1.19471831485579, 3.10562068169858, -2.32269806558126, 0.0, 0.0, 0.0, 0.0, 0.0, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150502, 0.0, 0.0, -2.88176900403078, -1.51261363209513, 0.763985254692617, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, -1.59872115546023e-14, -1.02140518265514e-14, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {1.15175110689979, 0.546323519313511, -0.105140010313424, 3.2711894277325, 0.0, 0.0, 2.69341127303544, 0.0, -0.518347241175136, 4.25171145123352, 0.0, 0.0, -1.46549439250521e-14, 0.0, 0.0, 6.71889089790565, 0.0, 0.0, -1.29305115618718, 1.82865048192214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059452, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376108, -6.78263087840208, 3.68560354207935, -0.814411017927958, -1.95399252334028e-14, 10.0216907612581, 2.67510569439611, 6.00856531485323, -1.4536216402544, 0.321208037219802, -2.22044604925031e-14, 2.1316282072803e-14, 0.0, -7.57008074256671, -2.2727058403442, -0.606656948415846, 6.99294104721299, -1.36261453366203, 0.329650402328139, -0.0728431359084718, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 18.7137404500718, 0.760821741084519, 0.228415531250639, 0.0609713174047686, 5.40219154319687, -0.702817019232754, 0.136947913395212, -0.0331311120155253, 0.0073210106170063, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {1.15175110689981, 3.8242646351946, 2.20794021658199, 0.892142571199756, 1.4210854715202e-14, -2.46306042692148, 6.78739640804924, 2.13307290077017, 3.91870514328395, -1.31949665727937, 0.0, 0.0, 0.0, 3.22490309931941, -7.63378455726038, -4.04762275910192, 1.11713920350153, 6.6110513536048, -2.33689608954553, 0.591817792331162, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108413, 0.721929233499935, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297046, -0.0962371838080749, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.29677388219329e-14, -1.11022302462516e-14, 0.0, 0.0},
      {1.03015750727539, -1.46593983227032, 1.12848100903608, 1.99489143482414, 0.0, 1.10151410945721, -5.20357020296094, 0.476969600708474, 4.00571020990211, 0.590096844352095, 0.0, 1.4210854715202e-14, 0.0, 1.97619698383278e-14, 6.41153127835566, -6.24994106094657, 0.0, 2.77627448210729, 4.8112068719424, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.0440762145518, 0.0, 0.0, 6.69662601613678, -2.34333096254029, 0.59178043363451, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0},
      {0.892142571199763, 0.705300630647548, 0.407205508963994, 2.53385243517953, 0.0, 0.0, 3.47717900165118, 0.0, 2.0075502326238, 3.29336152870136, 0.0, 1.33226762955019e-14, -1.10467190950203e-14, 0.0, 0.0, 8.67405085085772, 1.06581410364015e-14, 0.0, 5.00796559370721, 1.41646657250371, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.04647271886989, -2.27776395106693, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084677, 0.0, 0.0, 2.53908227033121, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237768, 0.0, 0.0, 1.95399252334028e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 1.0991207943789e-14, 0.0, 6.93924068068617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359276, 0.0, -4.65474668125631, -3.29140294302193, -1.24344978758018e-14, -1.50990331349021e-14, 2.1316282072803e-14, 13.490737563232, 1.83585684909536, 1.2981468272831, 0.0, 0.0, -1.4210854715202e-14, 1.4210854715202e-14, 1.24344978758018e-14, 0.0, -3.53270434653113, -3.0594117081557, -0.416333199893252, -0.294392028877599, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.35505014583943, 0.307482445914328, 0.0418430609640565, 0.0295875121532907, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.89848137210902e-14, 0.0},
      {-2.6598552464322, 0.0, 5.09901951359279, -2.06031501455086, 1.33226762955019e-14, 1.19904086659517e-14, -1.4210854715202e-14, -1.23153021346073, 9.049861877399, 3.04724700110021, 0.0, 0.0, 0.0, 0.0, -3.5527136788005e-14, 0.0, 3.86988371918332, -3.8168922786302, -5.39683034546924, -1.36674464685442, 0.0, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, -1.06581410364015e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, 21.00264918355, 0.898213715542057, 0.962572311333265, 0.222250255910581, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 3.19744231092045e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {2.97380857066587, 0.0, -0.814411017927956, 5.75875553449897, -1.73194791841524e-14, 0.0, 2.1316282072803e-14, 1.3768926368215, -2.89087233497831, 1.70346285967311, 0.0, 2.48689957516035e-14, -1.4210854715202e-14, 0.0, 0.0, 1.59872115546023e-14, -1.24344978758018e-14, 8.01441409794464, -3.47218947830362, -5.19371076584692, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3235940121703e-14, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.03015750727544, -2.48689957516035e-14, 0.940400840863432, -2.92584077107541, -1.35447209004269e-14, 0.0, -2.48689957516035e-14, 0.0, 4.63623866886822, -3.80284633026897, 0.0, 2.8421709430404e-14, 1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 1.50990331349021e-14, -1.4210854715202e-14, 11.565401134477, -1.63559471386626, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059784, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376111, 0.0, 0.0, 4.39781949681098, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 8.67261700493488, 0.0, 0.0, 3.37507799486048e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 1.73194791841524e-14, 1.4210854715202e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 1.26565424807268e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494324, -1.77635683940025e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.26565424807268e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.11126385871074e-14, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.61248608016089, -1.08012344973465, -0.763762615825974, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461892, 4.18330013267039, -0.591607978309968, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338695, 7.09929573971952, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.37667655053519e-14, -3.5527136788005e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.31006316905768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, -1.24344978758018e-14, 3.86436713231718, -0.34156502553199, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.31006316905768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, -1.06581410364015e-14, 7.09929573971954, 2.50998007960222, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -2.44249065417534e-14, 0.0, -1.55431223447522e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912988, 0.0, -1.06581410364015e-14, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697347, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113257, 0.346410161513768, 0.282842712474613, 0.2, 0.0, -1.59872115546023e-14, -1.59872115546023e-14, 0.0, -1.68753899743024e-14, -1.47659662275146e-14, 0.0, 1.33226762955019e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772447, 2.44948974278317, 2.8284271247462, -1.0, 1.30930734141596, 7.09929573971952, -0.414039335605402, -2.04939015319193, -0.47809144373376, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, -1.55431223447522e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974978, 2.12132034355965, -0.408248290463864, 3.17542648054295, 9.07114735222145, 0.0, 7.17137165600638, 0.0, -1.38013111868472, -1.56144011671766, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, -4.2632564145606e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033669, 4.38178046004134, -0.774596669241499, 0.0, 3.14233761939828, -0.106904496764967, 4.76235235991627, -0.740656079818042, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681202, 0.547722557505163, 1.5811388300842, 2.45967477524978, 1.06581410364015e-14, 9.07114735222144, 1.85164019954511, 0.0, 5.34522483824848, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.95399252334028e-14, 0.0, 2.30926389122033e-14, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613581, -6.26099033699939, -2.30926389122033e-14, 3.83405790253615, 0.0, 0.0, 10.5830052442584, 1.15463194561016e-14, 0.0, 5.18459255872627, 0.0, 0.0, 0.0, 1.06581410364015e-14, 2.1316282072803e-14, 0.0, -1.64313007644523e-14, 0.0, -2.39808173319034e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.28785870856518e-14},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499965, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824839, 0.0755928946018476, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000004, 1.06581410364015e-14, 1.46059348668045, 1.42009389360938, 0.0, 0.0, 0.0, 9.07114735222147, 4.93770719878695, -0.698297248755177, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283497, 0.0, -6.26099033699942, 2.21359436211787, 0.0, 0.0, 1.06581410364015e-14, 0.0, 10.5830052442584, 2.99332590941915, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497732, 1.24344978758018e-14, 0.0, -4.69574275274958, 1.06581410364015e-14, 0.0, 3.37507799486048e-14, 0.0, -1.06581410364015e-14, 12.69960629311, 0.0, -1.06581410364015e-14, -2.08721928629529e-14, 0.0, 0.0, 1.77635683940025e-14, -1.06581410364015e-14, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473997, -2.01017818278146, -1.42141062443802, 8.14215222512714, -2.1022946646802, -1.71651640581397, 0.728256234341417, 0.594618725379069, 0.420458932936041, 9.81070843517429, -1.18450885369838, -1.02581475831037, 0.305838870920597, 0.264864231681972, 0.21626073957838, -0.105945692672785, -0.0917516612761684, -0.0749149177264175, -0.0529728463363923, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239554, 3.07059789431496, 1.77281052085586, -1.25356634105601, 2.39356776939084, 6.30376871403131, -0.908295106229229, -2.78313372537745, -0.524404424085083, 0.370809924354783, 1.23603308118261, 9.40174755792011, -0.301561193523235, -2.42752078113805, -0.794200206656987, 0.114434427054266, 0.840917865872093, 0.35064189060884, 0.0660687472643469, -0.0467176592151097, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047612, 2.74642624930239, -0.792824967172102, 2.24244764232555, 2.14087209644418, -0.331662479035527, 6.4992307237088, 0.0957427107756388, -1.87616630392937, -2.15580611373101, 11.0554159678513, -2.1316282072803e-14, 9.44035859331466, 0.0, -1.46249406456535, -2.04706526287664, 0.0, 0.422185670932521, 0.590936840285281, 0.522319308773337, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551271, 1.29756443747036, 3.745745886322, -1.05945692672795, 0.404586796856341, 5.01426536422407, -0.383824736789361, 1.80936716113937, -1.10800657553489, 0.313391585264005, 0.0, 2.82521847127455, -0.0509731451534392, 8.20651806648288, -0.631738055305805, 0.0483573714561651, -2.84282124887605, -0.227958835180072, 0.139595707137609, -0.039483628456618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852097, 1.89521416591738, 0.361873432227869, 1.96214168703486, 2.74642624930239, -0.566421515598877, 3.17129986868835, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827825, -0.865042958313596, 0.0, -2.49768411251821, -0.998865569685879, 0.441440386136655, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139073, -0.193429485824682, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034305, 0.0, -0.858258202907006, 2.67027285925185, -1.4210854715202e-14, 1.01030295240889e-14, 12.4373429638327, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683796, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {1.48323969741915, 0.335029697130249, 4.06201920231799, -0.820651806648296, 1.11299858218672e-14, 1.69926454679665, -0.0991031208965194, 5.88642506110459, -1.20156148406978, 0.242752078113808, 0.0, -1.15463194561016e-14, 0.0, 4.94413232473044, -0.214087209644431, 0.0124858196210829, 5.13809303146607, -0.741619848709565, 0.151382517704894, -0.0305838870920692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0},
      {1.32664991614218, 0.299659670905765, 2.07610309995257, 1.46802658041886, 0.0, 0.868496237346897, 0.709124208342343, 1.31624465810883, 4.91295663090393, -1.4113063856887, 0.0, -1.86517468137026e-14, 0.0, 11.0554159678513, 3.82970843102534, -0.223353131420161, 0.0, 5.80409338312194, -1.54743588659733, 0.341938252770112, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930758, 0.259512887494063, 0.749149177264362, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036811, 1.50990331349021e-14, 3.32401972660468, 2.06838446274243, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552746, -1.59872115546023e-14, 0.0, 6.28180682119206, -1.77676328054752, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0},
      {0.938083151964673, 7.62808987244124, 2.30926389122033e-14, 3.11415464992885, 0.0, 0.0, -7.52139804633608, -1.69864122767649e-14, -1.13242748511766e-14, 5.52707620976691, 0.0, 0.0, 1.06581410364015e-14, -1.33226762955019e-14, -3.19744231092045e-14, 14.2141062443803, 1.34336985979644e-14, 1.64313007644523e-14, 1.95399252334028e-14, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577679, 0.0, 2.68023757704196, -0.473803541479345, 0.0, 0.0, -1.06581410364015e-14, 5.09779364038994, -0.792824967172086, 0.140152977645355, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 7.91061171956872, -0.642261628933269, 0.0998865569685985, -0.01765761544547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205081, 2.39808173319034e-14, 1.4982983545288, 0.847565541382366, 0.0, 1.4210854715202e-14, 0.0, 1.62843044502544, 3.54562104171167, -0.814818121686409, 1.06581410364015e-14, -2.1316282072803e-14, 1.77635683940025e-14, 1.4210854715202e-14, -1.06581410364015e-14, 1.37667655053519e-14, 11.0554159678513, 7.18070330817254, -1.11676565710081, 0.19741814228306, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071088, 1.06581410364015e-14, 0.692034366650873, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212813, 3.07059789431493, 1.19418232635199, 0.0, 0.0, 0.0, 2.48689957516035e-14, 0.0, 1.4210854715202e-14, 1.59872115546023e-14, 12.4373429638327, 5.80288457473997, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309067, 0.0, 7.62808987244127, 1.79795802543454, 0.0, 0.0, 0.0, 0.0, -7.52139804633612, 3.19105893754051, 0.0, 1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 1.12687636999453e-14, -1.15463194561016e-14, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451481, -1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, -5.26497863243526, 0.0, 0.0, 3.5527136788005e-14, -1.15463194561016e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.06581410364015e-14, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361256, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910462, 0.869835476750492, 0.615066564126904, 10.333118277332, -2.18326971917504, -1.8907670401189, 0.724780051083752, 0.62767793639472, 0.512496888990055, -0.278967971730977, -0.241593350361244, -0.197260144544827, -0.139483985865489, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516521, -0.0814411017927967, -0.0728431359084678, -0.0630840061880518, -0.0515078753637661, 0.0313466946954453, 0.0280373360835799, 0.0242810453028185, 0.0198253904711074, 0.0140186680417875, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069938, 0.997445717412067, -1.4106012612951, 3.23209352764251, 5.28531208250978, -1.36277028773849, -2.89087233497829, -0.393397896234716, 0.556348640264182, 2.33666428910958, 9.02784807228864, -0.732969916135163, -3.93352933905728, -1.19859611757308, 0.309047252182626, 1.64018416088946, 0.655588223176222, 0.0892142571199899, -0.126168012376108, 1.1908743922773, 11.55277744383, -0.23484359721209, -2.44096975264613, -0.907332870306508, 0.07366624831632, 0.810328731479528, 0.395334573318417, 0.120463442338385, -0.0310604175145487, -0.311895674167864, -0.164844710568316, -0.0658890955530707, -0.00896637020658575, 0.0126803623514082, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940282, -1.09264703862702, 1.54523626091313, 2.95048422176041, -0.761811750275044, 5.59815020469135, 0.263899331455878, -1.9392561165855, -2.28543525082518, 2.13307290077016, -0.257539376818849, 9.14446135479764, 0.0664963811608006, -2.36108976914457, -3.33842298506506, -0.0230350221379944, 0.817905488277884, 1.1564636454577, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.3977187881547, -2.15192884958005, 0.0, 0.360889439280287, 0.555625639776455, 0.595437196138646, 0.0, -0.125015768949698, -0.19247436761616, -0.206265495285703, -0.166687691932943, 0.0, 0.0, -1.04360964314765e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482233189, 1.82834820066017, 2.99085908983327, -1.24403337882028, 0.950146187582611, 5.74064456311312, -0.721110255092799, -0.169967317119746, -1.17961073303081, 0.490653381462665, 0.294392028877595, 4.97613351528118, -0.21547290184283, 5.7817446699566, -1.30185581821821, 0.163532434528642, -3.22682211353224, 0.0385449644663702, 0.26751056943961, -0.111269728052828, 0.0, 2.646387538394, -0.0295875121532858, 10.7636648722209, -0.500120235663634, 0.0216558414515688, -3.57321383950879, -0.581087203147985, 0.130841432732453, -0.0164356280722675, 1.37533064807501, 0.324307824721458, -0.00387391468765175, -0.0268858238268316, 0.0111830284386746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637247, 1.66904592079257, 0.963624111659414, 1.3627702877385, 0.867360833110881, 2.28430636201793, 2.96226264871974, -1.00852844760551, 1.7102631376487, -2.01556443707464, 0.268741924943299, 2.0441554316077, 2.68821895760392, -0.527798662911731, 7.07977053255618, -1.76652739792482, 0.182834820066021, -3.12574097035513, -1.01990506872273, 0.904016610326401, 0.0, 13.0453753561106, 1.45851730441319, 0.0, 11.0940489487798, -0.632607619454905, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468092, 0.0, 0.992281903807267, 0.735567892896448, 0.181909068193167, -0.147004726489969, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493886, 1.49284005458436, -0.430945803685658, 3.04724700110021, 0.775791113542713, -0.120185042515461, 5.29905651979671, 0.0346944333244359, -1.52970585407782, 0.901387818866001, -10.576283741361, 1.15463194561016e-14, 4.5156107826894, -1.04360964314765e-14, -0.699555414372448, 6.36462844462232, 0.0, 0.201944253400475, -1.83730997289731, -2.74825341360597, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.09993548319961, 0.0, 0.0, 0.487107866980279, 0.894874292847877, 0.903959543974644, 0.0, 0.0, -1.33781874467331e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456568, 3.86595114186567, -1.05140010313427, 0.160604018609916, 3.35889012281482, -0.304724700110037, 3.87851223317102, -1.52475169285614, 0.414677792940095, 0.0, 1.135512111385, -0.0364215679542248, 7.32969916135159, -0.761724681099363, 0.0691050664139874, 0.564240504518043, -0.879563899362187, 0.345781182036198, -0.0940400840863448, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162678, 0.00366050530850304, 9.059750638547, -0.736662483163212, 0.0765562109321147, -0.00694532049720864, -3.48709964663733, -0.0567083043941574, 0.0883994979795864, -0.0347523163751431, 0.00945138406568952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {1.48690428533298, 0.705300630647584, 2.03602754481991, 1.15175110689981, 0.146610739697702, 1.817027050318, 1.25178444059442, 0.655663160391223, 3.61359041872286, -1.7034628596731, 0.0, 0.614267257013214, 0.454391937932161, 1.78428514239955, 5.63152770643897, -0.746494073225309, -0.618094504365235, 2.03210252328836, -2.15494277062553, 0.764033484562619, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865874, -0.106930204231198, 0.0, 9.68367982311022, -1.32524448062075, 0.133143804689793, 0.0, -3.35452509157129, -0.478206411017785, 0.384353057392899, -0.124241670058189, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880569, 0.728431359084681, 2.57539376818856, 0.131132632078232, 0.711024300256724, 2.23926008187656, -0.205255035576788, 2.58567482211399, 0.761811750275053, 0.0, -10.576283741361, 0.763277533137579, 1.24344978758018e-14, 4.13862564412656, 2.68954640486933, 1.08801856413265e-14, -1.19471831485578, 3.1056206816986, -2.32269806558127, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241848, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 1.24344978758018e-14, -2.88176900403078, -1.51261363209514, 0.76398525469261, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, -1.21014309684142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, -1.4210854715202e-14},
      {1.15175110689979, 0.546323519313527, -0.105140010313412, 3.27118942773249, 9.65295620481433, -1.02140518265514e-14, 2.69341127303542, 0.0, -0.518347241175119, 4.25171145123353, 0.0, 0.0, -9.91526600752598, 0.0, 0.0, 6.71889089790567, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059453, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376109, 0.199489143482415, 3.68560354207935, -0.814411017927958, 0.0, 1.02786571910339, -0.078679579246943, 6.00856531485323, -1.4536216402544, 0.321208037219809, 0.0, 0.0, 0.0, 3.02803229702669, -0.2330980349071, 0.0178428514239943, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084669, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433803, 0.0234272339744236, -0.00179327404131602, 5.40219154319688, -0.702817019232749, 0.136947913395217, -0.0331311120155255, 0.00732101061700685, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {1.15175110689975, 0.182107839771152, 2.20794021658199, 0.892142571199752, -1.4210854715202e-14, 0.615765106730371, 0.32320935276422, 2.13307290077017, 3.91870514328394, -1.31949665727937, 0.0, 0.0, 1.02140518265514e-14, 1.07496769977314, 1.90844613931508, -0.192743940909618, 1.11713920350153, 6.61105135360478, -2.33689608954553, 0.591817792331155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771028, 0.0343775825476166, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297044, -0.0962371838080771, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 1.65423230669148e-14, 0.0, 0.0, 0.0},
      {1.03015750727541, 0.162882203585591, 1.12848100903608, 1.99489143482414, 0.0, 0.314718316987764, 0.578174466995661, 0.476969600708475, 4.00571020990213, 0.590096844352082, 0.0, 0.0, 0.0, -10.576283741361, 1.83186607953016, 0.694437895660752, 0.0, 2.77627448210727, 4.8112068719424, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780438, -0.338230690505755, -1.4210854715202e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634515, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199777, 0.141060126129509, 0.407205508964008, 2.53385243517952, 0.0, 9.65295620481432, 0.695435800330246, 0.0, 2.0075502326238, 3.29336152870135, 0.0, 1.59872115546023e-14, -1.26565424807268e-14, 0.0, -9.91526600752598, 1.73481017017154, 2.62012633811537e-14, 0.0, 5.00796559370722, 1.41646657250369, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 2.44096975264614, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {0.728431359084674, -7.94708263760856, 0.0, 2.5390822703312, 0.0, 0.0, 10.2207771580387, 0.0, 0.0, 5.00713776237769, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, -8.49879943502222, -1.4210854715202e-14, 0.0, 0.0, 6.93924068068618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 0.0, 0.0, 0.0, 1.15463194561016e-14, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084662, 0.0, 2.32737334062816, -0.470200420431693, 0.0, 0.0, 1.59872115546023e-14, 4.49691252107736, -0.917928424547695, 0.185449546754731, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0654086930623, -1.01980390271857, 0.20816659994661, -0.042056004125357, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678881, 0.10249414863811, -0.0209215304820316, 0.00422678745047178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608005, 0.0, 1.45686271816938, 0.51507875363772, 0.0, 0.0, 1.4210854715202e-14, 1.84729532019112, 2.58567482211398, -0.761811750275054, 1.4210854715202e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.71994831963705, 5.72533841794521, -1.54195152727693, 0.341686161713623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 13.0453753561106, 9.33451074824442, -1.3473205733131, 0.275020660380936, -0.055562563977638, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {0.594761714133161, 0.0, 0.814411017927945, 1.15175110689979, -1.33226762955019e-14, 0.0, -1.24344978758018e-14, 0.590096844352066, 2.89087233497828, 0.340692571934627, 0.0, 1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 1.59872115546023e-14, -10.576283741361, 3.43474889911911, 3.47218947830366, -1.03874215316938, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 8.28492607088318, -1.69115345252877, 0.341664592660038, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.515078753637698, 0.0, 0.376160336345346, 1.46292038553769, 0.0, 0.0, 2.53130849614536e-14, 9.65295620481433, 1.85449546754729, 1.90142316513449, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -9.91526600752596, 4.6261604537908, 0.817797356933113, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 15.9443476574685, 6.50925267372302, -1.31506763029893, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {0.420560041253698, -1.90958360235527e-14, -7.94708263760857, 1.46593983227031, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497828, 0.0, 1.95399252334028e-14, -2.1316282072803e-14, -1.06581410364015e-14, 0.0, -1.59872115546023e-14, -1.68753899743024e-14, 0.0, -8.49879943502225, 4.00637247496573, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 17.9373911146521, 3.6239002554188, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {6.54237885546497, 0.0, 1.73194791841524e-14, -6.9105066413987, 0.0, 0.0, -3.46389583683049e-14, 1.33226762955019e-14, 0.0, 12.2649325896465, 0.0, 0.0, 1.77635683940025e-14, 0.0, -3.5527136788005e-14, -1.95399252334028e-14, 0.0, 2.64233079860787e-14, 1.4210854715202e-14, -5.6658662900148, 0.0, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 1.4210854715202e-14, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, -2.30926389122033e-14, 0.0, -1.14352971536391e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 1.86517468137026e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923487, -0.00609788120679259, 0.00352061335622804, 0.00248944957812477, 0.0070594623332504, -0.0054682360099715, -0.00446479600584757, 0.00315708753234942, 0.00257775117585286, 0.00182274533665716, 0.00298267418725716, -0.00252081977982929, -0.00218309396769447, 0.00195261860521384, 0.00169101731601731, 0.00138070985681772, -0.00112734487734488, -0.000976309302606918, -0.000797153207506475, -0.000563672438672439, 0.00278687112460003, -0.00245778931055953, -0.00219831358911339, 0.00207721109304566, 0.00185791408306669, 0.00160900079398462, -0.00160900079398463, -0.0014391340604803, -0.0012463266558274, -0.00101762145320216, 0.00092895704153335, 0.000830884437218259, 0.000719567030240153, 0.000587524019939406, 0.000415442218609129, 0.00705593524717798, -0.00638233357089082, -0.00582624677716566, 0.00562868913761197, 0.00513826668309062, 0.0045958054359652, -0.00475711057319694, -0.00434262794914382, -0.00388416451811044, -0.00336378514516178, 0.00368484200521179, 0.00336378514516178, 0.00300866089851429, 0.00260557676948629, 0.00212744452363026, -0.00212744452363027, -0.00194208225905521, -0.00173705117965753, -0.00150433044925715, -0.00122828066840393, -0.000868525589828762};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033678, -2.48689957516035e-14, 0.0, 0.0, 1.04360964314765e-14, -1.77635683940025e-14, -1.46549439250521e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.48787232534531e-14, 0.0, -3.19744231092045e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.41948691584548e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.4210854715202e-14, -1.15463194561016e-14, 0.0, 1.54888466424096e-14, 0.0, 0.0, 0.0, -1.50990331349021e-14, -2.30926389122033e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, -4.08562073062058e-14, 8.36660026534077, -1.18321595661994, 0.0, -2.53130849614536e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, -3.28626015289046e-14, 0.0, -1.90958360235527e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, -2.8421709430404e-14, 0.0, 8.69482604771367, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -4.9737991503207e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394698, 0.0, -3.34664010613629, -2.36643191323984, 15.4919333848297, 0.0, 2.30926389122033e-14, 0.692820323027545, 0.565685424949236, 0.4, 0.0, -2.8421709430404e-14, -1.4210854715202e-14, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0},
      {2.89768209427166e-14, 4.89897948556636, 2.1316282072803e-14, 0.0, 1.06581410364015e-14, 14.1985914794391, -0.828078671210806, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 1.68753899743024e-14, 2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, -2.1316282072803e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, -2.1316282072803e-14, 0.0, 0.0, 0.0, 14.3427433120128, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, -4.08562073062058e-14, 0.0, 1.73194791841524e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {3.6, -2.04281036531029e-14, 8.76356092008267, -1.549193338483, 0.0, -1.06581410364015e-14, 0.0, 9.52470471983255, -1.48131215963607, 0.261861468283193, 0.0, -1.4210854715202e-14, 0.0, -2.1316282072803e-14, -1.4210854715202e-14, 0.0, 1.4210854715202e-14, -1.77635683940025e-14, 2.1316282072803e-14, -2.79776202205539e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 1.11022302462516e-14, 0.0, 0.0, -1.29896093881143e-14},
      {3.11769145362399, -2.95319324550292e-14, 3.16227766016838, 4.91934955049954, 0.0, -2.75612865863195e-14, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 1.06581410364015e-14, -2.22044604925031e-14, -1.50990331349021e-14, -3.71369601737115e-14, 0.0, 0.0, -3.90798504668055e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, -1.24344978758018e-14, 0.0, 0.0, -1.95399252334028e-14, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, -1.19904086659517e-14, 7.66811580507232, 0.0, 0.0, 2.38697950294409e-14, 0.0, -1.77635683940025e-14, 10.3691851174526, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.22124532708767e-14, -1.24344978758018e-14, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.55111512312578e-14, 11.6057691494799, 0.0, 0.0, 0.0, -4.20458932936039, -3.43303281162796, 0.0, 0.0, 0.0, 19.6214168703486, -1.77635683940025e-14, -1.59872115546023e-14, 0.61167774184119, 0.529728463363962, 0.432521479156773, 0.0, 0.0, 1.90958360235527e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1878460182374e-14, 0.0, -1.06581410364015e-14, 1.24344978758018e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479106, 0.0, 3.54562104171168, -2.50713268211202, 4.78713553878169, 0.0, 2.01505478969466e-14, -5.56626745075489, -1.04880884817015, 0.741619848709564, 0.0, 18.8034951158402, -0.603122387046459, 0.0, -2.75335310107039e-14, 0.0, 1.68183573174417, 0.701283781217668, 0.132137494528686, -0.0934353184302177, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095214, 1.46549439250521e-14, -1.58564993434419, 4.48489528465112, 4.28174419288837, 0.0, 2.8421709430404e-14, 0.191485421551263, -3.75233260785876, -4.31161222746203, 0.0, -1.24344978758018e-14, 18.8807171866293, 0.0, -2.8421709430404e-14, 1.77635683940025e-14, 0.0, 0.844371341865036, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.95079541199084e-14, 2.59512887494073, 2.8421709430404e-14, 1.59872115546023e-14, 1.4210854715202e-14, 10.0285307284481, -0.76764947357873, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061159, 0.0967147429123472, 2.1316282072803e-14, 2.1316282072803e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989599, 0.0, 0.0, 0.0, 3.92428337406972, 5.49285249860479, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662718, 0.0, 2.8421709430404e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278145, 0.0, 0.0, 0.0, 0.0, 8.91928088068606, 0.0, 0.0, 0.0, 0.0, 0.0, 3.01980662698043e-14, 0.0, 0.0, 16.8558564884488, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483828, 0.0, 8.12403840463598, -1.6413036132966, 1.06581410364015e-14, 0.0, -1.77635683940025e-14, 11.7728501222092, -2.40312296813957, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741915, 0.302765035409783, -0.061167774184141, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.57571741713036e-14, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 2.62012633811537e-14, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990516, 2.93605316083771, 0.0, -1.28785870856518e-14, 0.0, 2.63248931621765, 9.82591326180785, -2.8226127713774, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 1.38777878078145e-14, 11.6081867662439, -3.09487177319466, 0.683876505540219, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.28785870856518e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.83741910575463e-14, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, -1.24344978758018e-14, 1.26565424807268e-14, -1.28785870856518e-14},
      {2.29782505861523, 0.0, 1.49829835452876, 5.50917601898537, 0.0, 0.0, 0.0, 0.0, 6.64803945320938, 4.13676892548486, 0.0, -1.15463194561016e-14, 0.0, 0.0, -2.1316282072803e-14, -2.1316282072803e-14, 0.0, 0.0, 12.5636136423841, -3.55352656109505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0},
      {1.87616630392939, 1.15463194561016e-14, 0.0, 6.22830929985769, 0.0, 0.0, 3.90798504668055e-14, 0.0, -1.77635683940025e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722506, 0.0, -4.41087092453691, -3.11895674167864, 16.6749979177077, 1.02140518265514e-14, 0.0, 2.13065307820925, 1.73967095350099, 1.23013312825381, -1.4210854715202e-14, -4.36653943835008, -3.7815340802378, 0.0, 2.48689957516035e-14, 1.24344978758018e-14, -0.557935943461974, -0.483186700722504, -0.394520289089682, -0.278967971730994, 23.6981011897578, 0.0, 0.0, 0.490653381462664, 0.438853725736261, 0.380058475033041, 0.0, 0.0, 0.0, 0.0, 0.0626933893908879, 0.0560746721671604, 0.048562090605635, 0.0396507809422171, 0.0280373360835759, -1.06581410364015e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.91050664139875, -1.04360964314765e-14, 0.0, 0.0, 10.5706241650195, -2.725540575477, 2.28705943072782e-14, 0.0, 0.0, 4.67332857821917, -4.44089209850063e-14, 0.0, -7.86705867811457, -2.39719223514613, 0.618094504365247, 0.0, 0.0, 1.64313007644523e-14, 0.0, 0.0, 23.1055548876599, -0.469687194424181, 0.0, 0.0, 0.0, 1.62065746295905, 0.790669146636831, 0.240926884676766, -0.062120835029098, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.62012633811537e-14, 0.0, 1.77635683940025e-14, 1.11022302462516e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {3.81916720471054e-14, 6.30840061880562, 1.59872115546023e-14, -1.59872115546023e-14, 0.0, -1.5236235005501, 11.1963004093827, 0.0, 0.0, 0.0, 4.26614580154031, 0.0, -2.48689957516035e-14, 0.132992762321612, -4.72217953828915, -6.67684597013015, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 1.06581410364015e-14, 0.0, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560579, 1.11125127955291, 1.19087439227729, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 1.15463194561016e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {3.85449644663773, 2.30926389122033e-14, 5.98171817966648, -2.48806675764059, 1.90029237516521, 1.95399252334028e-14, 0.0, -0.339934634239501, -2.35922146606162, 0.981306762925323, 0.0, 9.9522670305624, -0.43094580368566, 0.0, 0.0, 2.48689957516035e-14, -6.45364422706454, 0.0770899289327254, 0.535021138879209, -0.222539456105663, 0.0, 1.02140518265514e-14, 0.0, 21.5273297444417, -1.00024047132727, 0.0433116829031313, 0.0, 0.0, 0.0, 0.0, 2.75066129615, 0.648615649442922, -0.00774782937530727, -0.0537716476536625, 0.0223660568773498, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274496, 2.22044604925031e-14, 1.92724822331888, 2.72554057547701, 1.73472166622177, 0.0, 4.2632564145606e-14, -2.01705689521107, 3.4205262752974, -4.03112887414928, 0.0, 4.08831086321546, 5.37643791520785, 0.0, -3.5527136788005e-14, 2.22044604925031e-14, 0.365669640132043, -6.25148194071026, -2.03981013744546, 1.8080332206528, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.2652152389098, 0.0, 0.0, 0.0, 0.0, 0.0, 1.98456380761455, 1.4711357857929, 0.363818136386334, -0.294009452979941, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0},
      {3.14718316987776, 0.0, -0.861891607371339, 6.09449400220043, 1.55158222708542, 1.24344978758018e-14, 0.0, 0.0693888666488744, -3.05941170815567, 1.802775637732, 0.0, 1.7874590696465e-14, 9.03122156537879, 0.0, -2.22044604925031e-14, 3.19744231092045e-14, 0.0, 0.403888506800969, -3.67461994579464, -5.49650682721195, 0.0, 0.0, 0.0, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.97421573396055, 1.78974858569576, 1.80791908794929, 0.0, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, -1.06581410364015e-14, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-2.8421709430404e-14, 1.54523626091312, 0.0, 0.0, 0.0, 6.71778024562962, -0.609449400220045, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 14.6593983227032, -1.52344936219871, 0.138210132827959, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864222, -0.0138906409944113, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {3.73034936274053e-14, 1.41060126129512, 1.59872115546023e-14, 1.4210854715202e-14, 0.0, 3.63405410063598, 2.50356888118885, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 3.56857028479908, 11.2630554128779, -1.49298814645065, 0.0, -1.4210854715202e-14, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124152, 0.266287609379576, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14},
      {-4.88498130835069e-14, 1.2616801237611, -1.59872115546023e-14, -1.4210854715202e-14, 0.0, 1.42204860051344, 4.4785201637531, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 8.27725128825315, 5.37909280973864, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.9654813226339, -2.61992366301005, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 1.77635683940025e-14, 0.0, -1.4210854715202e-14},
      {-2.97539770599542e-14, 1.09264703862701, 1.50990331349021e-14, 0.0, 0.0, -1.4210854715202e-14, 5.38682254607083, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.3988810110277e-14, -2.26485497023532e-14, 0.0, -1.33226762955019e-14, 13.4377817958113, 1.06581410364015e-14, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752222, 1.4210854715202e-14, 7.37120708415868, -1.62882203585591, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050879, 0.642416074439624, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882094426, -2.72522906732404, 0.659300804656283, -0.145686271816937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846549, 0.273895826790434, -0.0662622240310455, 0.0146420212340158, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {2.30350221379958, 0.0, 4.41588043316396, 1.78428514239951, 0.0, 0.0, -3.01980662698043e-14, 4.26614580154033, 7.83741028656787, -2.63899331455874, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 2.23427840700305, 13.2221027072096, -4.67379217909108, 1.1836355846623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 12.1258851598178, -3.11150358274814, 0.833612074594097, -0.192474367616154, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.66453525910038e-14, 1.84297022087776e-14, -1.56541446472147e-14, 1.64313007644523e-14, 0.0},
      {2.06031501455086, 1.4210854715202e-14, 2.25696201807216, 3.9897828696483, 0.0, 0.0, 2.39808173319034e-14, 0.953939201416929, 8.01142041980428, 1.18019368870417, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.77635683940025e-14, 1.4210854715202e-14, -1.06581410364015e-14, 5.55254896421457, 9.62241374388481, -3.59830837050571, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239956, 0.0, 0.814411017927968, 5.06770487035906, 0.0, 0.0, 2.48689957516035e-14, 0.0, 4.01510046524761, 6.5867230574027, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, -1.77635683940025e-14, 10.0159311874144, 2.8329331450074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 14.0929454377398, -4.55552790213387, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0},
      {1.45686271816935, 1.06581410364015e-14, 0.0, 5.07816454066241, -1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 10.0142755247554, 0.0, 0.0, 3.90798504668055e-14, 0.0, -2.30926389122033e-14, 0.0, 0.0, 2.19824158875781e-14, 1.77635683940025e-14, 13.8784813613723, 0.0, 0.0, 0.0, 0.0, -1.37667655053519e-14, -1.06581410364015e-14, 0.0, 1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 12.5535587278944, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.45439216225896e-14, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505168, -2.48689957516035e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.49637247037759e-14, 0.0, -3.01980662698043e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.61248608016089, -1.08012344973465, -0.763762615825974, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.2456883730947, 4.18330013267038, -0.591607978309975, 0.0, -1.4210854715202e-14, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -2.8421709430404e-14, 0.0, 1.0325074129014e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.44051437445114e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, -1.4210854715202e-14, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106461, -1.4210854715202e-14, 9.66091783079297, 0.683130051063949, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.68753899743024e-14, 0.0, 1.4210854715202e-14, 0.0, -1.15463194561016e-14, -1.4210854715202e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, -2.30926389122033e-14, 0.0, 7.52994023880669, 0.0, -1.02140518265514e-14, -1.59872115546023e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -3.90798504668055e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697347, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113257, 0.346410161513768, 0.282842712474613, 0.2, 0.0, -1.59872115546023e-14, -1.59872115546023e-14, 0.0, -1.68753899743024e-14, -1.47659662275146e-14, 0.0, 1.33226762955019e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278316, 2.82842712474622, -0.999999999999997, 9.16515138991168, 7.09929573971952, -0.414039335605381, -2.04939015319193, -0.478091443733767, 0.169030850945705, 2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 1.86517468137026e-14, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355963, -0.408248290463877, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671766, 0.0, 0.0, 0.0, 0.0, 0.0, -4.2632564145606e-14, 0.0, 0.0, -1.59872115546023e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.26565424807268e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000005, -5.69209978830307, 4.38178046004135, -0.77459666924149, 1.77635683940025e-14, 10.998181667894, 0.962140470884736, 4.76235235991627, -0.74065607981803, 0.1309307341416, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752581, 1.58113883008417, 2.45967477524976, 0.0, -1.02140518265514e-14, 9.25820099772553, 0.0, 5.34522483824848, -1.20948631362953, 0.0, 0.0, 1.59872115546023e-14, -1.33226762955019e-14, 0.0, -5.06261699229071e-14, 0.0, 1.4210854715202e-14, -3.19744231092045e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, -1.17683640610267e-14, -1.64313007644523e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 1.19348975147204e-14, 0.0, 0.0, 5.18459255872628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270666, -2.8421709430404e-14, -3.16227766016839, -2.23606797749981, 0.0, 0.0, -2.48689957516035e-14, 13.7477270848675, 0.534522483824869, 0.377964473009236, -2.8421709430404e-14, -2.15938378289593e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 2.84494650060196e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.85407245112401e-14, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.6514837167011, -2.8401877872188, 0.0, 0.0, 2.8421709430404e-14, 1.15463194561016e-14, 12.3442679969673, 1.39659449751036, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.24344978758018e-14, -3.99680288865056e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.20454076850487, 1.28785870856518e-14, 0.0, 6.64078308635358, 0.0, 0.0, 2.08721928629529e-14, 0.0, -1.24344978758018e-14, 8.97997772825744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473997, -2.01017818278146, -1.42141062443802, 8.14215222512714, -2.1022946646802, -1.71651640581397, 0.728256234341417, 0.594618725379069, 0.420458932936041, 9.81070843517429, -1.18450885369838, -1.02581475831037, 0.305838870920597, 0.264864231681972, 0.21626073957838, -0.105945692672785, -0.0917516612761684, -0.0749149177264175, -0.0529728463363923, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239559, 3.07059789431498, 1.77281052085585, -1.25356634105601, 2.39356776939085, 6.30376871403132, -0.908295106229227, -2.78313372537745, -0.524404424085072, 0.370809924354783, 11.1242977306435, 9.4017475579201, -0.301561193523241, -2.42752078113805, -0.794200206656987, 0.114434427054269, 0.840917865872093, 0.350641890608839, 0.0660687472643508, -0.0467176592151073, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047606, 2.74642624930239, -0.792824967172102, 2.24244764232555, 2.14087209644418, -0.331662479035535, 6.4992307237088, 0.095742710775629, -1.87616630392938, -2.15580611373101, 1.06581410364015e-14, 0.0, 9.44035859331467, 0.0, -1.46249406456536, -2.04706526287664, 0.0, 0.422185670932525, 0.590936840285275, 0.522319308773337, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01585406753202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551273, 1.29756443747036, 3.74574588632199, -1.05945692672795, -8.09173593712688, 5.01426536422408, -0.383824736789381, 1.80936716113938, -1.10800657553488, 0.313391585264006, 0.0, 12.7134831207354, 1.01946290306867, 8.20651806648289, -0.631738055305803, 0.0483573714561754, -2.84282124887605, -0.227958835180086, 0.139595707137602, -0.0394836284566153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715532, 1.160576914948, 1.34011878852097, 1.89521416591739, 2.53311402559511, 1.96214168703485, 2.74642624930243, -0.566421515598881, 3.17129986868835, -1.82198870938951, 0.0, -1.11022302462516e-14, 11.1699829238239, -1.06581410364015e-14, 8.65223156827826, -0.865042958313582, 0.0, -2.49768411251821, -0.998865569685881, 0.441440386136652, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -2.48689957516035e-14, -1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824669, 3.55615782880926, 0.0, 0.0, 4.45964044034303, 0.0, -0.858258202906998, 2.67027285925185, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422439, 0.0, 0.0, -1.62195554683795, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 7.03562363973514, 4.06201920231801, -0.820651806648293, 0.0, -6.79705818718656, -2.08116553882676, 5.8864250611046, -1.20156148406977, 0.242752078113808, 0.0, -2.1316282072803e-14, 0.0, 14.8323969741913, 0.856348838577661, 0.262202212042544, 5.13809303146608, -0.741619848709579, 0.151382517704904, -0.0305838870920607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02060590481778e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815182, 2.07610309995257, 1.46802658041886, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090391, -1.41130638568869, 0.0, 0.0, -1.24344978758018e-14, 0.0, 13.4039795085887, 2.01017818278148, 0.0, 5.80409338312194, -1.54743588659734, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 1.02695629777827e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4432899320127e-14, 0.0, 0.0, -1.62092561595273e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 1.29756443747035, 0.749149177264378, 2.75458800949268, 0.0, 0.0, 5.75737105184055, 0.0, 3.32401972660469, 2.06838446274243, 0.0, -1.28785870856518e-14, 0.0, 0.0, -1.59872115546023e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119206, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.938083151964694, 0.0, 0.0, 3.11415464992884, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964689, 1.89521416591739, 0.0, 0.0, 0.0, -3.39852909359327, -2.77488738510234, -0.560611910581399, 0.0, 1.4210854715202e-14, 0.0, 1.77635683940025e-14, 0.0, 0.0, 17.7988763690296, 0.428174419288845, 0.349602949390066, 0.0706304617818807, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 1.77635683940025e-14, -1.49829835452876, 4.2378277069118, -1.29340982368831e-14, 1.24344978758018e-14, -3.10862446895044e-14, 3.79967103839267, -3.54562104171167, -4.07409060843205, 1.4210854715202e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, 1.77635683940025e-14, 0.0, 16.7549743857359, 1.11676565710086, 0.987090711415302, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, -2.66453525910038e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0},
      {-1.32664991614215, 1.95399252334028e-14, 1.73008591662713, -3.18072425757421, 0.0, 0.0, 0.0, 0.0, 7.67649473578738, -2.38836465270395, 0.0, 0.0, 2.8421709430404e-14, 0.0, 0.0, 2.48689957516035e-14, 0.0, 0.0, 14.5072114368499, 2.05162951662075, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630363, 0.0, 0.0, 3.73034936274053e-14, 0.0, -1.24344978758018e-14, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361256, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910462, 0.869835476750492, 0.615066564126904, 10.333118277332, -2.18326971917504, -1.8907670401189, 0.724780051083752, 0.62767793639472, 0.512496888990055, -0.278967971730977, -0.241593350361244, -0.197260144544827, -0.139483985865489, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516521, -0.0814411017927967, -0.0728431359084678, -0.0630840061880518, -0.0515078753637661, 0.0313466946954453, 0.0280373360835799, 0.0242810453028185, 0.0198253904711074, 0.0140186680417875, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725406, 3.45525332069938, 0.997445717412056, -1.4106012612951, 3.2320935276425, 5.28531208250978, -1.3627702877385, -2.89087233497828, -0.393397896234713, 0.556348640264176, 2.33666428910958, 9.02784807228866, -0.732969916135154, -3.93352933905728, -1.19859611757306, 0.309047252182632, 1.64018416088946, 0.655588223176217, 0.0892142571199757, -0.126168012376112, 13.0996183150503, 11.55277744383, -0.234843597212092, -2.44096975264613, -0.907332870306506, 0.0736662483163188, 0.810328731479524, 0.395334573318416, 0.120463442338386, -0.031060417514547, -0.311895674167857, -0.164844710568314, -0.0658890955530745, -0.00896637020658053, 0.0126803623514053, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482413, 3.15420030940281, -1.09264703862701, 1.54523626091313, 2.95048422176041, -0.761811750275046, 5.59815020469136, 0.263899331455872, -1.93925611658551, -2.28543525082517, 2.13307290077016, -0.257539376818862, 9.14446135479763, 0.0664963811608028, -2.36108976914459, -3.33842298506508, -0.0230350221379902, 0.817905488277889, 1.15646364545771, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.3977187881547, -2.15192884958004, 0.0, 0.360889439280293, 0.555625639776453, 0.595437196138646, 0.0, -0.125015768949699, -0.192474367616155, -0.206265495285708, -0.166687691932939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331884, 1.82834820066015, 2.99085908983325, -1.24403337882029, 0.950146187582618, 5.74064456311311, -0.721110255092816, -0.169967317119732, -1.17961073303081, 0.490653381462656, -10.3037210107158, 4.97613351528118, -0.215472901842828, 5.78174466995661, -1.3018558182182, 0.163532434528636, -3.22682211353225, 0.0385449644663654, 0.267510569439617, -0.111269728052835, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663636, 0.0216558414515651, -3.5732138395088, -0.581087203147984, 0.130841432732455, -0.0164356280722688, 1.37533064807501, 0.324307824721448, -0.00387391468765075, -0.0268858238268341, 0.0111830284386727, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637251, 1.66904592079258, 0.963624111659453, 1.3627702877385, 0.867360833110876, 2.28430636201793, 2.96226264871975, -1.00852844760553, 1.7102631376487, -2.01556443707463, 2.41867732448957, 2.04415543160773, 2.68821895760391, -0.527798662911733, 7.07977053255616, -1.7665273979248, 0.182834820066026, -3.12574097035513, -1.01990506872272, 0.904016610326403, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.6326076194549, 0.0, -2.8644711213756, -1.66605356688627, 0.31507574846809, 0.0, 0.992281903807282, 0.735567892896452, 0.181909068193165, -0.147004726489971, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, -2.04281036531029e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458435, -0.430945803685674, 3.04724700110021, 0.775791113542706, -0.120185042515456, 5.29905651979673, 0.0346944333244417, -1.52970585407783, 0.901387818866002, 0.0, 0.0, 4.51561078268941, 0.0, -0.699555414372428, 6.36462844462229, 0.0, 0.201944253400487, -1.83730997289732, -2.74825341360597, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980271, 0.894874292847878, 0.903959543974647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585588, 0.772618130456575, 3.86595114186568, -1.05140010313426, 9.1544290607646, 3.35889012281482, -0.304724700110037, 3.87851223317103, -1.52475169285614, 0.414677792940099, 0.0, -9.46260092820843, -2.07602937339135, 7.3296991613516, -0.761724681099355, 0.0691050664139841, 0.564240504518073, -0.879563899362193, 0.34578118203621, -0.0940400840863395, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355638, 0.208648802584717, 9.059750638547, -0.736662483163211, 0.0765562109321121, -0.00694532049720742, -3.48709964663733, -0.0567083043941636, 0.0883994979795868, -0.0347523163751426, 0.00945138406569146, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.72639680329212e-14, 0.0, 0.0, 0.0},
      {1.48690428533299, 0.705300630647569, 2.03602754481992, 1.15175110689979, -2.93221479395416, 1.81702705031799, 1.25178444059441, 0.655663160391217, 3.61359041872288, -1.70346285967311, 0.0, 2.7642026565595, -9.08783875864328, 1.78428514239955, 5.63152770643898, -0.746494073225321, -0.618094504365244, 2.03210252328837, -2.1549427706255, 0.76403348456261, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462395, 0.0, 9.68367982311023, -1.32524448062075, 0.133143804689791, 0.0, -3.35452509157129, -0.478206411017788, 0.384353057392897, -0.124241670058193, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880569, 0.728431359084661, 2.57539376818856, 0.917928424547665, 0.711024300256719, 2.23926008187655, -0.205255035576781, 2.585674822114, 0.761811750275065, 0.0, 0.0, 5.34294273196308, 0.0, 4.13862564412656, 2.68954640486934, 0.0, -1.19471831485579, 3.10562068169858, -2.32269806558126, 0.0, 0.0, 0.0, 0.0, 0.0, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150502, 0.0, 0.0, -2.88176900403078, -1.51261363209513, 0.763985254692617, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, -1.59872115546023e-14, -1.02140518265514e-14, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {1.15175110689979, 0.546323519313511, -0.105140010313424, 3.2711894277325, 0.0, 0.0, 2.69341127303544, 0.0, -0.518347241175136, 4.25171145123352, 0.0, 0.0, -1.46549439250521e-14, 0.0, 0.0, 6.71889089790565, 0.0, 0.0, -1.29305115618718, 1.82865048192214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059452, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376108, -6.78263087840208, 3.68560354207935, -0.814411017927958, -1.95399252334028e-14, 10.0216907612581, 2.67510569439611, 6.00856531485323, -1.4536216402544, 0.321208037219802, -2.22044604925031e-14, 2.1316282072803e-14, 0.0, -7.57008074256671, -2.2727058403442, -0.606656948415846, 6.99294104721299, -1.36261453366203, 0.329650402328139, -0.0728431359084718, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 18.7137404500718, 0.760821741084519, 0.228415531250639, 0.0609713174047686, 5.40219154319687, -0.702817019232754, 0.136947913395212, -0.0331311120155253, 0.0073210106170063, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {1.15175110689981, 3.8242646351946, 2.20794021658199, 0.892142571199756, 1.4210854715202e-14, -2.46306042692148, 6.78739640804924, 2.13307290077017, 3.91870514328395, -1.31949665727937, 0.0, 0.0, 0.0, 3.22490309931941, -7.63378455726038, -4.04762275910192, 1.11713920350153, 6.6110513536048, -2.33689608954553, 0.591817792331162, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108413, 0.721929233499935, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297046, -0.0962371838080749, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.29677388219329e-14, -1.11022302462516e-14, 0.0, 0.0},
      {1.03015750727539, -1.46593983227032, 1.12848100903608, 1.99489143482414, 0.0, 1.10151410945721, -5.20357020296094, 0.476969600708474, 4.00571020990211, 0.590096844352095, 0.0, 1.4210854715202e-14, 0.0, 1.97619698383278e-14, 6.41153127835566, -6.24994106094657, 0.0, 2.77627448210729, 4.8112068719424, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.0440762145518, 0.0, 0.0, 6.69662601613678, -2.34333096254029, 0.59178043363451, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0},
      {0.892142571199763, 0.705300630647548, 0.407205508963994, 2.53385243517953, 0.0, 0.0, 3.47717900165118, 0.0, 2.0075502326238, 3.29336152870136, 0.0, 1.33226762955019e-14, -1.10467190950203e-14, 0.0, 0.0, 8.67405085085772, 1.06581410364015e-14, 0.0, 5.00796559370721, 1.41646657250371, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.04647271886989, -2.27776395106693, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084677, 0.0, 0.0, 2.53908227033121, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237768, 0.0, 0.0, 1.95399252334028e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 1.0991207943789e-14, 0.0, 6.93924068068617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359276, 0.0, -4.65474668125631, -3.29140294302193, -1.24344978758018e-14, -1.50990331349021e-14, 2.1316282072803e-14, 13.490737563232, 1.83585684909536, 1.2981468272831, 0.0, 0.0, -1.4210854715202e-14, 1.4210854715202e-14, 1.24344978758018e-14, 0.0, -3.53270434653113, -3.0594117081557, -0.416333199893252, -0.294392028877599, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.35505014583943, 0.307482445914328, 0.0418430609640565, 0.0295875121532907, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.89848137210902e-14, 0.0},
      {-2.6598552464322, 0.0, 5.09901951359279, -2.06031501455086, 1.33226762955019e-14, 1.19904086659517e-14, -1.4210854715202e-14, -1.23153021346073, 9.049861877399, 3.04724700110021, 0.0, 0.0, 0.0, 0.0, -3.5527136788005e-14, 0.0, 3.86988371918332, -3.8168922786302, -5.39683034546924, -1.36674464685442, 0.0, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, -1.06581410364015e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, 21.00264918355, 0.898213715542057, 0.962572311333265, 0.222250255910581, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 3.19744231092045e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {2.97380857066587, 0.0, -0.814411017927956, 5.75875553449897, -1.73194791841524e-14, 0.0, 2.1316282072803e-14, 1.3768926368215, -2.89087233497831, 1.70346285967311, 0.0, 2.48689957516035e-14, -1.4210854715202e-14, 0.0, 0.0, 1.59872115546023e-14, -1.24344978758018e-14, 8.01441409794464, -3.47218947830362, -5.19371076584692, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3235940121703e-14, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.03015750727544, -2.48689957516035e-14, 0.940400840863432, -2.92584077107541, -1.35447209004269e-14, 0.0, -2.48689957516035e-14, 0.0, 4.63623866886822, -3.80284633026897, 0.0, 2.8421709430404e-14, 1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 1.50990331349021e-14, -1.4210854715202e-14, 11.565401134477, -1.63559471386626, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059784, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376111, 0.0, 0.0, 4.39781949681098, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 8.67261700493488, 0.0, 0.0, 3.37507799486048e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 1.73194791841524e-14, 1.4210854715202e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 1.26565424807268e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494324, -1.77635683940025e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.26565424807268e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.11126385871074e-14, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.61248608016089, -1.08012344973465, -0.763762615825974, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461892, 4.18330013267039, -0.591607978309968, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338695, 7.09929573971952, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.37667655053519e-14, -3.5527136788005e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.31006316905768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, -1.24344978758018e-14, 3.86436713231718, -0.34156502553199, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.31006316905768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, -1.06581410364015e-14, 7.09929573971954, 2.50998007960222, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -2.44249065417534e-14, 0.0, -1.55431223447522e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912988, 0.0, -1.06581410364015e-14, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697347, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113257, 0.346410161513768, 0.282842712474613, 0.2, 0.0, -1.59872115546023e-14, -1.59872115546023e-14, 0.0, -1.68753899743024e-14, -1.47659662275146e-14, 0.0, 1.33226762955019e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772447, 2.44948974278317, 2.8284271247462, -1.0, 1.30930734141596, 7.09929573971952, -0.414039335605402, -2.04939015319193, -0.47809144373376, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, -1.55431223447522e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974978, 2.12132034355965, -0.408248290463864, 3.17542648054295, 9.07114735222145, 0.0, 7.17137165600638, 0.0, -1.38013111868472, -1.56144011671766, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, -4.2632564145606e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033669, 4.38178046004134, -0.774596669241499, 0.0, 3.14233761939828, -0.106904496764967, 4.76235235991627, -0.740656079818042, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681202, 0.547722557505163, 1.5811388300842, 2.45967477524978, 1.06581410364015e-14, 9.07114735222144, 1.85164019954511, 0.0, 5.34522483824848, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.95399252334028e-14, 0.0, 2.30926389122033e-14, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613581, -6.26099033699939, -2.30926389122033e-14, 3.83405790253615, 0.0, 0.0, 10.5830052442584, 1.15463194561016e-14, 0.0, 5.18459255872627, 0.0, 0.0, 0.0, 1.06581410364015e-14, 2.1316282072803e-14, 0.0, -1.64313007644523e-14, 0.0, -2.39808173319034e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.28785870856518e-14},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499965, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824839, 0.0755928946018476, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000004, 1.06581410364015e-14, 1.46059348668045, 1.42009389360938, 0.0, 0.0, 0.0, 9.07114735222147, 4.93770719878695, -0.698297248755177, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283497, 0.0, -6.26099033699942, 2.21359436211787, 0.0, 0.0, 1.06581410364015e-14, 0.0, 10.5830052442584, 2.99332590941915, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497732, 1.24344978758018e-14, 0.0, -4.69574275274958, 1.06581410364015e-14, 0.0, 3.37507799486048e-14, 0.0, -1.06581410364015e-14, 12.69960629311, 0.0, -1.06581410364015e-14, -2.08721928629529e-14, 0.0, 0.0, 1.77635683940025e-14, -1.06581410364015e-14, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473997, -2.01017818278146, -1.42141062443802, 8.14215222512714, -2.1022946646802, -1.71651640581397, 0.728256234341417, 0.594618725379069, 0.420458932936041, 9.81070843517429, -1.18450885369838, -1.02581475831037, 0.305838870920597, 0.264864231681972, 0.21626073957838, -0.105945692672785, -0.0917516612761684, -0.0749149177264175, -0.0529728463363923, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239554, 3.07059789431496, 1.77281052085586, -1.25356634105601, 2.39356776939084, 6.30376871403131, -0.908295106229229, -2.78313372537745, -0.524404424085083, 0.370809924354783, 1.23603308118261, 9.40174755792011, -0.301561193523235, -2.42752078113805, -0.794200206656987, 0.114434427054266, 0.840917865872093, 0.35064189060884, 0.0660687472643469, -0.0467176592151097, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047612, 2.74642624930239, -0.792824967172102, 2.24244764232555, 2.14087209644418, -0.331662479035527, 6.4992307237088, 0.0957427107756388, -1.87616630392937, -2.15580611373101, 11.0554159678513, -2.1316282072803e-14, 9.44035859331466, 0.0, -1.46249406456535, -2.04706526287664, 0.0, 0.422185670932521, 0.590936840285281, 0.522319308773337, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551271, 1.29756443747036, 3.745745886322, -1.05945692672795, 0.404586796856341, 5.01426536422407, -0.383824736789361, 1.80936716113937, -1.10800657553489, 0.313391585264005, 0.0, 2.82521847127455, -0.0509731451534392, 8.20651806648288, -0.631738055305805, 0.0483573714561651, -2.84282124887605, -0.227958835180072, 0.139595707137609, -0.039483628456618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852097, 1.89521416591738, 0.361873432227869, 1.96214168703486, 2.74642624930239, -0.566421515598877, 3.17129986868835, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827825, -0.865042958313596, 0.0, -2.49768411251821, -0.998865569685879, 0.441440386136655, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139073, -0.193429485824682, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034305, 0.0, -0.858258202907006, 2.67027285925185, -1.4210854715202e-14, 1.01030295240889e-14, 12.4373429638327, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683796, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {1.48323969741915, 0.335029697130249, 4.06201920231799, -0.820651806648296, 1.11299858218672e-14, 1.69926454679665, -0.0991031208965194, 5.88642506110459, -1.20156148406978, 0.242752078113808, 0.0, -1.15463194561016e-14, 0.0, 4.94413232473044, -0.214087209644431, 0.0124858196210829, 5.13809303146607, -0.741619848709565, 0.151382517704894, -0.0305838870920692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0},
      {1.32664991614218, 0.299659670905765, 2.07610309995257, 1.46802658041886, 0.0, 0.868496237346897, 0.709124208342343, 1.31624465810883, 4.91295663090393, -1.4113063856887, 0.0, -1.86517468137026e-14, 0.0, 11.0554159678513, 3.82970843102534, -0.223353131420161, 0.0, 5.80409338312194, -1.54743588659733, 0.341938252770112, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930758, 0.259512887494063, 0.749149177264362, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036811, 1.50990331349021e-14, 3.32401972660468, 2.06838446274243, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552746, -1.59872115546023e-14, 0.0, 6.28180682119206, -1.77676328054752, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0},
      {0.938083151964673, 7.62808987244124, 2.30926389122033e-14, 3.11415464992885, 0.0, 0.0, -7.52139804633608, -1.69864122767649e-14, -1.13242748511766e-14, 5.52707620976691, 0.0, 0.0, 1.06581410364015e-14, -1.33226762955019e-14, -3.19744231092045e-14, 14.2141062443803, 1.34336985979644e-14, 1.64313007644523e-14, 1.95399252334028e-14, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577679, 0.0, 2.68023757704196, -0.473803541479345, 0.0, 0.0, -1.06581410364015e-14, 5.09779364038994, -0.792824967172086, 0.140152977645355, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 7.91061171956872, -0.642261628933269, 0.0998865569685985, -0.01765761544547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205081, 2.39808173319034e-14, 1.4982983545288, 0.847565541382366, 0.0, 1.4210854715202e-14, 0.0, 1.62843044502544, 3.54562104171167, -0.814818121686409, 1.06581410364015e-14, -2.1316282072803e-14, 1.77635683940025e-14, 1.4210854715202e-14, -1.06581410364015e-14, 1.37667655053519e-14, 11.0554159678513, 7.18070330817254, -1.11676565710081, 0.19741814228306, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071088, 1.06581410364015e-14, 0.692034366650873, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212813, 3.07059789431493, 1.19418232635199, 0.0, 0.0, 0.0, 2.48689957516035e-14, 0.0, 1.4210854715202e-14, 1.59872115546023e-14, 12.4373429638327, 5.80288457473997, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309067, 0.0, 7.62808987244127, 1.79795802543454, 0.0, 0.0, 0.0, 0.0, -7.52139804633612, 3.19105893754051, 0.0, 1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 1.12687636999453e-14, -1.15463194561016e-14, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451481, -1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, -5.26497863243526, 0.0, 0.0, 3.5527136788005e-14, -1.15463194561016e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.06581410364015e-14, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361256, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910462, 0.869835476750492, 0.615066564126904, 10.333118277332, -2.18326971917504, -1.8907670401189, 0.724780051083752, 0.62767793639472, 0.512496888990055, -0.278967971730977, -0.241593350361244, -0.197260144544827, -0.139483985865489, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516521, -0.0814411017927967, -0.0728431359084678, -0.0630840061880518, -0.0515078753637661, 0.0313466946954453, 0.0280373360835799, 0.0242810453028185, 0.0198253904711074, 0.0140186680417875, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069938, 0.997445717412067, -1.4106012612951, 3.23209352764251, 5.28531208250978, -1.36277028773849, -2.89087233497829, -0.393397896234716, 0.556348640264182, 2.33666428910958, 9.02784807228864, -0.732969916135163, -3.93352933905728, -1.19859611757308, 0.309047252182626, 1.64018416088946, 0.655588223176222, 0.0892142571199899, -0.126168012376108, 1.1908743922773, 11.55277744383, -0.23484359721209, -2.44096975264613, -0.907332870306508, 0.07366624831632, 0.810328731479528, 0.395334573318417, 0.120463442338385, -0.0310604175145487, -0.311895674167864, -0.164844710568316, -0.0658890955530707, -0.00896637020658575, 0.0126803623514082, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940282, -1.09264703862702, 1.54523626091313, 2.95048422176041, -0.761811750275044, 5.59815020469135, 0.263899331455878, -1.9392561165855, -2.28543525082518, 2.13307290077016, -0.257539376818849, 9.14446135479764, 0.0664963811608006, -2.36108976914457, -3.33842298506506, -0.0230350221379944, 0.817905488277884, 1.1564636454577, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.3977187881547, -2.15192884958005, 0.0, 0.360889439280287, 0.555625639776455, 0.595437196138646, 0.0, -0.125015768949698, -0.19247436761616, -0.206265495285703, -0.166687691932943, 0.0, 0.0, -1.04360964314765e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482233189, 1.82834820066017, 2.99085908983327, -1.24403337882028, 0.950146187582611, 5.74064456311312, -0.721110255092799, -0.169967317119746, -1.17961073303081, 0.490653381462665, 0.294392028877595, 4.97613351528118, -0.21547290184283, 5.7817446699566, -1.30185581821821, 0.163532434528642, -3.22682211353224, 0.0385449644663702, 0.26751056943961, -0.111269728052828, 0.0, 2.646387538394, -0.0295875121532858, 10.7636648722209, -0.500120235663634, 0.0216558414515688, -3.57321383950879, -0.581087203147985, 0.130841432732453, -0.0164356280722675, 1.37533064807501, 0.324307824721458, -0.00387391468765175, -0.0268858238268316, 0.0111830284386746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637247, 1.66904592079257, 0.963624111659414, 1.3627702877385, 0.867360833110881, 2.28430636201793, 2.96226264871974, -1.00852844760551, 1.7102631376487, -2.01556443707464, 0.268741924943299, 2.0441554316077, 2.68821895760392, -0.527798662911731, 7.07977053255618, -1.76652739792482, 0.182834820066021, -3.12574097035513, -1.01990506872273, 0.904016610326401, 0.0, 13.0453753561106, 1.45851730441319, 0.0, 11.0940489487798, -0.632607619454905, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468092, 0.0, 0.992281903807267, 0.735567892896448, 0.181909068193167, -0.147004726489969, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493886, 1.49284005458436, -0.430945803685658, 3.04724700110021, 0.775791113542713, -0.120185042515461, 5.29905651979671, 0.0346944333244359, -1.52970585407782, 0.901387818866001, -10.576283741361, 1.15463194561016e-14, 4.5156107826894, -1.04360964314765e-14, -0.699555414372448, 6.36462844462232, 0.0, 0.201944253400475, -1.83730997289731, -2.74825341360597, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.09993548319961, 0.0, 0.0, 0.487107866980279, 0.894874292847877, 0.903959543974644, 0.0, 0.0, -1.33781874467331e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456568, 3.86595114186567, -1.05140010313427, 0.160604018609916, 3.35889012281482, -0.304724700110037, 3.87851223317102, -1.52475169285614, 0.414677792940095, 0.0, 1.135512111385, -0.0364215679542248, 7.32969916135159, -0.761724681099363, 0.0691050664139874, 0.564240504518043, -0.879563899362187, 0.345781182036198, -0.0940400840863448, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162678, 0.00366050530850304, 9.059750638547, -0.736662483163212, 0.0765562109321147, -0.00694532049720864, -3.48709964663733, -0.0567083043941574, 0.0883994979795864, -0.0347523163751431, 0.00945138406568952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {1.48690428533298, 0.705300630647584, 2.03602754481991, 1.15175110689981, 0.146610739697702, 1.817027050318, 1.25178444059442, 0.655663160391223, 3.61359041872286, -1.7034628596731, 0.0, 0.614267257013214, 0.454391937932161, 1.78428514239955, 5.63152770643897, -0.746494073225309, -0.618094504365235, 2.03210252328836, -2.15494277062553, 0.764033484562619, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865874, -0.106930204231198, 0.0, 9.68367982311022, -1.32524448062075, 0.133143804689793, 0.0, -3.35452509157129, -0.478206411017785, 0.384353057392899, -0.124241670058189, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880569, 0.728431359084681, 2.57539376818856, 0.131132632078232, 0.711024300256724, 2.23926008187656, -0.205255035576788, 2.58567482211399, 0.761811750275053, 0.0, -10.576283741361, 0.763277533137579, 1.24344978758018e-14, 4.13862564412656, 2.68954640486933, 1.08801856413265e-14, -1.19471831485578, 3.1056206816986, -2.32269806558127, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241848, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 1.24344978758018e-14, -2.88176900403078, -1.51261363209514, 0.76398525469261, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, -1.21014309684142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, -1.4210854715202e-14},
      {1.15175110689979, 0.546323519313527, -0.105140010313412, 3.27118942773249, 9.65295620481433, -1.02140518265514e-14, 2.69341127303542, 0.0, -0.518347241175119, 4.25171145123353, 0.0, 0.0, -9.91526600752598, 0.0, 0.0, 6.71889089790567, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059453, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376109, 0.199489143482415, 3.68560354207935, -0.814411017927958, 0.0, 1.02786571910339, -0.078679579246943, 6.00856531485323, -1.4536216402544, 0.321208037219809, 0.0, 0.0, 0.0, 3.02803229702669, -0.2330980349071, 0.0178428514239943, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084669, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433803, 0.0234272339744236, -0.00179327404131602, 5.40219154319688, -0.702817019232749, 0.136947913395217, -0.0331311120155255, 0.00732101061700685, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {1.15175110689975, 0.182107839771152, 2.20794021658199, 0.892142571199752, -1.4210854715202e-14, 0.615765106730371, 0.32320935276422, 2.13307290077017, 3.91870514328394, -1.31949665727937, 0.0, 0.0, 1.02140518265514e-14, 1.07496769977314, 1.90844613931508, -0.192743940909618, 1.11713920350153, 6.61105135360478, -2.33689608954553, 0.591817792331155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771028, 0.0343775825476166, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297044, -0.0962371838080771, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 1.65423230669148e-14, 0.0, 0.0, 0.0},
      {1.03015750727541, 0.162882203585591, 1.12848100903608, 1.99489143482414, 0.0, 0.314718316987764, 0.578174466995661, 0.476969600708475, 4.00571020990213, 0.590096844352082, 0.0, 0.0, 0.0, -10.576283741361, 1.83186607953016, 0.694437895660752, 0.0, 2.77627448210727, 4.8112068719424, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780438, -0.338230690505755, -1.4210854715202e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634515, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199777, 0.141060126129509, 0.407205508964008, 2.53385243517952, 0.0, 9.65295620481432, 0.695435800330246, 0.0, 2.0075502326238, 3.29336152870135, 0.0, 1.59872115546023e-14, -1.26565424807268e-14, 0.0, -9.91526600752598, 1.73481017017154, 2.62012633811537e-14, 0.0, 5.00796559370722, 1.41646657250369, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 2.44096975264614, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {0.728431359084674, -7.94708263760856, 0.0, 2.5390822703312, 0.0, 0.0, 10.2207771580387, 0.0, 0.0, 5.00713776237769, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, -8.49879943502222, -1.4210854715202e-14, 0.0, 0.0, 6.93924068068618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 0.0, 0.0, 0.0, 1.15463194561016e-14, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084662, 0.0, 2.32737334062816, -0.470200420431693, 0.0, 0.0, 1.59872115546023e-14, 4.49691252107736, -0.917928424547695, 0.185449546754731, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0654086930623, -1.01980390271857, 0.20816659994661, -0.042056004125357, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678881, 0.10249414863811, -0.0209215304820316, 0.00422678745047178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608005, 0.0, 1.45686271816938, 0.51507875363772, 0.0, 0.0, 1.4210854715202e-14, 1.84729532019112, 2.58567482211398, -0.761811750275054, 1.4210854715202e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.71994831963705, 5.72533841794521, -1.54195152727693, 0.341686161713623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 13.0453753561106, 9.33451074824442, -1.3473205733131, 0.275020660380936, -0.055562563977638, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {0.594761714133161, 0.0, 0.814411017927945, 1.15175110689979, -1.33226762955019e-14, 0.0, -1.24344978758018e-14, 0.590096844352066, 2.89087233497828, 0.340692571934627, 0.0, 1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 1.59872115546023e-14, -10.576283741361, 3.43474889911911, 3.47218947830366, -1.03874215316938, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 8.28492607088318, -1.69115345252877, 0.341664592660038, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.515078753637698, 0.0, 0.376160336345346, 1.46292038553769, 0.0, 0.0, 2.53130849614536e-14, 9.65295620481433, 1.85449546754729, 1.90142316513449, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -9.91526600752596, 4.6261604537908, 0.817797356933113, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 15.9443476574685, 6.50925267372302, -1.31506763029893, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {0.420560041253698, -1.90958360235527e-14, -7.94708263760857, 1.46593983227031, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497828, 0.0, 1.95399252334028e-14, -2.1316282072803e-14, -1.06581410364015e-14, 0.0, -1.59872115546023e-14, -1.68753899743024e-14, 0.0, -8.49879943502225, 4.00637247496573, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 17.9373911146521, 3.6239002554188, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {6.54237885546497, 0.0, 1.73194791841524e-14, -6.9105066413987, 0.0, 0.0, -3.46389583683049e-14, 1.33226762955019e-14, 0.0, 12.2649325896465, 0.0, 0.0, 1.77635683940025e-14, 0.0, -3.5527136788005e-14, -1.95399252334028e-14, 0.0, 2.64233079860787e-14, 1.4210854715202e-14, -5.6658662900148, 0.0, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 1.4210854715202e-14, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, -2.30926389122033e-14, 0.0, -1.14352971536391e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 1.86517468137026e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923503, 0.0, -0.00704122671245617, 0.00248944957812476, 0.0, 0.0, 0.0, 0.00947126259704828, -0.00515550235170574, 0.00182274533665714, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00450937950937953, -0.00292892790782074, 0.00159430641501298, -0.000563672438672429, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00464478520766671, -0.00332353774887302, 0.00215870109072045, -0.00117504803987881, 0.000415442218609134, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0127646671417816, -0.0097104112952761, 0.00694820471863011, -0.00451299134777143, 0.00245656133680785, -0.000868525589828767};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033678, -2.48689957516035e-14, 0.0, 0.0, 1.04360964314765e-14, -1.77635683940025e-14, -1.46549439250521e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.48787232534531e-14, 0.0, -3.19744231092045e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.41948691584548e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.4210854715202e-14, -1.15463194561016e-14, 0.0, 1.54888466424096e-14, 0.0, 0.0, 0.0, -1.50990331349021e-14, -2.30926389122033e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, -4.08562073062058e-14, 8.36660026534077, -1.18321595661994, 0.0, -2.53130849614536e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, -3.28626015289046e-14, 0.0, -1.90958360235527e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, -2.8421709430404e-14, 0.0, 8.69482604771367, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -4.9737991503207e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394698, 0.0, -3.34664010613629, -2.36643191323984, 15.4919333848297, 0.0, 2.30926389122033e-14, 0.692820323027545, 0.565685424949236, 0.4, 0.0, -2.8421709430404e-14, -1.4210854715202e-14, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0},
      {2.89768209427166e-14, 4.89897948556636, 2.1316282072803e-14, 0.0, 1.06581410364015e-14, 14.1985914794391, -0.828078671210806, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 1.68753899743024e-14, 2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, -2.1316282072803e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, -2.1316282072803e-14, 0.0, 0.0, 0.0, 14.3427433120128, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, -4.08562073062058e-14, 0.0, 1.73194791841524e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {3.6, -2.04281036531029e-14, 8.76356092008267, -1.549193338483, 0.0, -1.06581410364015e-14, 0.0, 9.52470471983255, -1.48131215963607, 0.261861468283193, 0.0, -1.4210854715202e-14, 0.0, -2.1316282072803e-14, -1.4210854715202e-14, 0.0, 1.4210854715202e-14, -1.77635683940025e-14, 2.1316282072803e-14, -2.79776202205539e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 1.11022302462516e-14, 0.0, 0.0, -1.29896093881143e-14},
      {3.11769145362399, -2.95319324550292e-14, 3.16227766016838, 4.91934955049954, 0.0, -2.75612865863195e-14, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 1.06581410364015e-14, -2.22044604925031e-14, -1.50990331349021e-14, -3.71369601737115e-14, 0.0, 0.0, -3.90798504668055e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, -1.24344978758018e-14, 0.0, 0.0, -1.95399252334028e-14, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, -1.19904086659517e-14, 7.66811580507232, 0.0, 0.0, 2.38697950294409e-14, 0.0, -1.77635683940025e-14, 10.3691851174526, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.22124532708767e-14, -1.24344978758018e-14, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.55111512312578e-14, 11.6057691494799, 0.0, 0.0, 0.0, -4.20458932936039, -3.43303281162796, 0.0, 0.0, 0.0, 19.6214168703486, -1.77635683940025e-14, -1.59872115546023e-14, 0.61167774184119, 0.529728463363962, 0.432521479156773, 0.0, 0.0, 1.90958360235527e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1878460182374e-14, 0.0, -1.06581410364015e-14, 1.24344978758018e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479106, 0.0, 3.54562104171168, -2.50713268211202, 4.78713553878169, 0.0, 2.01505478969466e-14, -5.56626745075489, -1.04880884817015, 0.741619848709564, 0.0, 18.8034951158402, -0.603122387046459, 0.0, -2.75335310107039e-14, 0.0, 1.68183573174417, 0.701283781217668, 0.132137494528686, -0.0934353184302177, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095214, 1.46549439250521e-14, -1.58564993434419, 4.48489528465112, 4.28174419288837, 0.0, 2.8421709430404e-14, 0.191485421551263, -3.75233260785876, -4.31161222746203, 0.0, -1.24344978758018e-14, 18.8807171866293, 0.0, -2.8421709430404e-14, 1.77635683940025e-14, 0.0, 0.844371341865036, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.95079541199084e-14, 2.59512887494073, 2.8421709430404e-14, 1.59872115546023e-14, 1.4210854715202e-14, 10.0285307284481, -0.76764947357873, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061159, 0.0967147429123472, 2.1316282072803e-14, 2.1316282072803e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989599, 0.0, 0.0, 0.0, 3.92428337406972, 5.49285249860479, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662718, 0.0, 2.8421709430404e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278145, 0.0, 0.0, 0.0, 0.0, 8.91928088068606, 0.0, 0.0, 0.0, 0.0, 0.0, 3.01980662698043e-14, 0.0, 0.0, 16.8558564884488, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483828, 0.0, 8.12403840463598, -1.6413036132966, 1.06581410364015e-14, 0.0, -1.77635683940025e-14, 11.7728501222092, -2.40312296813957, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741915, 0.302765035409783, -0.061167774184141, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.57571741713036e-14, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 2.62012633811537e-14, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990516, 2.93605316083771, 0.0, -1.28785870856518e-14, 0.0, 2.63248931621765, 9.82591326180785, -2.8226127713774, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 1.38777878078145e-14, 11.6081867662439, -3.09487177319466, 0.683876505540219, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.28785870856518e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.83741910575463e-14, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, -1.24344978758018e-14, 1.26565424807268e-14, -1.28785870856518e-14},
      {2.29782505861523, 0.0, 1.49829835452876, 5.50917601898537, 0.0, 0.0, 0.0, 0.0, 6.64803945320938, 4.13676892548486, 0.0, -1.15463194561016e-14, 0.0, 0.0, -2.1316282072803e-14, -2.1316282072803e-14, 0.0, 0.0, 12.5636136423841, -3.55352656109505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0},
      {1.87616630392939, 1.15463194561016e-14, 0.0, 6.22830929985769, 0.0, 0.0, 3.90798504668055e-14, 0.0, -1.77635683940025e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722506, 0.0, -4.41087092453691, -3.11895674167864, 16.6749979177077, 1.02140518265514e-14, 0.0, 2.13065307820925, 1.73967095350099, 1.23013312825381, -1.4210854715202e-14, -4.36653943835008, -3.7815340802378, 0.0, 2.48689957516035e-14, 1.24344978758018e-14, -0.557935943461974, -0.483186700722504, -0.394520289089682, -0.278967971730994, 23.6981011897578, 0.0, 0.0, 0.490653381462664, 0.438853725736261, 0.380058475033041, 0.0, 0.0, 0.0, 0.0, 0.0626933893908879, 0.0560746721671604, 0.048562090605635, 0.0396507809422171, 0.0280373360835759, -1.06581410364015e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.91050664139875, -1.04360964314765e-14, 0.0, 0.0, 10.5706241650195, -2.725540575477, 2.28705943072782e-14, 0.0, 0.0, 4.67332857821917, -4.44089209850063e-14, 0.0, -7.86705867811457, -2.39719223514613, 0.618094504365247, 0.0, 0.0, 1.64313007644523e-14, 0.0, 0.0, 23.1055548876599, -0.469687194424181, 0.0, 0.0, 0.0, 1.62065746295905, 0.790669146636831, 0.240926884676766, -0.062120835029098, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.62012633811537e-14, 0.0, 1.77635683940025e-14, 1.11022302462516e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {3.81916720471054e-14, 6.30840061880562, 1.59872115546023e-14, -1.59872115546023e-14, 0.0, -1.5236235005501, 11.1963004093827, 0.0, 0.0, 0.0, 4.26614580154031, 0.0, -2.48689957516035e-14, 0.132992762321612, -4.72217953828915, -6.67684597013015, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 1.06581410364015e-14, 0.0, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560579, 1.11125127955291, 1.19087439227729, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 1.15463194561016e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {3.85449644663773, 2.30926389122033e-14, 5.98171817966648, -2.48806675764059, 1.90029237516521, 1.95399252334028e-14, 0.0, -0.339934634239501, -2.35922146606162, 0.981306762925323, 0.0, 9.9522670305624, -0.43094580368566, 0.0, 0.0, 2.48689957516035e-14, -6.45364422706454, 0.0770899289327254, 0.535021138879209, -0.222539456105663, 0.0, 1.02140518265514e-14, 0.0, 21.5273297444417, -1.00024047132727, 0.0433116829031313, 0.0, 0.0, 0.0, 0.0, 2.75066129615, 0.648615649442922, -0.00774782937530727, -0.0537716476536625, 0.0223660568773498, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274496, 2.22044604925031e-14, 1.92724822331888, 2.72554057547701, 1.73472166622177, 0.0, 4.2632564145606e-14, -2.01705689521107, 3.4205262752974, -4.03112887414928, 0.0, 4.08831086321546, 5.37643791520785, 0.0, -3.5527136788005e-14, 2.22044604925031e-14, 0.365669640132043, -6.25148194071026, -2.03981013744546, 1.8080332206528, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.2652152389098, 0.0, 0.0, 0.0, 0.0, 0.0, 1.98456380761455, 1.4711357857929, 0.363818136386334, -0.294009452979941, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0},
      {3.14718316987776, 0.0, -0.861891607371339, 6.09449400220043, 1.55158222708542, 1.24344978758018e-14, 0.0, 0.0693888666488744, -3.05941170815567, 1.802775637732, 0.0, 1.7874590696465e-14, 9.03122156537879, 0.0, -2.22044604925031e-14, 3.19744231092045e-14, 0.0, 0.403888506800969, -3.67461994579464, -5.49650682721195, 0.0, 0.0, 0.0, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.97421573396055, 1.78974858569576, 1.80791908794929, 0.0, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, -1.06581410364015e-14, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-2.8421709430404e-14, 1.54523626091312, 0.0, 0.0, 0.0, 6.71778024562962, -0.609449400220045, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 14.6593983227032, -1.52344936219871, 0.138210132827959, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864222, -0.0138906409944113, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {3.73034936274053e-14, 1.41060126129512, 1.59872115546023e-14, 1.4210854715202e-14, 0.0, 3.63405410063598, 2.50356888118885, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 3.56857028479908, 11.2630554128779, -1.49298814645065, 0.0, -1.4210854715202e-14, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124152, 0.266287609379576, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14},
      {-4.88498130835069e-14, 1.2616801237611, -1.59872115546023e-14, -1.4210854715202e-14, 0.0, 1.42204860051344, 4.4785201637531, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 8.27725128825315, 5.37909280973864, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.9654813226339, -2.61992366301005, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 1.77635683940025e-14, 0.0, -1.4210854715202e-14},
      {-2.97539770599542e-14, 1.09264703862701, 1.50990331349021e-14, 0.0, 0.0, -1.4210854715202e-14, 5.38682254607083, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.3988810110277e-14, -2.26485497023532e-14, 0.0, -1.33226762955019e-14, 13.4377817958113, 1.06581410364015e-14, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752222, 1.4210854715202e-14, 7.37120708415868, -1.62882203585591, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050879, 0.642416074439624, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882094426, -2.72522906732404, 0.659300804656283, -0.145686271816937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846549, 0.273895826790434, -0.0662622240310455, 0.0146420212340158, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {2.30350221379958, 0.0, 4.41588043316396, 1.78428514239951, 0.0, 0.0, -3.01980662698043e-14, 4.26614580154033, 7.83741028656787, -2.63899331455874, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 2.23427840700305, 13.2221027072096, -4.67379217909108, 1.1836355846623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 12.1258851598178, -3.11150358274814, 0.833612074594097, -0.192474367616154, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.66453525910038e-14, 1.84297022087776e-14, -1.56541446472147e-14, 1.64313007644523e-14, 0.0},
      {2.06031501455086, 1.4210854715202e-14, 2.25696201807216, 3.9897828696483, 0.0, 0.0, 2.39808173319034e-14, 0.953939201416929, 8.01142041980428, 1.18019368870417, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.77635683940025e-14, 1.4210854715202e-14, -1.06581410364015e-14, 5.55254896421457, 9.62241374388481, -3.59830837050571, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239956, 0.0, 0.814411017927968, 5.06770487035906, 0.0, 0.0, 2.48689957516035e-14, 0.0, 4.01510046524761, 6.5867230574027, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, -1.77635683940025e-14, 10.0159311874144, 2.8329331450074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 14.0929454377398, -4.55552790213387, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0},
      {1.45686271816935, 1.06581410364015e-14, 0.0, 5.07816454066241, -1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 10.0142755247554, 0.0, 0.0, 3.90798504668055e-14, 0.0, -2.30926389122033e-14, 0.0, 0.0, 2.19824158875781e-14, 1.77635683940025e-14, 13.8784813613723, 0.0, 0.0, 0.0, 0.0, -1.37667655053519e-14, -1.06581410364015e-14, 0.0, 1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 12.5535587278944, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.45439216225896e-14, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505168, -2.48689957516035e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.49637247037759e-14, 0.0, -3.01980662698043e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.61248608016089, -1.08012344973465, -0.763762615825974, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.2456883730947, 4.18330013267038, -0.591607978309975, 0.0, -1.4210854715202e-14, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -2.8421709430404e-14, 0.0, 1.0325074129014e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.44051437445114e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, -1.4210854715202e-14, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106461, -1.4210854715202e-14, 9.66091783079297, 0.683130051063949, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.68753899743024e-14, 0.0, 1.4210854715202e-14, 0.0, -1.15463194561016e-14, -1.4210854715202e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, -2.30926389122033e-14, 0.0, 7.52994023880669, 0.0, -1.02140518265514e-14, -1.59872115546023e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -3.90798504668055e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697347, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113257, 0.346410161513768, 0.282842712474613, 0.2, 0.0, -1.59872115546023e-14, -1.59872115546023e-14, 0.0, -1.68753899743024e-14, -1.47659662275146e-14, 0.0, 1.33226762955019e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278316, 2.82842712474622, -0.999999999999997, 9.16515138991168, 7.09929573971952, -0.414039335605381, -2.04939015319193, -0.478091443733767, 0.169030850945705, 2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 1.86517468137026e-14, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355963, -0.408248290463877, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671766, 0.0, 0.0, 0.0, 0.0, 0.0, -4.2632564145606e-14, 0.0, 0.0, -1.59872115546023e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.26565424807268e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000005, -5.69209978830307, 4.38178046004135, -0.77459666924149, 1.77635683940025e-14, 10.998181667894, 0.962140470884736, 4.76235235991627, -0.74065607981803, 0.1309307341416, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752581, 1.58113883008417, 2.45967477524976, 0.0, -1.02140518265514e-14, 9.25820099772553, 0.0, 5.34522483824848, -1.20948631362953, 0.0, 0.0, 1.59872115546023e-14, -1.33226762955019e-14, 0.0, -5.06261699229071e-14, 0.0, 1.4210854715202e-14, -3.19744231092045e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, -1.17683640610267e-14, -1.64313007644523e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 1.19348975147204e-14, 0.0, 0.0, 5.18459255872628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270666, -2.8421709430404e-14, -3.16227766016839, -2.23606797749981, 0.0, 0.0, -2.48689957516035e-14, 13.7477270848675, 0.534522483824869, 0.377964473009236, -2.8421709430404e-14, -2.15938378289593e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 2.84494650060196e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.85407245112401e-14, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.6514837167011, -2.8401877872188, 0.0, 0.0, 2.8421709430404e-14, 1.15463194561016e-14, 12.3442679969673, 1.39659449751036, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.24344978758018e-14, -3.99680288865056e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.20454076850487, 1.28785870856518e-14, 0.0, 6.64078308635358, 0.0, 0.0, 2.08721928629529e-14, 0.0, -1.24344978758018e-14, 8.97997772825744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473997, -2.01017818278146, -1.42141062443802, 8.14215222512714, -2.1022946646802, -1.71651640581397, 0.728256234341417, 0.594618725379069, 0.420458932936041, 9.81070843517429, -1.18450885369838, -1.02581475831037, 0.305838870920597, 0.264864231681972, 0.21626073957838, -0.105945692672785, -0.0917516612761684, -0.0749149177264175, -0.0529728463363923, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239559, 3.07059789431498, 1.77281052085585, -1.25356634105601, 2.39356776939085, 6.30376871403132, -0.908295106229227, -2.78313372537745, -0.524404424085072, 0.370809924354783, 11.1242977306435, 9.4017475579201, -0.301561193523241, -2.42752078113805, -0.794200206656987, 0.114434427054269, 0.840917865872093, 0.350641890608839, 0.0660687472643508, -0.0467176592151073, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047606, 2.74642624930239, -0.792824967172102, 2.24244764232555, 2.14087209644418, -0.331662479035535, 6.4992307237088, 0.095742710775629, -1.87616630392938, -2.15580611373101, 1.06581410364015e-14, 0.0, 9.44035859331467, 0.0, -1.46249406456536, -2.04706526287664, 0.0, 0.422185670932525, 0.590936840285275, 0.522319308773337, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01585406753202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551273, 1.29756443747036, 3.74574588632199, -1.05945692672795, -8.09173593712688, 5.01426536422408, -0.383824736789381, 1.80936716113938, -1.10800657553488, 0.313391585264006, 0.0, 12.7134831207354, 1.01946290306867, 8.20651806648289, -0.631738055305803, 0.0483573714561754, -2.84282124887605, -0.227958835180086, 0.139595707137602, -0.0394836284566153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715532, 1.160576914948, 1.34011878852097, 1.89521416591739, 2.53311402559511, 1.96214168703485, 2.74642624930243, -0.566421515598881, 3.17129986868835, -1.82198870938951, 0.0, -1.11022302462516e-14, 11.1699829238239, -1.06581410364015e-14, 8.65223156827826, -0.865042958313582, 0.0, -2.49768411251821, -0.998865569685881, 0.441440386136652, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -2.48689957516035e-14, -1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824669, 3.55615782880926, 0.0, 0.0, 4.45964044034303, 0.0, -0.858258202906998, 2.67027285925185, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422439, 0.0, 0.0, -1.62195554683795, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 7.03562363973514, 4.06201920231801, -0.820651806648293, 0.0, -6.79705818718656, -2.08116553882676, 5.8864250611046, -1.20156148406977, 0.242752078113808, 0.0, -2.1316282072803e-14, 0.0, 14.8323969741913, 0.856348838577661, 0.262202212042544, 5.13809303146608, -0.741619848709579, 0.151382517704904, -0.0305838870920607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02060590481778e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815182, 2.07610309995257, 1.46802658041886, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090391, -1.41130638568869, 0.0, 0.0, -1.24344978758018e-14, 0.0, 13.4039795085887, 2.01017818278148, 0.0, 5.80409338312194, -1.54743588659734, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 1.02695629777827e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4432899320127e-14, 0.0, 0.0, -1.62092561595273e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 1.29756443747035, 0.749149177264378, 2.75458800949268, 0.0, 0.0, 5.75737105184055, 0.0, 3.32401972660469, 2.06838446274243, 0.0, -1.28785870856518e-14, 0.0, 0.0, -1.59872115546023e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119206, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.938083151964694, 0.0, 0.0, 3.11415464992884, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964689, 1.89521416591739, 0.0, 0.0, 0.0, -3.39852909359327, -2.77488738510234, -0.560611910581399, 0.0, 1.4210854715202e-14, 0.0, 1.77635683940025e-14, 0.0, 0.0, 17.7988763690296, 0.428174419288845, 0.349602949390066, 0.0706304617818807, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 1.77635683940025e-14, -1.49829835452876, 4.2378277069118, -1.29340982368831e-14, 1.24344978758018e-14, -3.10862446895044e-14, 3.79967103839267, -3.54562104171167, -4.07409060843205, 1.4210854715202e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, 1.77635683940025e-14, 0.0, 16.7549743857359, 1.11676565710086, 0.987090711415302, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, -2.66453525910038e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0},
      {-1.32664991614215, 1.95399252334028e-14, 1.73008591662713, -3.18072425757421, 0.0, 0.0, 0.0, 0.0, 7.67649473578738, -2.38836465270395, 0.0, 0.0, 2.8421709430404e-14, 0.0, 0.0, 2.48689957516035e-14, 0.0, 0.0, 14.5072114368499, 2.05162951662075, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630363, 0.0, 0.0, 3.73034936274053e-14, 0.0, -1.24344978758018e-14, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361256, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910462, 0.869835476750492, 0.615066564126904, 10.333118277332, -2.18326971917504, -1.8907670401189, 0.724780051083752, 0.62767793639472, 0.512496888990055, -0.278967971730977, -0.241593350361244, -0.197260144544827, -0.139483985865489, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516521, -0.0814411017927967, -0.0728431359084678, -0.0630840061880518, -0.0515078753637661, 0.0313466946954453, 0.0280373360835799, 0.0242810453028185, 0.0198253904711074, 0.0140186680417875, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725406, 3.45525332069938, 0.997445717412056, -1.4106012612951, 3.2320935276425, 5.28531208250978, -1.3627702877385, -2.89087233497828, -0.393397896234713, 0.556348640264176, 2.33666428910958, 9.02784807228866, -0.732969916135154, -3.93352933905728, -1.19859611757306, 0.309047252182632, 1.64018416088946, 0.655588223176217, 0.0892142571199757, -0.126168012376112, 13.0996183150503, 11.55277744383, -0.234843597212092, -2.44096975264613, -0.907332870306506, 0.0736662483163188, 0.810328731479524, 0.395334573318416, 0.120463442338386, -0.031060417514547, -0.311895674167857, -0.164844710568314, -0.0658890955530745, -0.00896637020658053, 0.0126803623514053, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482413, 3.15420030940281, -1.09264703862701, 1.54523626091313, 2.95048422176041, -0.761811750275046, 5.59815020469136, 0.263899331455872, -1.93925611658551, -2.28543525082517, 2.13307290077016, -0.257539376818862, 9.14446135479763, 0.0664963811608028, -2.36108976914459, -3.33842298506508, -0.0230350221379902, 0.817905488277889, 1.15646364545771, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.3977187881547, -2.15192884958004, 0.0, 0.360889439280293, 0.555625639776453, 0.595437196138646, 0.0, -0.125015768949699, -0.192474367616155, -0.206265495285708, -0.166687691932939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331884, 1.82834820066015, 2.99085908983325, -1.24403337882029, 0.950146187582618, 5.74064456311311, -0.721110255092816, -0.169967317119732, -1.17961073303081, 0.490653381462656, -10.3037210107158, 4.97613351528118, -0.215472901842828, 5.78174466995661, -1.3018558182182, 0.163532434528636, -3.22682211353225, 0.0385449644663654, 0.267510569439617, -0.111269728052835, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663636, 0.0216558414515651, -3.5732138395088, -0.581087203147984, 0.130841432732455, -0.0164356280722688, 1.37533064807501, 0.324307824721448, -0.00387391468765075, -0.0268858238268341, 0.0111830284386727, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637251, 1.66904592079258, 0.963624111659453, 1.3627702877385, 0.867360833110876, 2.28430636201793, 2.96226264871975, -1.00852844760553, 1.7102631376487, -2.01556443707463, 2.41867732448957, 2.04415543160773, 2.68821895760391, -0.527798662911733, 7.07977053255616, -1.7665273979248, 0.182834820066026, -3.12574097035513, -1.01990506872272, 0.904016610326403, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.6326076194549, 0.0, -2.8644711213756, -1.66605356688627, 0.31507574846809, 0.0, 0.992281903807282, 0.735567892896452, 0.181909068193165, -0.147004726489971, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, -2.04281036531029e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458435, -0.430945803685674, 3.04724700110021, 0.775791113542706, -0.120185042515456, 5.29905651979673, 0.0346944333244417, -1.52970585407783, 0.901387818866002, 0.0, 0.0, 4.51561078268941, 0.0, -0.699555414372428, 6.36462844462229, 0.0, 0.201944253400487, -1.83730997289732, -2.74825341360597, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980271, 0.894874292847878, 0.903959543974647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585588, 0.772618130456575, 3.86595114186568, -1.05140010313426, 9.1544290607646, 3.35889012281482, -0.304724700110037, 3.87851223317103, -1.52475169285614, 0.414677792940099, 0.0, -9.46260092820843, -2.07602937339135, 7.3296991613516, -0.761724681099355, 0.0691050664139841, 0.564240504518073, -0.879563899362193, 0.34578118203621, -0.0940400840863395, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355638, 0.208648802584717, 9.059750638547, -0.736662483163211, 0.0765562109321121, -0.00694532049720742, -3.48709964663733, -0.0567083043941636, 0.0883994979795868, -0.0347523163751426, 0.00945138406569146, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.72639680329212e-14, 0.0, 0.0, 0.0},
      {1.48690428533299, 0.705300630647569, 2.03602754481992, 1.15175110689979, -2.93221479395416, 1.81702705031799, 1.25178444059441, 0.655663160391217, 3.61359041872288, -1.70346285967311, 0.0, 2.7642026565595, -9.08783875864328, 1.78428514239955, 5.63152770643898, -0.746494073225321, -0.618094504365244, 2.03210252328837, -2.1549427706255, 0.76403348456261, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462395, 0.0, 9.68367982311023, -1.32524448062075, 0.133143804689791, 0.0, -3.35452509157129, -0.478206411017788, 0.384353057392897, -0.124241670058193, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880569, 0.728431359084661, 2.57539376818856, 0.917928424547665, 0.711024300256719, 2.23926008187655, -0.205255035576781, 2.585674822114, 0.761811750275065, 0.0, 0.0, 5.34294273196308, 0.0, 4.13862564412656, 2.68954640486934, 0.0, -1.19471831485579, 3.10562068169858, -2.32269806558126, 0.0, 0.0, 0.0, 0.0, 0.0, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150502, 0.0, 0.0, -2.88176900403078, -1.51261363209513, 0.763985254692617, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, -1.59872115546023e-14, -1.02140518265514e-14, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {1.15175110689979, 0.546323519313511, -0.105140010313424, 3.2711894277325, 0.0, 0.0, 2.69341127303544, 0.0, -0.518347241175136, 4.25171145123352, 0.0, 0.0, -1.46549439250521e-14, 0.0, 0.0, 6.71889089790565, 0.0, 0.0, -1.29305115618718, 1.82865048192214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059452, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376108, -6.78263087840208, 3.68560354207935, -0.814411017927958, -1.95399252334028e-14, 10.0216907612581, 2.67510569439611, 6.00856531485323, -1.4536216402544, 0.321208037219802, -2.22044604925031e-14, 2.1316282072803e-14, 0.0, -7.57008074256671, -2.2727058403442, -0.606656948415846, 6.99294104721299, -1.36261453366203, 0.329650402328139, -0.0728431359084718, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 18.7137404500718, 0.760821741084519, 0.228415531250639, 0.0609713174047686, 5.40219154319687, -0.702817019232754, 0.136947913395212, -0.0331311120155253, 0.0073210106170063, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {1.15175110689981, 3.8242646351946, 2.20794021658199, 0.892142571199756, 1.4210854715202e-14, -2.46306042692148, 6.78739640804924, 2.13307290077017, 3.91870514328395, -1.31949665727937, 0.0, 0.0, 0.0, 3.22490309931941, -7.63378455726038, -4.04762275910192, 1.11713920350153, 6.6110513536048, -2.33689608954553, 0.591817792331162, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108413, 0.721929233499935, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297046, -0.0962371838080749, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.29677388219329e-14, -1.11022302462516e-14, 0.0, 0.0},
      {1.03015750727539, -1.46593983227032, 1.12848100903608, 1.99489143482414, 0.0, 1.10151410945721, -5.20357020296094, 0.476969600708474, 4.00571020990211, 0.590096844352095, 0.0, 1.4210854715202e-14, 0.0, 1.97619698383278e-14, 6.41153127835566, -6.24994106094657, 0.0, 2.77627448210729, 4.8112068719424, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.0440762145518, 0.0, 0.0, 6.69662601613678, -2.34333096254029, 0.59178043363451, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0},
      {0.892142571199763, 0.705300630647548, 0.407205508963994, 2.53385243517953, 0.0, 0.0, 3.47717900165118, 0.0, 2.0075502326238, 3.29336152870136, 0.0, 1.33226762955019e-14, -1.10467190950203e-14, 0.0, 0.0, 8.67405085085772, 1.06581410364015e-14, 0.0, 5.00796559370721, 1.41646657250371, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.04647271886989, -2.27776395106693, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084677, 0.0, 0.0, 2.53908227033121, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237768, 0.0, 0.0, 1.95399252334028e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 1.0991207943789e-14, 0.0, 6.93924068068617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359276, 0.0, -4.65474668125631, -3.29140294302193, -1.24344978758018e-14, -1.50990331349021e-14, 2.1316282072803e-14, 13.490737563232, 1.83585684909536, 1.2981468272831, 0.0, 0.0, -1.4210854715202e-14, 1.4210854715202e-14, 1.24344978758018e-14, 0.0, -3.53270434653113, -3.0594117081557, -0.416333199893252, -0.294392028877599, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.35505014583943, 0.307482445914328, 0.0418430609640565, 0.0295875121532907, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.89848137210902e-14, 0.0},
      {-2.6598552464322, 0.0, 5.09901951359279, -2.06031501455086, 1.33226762955019e-14, 1.19904086659517e-14, -1.4210854715202e-14, -1.23153021346073, 9.049861877399, 3.04724700110021, 0.0, 0.0, 0.0, 0.0, -3.5527136788005e-14, 0.0, 3.86988371918332, -3.8168922786302, -5.39683034546924, -1.36674464685442, 0.0, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, -1.06581410364015e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, 21.00264918355, 0.898213715542057, 0.962572311333265, 0.222250255910581, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 3.19744231092045e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {2.97380857066587, 0.0, -0.814411017927956, 5.75875553449897, -1.73194791841524e-14, 0.0, 2.1316282072803e-14, 1.3768926368215, -2.89087233497831, 1.70346285967311, 0.0, 2.48689957516035e-14, -1.4210854715202e-14, 0.0, 0.0, 1.59872115546023e-14, -1.24344978758018e-14, 8.01441409794464, -3.47218947830362, -5.19371076584692, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3235940121703e-14, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.03015750727544, -2.48689957516035e-14, 0.940400840863432, -2.92584077107541, -1.35447209004269e-14, 0.0, -2.48689957516035e-14, 0.0, 4.63623866886822, -3.80284633026897, 0.0, 2.8421709430404e-14, 1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 1.50990331349021e-14, -1.4210854715202e-14, 11.565401134477, -1.63559471386626, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059784, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376111, 0.0, 0.0, 4.39781949681098, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 8.67261700493488, 0.0, 0.0, 3.37507799486048e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 1.73194791841524e-14, 1.4210854715202e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 1.26565424807268e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494324, -1.77635683940025e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.26565424807268e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.11126385871074e-14, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.61248608016089, -1.08012344973465, -0.763762615825974, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461892, 4.18330013267039, -0.591607978309968, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338695, 7.09929573971952, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.37667655053519e-14, -3.5527136788005e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.31006316905768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, -1.24344978758018e-14, 3.86436713231718, -0.34156502553199, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.31006316905768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, -1.06581410364015e-14, 7.09929573971954, 2.50998007960222, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -2.44249065417534e-14, 0.0, -1.55431223447522e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912988, 0.0, -1.06581410364015e-14, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697347, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113257, 0.346410161513768, 0.282842712474613, 0.2, 0.0, -1.59872115546023e-14, -1.59872115546023e-14, 0.0, -1.68753899743024e-14, -1.47659662275146e-14, 0.0, 1.33226762955019e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772447, 2.44948974278317, 2.8284271247462, -1.0, 1.30930734141596, 7.09929573971952, -0.414039335605402, -2.04939015319193, -0.47809144373376, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, -1.55431223447522e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974978, 2.12132034355965, -0.408248290463864, 3.17542648054295, 9.07114735222145, 0.0, 7.17137165600638, 0.0, -1.38013111868472, -1.56144011671766, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, -4.2632564145606e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033669, 4.38178046004134, -0.774596669241499, 0.0, 3.14233761939828, -0.106904496764967, 4.76235235991627, -0.740656079818042, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681202, 0.547722557505163, 1.5811388300842, 2.45967477524978, 1.06581410364015e-14, 9.07114735222144, 1.85164019954511, 0.0, 5.34522483824848, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.95399252334028e-14, 0.0, 2.30926389122033e-14, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613581, -6.26099033699939, -2.30926389122033e-14, 3.83405790253615, 0.0, 0.0, 10.5830052442584, 1.15463194561016e-14, 0.0, 5.18459255872627, 0.0, 0.0, 0.0, 1.06581410364015e-14, 2.1316282072803e-14, 0.0, -1.64313007644523e-14, 0.0, -2.39808173319034e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.28785870856518e-14},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499965, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824839, 0.0755928946018476, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000004, 1.06581410364015e-14, 1.46059348668045, 1.42009389360938, 0.0, 0.0, 0.0, 9.07114735222147, 4.93770719878695, -0.698297248755177, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283497, 0.0, -6.26099033699942, 2.21359436211787, 0.0, 0.0, 1.06581410364015e-14, 0.0, 10.5830052442584, 2.99332590941915, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497732, 1.24344978758018e-14, 0.0, -4.69574275274958, 1.06581410364015e-14, 0.0, 3.37507799486048e-14, 0.0, -1.06581410364015e-14, 12.69960629311, 0.0, -1.06581410364015e-14, -2.08721928629529e-14, 0.0, 0.0, 1.77635683940025e-14, -1.06581410364015e-14, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473997, -2.01017818278146, -1.42141062443802, 8.14215222512714, -2.1022946646802, -1.71651640581397, 0.728256234341417, 0.594618725379069, 0.420458932936041, 9.81070843517429, -1.18450885369838, -1.02581475831037, 0.305838870920597, 0.264864231681972, 0.21626073957838, -0.105945692672785, -0.0917516612761684, -0.0749149177264175, -0.0529728463363923, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239554, 3.07059789431496, 1.77281052085586, -1.25356634105601, 2.39356776939084, 6.30376871403131, -0.908295106229229, -2.78313372537745, -0.524404424085083, 0.370809924354783, 1.23603308118261, 9.40174755792011, -0.301561193523235, -2.42752078113805, -0.794200206656987, 0.114434427054266, 0.840917865872093, 0.35064189060884, 0.0660687472643469, -0.0467176592151097, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047612, 2.74642624930239, -0.792824967172102, 2.24244764232555, 2.14087209644418, -0.331662479035527, 6.4992307237088, 0.0957427107756388, -1.87616630392937, -2.15580611373101, 11.0554159678513, -2.1316282072803e-14, 9.44035859331466, 0.0, -1.46249406456535, -2.04706526287664, 0.0, 0.422185670932521, 0.590936840285281, 0.522319308773337, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551271, 1.29756443747036, 3.745745886322, -1.05945692672795, 0.404586796856341, 5.01426536422407, -0.383824736789361, 1.80936716113937, -1.10800657553489, 0.313391585264005, 0.0, 2.82521847127455, -0.0509731451534392, 8.20651806648288, -0.631738055305805, 0.0483573714561651, -2.84282124887605, -0.227958835180072, 0.139595707137609, -0.039483628456618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852097, 1.89521416591738, 0.361873432227869, 1.96214168703486, 2.74642624930239, -0.566421515598877, 3.17129986868835, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827825, -0.865042958313596, 0.0, -2.49768411251821, -0.998865569685879, 0.441440386136655, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139073, -0.193429485824682, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034305, 0.0, -0.858258202907006, 2.67027285925185, -1.4210854715202e-14, 1.01030295240889e-14, 12.4373429638327, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683796, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {1.48323969741915, 0.335029697130249, 4.06201920231799, -0.820651806648296, 1.11299858218672e-14, 1.69926454679665, -0.0991031208965194, 5.88642506110459, -1.20156148406978, 0.242752078113808, 0.0, -1.15463194561016e-14, 0.0, 4.94413232473044, -0.214087209644431, 0.0124858196210829, 5.13809303146607, -0.741619848709565, 0.151382517704894, -0.0305838870920692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0},
      {1.32664991614218, 0.299659670905765, 2.07610309995257, 1.46802658041886, 0.0, 0.868496237346897, 0.709124208342343, 1.31624465810883, 4.91295663090393, -1.4113063856887, 0.0, -1.86517468137026e-14, 0.0, 11.0554159678513, 3.82970843102534, -0.223353131420161, 0.0, 5.80409338312194, -1.54743588659733, 0.341938252770112, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930758, 0.259512887494063, 0.749149177264362, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036811, 1.50990331349021e-14, 3.32401972660468, 2.06838446274243, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552746, -1.59872115546023e-14, 0.0, 6.28180682119206, -1.77676328054752, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0},
      {0.938083151964673, 7.62808987244124, 2.30926389122033e-14, 3.11415464992885, 0.0, 0.0, -7.52139804633608, -1.69864122767649e-14, -1.13242748511766e-14, 5.52707620976691, 0.0, 0.0, 1.06581410364015e-14, -1.33226762955019e-14, -3.19744231092045e-14, 14.2141062443803, 1.34336985979644e-14, 1.64313007644523e-14, 1.95399252334028e-14, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577679, 0.0, 2.68023757704196, -0.473803541479345, 0.0, 0.0, -1.06581410364015e-14, 5.09779364038994, -0.792824967172086, 0.140152977645355, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 7.91061171956872, -0.642261628933269, 0.0998865569685985, -0.01765761544547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205081, 2.39808173319034e-14, 1.4982983545288, 0.847565541382366, 0.0, 1.4210854715202e-14, 0.0, 1.62843044502544, 3.54562104171167, -0.814818121686409, 1.06581410364015e-14, -2.1316282072803e-14, 1.77635683940025e-14, 1.4210854715202e-14, -1.06581410364015e-14, 1.37667655053519e-14, 11.0554159678513, 7.18070330817254, -1.11676565710081, 0.19741814228306, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071088, 1.06581410364015e-14, 0.692034366650873, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212813, 3.07059789431493, 1.19418232635199, 0.0, 0.0, 0.0, 2.48689957516035e-14, 0.0, 1.4210854715202e-14, 1.59872115546023e-14, 12.4373429638327, 5.80288457473997, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309067, 0.0, 7.62808987244127, 1.79795802543454, 0.0, 0.0, 0.0, 0.0, -7.52139804633612, 3.19105893754051, 0.0, 1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 1.12687636999453e-14, -1.15463194561016e-14, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451481, -1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, -5.26497863243526, 0.0, 0.0, 3.5527136788005e-14, -1.15463194561016e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.06581410364015e-14, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361256, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910462, 0.869835476750492, 0.615066564126904, 10.333118277332, -2.18326971917504, -1.8907670401189, 0.724780051083752, 0.62767793639472, 0.512496888990055, -0.278967971730977, -0.241593350361244, -0.197260144544827, -0.139483985865489, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516521, -0.0814411017927967, -0.0728431359084678, -0.0630840061880518, -0.0515078753637661, 0.0313466946954453, 0.0280373360835799, 0.0242810453028185, 0.0198253904711074, 0.0140186680417875, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069938, 0.997445717412067, -1.4106012612951, 3.23209352764251, 5.28531208250978, -1.36277028773849, -2.89087233497829, -0.393397896234716, 0.556348640264182, 2.33666428910958, 9.02784807228864, -0.732969916135163, -3.93352933905728, -1.19859611757308, 0.309047252182626, 1.64018416088946, 0.655588223176222, 0.0892142571199899, -0.126168012376108, 1.1908743922773, 11.55277744383, -0.23484359721209, -2.44096975264613, -0.907332870306508, 0.07366624831632, 0.810328731479528, 0.395334573318417, 0.120463442338385, -0.0310604175145487, -0.311895674167864, -0.164844710568316, -0.0658890955530707, -0.00896637020658575, 0.0126803623514082, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940282, -1.09264703862702, 1.54523626091313, 2.95048422176041, -0.761811750275044, 5.59815020469135, 0.263899331455878, -1.9392561165855, -2.28543525082518, 2.13307290077016, -0.257539376818849, 9.14446135479764, 0.0664963811608006, -2.36108976914457, -3.33842298506506, -0.0230350221379944, 0.817905488277884, 1.1564636454577, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.3977187881547, -2.15192884958005, 0.0, 0.360889439280287, 0.555625639776455, 0.595437196138646, 0.0, -0.125015768949698, -0.19247436761616, -0.206265495285703, -0.166687691932943, 0.0, 0.0, -1.04360964314765e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482233189, 1.82834820066017, 2.99085908983327, -1.24403337882028, 0.950146187582611, 5.74064456311312, -0.721110255092799, -0.169967317119746, -1.17961073303081, 0.490653381462665, 0.294392028877595, 4.97613351528118, -0.21547290184283, 5.7817446699566, -1.30185581821821, 0.163532434528642, -3.22682211353224, 0.0385449644663702, 0.26751056943961, -0.111269728052828, 0.0, 2.646387538394, -0.0295875121532858, 10.7636648722209, -0.500120235663634, 0.0216558414515688, -3.57321383950879, -0.581087203147985, 0.130841432732453, -0.0164356280722675, 1.37533064807501, 0.324307824721458, -0.00387391468765175, -0.0268858238268316, 0.0111830284386746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637247, 1.66904592079257, 0.963624111659414, 1.3627702877385, 0.867360833110881, 2.28430636201793, 2.96226264871974, -1.00852844760551, 1.7102631376487, -2.01556443707464, 0.268741924943299, 2.0441554316077, 2.68821895760392, -0.527798662911731, 7.07977053255618, -1.76652739792482, 0.182834820066021, -3.12574097035513, -1.01990506872273, 0.904016610326401, 0.0, 13.0453753561106, 1.45851730441319, 0.0, 11.0940489487798, -0.632607619454905, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468092, 0.0, 0.992281903807267, 0.735567892896448, 0.181909068193167, -0.147004726489969, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493886, 1.49284005458436, -0.430945803685658, 3.04724700110021, 0.775791113542713, -0.120185042515461, 5.29905651979671, 0.0346944333244359, -1.52970585407782, 0.901387818866001, -10.576283741361, 1.15463194561016e-14, 4.5156107826894, -1.04360964314765e-14, -0.699555414372448, 6.36462844462232, 0.0, 0.201944253400475, -1.83730997289731, -2.74825341360597, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.09993548319961, 0.0, 0.0, 0.487107866980279, 0.894874292847877, 0.903959543974644, 0.0, 0.0, -1.33781874467331e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456568, 3.86595114186567, -1.05140010313427, 0.160604018609916, 3.35889012281482, -0.304724700110037, 3.87851223317102, -1.52475169285614, 0.414677792940095, 0.0, 1.135512111385, -0.0364215679542248, 7.32969916135159, -0.761724681099363, 0.0691050664139874, 0.564240504518043, -0.879563899362187, 0.345781182036198, -0.0940400840863448, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162678, 0.00366050530850304, 9.059750638547, -0.736662483163212, 0.0765562109321147, -0.00694532049720864, -3.48709964663733, -0.0567083043941574, 0.0883994979795864, -0.0347523163751431, 0.00945138406568952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {1.48690428533298, 0.705300630647584, 2.03602754481991, 1.15175110689981, 0.146610739697702, 1.817027050318, 1.25178444059442, 0.655663160391223, 3.61359041872286, -1.7034628596731, 0.0, 0.614267257013214, 0.454391937932161, 1.78428514239955, 5.63152770643897, -0.746494073225309, -0.618094504365235, 2.03210252328836, -2.15494277062553, 0.764033484562619, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865874, -0.106930204231198, 0.0, 9.68367982311022, -1.32524448062075, 0.133143804689793, 0.0, -3.35452509157129, -0.478206411017785, 0.384353057392899, -0.124241670058189, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880569, 0.728431359084681, 2.57539376818856, 0.131132632078232, 0.711024300256724, 2.23926008187656, -0.205255035576788, 2.58567482211399, 0.761811750275053, 0.0, -10.576283741361, 0.763277533137579, 1.24344978758018e-14, 4.13862564412656, 2.68954640486933, 1.08801856413265e-14, -1.19471831485578, 3.1056206816986, -2.32269806558127, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241848, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 1.24344978758018e-14, -2.88176900403078, -1.51261363209514, 0.76398525469261, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, -1.21014309684142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, -1.4210854715202e-14},
      {1.15175110689979, 0.546323519313527, -0.105140010313412, 3.27118942773249, 9.65295620481433, -1.02140518265514e-14, 2.69341127303542, 0.0, -0.518347241175119, 4.25171145123353, 0.0, 0.0, -9.91526600752598, 0.0, 0.0, 6.71889089790567, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059453, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376109, 0.199489143482415, 3.68560354207935, -0.814411017927958, 0.0, 1.02786571910339, -0.078679579246943, 6.00856531485323, -1.4536216402544, 0.321208037219809, 0.0, 0.0, 0.0, 3.02803229702669, -0.2330980349071, 0.0178428514239943, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084669, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433803, 0.0234272339744236, -0.00179327404131602, 5.40219154319688, -0.702817019232749, 0.136947913395217, -0.0331311120155255, 0.00732101061700685, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {1.15175110689975, 0.182107839771152, 2.20794021658199, 0.892142571199752, -1.4210854715202e-14, 0.615765106730371, 0.32320935276422, 2.13307290077017, 3.91870514328394, -1.31949665727937, 0.0, 0.0, 1.02140518265514e-14, 1.07496769977314, 1.90844613931508, -0.192743940909618, 1.11713920350153, 6.61105135360478, -2.33689608954553, 0.591817792331155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771028, 0.0343775825476166, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297044, -0.0962371838080771, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 1.65423230669148e-14, 0.0, 0.0, 0.0},
      {1.03015750727541, 0.162882203585591, 1.12848100903608, 1.99489143482414, 0.0, 0.314718316987764, 0.578174466995661, 0.476969600708475, 4.00571020990213, 0.590096844352082, 0.0, 0.0, 0.0, -10.576283741361, 1.83186607953016, 0.694437895660752, 0.0, 2.77627448210727, 4.8112068719424, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780438, -0.338230690505755, -1.4210854715202e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634515, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199777, 0.141060126129509, 0.407205508964008, 2.53385243517952, 0.0, 9.65295620481432, 0.695435800330246, 0.0, 2.0075502326238, 3.29336152870135, 0.0, 1.59872115546023e-14, -1.26565424807268e-14, 0.0, -9.91526600752598, 1.73481017017154, 2.62012633811537e-14, 0.0, 5.00796559370722, 1.41646657250369, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 2.44096975264614, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {0.728431359084674, -7.94708263760856, 0.0, 2.5390822703312, 0.0, 0.0, 10.2207771580387, 0.0, 0.0, 5.00713776237769, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, -8.49879943502222, -1.4210854715202e-14, 0.0, 0.0, 6.93924068068618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 0.0, 0.0, 0.0, 1.15463194561016e-14, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084662, 0.0, 2.32737334062816, -0.470200420431693, 0.0, 0.0, 1.59872115546023e-14, 4.49691252107736, -0.917928424547695, 0.185449546754731, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0654086930623, -1.01980390271857, 0.20816659994661, -0.042056004125357, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678881, 0.10249414863811, -0.0209215304820316, 0.00422678745047178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608005, 0.0, 1.45686271816938, 0.51507875363772, 0.0, 0.0, 1.4210854715202e-14, 1.84729532019112, 2.58567482211398, -0.761811750275054, 1.4210854715202e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.71994831963705, 5.72533841794521, -1.54195152727693, 0.341686161713623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 13.0453753561106, 9.33451074824442, -1.3473205733131, 0.275020660380936, -0.055562563977638, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {0.594761714133161, 0.0, 0.814411017927945, 1.15175110689979, -1.33226762955019e-14, 0.0, -1.24344978758018e-14, 0.590096844352066, 2.89087233497828, 0.340692571934627, 0.0, 1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 1.59872115546023e-14, -10.576283741361, 3.43474889911911, 3.47218947830366, -1.03874215316938, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 8.28492607088318, -1.69115345252877, 0.341664592660038, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.515078753637698, 0.0, 0.376160336345346, 1.46292038553769, 0.0, 0.0, 2.53130849614536e-14, 9.65295620481433, 1.85449546754729, 1.90142316513449, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -9.91526600752596, 4.6261604537908, 0.817797356933113, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 15.9443476574685, 6.50925267372302, -1.31506763029893, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {0.420560041253698, -1.90958360235527e-14, -7.94708263760857, 1.46593983227031, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497828, 0.0, 1.95399252334028e-14, -2.1316282072803e-14, -1.06581410364015e-14, 0.0, -1.59872115546023e-14, -1.68753899743024e-14, 0.0, -8.49879943502225, 4.00637247496573, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 17.9373911146521, 3.6239002554188, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {6.54237885546497, 0.0, 1.73194791841524e-14, -6.9105066413987, 0.0, 0.0, -3.46389583683049e-14, 1.33226762955019e-14, 0.0, 12.2649325896465, 0.0, 0.0, 1.77635683940025e-14, 0.0, -3.5527136788005e-14, -1.95399252334028e-14, 0.0, 2.64233079860787e-14, 1.4210854715202e-14, -5.6658662900148, 0.0, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 1.4210854715202e-14, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, -2.30926389122033e-14, 0.0, -1.14352971536391e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 1.86517468137026e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[56] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      double tmp1 = 0.25*(Y + Z)*(Y + Z);
      double tmp2 = 0.5*(1.0 + Z + 2.0*Y);
      double tmp3 = 0.5*(1.0 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[4] = 1.5*tmp0*basisvalues[1] - 0.5*tmp1*basisvalues[0];
      basisvalues[10] = 1.66666666666667*tmp0*basisvalues[4] - 0.666666666666667*tmp1*basisvalues[1];
      basisvalues[20] = 1.75*tmp0*basisvalues[10] - 0.75*tmp1*basisvalues[4];
      basisvalues[35] = 1.8*tmp0*basisvalues[20] - 0.8*tmp1*basisvalues[10];
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[5] = (0.5*(2.0 + 3.0*Y + Z) + 1.0*(1.0 + Y))*basisvalues[1];
      basisvalues[11] = (0.5*(2.0 + 3.0*Y + Z) + 2.0*(1.0 + Y))*basisvalues[4];
      basisvalues[21] = (0.5*(2.0 + 3.0*Y + Z) + 3.0*(1.0 + Y))*basisvalues[10];
      basisvalues[36] = (0.5*(2.0 + 3.0*Y + Z) + 4.0*(1.0 + Y))*basisvalues[20];
      basisvalues[7] = (1.66666666666667*tmp2 + 0.111111111111111*tmp3)*basisvalues[2] - 0.555555555555556*tmp4*basisvalues[0];
      basisvalues[16] = (1.75*tmp2 + 0.05*tmp3)*basisvalues[7] - 0.7*tmp4*basisvalues[2];
      basisvalues[30] = (1.8*tmp2 + 0.0285714285714286*tmp3)*basisvalues[16] - 0.771428571428571*tmp4*basisvalues[7];
      basisvalues[50] = (1.83333333333333*tmp2 + 0.0185185185185185*tmp3)*basisvalues[30] - 0.814814814814815*tmp4*basisvalues[16];
      basisvalues[13] = (2.1*tmp2 + 0.54*tmp3)*basisvalues[5] - 0.56*tmp4*basisvalues[1];
      basisvalues[26] = (2.0*tmp2 + 0.285714285714286*tmp3)*basisvalues[13] - 0.714285714285714*tmp4*basisvalues[5];
      basisvalues[45] = (1.96428571428571*tmp2 + 0.178571428571429*tmp3)*basisvalues[26] - 0.785714285714286*tmp4*basisvalues[13];
      basisvalues[23] = (2.57142857142857*tmp2 + 1.02040816326531*tmp3)*basisvalues[11] - 0.551020408163265*tmp4*basisvalues[4];
      basisvalues[41] = (2.29166666666667*tmp2 + 0.578703703703704*tmp3)*basisvalues[23] - 0.712962962962963*tmp4*basisvalues[11];
      basisvalues[38] = (3.05555555555556*tmp2 + 1.51234567901235*tmp3)*basisvalues[21] - 0.54320987654321*tmp4*basisvalues[10];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[8] = (3.0*Z + 2.0)*basisvalues[2];
      basisvalues[17] = (4.0*Z + 3.0)*basisvalues[7];
      basisvalues[31] = (5.0*Z + 4.0)*basisvalues[16];
      basisvalues[51] = (6.0*Z + 5.0)*basisvalues[30];
      basisvalues[6] = (3.0*Z + 2.0)*basisvalues[1];
      basisvalues[14] = (4.0*Z + 3.0)*basisvalues[5];
      basisvalues[27] = (5.0*Z + 4.0)*basisvalues[13];
      basisvalues[46] = (6.0*Z + 5.0)*basisvalues[26];
      basisvalues[12] = (4.0*Z + 3.0)*basisvalues[4];
      basisvalues[24] = (5.0*Z + 4.0)*basisvalues[11];
      basisvalues[42] = (6.0*Z + 5.0)*basisvalues[23];
      basisvalues[22] = (5.0*Z + 4.0)*basisvalues[10];
      basisvalues[39] = (6.0*Z + 5.0)*basisvalues[21];
      basisvalues[37] = (6.0*Z + 5.0)*basisvalues[20];
      basisvalues[9] = basisvalues[3]*(0.3125 + 1.875*Z) - 0.5625*basisvalues[0];
      basisvalues[19] = basisvalues[9]*(0.155555555555556 + 1.86666666666667*Z) - 0.711111111111111*basisvalues[3];
      basisvalues[34] = basisvalues[19]*(0.09375 + 1.875*Z) - 0.78125*basisvalues[9];
      basisvalues[55] = basisvalues[34]*(0.0628571428571429 + 1.88571428571429*Z) - 0.822857142857143*basisvalues[19];
      basisvalues[18] = basisvalues[8]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[2];
      basisvalues[33] = basisvalues[18]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[8];
      basisvalues[54] = basisvalues[33]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[18];
      basisvalues[32] = basisvalues[17]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[7];
      basisvalues[53] = basisvalues[32]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[17];
      basisvalues[52] = basisvalues[31]*(1.76 + 3.3*Z) - 0.54*basisvalues[16];
      basisvalues[15] = basisvalues[6]*(0.777777777777778 + 2.33333333333333*Z) - 0.555555555555556*basisvalues[1];
      basisvalues[29] = basisvalues[15]*(0.428571428571429 + 2.14285714285714*Z) - 0.714285714285714*basisvalues[6];
      basisvalues[49] = basisvalues[29]*(0.275 + 2.0625*Z) - 0.7875*basisvalues[15];
      basisvalues[28] = basisvalues[14]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[5];
      basisvalues[48] = basisvalues[28]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[14];
      basisvalues[47] = basisvalues[27]*(1.76 + 3.3*Z) - 0.54*basisvalues[13];
      basisvalues[25] = basisvalues[12]*(1.265625 + 2.8125*Z) - 0.546875*basisvalues[4];
      basisvalues[44] = basisvalues[25]*(0.733333333333333 + 2.44444444444444*Z) - 0.711111111111111*basisvalues[12];
      basisvalues[43] = basisvalues[24]*(1.76 + 3.3*Z) - 0.54*basisvalues[11];
      basisvalues[40] = basisvalues[22]*(1.76 + 3.3*Z) - 0.54*basisvalues[10];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[9] *= std::sqrt(1.75);
      basisvalues[19] *= std::sqrt(2.25);
      basisvalues[34] *= std::sqrt(2.75);
      basisvalues[55] *= std::sqrt(3.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[8] *= std::sqrt(3.5);
      basisvalues[18] *= std::sqrt(4.5);
      basisvalues[33] *= std::sqrt(5.5);
      basisvalues[54] *= std::sqrt(6.5);
      basisvalues[7] *= std::sqrt(5.25);
      basisvalues[17] *= std::sqrt(6.75);
      basisvalues[32] *= std::sqrt(8.25);
      basisvalues[53] *= std::sqrt(9.75);
      basisvalues[16] *= std::sqrt(9.0);
      basisvalues[31] *= std::sqrt(11.0);
      basisvalues[52] *= std::sqrt(13.0);
      basisvalues[30] *= std::sqrt(13.75);
      basisvalues[51] *= std::sqrt(16.25);
      basisvalues[50] *= std::sqrt(19.5);
      basisvalues[1] *= std::sqrt(7.5);
      basisvalues[6] *= std::sqrt(10.5);
      basisvalues[15] *= std::sqrt(13.5);
      basisvalues[29] *= std::sqrt(16.5);
      basisvalues[49] *= std::sqrt(19.5);
      basisvalues[5] *= std::sqrt(15.75);
      basisvalues[14] *= std::sqrt(20.25);
      basisvalues[28] *= std::sqrt(24.75);
      basisvalues[48] *= std::sqrt(29.25);
      basisvalues[13] *= std::sqrt(27.0);
      basisvalues[27] *= std::sqrt(33.0);
      basisvalues[47] *= std::sqrt(39.0);
      basisvalues[26] *= std::sqrt(41.25);
      basisvalues[46] *= std::sqrt(48.75);
      basisvalues[45] *= std::sqrt(58.5);
      basisvalues[4] *= std::sqrt(26.25);
      basisvalues[12] *= std::sqrt(33.75);
      basisvalues[25] *= std::sqrt(41.25);
      basisvalues[44] *= std::sqrt(48.75);
      basisvalues[11] *= std::sqrt(45.0);
      basisvalues[24] *= std::sqrt(55.0);
      basisvalues[43] *= std::sqrt(65.0);
      basisvalues[23] *= std::sqrt(68.75);
      basisvalues[42] *= std::sqrt(81.25);
      basisvalues[41] *= std::sqrt(97.5);
      basisvalues[10] *= std::sqrt(63.0);
      basisvalues[22] *= std::sqrt(77.0);
      basisvalues[40] *= std::sqrt(91.0);
      basisvalues[21] *= std::sqrt(96.25);
      basisvalues[39] *= std::sqrt(113.75);
      basisvalues[38] *= std::sqrt(136.5);
      basisvalues[20] *= std::sqrt(123.75);
      basisvalues[37] *= std::sqrt(146.25);
      basisvalues[36] *= std::sqrt(175.5);
      basisvalues[35] *= std::sqrt(214.5);
      
      // Table(s) of coefficients
      static const double coefficients0[56] = \
      {0.00945067404923512, 0.0, 0.0, -0.00746834873437425, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0109364720199429, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00563672438672438, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00623163327913695, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0182390373864041};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {6.32455532033678, -2.48689957516035e-14, 0.0, 0.0, 1.04360964314765e-14, -1.77635683940025e-14, -1.46549439250521e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.48787232534531e-14, 0.0, -3.19744231092045e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.41948691584548e-14, 11.2249721603218, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.4210854715202e-14, -1.15463194561016e-14, 0.0, 1.54888466424096e-14, 0.0, 0.0, 0.0, -1.50990331349021e-14, -2.30926389122033e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.58257569495585, -4.08562073062058e-14, 8.36660026534077, -1.18321595661994, 0.0, -2.53130849614536e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, -3.28626015289046e-14, 0.0, -1.90958360235527e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.74165738677395, -2.8421709430404e-14, 0.0, 8.69482604771367, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -4.9737991503207e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.49909083394698, 0.0, -3.34664010613629, -2.36643191323984, 15.4919333848297, 0.0, 2.30926389122033e-14, 0.692820323027545, 0.565685424949236, 0.4, 0.0, -2.8421709430404e-14, -1.4210854715202e-14, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 2.04281036531029e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0},
      {2.89768209427166e-14, 4.89897948556636, 2.1316282072803e-14, 0.0, 1.06581410364015e-14, 14.1985914794391, -0.828078671210806, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 1.68753899743024e-14, 2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, -2.1316282072803e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {0.0, 4.24264068711928, -2.1316282072803e-14, 0.0, 0.0, 0.0, 14.3427433120128, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, -4.08562073062058e-14, 0.0, 1.73194791841524e-14, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {3.6, -2.04281036531029e-14, 8.76356092008267, -1.549193338483, 0.0, -1.06581410364015e-14, 0.0, 9.52470471983255, -1.48131215963607, 0.261861468283193, 0.0, -1.4210854715202e-14, 0.0, -2.1316282072803e-14, -1.4210854715202e-14, 0.0, 1.4210854715202e-14, -1.77635683940025e-14, 2.1316282072803e-14, -2.79776202205539e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 1.11022302462516e-14, 0.0, 0.0, -1.29896093881143e-14},
      {3.11769145362399, -2.95319324550292e-14, 3.16227766016838, 4.91934955049954, 0.0, -2.75612865863195e-14, 0.0, 0.0, 10.690449676497, -2.41897262725906, 0.0, 0.0, 1.06581410364015e-14, -2.22044604925031e-14, -1.50990331349021e-14, -3.71369601737115e-14, 0.0, 0.0, -3.90798504668055e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.86517468137026e-14, -1.24344978758018e-14, 0.0, 0.0, -1.95399252334028e-14, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.54558441227159, 0.0, -1.19904086659517e-14, 7.66811580507232, 0.0, 0.0, 2.38697950294409e-14, 0.0, -1.77635683940025e-14, 10.3691851174526, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.22124532708767e-14, -1.24344978758018e-14, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.55111512312578e-14, 11.6057691494799, 0.0, 0.0, 0.0, -4.20458932936039, -3.43303281162796, 0.0, 0.0, 0.0, 19.6214168703486, -1.77635683940025e-14, -1.59872115546023e-14, 0.61167774184119, 0.529728463363962, 0.432521479156773, 0.0, 0.0, 1.90958360235527e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1878460182374e-14, 0.0, -1.06581410364015e-14, 1.24344978758018e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.53137212479106, 0.0, 3.54562104171168, -2.50713268211202, 4.78713553878169, 0.0, 2.01505478969466e-14, -5.56626745075489, -1.04880884817015, 0.741619848709564, 0.0, 18.8034951158402, -0.603122387046459, 0.0, -2.75335310107039e-14, 0.0, 1.68183573174417, 0.701283781217668, 0.132137494528686, -0.0934353184302177, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.05298244095214, 1.46549439250521e-14, -1.58564993434419, 4.48489528465112, 4.28174419288837, 0.0, 2.8421709430404e-14, 0.191485421551263, -3.75233260785876, -4.31161222746203, 0.0, -1.24344978758018e-14, 18.8807171866293, 0.0, -2.8421709430404e-14, 1.77635683940025e-14, 0.0, 0.844371341865036, 1.18187368057056, 1.04463861754668, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.06581410364015e-14, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.95079541199084e-14, 2.59512887494073, 2.8421709430404e-14, 1.59872115546023e-14, 1.4210854715202e-14, 10.0285307284481, -0.76764947357873, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.4130361329658, -1.26347611061159, 0.0967147429123472, 2.1316282072803e-14, 2.1316282072803e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.32115382989599, 0.0, 0.0, 0.0, 3.92428337406972, 5.49285249860479, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 17.3044631365565, -1.73008591662718, 0.0, 2.8421709430404e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 2.01017818278145, 0.0, 0.0, 0.0, 0.0, 8.91928088068606, 0.0, 0.0, 0.0, 0.0, 0.0, 3.01980662698043e-14, 0.0, 0.0, 16.8558564884488, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.96647939483828, 0.0, 8.12403840463598, -1.6413036132966, 1.06581410364015e-14, 0.0, -1.77635683940025e-14, 11.7728501222092, -2.40312296813957, 0.485504156227613, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.2761860629321, -1.48323969741915, 0.302765035409783, -0.061167774184141, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.57571741713036e-14, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 2.62012633811537e-14, 0.0, 0.0, 0.0},
      {2.65329983228433, 0.0, 4.15220619990516, 2.93605316083771, 0.0, -1.28785870856518e-14, 0.0, 2.63248931621765, 9.82591326180785, -2.8226127713774, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 1.38777878078145e-14, 11.6081867662439, -3.09487177319466, 0.683876505540219, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.28785870856518e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, -1.83741910575463e-14, 0.0, 0.0, 0.0, -1.86517468137026e-14, 0.0, -1.24344978758018e-14, 1.26565424807268e-14, -1.28785870856518e-14},
      {2.29782505861523, 0.0, 1.49829835452876, 5.50917601898537, 0.0, 0.0, 0.0, 0.0, 6.64803945320938, 4.13676892548486, 0.0, -1.15463194561016e-14, 0.0, 0.0, -2.1316282072803e-14, -2.1316282072803e-14, 0.0, 0.0, 12.5636136423841, -3.55352656109505, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0},
      {1.87616630392939, 1.15463194561016e-14, 0.0, 6.22830929985769, 0.0, 0.0, 3.90798504668055e-14, 0.0, -1.77635683940025e-14, 11.0541524195338, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 11.6057691494799, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.83186700722506, 0.0, -4.41087092453691, -3.11895674167864, 16.6749979177077, 1.02140518265514e-14, 0.0, 2.13065307820925, 1.73967095350099, 1.23013312825381, -1.4210854715202e-14, -4.36653943835008, -3.7815340802378, 0.0, 2.48689957516035e-14, 1.24344978758018e-14, -0.557935943461974, -0.483186700722504, -0.394520289089682, -0.278967971730994, 23.6981011897578, 0.0, 0.0, 0.490653381462664, 0.438853725736261, 0.380058475033041, 0.0, 0.0, 0.0, 0.0, 0.0626933893908879, 0.0560746721671604, 0.048562090605635, 0.0396507809422171, 0.0280373360835759, -1.06581410364015e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 6.91050664139875, -1.04360964314765e-14, 0.0, 0.0, 10.5706241650195, -2.725540575477, 2.28705943072782e-14, 0.0, 0.0, 4.67332857821917, -4.44089209850063e-14, 0.0, -7.86705867811457, -2.39719223514613, 0.618094504365247, 0.0, 0.0, 1.64313007644523e-14, 0.0, 0.0, 23.1055548876599, -0.469687194424181, 0.0, 0.0, 0.0, 1.62065746295905, 0.790669146636831, 0.240926884676766, -0.062120835029098, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.62012633811537e-14, 0.0, 1.77635683940025e-14, 1.11022302462516e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -1.50990331349021e-14, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {3.81916720471054e-14, 6.30840061880562, 1.59872115546023e-14, -1.59872115546023e-14, 0.0, -1.5236235005501, 11.1963004093827, 0.0, 0.0, 0.0, 4.26614580154031, 0.0, -2.48689957516035e-14, 0.132992762321612, -4.72217953828915, -6.67684597013015, 0.0, -1.06581410364015e-14, 1.4210854715202e-14, 0.0, 1.06581410364015e-14, 0.0, 23.1532444221696, 0.0, 0.0, 0.0, 0.0, 0.721778878560579, 1.11125127955291, 1.19087439227729, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 1.15463194561016e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 1.15463194561016e-14, 0.0, 0.0, 0.0},
      {3.85449644663773, 2.30926389122033e-14, 5.98171817966648, -2.48806675764059, 1.90029237516521, 1.95399252334028e-14, 0.0, -0.339934634239501, -2.35922146606162, 0.981306762925323, 0.0, 9.9522670305624, -0.43094580368566, 0.0, 0.0, 2.48689957516035e-14, -6.45364422706454, 0.0770899289327254, 0.535021138879209, -0.222539456105663, 0.0, 1.02140518265514e-14, 0.0, 21.5273297444417, -1.00024047132727, 0.0433116829031313, 0.0, 0.0, 0.0, 0.0, 2.75066129615, 0.648615649442922, -0.00774782937530727, -0.0537716476536625, 0.0223660568773498, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.51865775274496, 2.22044604925031e-14, 1.92724822331888, 2.72554057547701, 1.73472166622177, 0.0, 4.2632564145606e-14, -2.01705689521107, 3.4205262752974, -4.03112887414928, 0.0, 4.08831086321546, 5.37643791520785, 0.0, -3.5527136788005e-14, 2.22044604925031e-14, 0.365669640132043, -6.25148194071026, -2.03981013744546, 1.8080332206528, 0.0, 0.0, 0.0, 0.0, 22.1880978975596, -1.2652152389098, 0.0, 0.0, 0.0, 0.0, 0.0, 1.98456380761455, 1.4711357857929, 0.363818136386334, -0.294009452979941, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0},
      {3.14718316987776, 0.0, -0.861891607371339, 6.09449400220043, 1.55158222708542, 1.24344978758018e-14, 0.0, 0.0693888666488744, -3.05941170815567, 1.802775637732, 0.0, 1.7874590696465e-14, 9.03122156537879, 0.0, -2.22044604925031e-14, 3.19744231092045e-14, 0.0, 0.403888506800969, -3.67461994579464, -5.49650682721195, 0.0, 0.0, 0.0, 0.0, 0.0, 21.7841260588564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.97421573396055, 1.78974858569576, 1.80791908794929, 0.0, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, -1.06581410364015e-14, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {-2.8421709430404e-14, 1.54523626091312, 0.0, 0.0, 0.0, 6.71778024562962, -0.609449400220045, 0.0, 1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 14.6593983227032, -1.52344936219871, 0.138210132827959, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.119501277094, -1.47332496632642, 0.153112421864222, -0.0138906409944113, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {3.73034936274053e-14, 1.41060126129512, 1.59872115546023e-14, 1.4210854715202e-14, 0.0, 3.63405410063598, 2.50356888118885, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 3.56857028479908, 11.2630554128779, -1.49298814645065, 0.0, -1.4210854715202e-14, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.3673596462204, -2.65048896124152, 0.266287609379576, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14},
      {-4.88498130835069e-14, 1.2616801237611, -1.59872115546023e-14, -1.4210854715202e-14, 0.0, 1.42204860051344, 4.4785201637531, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 8.27725128825315, 5.37909280973864, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.9654813226339, -2.61992366301005, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 1.77635683940025e-14, 0.0, -1.4210854715202e-14},
      {-2.97539770599542e-14, 1.09264703862701, 1.50990331349021e-14, 0.0, 0.0, -1.4210854715202e-14, 5.38682254607083, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.3988810110277e-14, -2.26485497023532e-14, 0.0, -1.33226762955019e-14, 13.4377817958113, 1.06581410364015e-14, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 18.907670401189, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.52336024752222, 1.4210854715202e-14, 7.37120708415868, -1.62882203585591, 0.0, 0.0, 0.0, 12.0171306297065, -2.90724328050879, 0.642416074439624, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 13.985882094426, -2.72522906732404, 0.659300804656283, -0.145686271816937, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8043830863938, -1.40563403846549, 0.273895826790434, -0.0662622240310455, 0.0146420212340158, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {2.30350221379958, 0.0, 4.41588043316396, 1.78428514239951, 0.0, 0.0, -3.01980662698043e-14, 4.26614580154033, 7.83741028656787, -2.63899331455874, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 2.23427840700305, 13.2221027072096, -4.67379217909108, 1.1836355846623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 12.1258851598178, -3.11150358274814, 0.833612074594097, -0.192474367616154, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.66453525910038e-14, 1.84297022087776e-14, -1.56541446472147e-14, 1.64313007644523e-14, 0.0},
      {2.06031501455086, 1.4210854715202e-14, 2.25696201807216, 3.9897828696483, 0.0, 0.0, 2.39808173319034e-14, 0.953939201416929, 8.01142041980428, 1.18019368870417, 0.0, 0.0, 1.77635683940025e-14, 0.0, -1.77635683940025e-14, 1.4210854715202e-14, -1.06581410364015e-14, 5.55254896421457, 9.62241374388481, -3.59830837050571, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 13.3932520322736, -4.68666192508058, 1.18356086726903, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.78428514239956, 0.0, 0.814411017927968, 5.06770487035906, 0.0, 0.0, 2.48689957516035e-14, 0.0, 4.01510046524761, 6.5867230574027, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, -1.77635683940025e-14, 10.0159311874144, 2.8329331450074, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 14.0929454377398, -4.55552790213387, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.73194791841524e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0},
      {1.45686271816935, 1.06581410364015e-14, 0.0, 5.07816454066241, -1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 10.0142755247554, 0.0, 0.0, 3.90798504668055e-14, 0.0, -2.30926389122033e-14, 0.0, 0.0, 2.19824158875781e-14, 1.77635683940025e-14, 13.8784813613723, 0.0, 0.0, 0.0, 0.0, -1.37667655053519e-14, -1.06581410364015e-14, 0.0, 1.4432899320127e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 12.5535587278944, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.45439216225896e-14, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.47722557505168, -2.48689957516035e-14, 0.0, 0.0, 0.0, -1.77635683940025e-14, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -1.49637247037759e-14, 0.0, -3.01980662698043e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.61248608016089, -1.08012344973465, -0.763762615825974, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747791, 7.2456883730947, 4.18330013267038, -0.591607978309975, 0.0, -1.4210854715202e-14, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, -2.8421709430404e-14, 0.0, 1.0325074129014e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.44051437445114e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338697, -1.4210854715202e-14, 0.0, 4.34741302385684, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-2.64575131106461, -1.4210854715202e-14, 9.66091783079297, 0.683130051063949, 0.0, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, -1.68753899743024e-14, 0.0, 1.4210854715202e-14, 0.0, -1.15463194561016e-14, -1.4210854715202e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.24037034920394, -2.30926389122033e-14, 0.0, 7.52994023880669, 0.0, -1.02140518265514e-14, -1.59872115546023e-14, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -3.90798504668055e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697347, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113257, 0.346410161513768, 0.282842712474613, 0.2, 0.0, -1.59872115546023e-14, -1.59872115546023e-14, 0.0, -1.68753899743024e-14, -1.47659662275146e-14, 0.0, 1.33226762955019e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772444, 2.44948974278316, 2.82842712474622, -0.999999999999997, 9.16515138991168, 7.09929573971952, -0.414039335605381, -2.04939015319193, -0.478091443733767, 0.169030850945705, 2.1316282072803e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 1.86517468137026e-14, 1.73194791841524e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974981, 2.12132034355963, -0.408248290463877, 3.17542648054294, 0.0, 0.0, 7.17137165600636, 0.0, -1.38013111868471, -1.56144011671766, 0.0, 0.0, 0.0, 0.0, 0.0, -4.2632564145606e-14, 0.0, 0.0, -1.59872115546023e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.26565424807268e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000005, -5.69209978830307, 4.38178046004135, -0.77459666924149, 1.77635683940025e-14, 10.998181667894, 0.962140470884736, 4.76235235991627, -0.74065607981803, 0.1309307341416, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681199, 2.73861278752581, 1.58113883008417, 2.45967477524976, 0.0, -1.02140518265514e-14, 9.25820099772553, 0.0, 5.34522483824848, -1.20948631362953, 0.0, 0.0, 1.59872115546023e-14, -1.33226762955019e-14, 0.0, -5.06261699229071e-14, 0.0, 1.4210854715202e-14, -3.19744231092045e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, -1.06581410364015e-14, 0.0, 0.0, -1.17683640610267e-14, -1.64313007644523e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613579, 0.0, 0.0, 3.83405790253616, 0.0, 0.0, 1.19348975147204e-14, 0.0, 0.0, 5.18459255872628, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.19615242270666, -2.8421709430404e-14, -3.16227766016839, -2.23606797749981, 0.0, 0.0, -2.48689957516035e-14, 13.7477270848675, 0.534522483824869, 0.377964473009236, -2.8421709430404e-14, -2.15938378289593e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 2.84494650060196e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.85407245112401e-14, 0.0, 0.0, 0.0},
      {-1.8, 0.0, 3.6514837167011, -2.8401877872188, 0.0, 0.0, 2.8421709430404e-14, 1.15463194561016e-14, 12.3442679969673, 1.39659449751036, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, -1.24344978758018e-14, -3.99680288865056e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.22124532708767e-14, 0.0, -1.06581410364015e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14},
      {2.20454076850487, 1.28785870856518e-14, 0.0, 6.64078308635358, 0.0, 0.0, 2.08721928629529e-14, 0.0, -1.24344978758018e-14, 8.97997772825744, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, -2.8421709430404e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473997, -2.01017818278146, -1.42141062443802, 8.14215222512714, -2.1022946646802, -1.71651640581397, 0.728256234341417, 0.594618725379069, 0.420458932936041, 9.81070843517429, -1.18450885369838, -1.02581475831037, 0.305838870920597, 0.264864231681972, 0.21626073957838, -0.105945692672785, -0.0917516612761684, -0.0749149177264175, -0.0529728463363923, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239559, 3.07059789431498, 1.77281052085585, -1.25356634105601, 2.39356776939085, 6.30376871403132, -0.908295106229227, -2.78313372537745, -0.524404424085072, 0.370809924354783, 11.1242977306435, 9.4017475579201, -0.301561193523241, -2.42752078113805, -0.794200206656987, 0.114434427054269, 0.840917865872093, 0.350641890608839, 0.0660687472643508, -0.0467176592151073, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.24344978758018e-14, 0.0, 0.0, 0.0, -1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047606, 2.74642624930239, -0.792824967172102, 2.24244764232555, 2.14087209644418, -0.331662479035535, 6.4992307237088, 0.095742710775629, -1.87616630392938, -2.15580611373101, 1.06581410364015e-14, 0.0, 9.44035859331467, 0.0, -1.46249406456536, -2.04706526287664, 0.0, 0.422185670932525, 0.590936840285275, 0.522319308773337, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.01585406753202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551273, 1.29756443747036, 3.74574588632199, -1.05945692672795, -8.09173593712688, 5.01426536422408, -0.383824736789381, 1.80936716113938, -1.10800657553488, 0.313391585264006, 0.0, 12.7134831207354, 1.01946290306867, 8.20651806648289, -0.631738055305803, 0.0483573714561754, -2.84282124887605, -0.227958835180086, 0.139595707137602, -0.0394836284566153, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715532, 1.160576914948, 1.34011878852097, 1.89521416591739, 2.53311402559511, 1.96214168703485, 2.74642624930243, -0.566421515598881, 3.17129986868835, -1.82198870938951, 0.0, -1.11022302462516e-14, 11.1699829238239, -1.06581410364015e-14, 8.65223156827826, -0.865042958313582, 0.0, -2.49768411251821, -0.998865569685881, 0.441440386136652, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -2.48689957516035e-14, -1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 1.00508909139072, -0.193429485824669, 3.55615782880926, 0.0, 0.0, 4.45964044034303, 0.0, -0.858258202906998, 2.67027285925185, 0.0, 0.0, 0.0, 0.0, 0.0, 8.42792824422439, 0.0, 0.0, -1.62195554683795, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741913, 7.03562363973514, 4.06201920231801, -0.820651806648293, 0.0, -6.79705818718656, -2.08116553882676, 5.8864250611046, -1.20156148406977, 0.242752078113808, 0.0, -2.1316282072803e-14, 0.0, 14.8323969741913, 0.856348838577661, 0.262202212042544, 5.13809303146608, -0.741619848709579, 0.151382517704904, -0.0305838870920607, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.02060590481778e-14, 0.0, 0.0, 0.0},
      {1.32664991614217, -2.69693703815182, 2.07610309995257, 1.46802658041886, 0.0, 3.03973683071413, -6.38211787508101, 1.31624465810882, 4.91295663090391, -1.41130638568869, 0.0, 0.0, -1.24344978758018e-14, 0.0, 13.4039795085887, 2.01017818278148, 0.0, 5.80409338312194, -1.54743588659734, 0.341938252770122, 0.0, 0.0, 0.0, 0.0, 1.02695629777827e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4432899320127e-14, 0.0, 0.0, -1.62092561595273e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930762, 1.29756443747035, 0.749149177264378, 2.75458800949268, 0.0, 0.0, 5.75737105184055, 0.0, 3.32401972660469, 2.06838446274243, 0.0, -1.28785870856518e-14, 0.0, 0.0, -1.59872115546023e-14, 10.8804085776374, 0.0, 0.0, 6.28180682119206, -1.77676328054753, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {0.938083151964694, 0.0, 0.0, 3.11415464992884, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 5.52707620976691, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.80288457473997, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.42539535431072, 0.0, 9.38083151964689, 1.89521416591739, 0.0, 0.0, 0.0, -3.39852909359327, -2.77488738510234, -0.560611910581399, 0.0, 1.4210854715202e-14, 0.0, 1.77635683940025e-14, 0.0, 0.0, 17.7988763690296, 0.428174419288845, 0.349602949390066, 0.0706304617818807, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.82970843102536, 1.77635683940025e-14, -1.49829835452876, 4.2378277069118, -1.29340982368831e-14, 1.24344978758018e-14, -3.10862446895044e-14, 3.79967103839267, -3.54562104171167, -4.07409060843205, 1.4210854715202e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, 1.77635683940025e-14, 0.0, 16.7549743857359, 1.11676565710086, 0.987090711415302, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, -2.66453525910038e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37112543541207e-14, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0},
      {-1.32664991614215, 1.95399252334028e-14, 1.73008591662713, -3.18072425757421, 0.0, 0.0, 0.0, 0.0, 7.67649473578738, -2.38836465270395, 0.0, 0.0, 2.8421709430404e-14, 0.0, 0.0, 2.48689957516035e-14, 0.0, 0.0, 14.5072114368499, 2.05162951662075, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0},
      {1.6248076809272, 0.0, 0.0, 5.39387407630363, 0.0, 0.0, 3.73034936274053e-14, 0.0, -1.24344978758018e-14, 9.5731768126215, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 10.0508909139073, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361256, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910462, 0.869835476750492, 0.615066564126904, 10.333118277332, -2.18326971917504, -1.8907670401189, 0.724780051083752, 0.62767793639472, 0.512496888990055, -0.278967971730977, -0.241593350361244, -0.197260144544827, -0.139483985865489, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516521, -0.0814411017927967, -0.0728431359084678, -0.0630840061880518, -0.0515078753637661, 0.0313466946954453, 0.0280373360835799, 0.0242810453028185, 0.0198253904711074, 0.0140186680417875, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725406, 3.45525332069938, 0.997445717412056, -1.4106012612951, 3.2320935276425, 5.28531208250978, -1.3627702877385, -2.89087233497828, -0.393397896234713, 0.556348640264176, 2.33666428910958, 9.02784807228866, -0.732969916135154, -3.93352933905728, -1.19859611757306, 0.309047252182632, 1.64018416088946, 0.655588223176217, 0.0892142571199757, -0.126168012376112, 13.0996183150503, 11.55277744383, -0.234843597212092, -2.44096975264613, -0.907332870306506, 0.0736662483163188, 0.810328731479524, 0.395334573318416, 0.120463442338386, -0.031060417514547, -0.311895674167857, -0.164844710568314, -0.0658890955530745, -0.00896637020658053, 0.0126803623514053, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482413, 3.15420030940281, -1.09264703862701, 1.54523626091313, 2.95048422176041, -0.761811750275046, 5.59815020469136, 0.263899331455872, -1.93925611658551, -2.28543525082517, 2.13307290077016, -0.257539376818862, 9.14446135479763, 0.0664963811608028, -2.36108976914459, -3.33842298506508, -0.0230350221379902, 0.817905488277889, 1.15646364545771, 1.02505848514082, 0.0, 0.0, 11.5766222110848, 0.0, -1.3977187881547, -2.15192884958004, 0.0, 0.360889439280293, 0.555625639776453, 0.595437196138646, 0.0, -0.125015768949699, -0.192474367616155, -0.206265495285708, -0.166687691932939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.92724822331884, 1.82834820066015, 2.99085908983325, -1.24403337882029, 0.950146187582618, 5.74064456311311, -0.721110255092816, -0.169967317119732, -1.17961073303081, 0.490653381462656, -10.3037210107158, 4.97613351528118, -0.215472901842828, 5.78174466995661, -1.3018558182182, 0.163532434528636, -3.22682211353225, 0.0385449644663654, 0.267510569439617, -0.111269728052835, 0.0, 14.555131461167, 1.03556292536503, 10.7636648722209, -0.500120235663636, 0.0216558414515651, -3.5732138395088, -0.581087203147984, 0.130841432732455, -0.0164356280722688, 1.37533064807501, 0.324307824721448, -0.00387391468765075, -0.0268858238268341, 0.0111830284386727, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637251, 1.66904592079258, 0.963624111659453, 1.3627702877385, 0.867360833110876, 2.28430636201793, 2.96226264871975, -1.00852844760553, 1.7102631376487, -2.01556443707463, 2.41867732448957, 2.04415543160773, 2.68821895760391, -0.527798662911733, 7.07977053255616, -1.7665273979248, 0.182834820066026, -3.12574097035513, -1.01990506872272, 0.904016610326403, 0.0, 0.0, 13.1266557397187, 0.0, 11.0940489487798, -0.6326076194549, 0.0, -2.8644711213756, -1.66605356688627, 0.31507574846809, 0.0, 0.992281903807282, 0.735567892896452, 0.181909068193165, -0.147004726489971, 0.0, 0.0, -1.13242748511766e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, -2.04281036531029e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493889, 1.49284005458435, -0.430945803685674, 3.04724700110021, 0.775791113542706, -0.120185042515456, 5.29905651979673, 0.0346944333244417, -1.52970585407783, 0.901387818866002, 0.0, 0.0, 4.51561078268941, 0.0, -0.699555414372428, 6.36462844462229, 0.0, 0.201944253400487, -1.83730997289732, -2.74825341360597, 0.0, 0.0, 0.0, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875268, -3.09993548319961, 0.0, 0.0, 0.487107866980271, 0.894874292847878, 0.903959543974647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585588, 0.772618130456575, 3.86595114186568, -1.05140010313426, 9.1544290607646, 3.35889012281482, -0.304724700110037, 3.87851223317103, -1.52475169285614, 0.414677792940099, 0.0, -9.46260092820843, -2.07602937339135, 7.3296991613516, -0.761724681099355, 0.0691050664139841, 0.564240504518073, -0.879563899362193, 0.34578118203621, -0.0940400840863395, 0.0, 0.0, 0.0, 16.3745228938128, 0.951027176355638, 0.208648802584717, 9.059750638547, -0.736662483163211, 0.0765562109321121, -0.00694532049720742, -3.48709964663733, -0.0567083043941636, 0.0883994979795868, -0.0347523163751426, 0.00945138406569146, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.72639680329212e-14, 0.0, 0.0, 0.0},
      {1.48690428533299, 0.705300630647569, 2.03602754481992, 1.15175110689979, -2.93221479395416, 1.81702705031799, 1.25178444059441, 0.655663160391217, 3.61359041872288, -1.70346285967311, 0.0, 2.7642026565595, -9.08783875864328, 1.78428514239955, 5.63152770643898, -0.746494073225321, -0.618094504365244, 2.03210252328837, -2.1549427706255, 0.76403348456261, 0.0, 0.0, 0.0, 0.0, 15.0018922739643, 2.13860408462395, 0.0, 9.68367982311023, -1.32524448062075, 0.133143804689791, 0.0, -3.35452509157129, -0.478206411017788, 0.384353057392897, -0.124241670058193, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.06581410364015e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880569, 0.728431359084661, 2.57539376818856, 0.917928424547665, 0.711024300256719, 2.23926008187655, -0.205255035576781, 2.585674822114, 0.761811750275065, 0.0, 0.0, 5.34294273196308, 0.0, 4.13862564412656, 2.68954640486934, 0.0, -1.19471831485579, 3.10562068169858, -2.32269806558126, 0.0, 0.0, 0.0, 0.0, 0.0, 12.8876627769294, 0.0, 0.0, 9.98274066131697, -1.30996183150502, 0.0, 0.0, -2.88176900403078, -1.51261363209513, 0.763985254692617, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0, -1.59872115546023e-14, -1.02140518265514e-14, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {1.15175110689979, 0.546323519313511, -0.105140010313424, 3.2711894277325, 0.0, 0.0, 2.69341127303544, 0.0, -0.518347241175136, 4.25171145123352, 0.0, 0.0, -1.46549439250521e-14, 0.0, 0.0, 6.71889089790565, 0.0, 0.0, -1.29305115618718, 1.82865048192214, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.45383520059452, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376108, -6.78263087840208, 3.68560354207935, -0.814411017927958, -1.95399252334028e-14, 10.0216907612581, 2.67510569439611, 6.00856531485323, -1.4536216402544, 0.321208037219802, -2.22044604925031e-14, 2.1316282072803e-14, 0.0, -7.57008074256671, -2.2727058403442, -0.606656948415846, 6.99294104721299, -1.36261453366203, 0.329650402328139, -0.0728431359084718, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 18.7137404500718, 0.760821741084519, 0.228415531250639, 0.0609713174047686, 5.40219154319687, -0.702817019232754, 0.136947913395212, -0.0331311120155253, 0.0073210106170063, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0},
      {1.15175110689981, 3.8242646351946, 2.20794021658199, 0.892142571199756, 1.4210854715202e-14, -2.46306042692148, 6.78739640804924, 2.13307290077017, 3.91870514328395, -1.31949665727937, 0.0, 0.0, 0.0, 3.22490309931941, -7.63378455726038, -4.04762275910192, 1.11713920350153, 6.6110513536048, -2.33689608954553, 0.591817792331162, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.5022076529583, 1.79642743108413, 0.721929233499935, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297046, -0.0962371838080749, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.29677388219329e-14, -1.11022302462516e-14, 0.0, 0.0},
      {1.03015750727539, -1.46593983227032, 1.12848100903608, 1.99489143482414, 0.0, 1.10151410945721, -5.20357020296094, 0.476969600708474, 4.00571020990211, 0.590096844352095, 0.0, 1.4210854715202e-14, 0.0, 1.97619698383278e-14, 6.41153127835566, -6.24994106094657, 0.0, 2.77627448210729, 4.8112068719424, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.4651953323153, 3.0440762145518, 0.0, 0.0, 6.69662601613678, -2.34333096254029, 0.59178043363451, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 1.06581410364015e-14, 0.0, 0.0},
      {0.892142571199763, 0.705300630647548, 0.407205508963994, 2.53385243517953, 0.0, 0.0, 3.47717900165118, 0.0, 2.0075502326238, 3.29336152870136, 0.0, 1.33226762955019e-14, -1.10467190950203e-14, 0.0, 0.0, 8.67405085085772, 1.06581410364015e-14, 0.0, 5.00796559370721, 1.41646657250371, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 12.2048487632307, 0.0, 0.0, 0.0, 7.04647271886989, -2.27776395106693, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084677, 0.0, 0.0, 2.53908227033121, 0.0, 0.0, 0.0, 0.0, 0.0, 5.00713776237768, 0.0, 0.0, 1.95399252334028e-14, 0.0, -1.15463194561016e-14, 0.0, 0.0, 1.0991207943789e-14, 0.0, 6.93924068068617, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.2767793639472, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.09901951359276, 0.0, -4.65474668125631, -3.29140294302193, -1.24344978758018e-14, -1.50990331349021e-14, 2.1316282072803e-14, 13.490737563232, 1.83585684909536, 1.2981468272831, 0.0, 0.0, -1.4210854715202e-14, 1.4210854715202e-14, 1.24344978758018e-14, 0.0, -3.53270434653113, -3.0594117081557, -0.416333199893252, -0.294392028877599, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 21.8326971917504, 0.35505014583943, 0.307482445914328, 0.0418430609640565, 0.0295875121532907, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.89848137210902e-14, 0.0},
      {-2.6598552464322, 0.0, 5.09901951359279, -2.06031501455086, 1.33226762955019e-14, 1.19904086659517e-14, -1.4210854715202e-14, -1.23153021346073, 9.049861877399, 3.04724700110021, 0.0, 0.0, 0.0, 0.0, -3.5527136788005e-14, 0.0, 3.86988371918332, -3.8168922786302, -5.39683034546924, -1.36674464685442, 0.0, 0.0, 0.0, 0.0, -1.46549439250521e-14, 0.0, -1.06581410364015e-14, 0.0, -1.95399252334028e-14, 0.0, 0.0, 21.00264918355, 0.898213715542057, 0.962572311333265, 0.222250255910581, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, 3.19744231092045e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0},
      {2.97380857066587, 0.0, -0.814411017927956, 5.75875553449897, -1.73194791841524e-14, 0.0, 2.1316282072803e-14, 1.3768926368215, -2.89087233497831, 1.70346285967311, 0.0, 2.48689957516035e-14, -1.4210854715202e-14, 0.0, 0.0, 1.59872115546023e-14, -1.24344978758018e-14, 8.01441409794464, -3.47218947830362, -5.19371076584692, 0.0, 0.0, 0.0, 0.0, 0.0, -1.3235940121703e-14, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 19.3314941653941, 1.69115345252877, 1.70832296330019, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.95399252334028e-14, 1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-1.03015750727544, -2.48689957516035e-14, 0.940400840863432, -2.92584077107541, -1.35447209004269e-14, 0.0, -2.48689957516035e-14, 0.0, 4.63623866886822, -3.80284633026897, 0.0, 2.8421709430404e-14, 1.4210854715202e-14, 0.0, 0.0, -1.06581410364015e-14, 1.50990331349021e-14, -1.4210854715202e-14, 11.565401134477, -1.63559471386626, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 16.2731316843076, 2.63013526059784, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376111, 0.0, 0.0, 4.39781949681098, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 8.67261700493488, 0.0, 0.0, 3.37507799486048e-14, 0.0, -2.1316282072803e-14, 0.0, 0.0, 1.73194791841524e-14, 1.4210854715202e-14, 12.0191174248973, 0.0, 0.0, 0.0, 0.0, -1.11022302462516e-14, 0.0, 0.0, 1.26565424807268e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 10.8717007662564, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.35447209004269e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.59872115546023e-14, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[56][56] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {3.16227766016839, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.82574185835056, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.16397779494324, -1.77635683940025e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.26565424807268e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.11126385871074e-14, 0.0, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.9580398915498, 5.61248608016089, -1.08012344973465, -0.763762615825974, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -2.48689957516035e-14, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.29128784747792, 1.44913767461892, 4.18330013267039, -0.591607978309968, 0.0, -1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.87082869338695, 7.09929573971952, 0.0, 4.34741302385683, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.37667655053519e-14, -3.5527136788005e-14, 0.0, 1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.31006316905768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.3228756555323, -1.24344978758018e-14, 3.86436713231718, -0.34156502553199, 0.0, -1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.31006316905768e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.08012344973464, -1.06581410364015e-14, 7.09929573971954, 2.50998007960222, 0.0, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -2.44249065417534e-14, 0.0, -1.55431223447522e-14, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-3.81881307912988, 0.0, -1.06581410364015e-14, 8.87411967464942, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, -1.24344978758018e-14, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.74954541697347, 5.79655069847577, -1.67332005306814, -1.18321595661992, 7.74596669241483, -1.2, -0.979795897113257, 0.346410161513768, 0.282842712474613, 0.2, 0.0, -1.59872115546023e-14, -1.59872115546023e-14, 0.0, -1.68753899743024e-14, -1.47659662275146e-14, 0.0, 1.33226762955019e-14, 1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.32379000772447, 2.44948974278317, 2.8284271247462, -1.0, 1.30930734141596, 7.09929573971952, -0.414039335605402, -2.04939015319193, -0.47809144373376, 0.169030850945706, 0.0, 0.0, 0.0, 0.0, 0.0, -1.55431223447522e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.01246117974978, 2.12132034355965, -0.408248290463864, 3.17542648054295, 9.07114735222145, 0.0, 7.17137165600638, 0.0, -1.38013111868472, -1.56144011671766, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, -4.2632564145606e-14, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.80000000000001, 0.632455532033669, 4.38178046004134, -0.774596669241499, 0.0, 3.14233761939828, -0.106904496764967, 4.76235235991627, -0.740656079818042, 0.130930734141598, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, -1.28785870856518e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.55884572681202, 0.547722557505163, 1.5811388300842, 2.45967477524978, 1.06581410364015e-14, 9.07114735222144, 1.85164019954511, 0.0, 5.34522483824848, -1.20948631362953, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.95399252334028e-14, 0.0, 2.30926389122033e-14, -2.30926389122033e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.27279220613581, -6.26099033699939, -2.30926389122033e-14, 3.83405790253615, 0.0, 0.0, 10.5830052442584, 1.15463194561016e-14, 0.0, 5.18459255872627, 0.0, 0.0, 0.0, 1.06581410364015e-14, 2.1316282072803e-14, 0.0, -1.64313007644523e-14, 0.0, -2.39808173319034e-14, -1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, -1.28785870856518e-14},
      {1.03923048454133, 0.0, 3.16227766016838, -0.447213595499965, 0.0, 0.0, 0.0, 5.8918830363718, -0.534522483824839, 0.0755928946018476, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.900000000000004, 1.06581410364015e-14, 1.46059348668045, 1.42009389360938, 0.0, 0.0, 0.0, 9.07114735222147, 4.93770719878695, -0.698297248755177, 0.0, -1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.73484692283497, 0.0, -6.26099033699942, 2.21359436211787, 0.0, 0.0, 1.06581410364015e-14, 0.0, 10.5830052442584, 2.99332590941915, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, -2.22044604925031e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {5.71576766497732, 1.24344978758018e-14, 0.0, -4.69574275274958, 1.06581410364015e-14, 0.0, 3.37507799486048e-14, 0.0, -1.06581410364015e-14, 12.69960629311, 0.0, -1.06581410364015e-14, -2.08721928629529e-14, 0.0, 0.0, 1.77635683940025e-14, -1.06581410364015e-14, 0.0, 0.0, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.56904651573304, 5.80288457473997, -2.01017818278146, -1.42141062443802, 8.14215222512714, -2.1022946646802, -1.71651640581397, 0.728256234341417, 0.594618725379069, 0.420458932936041, 9.81070843517429, -1.18450885369838, -1.02581475831037, 0.305838870920597, 0.264864231681972, 0.21626073957838, -0.105945692672785, -0.0917516612761684, -0.0749149177264175, -0.0529728463363923, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.26568606239554, 3.07059789431496, 1.77281052085586, -1.25356634105601, 2.39356776939084, 6.30376871403131, -0.908295106229229, -2.78313372537745, -0.524404424085083, 0.370809924354783, 1.23603308118261, 9.40174755792011, -0.301561193523235, -2.42752078113805, -0.794200206656987, 0.114434427054266, 0.840917865872093, 0.35064189060884, 0.0660687472643469, -0.0467176592151097, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.02649122047612, 2.74642624930239, -0.792824967172102, 2.24244764232555, 2.14087209644418, -0.331662479035527, 6.4992307237088, 0.0957427107756388, -1.87616630392937, -2.15580611373101, 11.0554159678513, -2.1316282072803e-14, 9.44035859331466, 0.0, -1.46249406456535, -2.04706526287664, 0.0, 0.422185670932521, 0.590936840285281, 0.522319308773337, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.22124532708767e-14, 0.0, 0.0, 0.0, 0.0, 1.11022302462516e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.91485421551271, 1.29756443747036, 3.745745886322, -1.05945692672795, 0.404586796856341, 5.01426536422407, -0.383824736789361, 1.80936716113937, -1.10800657553489, 0.313391585264005, 0.0, 2.82521847127455, -0.0509731451534392, 8.20651806648288, -0.631738055305805, 0.0483573714561651, -2.84282124887605, -0.227958835180072, 0.139595707137609, -0.039483628456618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.71269767715535, 1.16057691494799, 1.34011878852097, 1.89521416591738, 0.361873432227869, 1.96214168703486, 2.74642624930239, -0.566421515598877, 3.17129986868835, -1.82198870938951, 0.0, 11.0554159678513, 1.59571184626056, 0.0, 8.65223156827825, -0.865042958313596, 0.0, -2.49768411251821, -0.998865569685879, 0.441440386136655, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.48323969741914, 1.00508909139073, -0.193429485824682, 3.55615782880925, -8.46157280212812, 0.0, 4.45964044034305, 0.0, -0.858258202907006, 2.67027285925185, -1.4210854715202e-14, 1.01030295240889e-14, 12.4373429638327, 0.0, 0.0, 8.42792824422443, 0.0, 0.0, -1.62195554683796, -2.2937915319045, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {1.48323969741915, 0.335029697130249, 4.06201920231799, -0.820651806648296, 1.11299858218672e-14, 1.69926454679665, -0.0991031208965194, 5.88642506110459, -1.20156148406978, 0.242752078113808, 0.0, -1.15463194561016e-14, 0.0, 4.94413232473044, -0.214087209644431, 0.0124858196210829, 5.13809303146607, -0.741619848709565, 0.151382517704894, -0.0305838870920692, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.50990331349021e-14, 0.0, 0.0, 0.0},
      {1.32664991614218, 0.299659670905765, 2.07610309995257, 1.46802658041886, 0.0, 0.868496237346897, 0.709124208342343, 1.31624465810883, 4.91295663090393, -1.4113063856887, 0.0, -1.86517468137026e-14, 0.0, 11.0554159678513, 3.82970843102534, -0.223353131420161, 0.0, 5.80409338312194, -1.54743588659733, 0.341938252770112, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.14891252930758, 0.259512887494063, 0.749149177264362, 2.75458800949268, 0.0, -8.46157280212811, 1.15147421036811, 1.50990331349021e-14, 3.32401972660468, 2.06838446274243, 0.0, 0.0, 0.0, 0.0, 12.4373429638327, 2.17608171552746, -1.59872115546023e-14, 0.0, 6.28180682119206, -1.77676328054752, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0},
      {0.938083151964673, 7.62808987244124, 2.30926389122033e-14, 3.11415464992885, 0.0, 0.0, -7.52139804633608, -1.69864122767649e-14, -1.13242748511766e-14, 5.52707620976691, 0.0, 0.0, 1.06581410364015e-14, -1.33226762955019e-14, -3.19744231092045e-14, 14.2141062443803, 1.34336985979644e-14, 1.64313007644523e-14, 1.95399252334028e-14, 5.80288457473998, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.856348838577679, 0.0, 2.68023757704196, -0.473803541479345, 0.0, 0.0, -1.06581410364015e-14, 5.09779364038994, -0.792824967172086, 0.140152977645355, -1.06581410364015e-14, -1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 7.91061171956872, -0.642261628933269, 0.0998865569685985, -0.01765761544547, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.765941686205081, 2.39808173319034e-14, 1.4982983545288, 0.847565541382366, 0.0, 1.4210854715202e-14, 0.0, 1.62843044502544, 3.54562104171167, -0.814818121686409, 1.06581410364015e-14, -2.1316282072803e-14, 1.77635683940025e-14, 1.4210854715202e-14, -1.06581410364015e-14, 1.37667655053519e-14, 11.0554159678513, 7.18070330817254, -1.11676565710081, 0.19741814228306, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.663324958071088, 1.06581410364015e-14, 0.692034366650873, 1.59036212878711, 0.0, 0.0, 0.0, -8.46157280212813, 3.07059789431493, 1.19418232635199, 0.0, 0.0, 0.0, 2.48689957516035e-14, 0.0, 1.4210854715202e-14, 1.59872115546023e-14, 12.4373429638327, 5.80288457473997, -1.02581475831035, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.541602560309067, 0.0, 7.62808987244127, 1.79795802543454, 0.0, 0.0, 0.0, 0.0, -7.52139804633612, 3.19105893754051, 0.0, 1.4210854715202e-14, 1.06581410364015e-14, 0.0, 0.0, 0.0, 1.12687636999453e-14, -1.15463194561016e-14, 14.2141062443803, 3.35029697130245, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {-5.36159180343551, 0.0, 0.0, 8.89943818451481, -1.59872115546023e-14, 0.0, 0.0, -1.4210854715202e-14, 0.0, -5.26497863243526, 0.0, 0.0, 3.5527136788005e-14, -1.15463194561016e-14, 0.0, 1.4210854715202e-14, 0.0, 0.0, 1.06581410364015e-14, 16.583123951777, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.77635683940025e-14, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.15463194561016e-14, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.41593350361256, 5.72988941019467, -2.20543546226844, -1.55947837083931, 8.33749895885383, -2.76779953857106, -2.25989885993662, 1.06532653910462, 0.869835476750492, 0.615066564126904, 10.333118277332, -2.18326971917504, -1.8907670401189, 0.724780051083752, 0.62767793639472, 0.512496888990055, -0.278967971730977, -0.241593350361244, -0.197260144544827, -0.139483985865489, 11.8490505948789, -1.16109782023228, -1.03851746182648, 0.245326690731331, 0.219426862868129, 0.190029237516521, -0.0814411017927967, -0.0728431359084678, -0.0630840061880518, -0.0515078753637661, 0.0313466946954453, 0.0280373360835799, 0.0242810453028185, 0.0198253904711074, 0.0140186680417875, -1.15463194561016e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.18529407725405, 3.45525332069938, 0.997445717412067, -1.4106012612951, 3.23209352764251, 5.28531208250978, -1.36277028773849, -2.89087233497829, -0.393397896234716, 0.556348640264182, 2.33666428910958, 9.02784807228864, -0.732969916135163, -3.93352933905728, -1.19859611757308, 0.309047252182626, 1.64018416088946, 0.655588223176222, 0.0892142571199899, -0.126168012376108, 1.1908743922773, 11.55277744383, -0.23484359721209, -2.44096975264613, -0.907332870306508, 0.07366624831632, 0.810328731479528, 0.395334573318417, 0.120463442338385, -0.0310604175145487, -0.311895674167864, -0.164844710568316, -0.0658890955530707, -0.00896637020658575, 0.0126803623514082, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.99489143482414, 3.15420030940282, -1.09264703862702, 1.54523626091313, 2.95048422176041, -0.761811750275044, 5.59815020469135, 0.263899331455878, -1.9392561165855, -2.28543525082518, 2.13307290077016, -0.257539376818849, 9.14446135479764, 0.0664963811608006, -2.36108976914457, -3.33842298506506, -0.0230350221379944, 0.817905488277884, 1.1564636454577, 1.02505848514081, 13.0453753561106, 0.0, 11.5766222110848, 0.0, -1.3977187881547, -2.15192884958005, 0.0, 0.360889439280287, 0.555625639776455, 0.595437196138646, 0.0, -0.125015768949698, -0.19247436761616, -0.206265495285703, -0.166687691932943, 0.0, 0.0, -1.04360964314765e-14, 0.0, 1.33226762955019e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.9272482233189, 1.82834820066017, 2.99085908983327, -1.24403337882028, 0.950146187582611, 5.74064456311312, -0.721110255092799, -0.169967317119746, -1.17961073303081, 0.490653381462665, 0.294392028877595, 4.97613351528118, -0.21547290184283, 5.7817446699566, -1.30185581821821, 0.163532434528642, -3.22682211353224, 0.0385449644663702, 0.26751056943961, -0.111269728052828, 0.0, 2.646387538394, -0.0295875121532858, 10.7636648722209, -0.500120235663634, 0.0216558414515688, -3.57321383950879, -0.581087203147985, 0.130841432732453, -0.0164356280722675, 1.37533064807501, 0.324307824721458, -0.00387391468765175, -0.0268858238268316, 0.0111830284386746, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.68753899743024e-14, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.75932887637247, 1.66904592079257, 0.963624111659414, 1.3627702877385, 0.867360833110881, 2.28430636201793, 2.96226264871974, -1.00852844760551, 1.7102631376487, -2.01556443707464, 0.268741924943299, 2.0441554316077, 2.68821895760392, -0.527798662911731, 7.07977053255618, -1.76652739792482, 0.182834820066021, -3.12574097035513, -1.01990506872273, 0.904016610326401, 0.0, 13.0453753561106, 1.45851730441319, 0.0, 11.0940489487798, -0.632607619454905, 0.0, -2.8644711213756, -1.66605356688627, 0.315075748468092, 0.0, 0.992281903807267, 0.735567892896448, 0.181909068193167, -0.147004726489969, 0.0, -1.86517468137026e-14, 0.0, 0.0, 0.0, 0.0, -2.1316282072803e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.57359158493886, 1.49284005458436, -0.430945803685658, 3.04724700110021, 0.775791113542713, -0.120185042515461, 5.29905651979671, 0.0346944333244359, -1.52970585407782, 0.901387818866001, -10.576283741361, 1.15463194561016e-14, 4.5156107826894, -1.04360964314765e-14, -0.699555414372448, 6.36462844462232, 0.0, 0.201944253400475, -1.83730997289731, -2.74825341360597, 0.0, 0.0, 14.3499128917217, 0.0, 0.0, 10.8920630294282, 0.0, 0.0, -1.68739114875267, -3.09993548319961, 0.0, 0.0, 0.487107866980279, 0.894874292847877, 0.903959543974644, 0.0, 0.0, -1.33781874467331e-14, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.02140518265514e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.62882203585591, 0.772618130456568, 3.86595114186567, -1.05140010313427, 0.160604018609916, 3.35889012281482, -0.304724700110037, 3.87851223317102, -1.52475169285614, 0.414677792940095, 0.0, 1.135512111385, -0.0364215679542248, 7.32969916135159, -0.761724681099363, 0.0691050664139874, 0.564240504518043, -0.879563899362187, 0.345781182036198, -0.0940400840863448, 0.0, 0.0, 0.0, 4.46577897103986, -0.114123261162678, 0.00366050530850304, 9.059750638547, -0.736662483163212, 0.0765562109321147, -0.00694532049720864, -3.48709964663733, -0.0567083043941574, 0.0883994979795864, -0.0347523163751431, 0.00945138406568952, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {1.48690428533298, 0.705300630647584, 2.03602754481991, 1.15175110689981, 0.146610739697702, 1.817027050318, 1.25178444059442, 0.655663160391223, 3.61359041872286, -1.7034628596731, 0.0, 0.614267257013214, 0.454391937932161, 1.78428514239955, 5.63152770643897, -0.746494073225309, -0.618094504365235, 2.03210252328836, -2.15494277062553, 0.764033484562619, 0.0, 0.0, 0.0, 13.0453753561106, 3.33375383865874, -0.106930204231198, 0.0, 9.68367982311022, -1.32524448062075, 0.133143804689793, 0.0, -3.35452509157129, -0.478206411017785, 0.384353057392899, -0.124241670058189, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.32992762321607, 0.630840061880569, 0.728431359084681, 2.57539376818856, 0.131132632078232, 0.711024300256724, 2.23926008187656, -0.205255035576788, 2.58567482211399, 0.761811750275053, 0.0, -10.576283741361, 0.763277533137579, 1.24344978758018e-14, 4.13862564412656, 2.68954640486933, 1.08801856413265e-14, -1.19471831485578, 3.1056206816986, -2.32269806558127, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 1.84109468241848, 0.0, 0.0, 9.98274066131697, -1.30996183150503, 0.0, 1.24344978758018e-14, -2.88176900403078, -1.51261363209514, 0.76398525469261, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.77635683940025e-14, 0.0, 0.0, 0.0, -1.21014309684142e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.15463194561016e-14, 0.0, -1.4210854715202e-14},
      {1.15175110689979, 0.546323519313527, -0.105140010313412, 3.27118942773249, 9.65295620481433, -1.02140518265514e-14, 2.69341127303542, 0.0, -0.518347241175119, 4.25171145123353, 0.0, 0.0, -9.91526600752598, 0.0, 0.0, 6.71889089790567, 0.0, 0.0, -1.29305115618717, 1.82865048192213, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 0.0, 0.0, 0.0, 9.45383520059453, 0.0, 0.0, 0.0, -1.81939143264587, -2.94058061635794, 0.0, 0.0, -1.4210854715202e-14, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {1.26168012376109, 0.199489143482415, 3.68560354207935, -0.814411017927958, 0.0, 1.02786571910339, -0.078679579246943, 6.00856531485323, -1.4536216402544, 0.321208037219809, 0.0, 0.0, 0.0, 3.02803229702669, -0.2330980349071, 0.0178428514239943, 6.99294104721298, -1.36261453366202, 0.329650402328149, -0.0728431359084669, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.80499652729883, -0.304328696433803, 0.0234272339744236, -0.00179327404131602, 5.40219154319688, -0.702817019232749, 0.136947913395217, -0.0331311120155255, 0.00732101061700685, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.19904086659517e-14, 0.0, 0.0, 0.0},
      {1.15175110689975, 0.182107839771152, 2.20794021658199, 0.892142571199752, -1.4210854715202e-14, 0.615765106730371, 0.32320935276422, 2.13307290077017, 3.91870514328394, -1.31949665727937, 0.0, 0.0, 1.02140518265514e-14, 1.07496769977314, 1.90844613931508, -0.192743940909618, 1.11713920350153, 6.61105135360478, -2.33689608954553, 0.591817792331155, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 13.0453753561106, 5.83406921765278, -0.449106857771028, 0.0343775825476166, 0.0, 6.06294257990892, -1.55575179137406, 0.416806037297044, -0.0962371838080771, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 0.0, -1.33226762955019e-14, 1.65423230669148e-14, 0.0, 0.0, 0.0},
      {1.03015750727541, 0.162882203585591, 1.12848100903608, 1.99489143482414, 0.0, 0.314718316987764, 0.578174466995661, 0.476969600708475, 4.00571020990213, 0.590096844352082, 0.0, 0.0, 0.0, -10.576283741361, 1.83186607953016, 0.694437895660752, 0.0, 2.77627448210727, 4.8112068719424, -1.79915418525286, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 4.41862723780438, -0.338230690505755, -1.4210854715202e-14, 0.0, 6.69662601613678, -2.34333096254029, 0.591780433634515, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.892142571199777, 0.141060126129509, 0.407205508964008, 2.53385243517952, 0.0, 9.65295620481432, 0.695435800330246, 0.0, 2.0075502326238, 3.29336152870135, 0.0, 1.59872115546023e-14, -1.26565424807268e-14, 0.0, -9.91526600752598, 1.73481017017154, 2.62012633811537e-14, 0.0, 5.00796559370722, 1.41646657250369, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 15.9443476574685, 2.44096975264614, 0.0, 0.0, 0.0, 7.0464727188699, -2.27776395106694, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14},
      {0.728431359084674, -7.94708263760856, 0.0, 2.5390822703312, 0.0, 0.0, 10.2207771580387, 0.0, 0.0, 5.00713776237769, 0.0, 1.86517468137026e-14, 0.0, 0.0, 0.0, -8.49879943502222, -1.4210854715202e-14, 0.0, 0.0, 6.93924068068618, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 17.9373911146521, 0.0, 0.0, 0.0, 1.15463194561016e-14, 6.27677936394721, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.728431359084662, 0.0, 2.32737334062816, -0.470200420431693, 0.0, 0.0, 1.59872115546023e-14, 4.49691252107736, -0.917928424547695, 0.185449546754731, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.0654086930623, -1.01980390271857, 0.20816659994661, -0.042056004125357, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.92395326897747, -0.710100291678881, 0.10249414863811, -0.0209215304820316, 0.00422678745047178, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.664963811608005, 0.0, 1.45686271816938, 0.51507875363772, 0.0, 0.0, 1.4210854715202e-14, 1.84729532019112, 2.58567482211398, -0.761811750275054, 1.4210854715202e-14, 1.77635683940025e-14, 0.0, 0.0, 0.0, 0.0, 1.71994831963705, 5.72533841794521, -1.54195152727693, 0.341686161713623, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 13.0453753561106, 9.33451074824442, -1.3473205733131, 0.275020660380936, -0.055562563977638, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, 0.0, 0.0, 2.22044604925031e-14, -1.59872115546023e-14, 0.0, 0.0, 0.0, 1.06581410364015e-14},
      {0.594761714133161, 0.0, 0.814411017927945, 1.15175110689979, -1.33226762955019e-14, 0.0, -1.24344978758018e-14, 0.590096844352066, 2.89087233497828, 0.340692571934627, 0.0, 1.06581410364015e-14, 1.4210854715202e-14, 0.0, 0.0, 1.59872115546023e-14, -10.576283741361, 3.43474889911911, 3.47218947830366, -1.03874215316938, 0.0, 0.0, 0.0, 0.0, -1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 14.3499128917217, 8.28492607088318, -1.69115345252877, 0.341664592660038, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.95399252334028e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.515078753637698, 0.0, 0.376160336345346, 1.46292038553769, 0.0, 0.0, 2.53130849614536e-14, 9.65295620481433, 1.85449546754729, 1.90142316513449, 0.0, 0.0, 0.0, 0.0, 0.0, 1.06581410364015e-14, 0.0, -9.91526600752596, 4.6261604537908, 0.817797356933113, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 15.9443476574685, 6.50925267372302, -1.31506763029893, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.24344978758018e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.37667655053519e-14, 0.0, 0.0, 0.0},
      {0.420560041253698, -1.90958360235527e-14, -7.94708263760857, 1.46593983227031, 0.0, 0.0, 0.0, 0.0, 10.2207771580387, 2.89087233497828, 0.0, 1.95399252334028e-14, -2.1316282072803e-14, -1.06581410364015e-14, 0.0, -1.59872115546023e-14, -1.68753899743024e-14, 0.0, -8.49879943502225, 4.00637247496573, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.4210854715202e-14, 17.9373911146521, 3.6239002554188, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.13242748511766e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.04360964314765e-14, 0.0, 0.0, 0.0, -1.24344978758018e-14},
      {6.54237885546497, 0.0, 1.73194791841524e-14, -6.9105066413987, 0.0, 0.0, -3.46389583683049e-14, 1.33226762955019e-14, 0.0, 12.2649325896465, 0.0, 0.0, 1.77635683940025e-14, 0.0, -3.5527136788005e-14, -1.95399252334028e-14, 0.0, 2.64233079860787e-14, 1.4210854715202e-14, -5.6658662900148, 0.0, 0.0, 0.0, 0.0, -1.68753899743024e-14, 0.0, 0.0, 0.0, -1.4210854715202e-14, -1.06581410364015e-14, 0.0, 0.0, 1.24344978758018e-14, 1.4210854715202e-14, 20.4998755596024, 0.0, 0.0, 0.0, 0.0, -1.06581410364015e-14, 0.0, 0.0, 1.59872115546023e-14, 0.0, 0.0, 0.0, -2.30926389122033e-14, 0.0, -1.14352971536391e-14, 0.0, 0.0, 0.0, 0.0, 0.0, 1.64313007644523e-14, 1.86517468137026e-14}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0