// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=io, header=GenericFile.h)
%feature("docstring")  dolfin::GenericFile::GenericFile "
Constructor
";

// Documentation extracted from: (module=io, header=File.h)
%feature("docstring")  dolfin::File "
A File represents a data file for reading and writing objects.
Unless specified explicitly, the format is determined by the
file name suffix.
A list of objects that can be read/written to file can be found in
GenericFile.h. Compatible file formats include:
    * XDMF   (.xdmf)
    * XML    (.xml)
    * VTK    (.pvd)
    * RAW    (.raw)
    * XYZ    (.xyz)
    * Binary (.bin)
    * SVG    (.svg)
";

%feature("docstring")  dolfin::File::File "
**Overloaded versions**

* File\ (filename, encoding=\"ascii\")

  Create a file with given name
  
  *Arguments*
      filename (str)
          Name of file.
      encoding (str)
          Optional argument specifying encoding, ascii is default.
  
  *Example*
      .. note::
      
          No example code available for this function.

* File\ (filename, type, encoding=\"ascii\")

  Create a file with given name and type (format)
  
  *Arguments*
      filename (str)
          Name of file.
      type (Type)
          File format.
      encoding (str)
          Optional argument specifying encoding, ascii is default.
  
  *Example*
      .. note::
      
          No example code available for this function.

* File\ (outstream)

  Create an outfile object writing to stream
  
  *Arguments*
      outstream (std::ostream)
          The stream.
";

%feature("docstring")  dolfin::File::operator>> "
Read from file
";

%feature("docstring")  dolfin::File::operator<< "
**Overloaded versions**

* operator<<\ (Function*, u)

  Write Function to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (t)

  Write object to file
";

%feature("docstring")  dolfin::File::exists "
Check if file exists

*Arguments*
    filename (str)
        Name of file.

*Returns*
    bool
        True if the file exists.
";

%feature("docstring")  dolfin::File::create_parent_path "

*Arguments*
    filename (str)
        Name of file / path.
";

// Documentation extracted from: (module=io, header=XDMFFile.h)
%feature("docstring")  dolfin::XDMFFile "
This class supports the output of meshes and functions in XDMF
(http://www.xdmf.org) format. It creates an XML file that describes
the data and points to a HDF5 file that stores the actual problem
data. Output of data in parallel is supported.

XDMF is not suitable for checkpointing as it may decimate
some data.
";

%feature("docstring")  dolfin::XDMFFile::XDMFFile "
Constructor
";

%feature("docstring")  dolfin::XDMFFile::operator<< "
**Overloaded versions**

* operator<<\ (mesh)

  Save a mesh for visualisation, with e.g. ParaView. Creates a HDF5
  file to store the mesh, and a related XDMF file with metadata.

* operator<<\ (u)

  Save a Function to XDMF/HDF5 files for visualisation.

* operator<<\ (Function*, ut)

  Save Function + time stamp to file

* operator<<\ (meshfunction)

  Save MeshFunction to file
";

%feature("docstring")  dolfin::XDMFFile::operator>> "
**Overloaded versions**

* operator>>\ (mesh)

  Read in a mesh from the associated HDF5 file

* operator>>\ (meshfunction)

  Read first MeshFunction from file
";

// Documentation extracted from: (module=io, header=HDF5File.h)
%feature("docstring")  dolfin::HDF5File::HDF5File "
Constructor. file_mode should \"a\" (append), \"w\" (write) ot \"r\"
(read).
";

%feature("docstring")  dolfin::HDF5File::write "
**Overloaded versions**

* write\ (x, name)

  Write Vector to file in a format suitable for re-reading

* write\ (mesh, name)

  Write Mesh to file in a format suitable for re-reading

* write\ (mesh, cell_dim, name)

  Write Mesh of given cell dimension to file
  in a format suitable for re-reading

* write\ (meshfunction, name)

  Write MeshFunction to file
  in a format suitable for re-reading

* write\ (meshfunction, name)

  Write MeshFunction to file
  in a format suitable for re-reading

* write\ (meshfunction, name)

  Write MeshFunction to file
  in a format suitable for re-reading
";

%feature("docstring")  dolfin::HDF5File::read "
**Overloaded versions**

* read\ (x, dataset_name, use_partition_from_file=true)

  Read vector from file

* read\ (mesh, name)

  Read Mesh from file

* read\ (meshfunction, name)

  Read MeshFunction from file

* read\ (meshfunction, name)

  Read MeshFunction from file

* read\ (meshfunction, name)

  Read MeshFunction from file
";

%feature("docstring")  dolfin::HDF5File::has_dataset "
Check if dataset exists in HDF5 file
";

%feature("docstring")  dolfin::HDF5File::flush "
Flush buffered I/O to disk
";

