# This module dynamically loads mpi. This needs to be done before any other modules
# loads mpi. This is because the shared mpi library needs to be loaded with the
# RTLD_GLOBAL options. See
#
#   <http://www.open-mpi.org/faq/?category=running#loading-libmpi-dynamically>
#

import ctypes

ctypes.CDLL('libmpi.so', ctypes.RTLD_GLOBAL)

# NOTE: We did the same with 'libmpi.0.dylib' on Darwin earlier, but that did not
# work with OpenMPI from MacPorts on Mac OS X Snow Leopard. It was not needed
# anyway, so it was removed.
