// This code conforms with the UFC specification version 1.6.0
// and was automatically generated by FFC version 1.6.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   no_ferari:                      True
//   optimize:                       False
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   restrict_keyword:               ''
//   split:                          False

#ifndef __HYPERELASTICITY_H
#define __HYPERELASTICITY_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class hyperelasticity_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  hyperelasticity_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Real', Domain(Cell('tetrahedron', 3)), 0, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 1;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell (actual implementation)
  static void _evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    
    // Compute subdeterminants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    } // end loop over 'r'
  }

  /// Evaluate basis function i at given point x in cell (non-static member function)
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    _evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate all basis functions at given point x in cell (actual implementation)
  static void _evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation)
  {
    // Element is constant, calling evaluate_basis.
    _evaluate_basis(0, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate all basis functions at given point x in cell (non-static member function)
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    _evaluate_basis_all(values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell (actual implementation)
  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 0)
    {
    return ;
    }
    
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell (non-static member function)
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    _evaluate_basis_derivatives(i, n, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell (actual implementation)
  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation)
  {
    // Element is constant, calling evaluate_basis_derivatives.
    _evaluate_basis_derivatives(0, n, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell (non-static member function)
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    _evaluate_basis_derivatives_all(n, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
    vertex_values[3] = dof_values[0];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new hyperelasticity_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class hyperelasticity_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  hyperelasticity_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3)), 1, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 4;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell (actual implementation)
  static void _evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate basis function i at given point x in cell (non-static member function)
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    _evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate all basis functions at given point x in cell (actual implementation)
  static void _evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    } // end loop over 'r'
  }

  /// Evaluate all basis functions at given point x in cell (non-static member function)
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    _evaluate_basis_all(values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell (actual implementation)
  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell (non-static member function)
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    _evaluate_basis_derivatives(i, n, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell (actual implementation)
  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 4; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[3];
    for (unsigned int r = 0; r < 3; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell (non-static member function)
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    _evaluate_basis_derivatives_all(n, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new hyperelasticity_finite_element_1();
  }

};

/// This class defines the interface for a finite element.

class hyperelasticity_finite_element_2: public ufc::finite_element
{
public:

  /// Constructor
  hyperelasticity_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_finite_element_2()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "VectorElement('Lagrange', Domain(Cell('tetrahedron', 3)), 1, 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 12;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point x in cell (actual implementation)
  static void _evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation)
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      } // end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate basis function i at given point x in cell (non-static member function)
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    _evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate all basis functions at given point x in cell (actual implementation)
  static void _evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation)
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 12; r++)
    {
      _evaluate_basis(r, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  /// Evaluate all basis functions at given point x in cell (non-static member function)
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    _evaluate_basis_all(values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell (actual implementation)
  static void _evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation)
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.0;
    } // end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[3][1];
    for (unsigned int row = 0; row < 3; row++)
    {
      for (unsigned int col = 0; col < 1; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[3][3];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, -0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.182574185835055, -0.105409255338946, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.210818510677892, -0.074535599249993};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.288675134594813, 0.0, 0.0, 0.223606797749979};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.32455532033676, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {5.47722557505166, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.16227766016838, 0.0, 0.0, 0.0},
      {1.82574185835055, 0.0, 0.0, 0.0},
      {5.16397779494322, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[3];
      for (unsigned int r = 0; r < 3; r++)
      {
        derivatives[r] = 0.0;
      } // end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          } // end loop over 'u'
        } // end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            } // end loop over 'u'
          } // end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              } // end loop over 'tu'
            } // end loop over 'u'
          } // end loop over 't'
          }
          
        } // end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          } // end loop over 't'
        } // end loop over 's'
      } // end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        } // end loop over 's'
      } // end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell (non-static member function)
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    _evaluate_basis_derivatives(i, n, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell (actual implementation)
  static void _evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation)
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      _evaluate_basis_all(values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    } // end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 12; r++)
    {
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = 0.0;
      } // end loop over 's'
    } // end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 1)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[9];
    for (unsigned int r = 0; r < 9; r++)
    {
      dof_values[r] = 0.0;
    } // end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 12; r++)
    {
      _evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      } // end loop over 's'
    } // end loop over 'r'
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell (non-static member function)
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    _evaluate_basis_derivatives_all(n, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 8:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 9:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 10:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 11:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[6] = vals[1];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[7] = vals[1];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[8] = vals[2];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[9] = vals[2];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[10] = vals[2];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[11] = vals[2];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[3] = dof_values[1];
    vertex_values[6] = dof_values[2];
    vertex_values[9] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[4] = dof_values[5];
    vertex_values[7] = dof_values[6];
    vertex_values[10] = dof_values[7];
    // Evaluate function and change variables
    vertex_values[2] = dof_values[8];
    vertex_values[5] = dof_values[9];
    vertex_values[8] = dof_values[10];
    vertex_values[11] = dof_values[11];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 3;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new hyperelasticity_finite_element_2();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class hyperelasticity_dofmap_0: public ufc::dofmap
{
public:

  /// Constructor
  hyperelasticity_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Real', Domain(Cell('tetrahedron', 3)), 0, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return 1;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t num_element_dofs() const
  {
    return 1;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    dofs[0] = 0;
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double* dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    dof_coordinates[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    dof_coordinates[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new hyperelasticity_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class hyperelasticity_dofmap_1: public ufc::dofmap
{
public:

  /// Constructor
  hyperelasticity_dofmap_1() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3)), 1, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return num_global_entities[0];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t num_element_dofs() const
  {
    return 4;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
    dofs[3] = c.entity_indices[0][3];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double* dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0] = vertex_coordinates[0];
    dof_coordinates[1] = vertex_coordinates[1];
    dof_coordinates[2] = vertex_coordinates[2];
    dof_coordinates[3] = vertex_coordinates[3];
    dof_coordinates[4] = vertex_coordinates[4];
    dof_coordinates[5] = vertex_coordinates[5];
    dof_coordinates[6] = vertex_coordinates[6];
    dof_coordinates[7] = vertex_coordinates[7];
    dof_coordinates[8] = vertex_coordinates[8];
    dof_coordinates[9] = vertex_coordinates[9];
    dof_coordinates[10] = vertex_coordinates[10];
    dof_coordinates[11] = vertex_coordinates[11];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new hyperelasticity_dofmap_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class hyperelasticity_dofmap_2: public ufc::dofmap
{
public:

  /// Constructor
  hyperelasticity_dofmap_2() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_dofmap_2()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for VectorElement('Lagrange', Domain(Cell('tetrahedron', 3)), 1, 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return 3*num_global_entities[0];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t num_element_dofs() const
  {
    return 12;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 9;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + c.entity_indices[0][0];
    dofs[5] = offset + c.entity_indices[0][1];
    dofs[6] = offset + c.entity_indices[0][2];
    dofs[7] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[8] = offset + c.entity_indices[0][0];
    dofs[9] = offset + c.entity_indices[0][1];
    dofs[10] = offset + c.entity_indices[0][2];
    dofs[11] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 9;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 11;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 10;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 3)
    {
    throw std::runtime_error("d is larger than dimension (3)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      throw std::runtime_error("i is larger than number of entities (3)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
        dofs[2] = 8;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
        dofs[2] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double* dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0] = vertex_coordinates[0];
    dof_coordinates[1] = vertex_coordinates[1];
    dof_coordinates[2] = vertex_coordinates[2];
    dof_coordinates[3] = vertex_coordinates[3];
    dof_coordinates[4] = vertex_coordinates[4];
    dof_coordinates[5] = vertex_coordinates[5];
    dof_coordinates[6] = vertex_coordinates[6];
    dof_coordinates[7] = vertex_coordinates[7];
    dof_coordinates[8] = vertex_coordinates[8];
    dof_coordinates[9] = vertex_coordinates[9];
    dof_coordinates[10] = vertex_coordinates[10];
    dof_coordinates[11] = vertex_coordinates[11];
    dof_coordinates[12] = vertex_coordinates[0];
    dof_coordinates[13] = vertex_coordinates[1];
    dof_coordinates[14] = vertex_coordinates[2];
    dof_coordinates[15] = vertex_coordinates[3];
    dof_coordinates[16] = vertex_coordinates[4];
    dof_coordinates[17] = vertex_coordinates[5];
    dof_coordinates[18] = vertex_coordinates[6];
    dof_coordinates[19] = vertex_coordinates[7];
    dof_coordinates[20] = vertex_coordinates[8];
    dof_coordinates[21] = vertex_coordinates[9];
    dof_coordinates[22] = vertex_coordinates[10];
    dof_coordinates[23] = vertex_coordinates[11];
    dof_coordinates[24] = vertex_coordinates[0];
    dof_coordinates[25] = vertex_coordinates[1];
    dof_coordinates[26] = vertex_coordinates[2];
    dof_coordinates[27] = vertex_coordinates[3];
    dof_coordinates[28] = vertex_coordinates[4];
    dof_coordinates[29] = vertex_coordinates[5];
    dof_coordinates[30] = vertex_coordinates[6];
    dof_coordinates[31] = vertex_coordinates[7];
    dof_coordinates[32] = vertex_coordinates[8];
    dof_coordinates[33] = vertex_coordinates[9];
    dof_coordinates[34] = vertex_coordinates[10];
    dof_coordinates[35] = vertex_coordinates[11];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 3;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new hyperelasticity_dofmap_2();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class hyperelasticity_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  /// Constructor
  hyperelasticity_cell_integral_0_otherwise() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_cell_integral_0_otherwise()
  {
    // Do nothing
  }

  /// Tabulate which form coefficients are used by this integral
  virtual const std::vector<bool> & enabled_coefficients() const
  {
    static const std::vector<bool> enabled({true, true, false, true, true});
    return enabled;
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double*  A,
                               const double * const *  w,
                               const double*  vertex_coordinates,
                               int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius
    
    
    // Array of quadrature weights.
    static const double W4[4] = {0.0416666666666667, 0.0416666666666667, 0.0416666666666667, 0.0416666666666667};
    // Quadrature points on the UFC reference element: (0.585410196624969, 0.138196601125011, 0.138196601125011), (0.138196601125011, 0.585410196624969, 0.138196601125011), (0.138196601125011, 0.138196601125011, 0.585410196624969), (0.138196601125011, 0.138196601125011, 0.138196601125011)
    
    // Values of basis functions at quadrature points.
    static const double FE0_C0[4][12] = \
    {{0.138196601125009, 0.585410196624969, 0.138196601125011, 0.138196601125011, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.138196601125009, 0.138196601125011, 0.585410196624969, 0.138196601125011, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.138196601125009, 0.138196601125011, 0.138196601125011, 0.585410196624969, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.585410196624967, 0.138196601125011, 0.138196601125011, 0.138196601125011, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C0_D001[4][12] = \
    {{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C0_D010[4][12] = \
    {{-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C0_D100[4][12] = \
    {{-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C1[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.138196601125009, 0.585410196624969, 0.138196601125011, 0.138196601125011, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.138196601125009, 0.138196601125011, 0.585410196624969, 0.138196601125011, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.138196601125009, 0.138196601125011, 0.138196601125011, 0.585410196624969, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.585410196624967, 0.138196601125011, 0.138196601125011, 0.138196601125011, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C1_D001[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C1_D010[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C1_D100[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C2[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.138196601125009, 0.585410196624969, 0.138196601125011, 0.138196601125011},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.138196601125009, 0.138196601125011, 0.585410196624969, 0.138196601125011},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.138196601125009, 0.138196601125011, 0.138196601125011, 0.585410196624969},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.585410196624967, 0.138196601125011, 0.138196601125011, 0.138196601125011}};
    
    static const double FE0_C2_D001[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0}};
    
    static const double FE0_C2_D010[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0}};
    
    static const double FE0_C2_D100[4][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0},
    {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0}};
    
    static const double FE1[4][1] = \
    {{1.0},
    {1.0},
    {1.0},
    {1.0}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 12; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', False), ('ignore ones', False), ('ignore zero tables', False), ('optimisation', False), ('remove zero terms', False)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 47248
    for (unsigned int ip = 0; ip < 4; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      double F6 = 0.0;
      double F7 = 0.0;
      double F8 = 0.0;
      double F9 = 0.0;
      double F10 = 0.0;
      double F11 = 0.0;
      double F12 = 0.0;
      double F13 = 0.0;
      
      // Total number of operations to compute function values = 4
      for (unsigned int r = 0; r < 1; r++)
      {
        F0 += FE1[ip][0]*w[3][0];
        F10 += FE1[ip][0]*w[4][0];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 288
      for (unsigned int r = 0; r < 12; r++)
      {
        F1 += FE0_C0_D100[ip][r]*w[0][r];
        F2 += FE0_C0_D010[ip][r]*w[0][r];
        F3 += FE0_C0_D001[ip][r]*w[0][r];
        F4 += FE0_C2_D100[ip][r]*w[0][r];
        F5 += FE0_C2_D010[ip][r]*w[0][r];
        F6 += FE0_C2_D001[ip][r]*w[0][r];
        F7 += FE0_C1_D100[ip][r]*w[0][r];
        F8 += FE0_C1_D010[ip][r]*w[0][r];
        F9 += FE0_C1_D001[ip][r]*w[0][r];
        F11 += FE0_C0[ip][r]*w[1][r];
        F12 += FE0_C1[ip][r]*w[1][r];
        F13 += FE0_C2[ip][r]*w[1][r];
      } // end loop over 'r'
      
      // Number of operations for primary indices: 11520
      for (unsigned int j = 0; j < 12; j++)
      {
        // Number of operations to compute entry: 960
        A[j] += ((((((((((((((K[0]*FE0_C1_D100[ip][j] + K[3]*FE0_C1_D010[ip][j] + K[6]*FE0_C1_D001[ip][j]))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + ((K[2]*FE0_C2_D100[ip][j] + K[5]*FE0_C2_D010[ip][j] + K[8]*FE0_C2_D001[ip][j]))*((K[0]*F7 + K[3]*F8 + K[6]*F9))))*(-1.0) + (((K[0]*FE0_C2_D100[ip][j] + K[3]*FE0_C2_D010[ip][j] + K[6]*FE0_C2_D001[ip][j]))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE0_C1_D100[ip][j] + K[5]*FE0_C1_D010[ip][j] + K[8]*FE0_C1_D001[ip][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE0_C0_D100[ip][j] + K[4]*FE0_C0_D010[ip][j] + K[7]*FE0_C0_D001[ip][j]))*((((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[0]*F4 + K[3]*F5 + K[6]*F6)) + (-1.0)*(((K[0]*F7 + K[3]*F8 + K[6]*F9))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)))))) + (((((((K[1]*FE0_C2_D100[ip][j] + K[4]*FE0_C2_D010[ip][j] + K[7]*FE0_C2_D001[ip][j]))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE0_C1_D100[ip][j] + K[5]*FE0_C1_D010[ip][j] + K[8]*FE0_C1_D001[ip][j]))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))*(-1.0) + (((K[1]*FE0_C1_D100[ip][j] + K[4]*FE0_C1_D010[ip][j] + K[7]*FE0_C1_D001[ip][j]))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + ((K[2]*FE0_C2_D100[ip][j] + K[5]*FE0_C2_D010[ip][j] + K[8]*FE0_C2_D001[ip][j]))*(((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0)))))*(((K[0]*F1 + K[3]*F2 + K[6]*F3) + 1.0)) + ((K[0]*FE0_C0_D100[ip][j] + K[3]*FE0_C0_D010[ip][j] + K[6]*FE0_C0_D001[ip][j]))*(((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + (-1.0)*(((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))))) + (((((((K[0]*FE0_C2_D100[ip][j] + K[3]*FE0_C2_D010[ip][j] + K[6]*FE0_C2_D001[ip][j]))*(((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0)) + ((K[1]*FE0_C1_D100[ip][j] + K[4]*FE0_C1_D010[ip][j] + K[7]*FE0_C1_D001[ip][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE0_C1_D100[ip][j] + K[3]*FE0_C1_D010[ip][j] + K[6]*FE0_C1_D001[ip][j]))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + ((K[1]*FE0_C2_D100[ip][j] + K[4]*FE0_C2_D010[ip][j] + K[7]*FE0_C2_D001[ip][j]))*((K[0]*F7 + K[3]*F8 + K[6]*F9)))))*((K[2]*F1 + K[5]*F2 + K[8]*F3)) + ((K[2]*FE0_C0_D100[ip][j] + K[5]*FE0_C0_D010[ip][j] + K[8]*FE0_C0_D001[ip][j]))*((((K[0]*F7 + K[3]*F8 + K[6]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + (-1.0)*((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))))/((((((K[0]*F1 + K[3]*F2 + K[6]*F3) + 1.0))*(((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + (-1.0)*(((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))) + ((K[1]*F1 + K[4]*F2 + K[7]*F3))*((((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[0]*F4 + K[3]*F5 + K[6]*F6)) + (-1.0)*(((K[0]*F7 + K[3]*F8 + K[6]*F9))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)))))) + ((K[2]*F1 + K[5]*F2 + K[8]*F3))*((((K[0]*F7 + K[3]*F8 + K[6]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + (-1.0)*((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))))))*2.0)*(std::log((((((K[0]*F1 + K[3]*F2 + K[6]*F3) + 1.0))*(((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + (-1.0)*(((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))) + ((K[1]*F1 + K[4]*F2 + K[7]*F3))*((((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[0]*F4 + K[3]*F5 + K[6]*F6)) + (-1.0)*(((K[0]*F7 + K[3]*F8 + K[6]*F9))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)))))) + ((K[2]*F1 + K[5]*F2 + K[8]*F3))*((((K[0]*F7 + K[3]*F8 + K[6]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + (-1.0)*((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))))))*F10/(2.0) + ((((((((((((K[0]*FE0_C1_D100[ip][j] + K[3]*FE0_C1_D010[ip][j] + K[6]*FE0_C1_D001[ip][j]))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + ((K[2]*FE0_C2_D100[ip][j] + K[5]*FE0_C2_D010[ip][j] + K[8]*FE0_C2_D001[ip][j]))*((K[0]*F7 + K[3]*F8 + K[6]*F9))))*(-1.0) + (((K[0]*FE0_C2_D100[ip][j] + K[3]*FE0_C2_D010[ip][j] + K[6]*FE0_C2_D001[ip][j]))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE0_C1_D100[ip][j] + K[5]*FE0_C1_D010[ip][j] + K[8]*FE0_C1_D001[ip][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE0_C0_D100[ip][j] + K[4]*FE0_C0_D010[ip][j] + K[7]*FE0_C0_D001[ip][j]))*((((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[0]*F4 + K[3]*F5 + K[6]*F6)) + (-1.0)*(((K[0]*F7 + K[3]*F8 + K[6]*F9))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)))))) + (((((((K[1]*FE0_C2_D100[ip][j] + K[4]*FE0_C2_D010[ip][j] + K[7]*FE0_C2_D001[ip][j]))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE0_C1_D100[ip][j] + K[5]*FE0_C1_D010[ip][j] + K[8]*FE0_C1_D001[ip][j]))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))*(-1.0) + (((K[1]*FE0_C1_D100[ip][j] + K[4]*FE0_C1_D010[ip][j] + K[7]*FE0_C1_D001[ip][j]))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + ((K[2]*FE0_C2_D100[ip][j] + K[5]*FE0_C2_D010[ip][j] + K[8]*FE0_C2_D001[ip][j]))*(((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0)))))*(((K[0]*F1 + K[3]*F2 + K[6]*F3) + 1.0)) + ((K[0]*FE0_C0_D100[ip][j] + K[3]*FE0_C0_D010[ip][j] + K[6]*FE0_C0_D001[ip][j]))*(((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + (-1.0)*(((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))))) + (((((((K[0]*FE0_C2_D100[ip][j] + K[3]*FE0_C2_D010[ip][j] + K[6]*FE0_C2_D001[ip][j]))*(((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0)) + ((K[1]*FE0_C1_D100[ip][j] + K[4]*FE0_C1_D010[ip][j] + K[7]*FE0_C1_D001[ip][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE0_C1_D100[ip][j] + K[3]*FE0_C1_D010[ip][j] + K[6]*FE0_C1_D001[ip][j]))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + ((K[1]*FE0_C2_D100[ip][j] + K[4]*FE0_C2_D010[ip][j] + K[7]*FE0_C2_D001[ip][j]))*((K[0]*F7 + K[3]*F8 + K[6]*F9)))))*((K[2]*F1 + K[5]*F2 + K[8]*F3)) + ((K[2]*FE0_C0_D100[ip][j] + K[5]*FE0_C0_D010[ip][j] + K[8]*FE0_C0_D001[ip][j]))*((((K[0]*F7 + K[3]*F8 + K[6]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + (-1.0)*((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))))/((((((K[0]*F1 + K[3]*F2 + K[6]*F3) + 1.0))*(((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)) + (-1.0)*(((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6))))) + ((K[1]*F1 + K[4]*F2 + K[7]*F3))*((((K[2]*F7 + K[5]*F8 + K[8]*F9))*((K[0]*F4 + K[3]*F5 + K[6]*F6)) + (-1.0)*(((K[0]*F7 + K[3]*F8 + K[6]*F9))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0)))))) + ((K[2]*F1 + K[5]*F2 + K[8]*F3))*((((K[0]*F7 + K[3]*F8 + K[6]*F9))*((K[1]*F4 + K[4]*F5 + K[7]*F6)) + (-1.0)*((((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))))))*F0)*(-1.0) + (((2.0*(((K[0]*FE0_C0_D100[ip][j] + K[3]*FE0_C0_D010[ip][j] + K[6]*FE0_C0_D001[ip][j]))*(((K[0]*F1 + K[3]*F2 + K[6]*F3) + 1.0))) + 2.0*(((K[0]*FE0_C1_D100[ip][j] + K[3]*FE0_C1_D010[ip][j] + K[6]*FE0_C1_D001[ip][j]))*((K[0]*F7 + K[3]*F8 + K[6]*F9))) + 2.0*(((K[0]*FE0_C2_D100[ip][j] + K[3]*FE0_C2_D010[ip][j] + K[6]*FE0_C2_D001[ip][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))) + (2.0*(((K[1]*FE0_C0_D100[ip][j] + K[4]*FE0_C0_D010[ip][j] + K[7]*FE0_C0_D001[ip][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))) + 2.0*(((K[1]*FE0_C1_D100[ip][j] + K[4]*FE0_C1_D010[ip][j] + K[7]*FE0_C1_D001[ip][j]))*(((K[1]*F7 + K[4]*F8 + K[7]*F9) + 1.0))) + 2.0*(((K[1]*FE0_C2_D100[ip][j] + K[4]*FE0_C2_D010[ip][j] + K[7]*FE0_C2_D001[ip][j]))*((K[1]*F4 + K[4]*F5 + K[7]*F6)))) + (2.0*(((K[2]*FE0_C0_D100[ip][j] + K[5]*FE0_C0_D010[ip][j] + K[8]*FE0_C0_D001[ip][j]))*((K[2]*F1 + K[5]*F2 + K[8]*F3))) + 2.0*(((K[2]*FE0_C1_D100[ip][j] + K[5]*FE0_C1_D010[ip][j] + K[8]*FE0_C1_D001[ip][j]))*((K[2]*F7 + K[5]*F8 + K[8]*F9))) + 2.0*(((K[2]*FE0_C2_D100[ip][j] + K[5]*FE0_C2_D010[ip][j] + K[8]*FE0_C2_D001[ip][j]))*(((K[2]*F4 + K[5]*F5 + K[8]*F6) + 1.0))))))*F0/(2.0))) + ((FE0_C0[ip][j]*F11 + FE0_C1[ip][j]*F12 + FE0_C2[ip][j]*F13))*(-1.0))*W4[ip]*det;
      } // end loop over 'j'
    } // end loop over 'ip'
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class hyperelasticity_exterior_facet_integral_0_otherwise: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  hyperelasticity_exterior_facet_integral_0_otherwise() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_exterior_facet_integral_0_otherwise()
  {
    // Do nothing
  }

  /// Tabulate which form coefficients are used by this integral
  virtual const std::vector<bool> & enabled_coefficients() const
  {
    static const std::vector<bool> enabled({false, false, true, false, false});
    return enabled;
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double*  A,
                               const double * const *  w,
                               const double*  vertex_coordinates,
                               std::size_t facet,
                               int cell_orientation) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      59
    // Number of operations (multiply-add pairs) for geometry tensor:    12
    // Number of operations (multiply-add pairs) for tensor contraction: 90
    // Total number of operations (multiply-add pairs):                  161
    
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Get vertices on face
    static unsigned int face_vertices[4][3] = {{1, 2, 3}, {0, 2, 3}, {0, 1, 3}, {0, 1, 2}};
    const unsigned int v0 = face_vertices[facet][0];
    const unsigned int v1 = face_vertices[facet][1];
    const unsigned int v2 = face_vertices[facet][2];
    
    // Compute scale factor (area of face scaled by area of reference triangle)
    const double a0 = (vertex_coordinates[3*v0 + 1]*vertex_coordinates[3*v1 + 2]  + vertex_coordinates[3*v0 + 2]*vertex_coordinates[3*v2 + 1]  + vertex_coordinates[3*v1 + 1]*vertex_coordinates[3*v2 + 2]) - (vertex_coordinates[3*v2 + 1]*vertex_coordinates[3*v1 + 2] + vertex_coordinates[3*v2 + 2]*vertex_coordinates[3*v0 + 1] + vertex_coordinates[3*v1 + 1]*vertex_coordinates[3*v0 + 2]);
    
    const double a1 = (vertex_coordinates[3*v0 + 2]*vertex_coordinates[3*v1 + 0]  + vertex_coordinates[3*v0 + 0]*vertex_coordinates[3*v2 + 2] + vertex_coordinates[3*v1 + 2]*vertex_coordinates[3*v2 + 0]) - (vertex_coordinates[3*v2 + 2]*vertex_coordinates[3*v1 + 0]  + vertex_coordinates[3*v2 + 0]*vertex_coordinates[3*v0 + 2] + vertex_coordinates[3*v1 + 2]*vertex_coordinates[3*v0 + 0]);
    
    const double a2 = (vertex_coordinates[3*v0 + 0]*vertex_coordinates[3*v1 + 1]  + vertex_coordinates[3*v0 + 1]*vertex_coordinates[3*v2 + 0]  + vertex_coordinates[3*v1 + 0]*vertex_coordinates[3*v2 + 1]) - (vertex_coordinates[3*v2 + 0]*vertex_coordinates[3*v1 + 1]  + vertex_coordinates[3*v2 + 1]*vertex_coordinates[3*v0 + 0]  + vertex_coordinates[3*v1 + 0]*vertex_coordinates[3*v0 + 1]);
    
    const double det = std::sqrt(a0*a0 + a1*a1 + a2*a2);
    
    
    // Compute geometry tensor
    const double G0_0 = det*w[2][0]*(1.0);
    const double G0_1 = det*w[2][1]*(1.0);
    const double G0_2 = det*w[2][2]*(1.0);
    const double G0_3 = det*w[2][3]*(1.0);
    const double G0_4 = det*w[2][4]*(1.0);
    const double G0_5 = det*w[2][5]*(1.0);
    const double G0_6 = det*w[2][6]*(1.0);
    const double G0_7 = det*w[2][7]*(1.0);
    const double G0_8 = det*w[2][8]*(1.0);
    const double G0_9 = det*w[2][9]*(1.0);
    const double G0_10 = det*w[2][10]*(1.0);
    const double G0_11 = det*w[2][11]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.0;
      A[1] = -0.0833333333333333*G0_1 - 0.0416666666666667*G0_2 - 0.0416666666666667*G0_3;
      A[2] = -0.0416666666666667*G0_1 - 0.0833333333333333*G0_2 - 0.0416666666666667*G0_3;
      A[3] = -0.0416666666666667*G0_1 - 0.0416666666666667*G0_2 - 0.0833333333333333*G0_3;
      A[4] = 0.0;
      A[5] = -0.0833333333333333*G0_5 - 0.0416666666666667*G0_6 - 0.0416666666666667*G0_7;
      A[6] = -0.0416666666666667*G0_5 - 0.0833333333333333*G0_6 - 0.0416666666666667*G0_7;
      A[7] = -0.0416666666666667*G0_5 - 0.0416666666666667*G0_6 - 0.0833333333333333*G0_7;
      A[8] = 0.0;
      A[9] = -0.0833333333333333*G0_9 - 0.0416666666666667*G0_10 - 0.0416666666666667*G0_11;
      A[10] = -0.0416666666666667*G0_9 - 0.0833333333333333*G0_10 - 0.0416666666666667*G0_11;
      A[11] = -0.0416666666666667*G0_9 - 0.0416666666666667*G0_10 - 0.0833333333333333*G0_11;
        break;
      }
    case 1:
      {
        A[0] = -0.0833333333333334*G0_0 - 0.0416666666666667*G0_2 - 0.0416666666666667*G0_3;
      A[1] = 0.0;
      A[2] = -0.0416666666666667*G0_0 - 0.0833333333333333*G0_2 - 0.0416666666666667*G0_3;
      A[3] = -0.0416666666666667*G0_0 - 0.0416666666666667*G0_2 - 0.0833333333333333*G0_3;
      A[4] = -0.0833333333333334*G0_4 - 0.0416666666666667*G0_6 - 0.0416666666666667*G0_7;
      A[5] = 0.0;
      A[6] = -0.0416666666666667*G0_4 - 0.0833333333333333*G0_6 - 0.0416666666666667*G0_7;
      A[7] = -0.0416666666666667*G0_4 - 0.0416666666666667*G0_6 - 0.0833333333333333*G0_7;
      A[8] = -0.0833333333333334*G0_8 - 0.0416666666666667*G0_10 - 0.0416666666666667*G0_11;
      A[9] = 0.0;
      A[10] = -0.0416666666666667*G0_8 - 0.0833333333333333*G0_10 - 0.0416666666666667*G0_11;
      A[11] = -0.0416666666666667*G0_8 - 0.0416666666666667*G0_10 - 0.0833333333333333*G0_11;
        break;
      }
    case 2:
      {
        A[0] = -0.0833333333333333*G0_0 - 0.0416666666666667*G0_1 - 0.0416666666666667*G0_3;
      A[1] = -0.0416666666666667*G0_0 - 0.0833333333333333*G0_1 - 0.0416666666666667*G0_3;
      A[2] = 0.0;
      A[3] = -0.0416666666666667*G0_0 - 0.0416666666666666*G0_1 - 0.0833333333333333*G0_3;
      A[4] = -0.0833333333333333*G0_4 - 0.0416666666666667*G0_5 - 0.0416666666666667*G0_7;
      A[5] = -0.0416666666666667*G0_4 - 0.0833333333333333*G0_5 - 0.0416666666666667*G0_7;
      A[6] = 0.0;
      A[7] = -0.0416666666666667*G0_4 - 0.0416666666666666*G0_5 - 0.0833333333333333*G0_7;
      A[8] = -0.0833333333333333*G0_8 - 0.0416666666666667*G0_9 - 0.0416666666666667*G0_11;
      A[9] = -0.0416666666666667*G0_8 - 0.0833333333333333*G0_9 - 0.0416666666666667*G0_11;
      A[10] = 0.0;
      A[11] = -0.0416666666666667*G0_8 - 0.0416666666666666*G0_9 - 0.0833333333333333*G0_11;
        break;
      }
    case 3:
      {
        A[0] = -0.0833333333333334*G0_0 - 0.0416666666666667*G0_1 - 0.0416666666666667*G0_2;
      A[1] = -0.0416666666666667*G0_0 - 0.0833333333333333*G0_1 - 0.0416666666666666*G0_2;
      A[2] = -0.0416666666666667*G0_0 - 0.0416666666666666*G0_1 - 0.0833333333333333*G0_2;
      A[3] = 0.0;
      A[4] = -0.0833333333333334*G0_4 - 0.0416666666666667*G0_5 - 0.0416666666666667*G0_6;
      A[5] = -0.0416666666666667*G0_4 - 0.0833333333333333*G0_5 - 0.0416666666666666*G0_6;
      A[6] = -0.0416666666666667*G0_4 - 0.0416666666666666*G0_5 - 0.0833333333333333*G0_6;
      A[7] = 0.0;
      A[8] = -0.0833333333333334*G0_8 - 0.0416666666666667*G0_9 - 0.0416666666666667*G0_10;
      A[9] = -0.0416666666666667*G0_8 - 0.0833333333333333*G0_9 - 0.0416666666666666*G0_10;
      A[10] = -0.0416666666666667*G0_8 - 0.0416666666666666*G0_9 - 0.0833333333333333*G0_10;
      A[11] = 0.0;
        break;
      }
    }
    
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class hyperelasticity_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  /// Constructor
  hyperelasticity_cell_integral_1_otherwise() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_cell_integral_1_otherwise()
  {
    // Do nothing
  }

  /// Tabulate which form coefficients are used by this integral
  virtual const std::vector<bool> & enabled_coefficients() const
  {
    static const std::vector<bool> enabled({true, true, true});
    return enabled;
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double*  A,
                               const double * const *  w,
                               const double*  vertex_coordinates,
                               int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute cell volume
    
    
    // Compute circumradius
    
    
    // Array of quadrature weights.
    static const double W1 = 0.166666666666667;
    // Quadrature points on the UFC reference element: (0.25, 0.25, 0.25)
    
    // Values of basis functions at quadrature points.
    static const double FE0_C0_D001[1][12] = \
    {{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C0_D010[1][12] = \
    {{-1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C0_D100[1][12] = \
    {{-1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C1_D001[1][12] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C1_D010[1][12] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C1_D100[1][12] = \
    {{0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    
    static const double FE0_C2_D001[1][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 0.0, 1.0}};
    
    static const double FE0_C2_D010[1][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0}};
    
    static const double FE0_C2_D100[1][12] = \
    {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0}};
    
    static const double FE1[1][1] = \
    {{1.0}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 144; r++)
    {
      A[r] = 0.0;
    } // end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', False), ('ignore ones', False), ('ignore zero tables', False), ('optimisation', False), ('remove zero terms', False)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 492268
    for (unsigned int ip = 0; ip < 1; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      double F6 = 0.0;
      double F7 = 0.0;
      double F8 = 0.0;
      double F9 = 0.0;
      double F10 = 0.0;
      
      // Total number of operations to compute function values = 4
      for (unsigned int r = 0; r < 1; r++)
      {
        F0 += FE1[0][0]*w[1][0];
        F10 += FE1[0][0]*w[2][0];
      } // end loop over 'r'
      
      // Total number of operations to compute function values = 216
      for (unsigned int r = 0; r < 12; r++)
      {
        F1 += FE0_C2_D100[0][r]*w[0][r];
        F2 += FE0_C2_D010[0][r]*w[0][r];
        F3 += FE0_C2_D001[0][r]*w[0][r];
        F4 += FE0_C1_D100[0][r]*w[0][r];
        F5 += FE0_C1_D010[0][r]*w[0][r];
        F6 += FE0_C1_D001[0][r]*w[0][r];
        F7 += FE0_C0_D100[0][r]*w[0][r];
        F8 += FE0_C0_D010[0][r]*w[0][r];
        F9 += FE0_C0_D001[0][r]*w[0][r];
      } // end loop over 'r'
      
      // Number of operations for primary indices: 492048
      for (unsigned int j = 0; j < 12; j++)
      {
        for (unsigned int k = 0; k < 12; k++)
        {
          // Number of operations to compute entry: 3417
          A[j*12 + k] += (((((((((((((((((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE0_C0_D100[0][k] + K[4]*FE0_C0_D010[0][k] + K[7]*FE0_C0_D001[0][k]))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + (((((((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE0_C0_D100[0][k] + K[3]*FE0_C0_D010[0][k] + K[6]*FE0_C0_D001[0][k]))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))))) + (((((((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE0_C0_D100[0][k] + K[5]*FE0_C0_D010[0][k] + K[8]*FE0_C0_D001[0][k]))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))))))*((((((((((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE0_C0_D100[0][j] + K[4]*FE0_C0_D010[0][j] + K[7]*FE0_C0_D001[0][j]))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + (((((((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE0_C0_D100[0][j] + K[3]*FE0_C0_D010[0][j] + K[6]*FE0_C0_D001[0][j]))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))))) + (((((((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE0_C0_D100[0][j] + K[5]*FE0_C0_D010[0][j] + K[8]*FE0_C0_D001[0][j]))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))/((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))))*(-1.0) + ((((((((((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k])) + ((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))))*(-1.0) + (((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k])) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j])))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE0_C0_D100[0][k] + K[4]*FE0_C0_D010[0][k] + K[7]*FE0_C0_D001[0][k]))*((((((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))) + ((K[1]*FE0_C0_D100[0][j] + K[4]*FE0_C0_D010[0][j] + K[7]*FE0_C0_D001[0][j]))*((((((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))) + ((((((((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k])) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))))*(-1.0) + (((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k])) + ((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j])))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE0_C0_D100[0][k] + K[3]*FE0_C0_D010[0][k] + K[6]*FE0_C0_D001[0][k]))*((((((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))) + ((K[0]*FE0_C0_D100[0][j] + K[3]*FE0_C0_D010[0][j] + K[6]*FE0_C0_D001[0][j]))*((((((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))))))) + ((((((((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k])) + ((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))))*(-1.0) + (((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k])) + ((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j])))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE0_C0_D100[0][k] + K[5]*FE0_C0_D010[0][k] + K[8]*FE0_C0_D001[0][k]))*((((((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))) + ((K[2]*FE0_C0_D100[0][j] + K[5]*FE0_C0_D010[0][j] + K[8]*FE0_C0_D001[0][j]))*((((((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))))))/((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))))))*2.0)*(std::log((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))) + (((((((((((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE0_C0_D100[0][j] + K[4]*FE0_C0_D010[0][j] + K[7]*FE0_C0_D001[0][j]))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + (((((((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE0_C0_D100[0][j] + K[3]*FE0_C0_D010[0][j] + K[6]*FE0_C0_D001[0][j]))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))))) + (((((((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE0_C0_D100[0][j] + K[5]*FE0_C0_D010[0][j] + K[8]*FE0_C0_D001[0][j]))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))/((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))))))*2.0)*((((((((((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE0_C0_D100[0][k] + K[4]*FE0_C0_D010[0][k] + K[7]*FE0_C0_D001[0][k]))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + (((((((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE0_C0_D100[0][k] + K[3]*FE0_C0_D010[0][k] + K[6]*FE0_C0_D001[0][k]))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))))) + (((((((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE0_C0_D100[0][k] + K[5]*FE0_C0_D010[0][k] + K[8]*FE0_C0_D001[0][k]))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))/((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))))))))*F10/(2.0) + (((((((((((((((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE0_C0_D100[0][k] + K[4]*FE0_C0_D010[0][k] + K[7]*FE0_C0_D001[0][k]))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + (((((((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE0_C0_D100[0][k] + K[3]*FE0_C0_D010[0][k] + K[6]*FE0_C0_D001[0][k]))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))))) + (((((((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE0_C0_D100[0][k] + K[5]*FE0_C0_D010[0][k] + K[8]*FE0_C0_D001[0][k]))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))))))*((((((((((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE0_C0_D100[0][j] + K[4]*FE0_C0_D010[0][j] + K[7]*FE0_C0_D001[0][j]))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + (((((((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE0_C0_D100[0][j] + K[3]*FE0_C0_D010[0][j] + K[6]*FE0_C0_D001[0][j]))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))))) + (((((((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE0_C0_D100[0][j] + K[5]*FE0_C0_D010[0][j] + K[8]*FE0_C0_D001[0][j]))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))/((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))))))*(-1.0) + ((((((((((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k])) + ((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))))*(-1.0) + (((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k])) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j])))))*((K[1]*F7 + K[4]*F8 + K[7]*F9)) + ((K[1]*FE0_C0_D100[0][k] + K[4]*FE0_C0_D010[0][k] + K[7]*FE0_C0_D001[0][k]))*((((((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))) + ((K[1]*FE0_C0_D100[0][j] + K[4]*FE0_C0_D010[0][j] + K[7]*FE0_C0_D001[0][j]))*((((((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))*(-1.0) + (((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3)))))) + ((((((((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k])) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))))*(-1.0) + (((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k])) + ((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j])))))*(((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0)) + ((K[0]*FE0_C0_D100[0][k] + K[3]*FE0_C0_D010[0][k] + K[6]*FE0_C0_D001[0][k]))*((((((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)))))) + ((K[0]*FE0_C0_D100[0][j] + K[3]*FE0_C0_D010[0][j] + K[6]*FE0_C0_D001[0][j]))*((((((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k]))*((K[2]*F4 + K[5]*F5 + K[8]*F6)) + ((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))*(-1.0) + (((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + ((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))))))) + ((((((((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k])) + ((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))))*(-1.0) + (((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k])) + ((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j])))))*((K[2]*F7 + K[5]*F8 + K[8]*F9)) + ((K[2]*FE0_C0_D100[0][k] + K[5]*FE0_C0_D010[0][k] + K[8]*FE0_C0_D001[0][k]))*((((((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))*((K[0]*F4 + K[3]*F5 + K[6]*F6)))))) + ((K[2]*FE0_C0_D100[0][j] + K[5]*FE0_C0_D010[0][j] + K[8]*FE0_C0_D001[0][j]))*((((((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k]))*(((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0)) + ((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))*(-1.0) + (((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + ((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k]))*((K[0]*F4 + K[3]*F5 + K[6]*F6))))))))/((((((K[0]*F7 + K[3]*F8 + K[6]*F9) + 1.0))*(((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)) + (-1.0)*(((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3))))) + ((K[1]*F7 + K[4]*F8 + K[7]*F9))*((((K[2]*F4 + K[5]*F5 + K[8]*F6))*((K[0]*F1 + K[3]*F2 + K[6]*F3)) + (-1.0)*(((K[0]*F4 + K[3]*F5 + K[6]*F6))*(((K[2]*F1 + K[5]*F2 + K[8]*F3) + 1.0)))))) + ((K[2]*F7 + K[5]*F8 + K[8]*F9))*((((K[0]*F4 + K[3]*F5 + K[6]*F6))*((K[1]*F1 + K[4]*F2 + K[7]*F3)) + (-1.0)*((((K[1]*F4 + K[4]*F5 + K[7]*F6) + 1.0))*((K[0]*F1 + K[3]*F2 + K[6]*F3))))))))*F0)*(-1.0) + (((2.0*(((K[0]*FE0_C0_D100[0][j] + K[3]*FE0_C0_D010[0][j] + K[6]*FE0_C0_D001[0][j]))*((K[0]*FE0_C0_D100[0][k] + K[3]*FE0_C0_D010[0][k] + K[6]*FE0_C0_D001[0][k]))) + 2.0*(((K[0]*FE0_C1_D100[0][j] + K[3]*FE0_C1_D010[0][j] + K[6]*FE0_C1_D001[0][j]))*((K[0]*FE0_C1_D100[0][k] + K[3]*FE0_C1_D010[0][k] + K[6]*FE0_C1_D001[0][k]))) + 2.0*(((K[0]*FE0_C2_D100[0][j] + K[3]*FE0_C2_D010[0][j] + K[6]*FE0_C2_D001[0][j]))*((K[0]*FE0_C2_D100[0][k] + K[3]*FE0_C2_D010[0][k] + K[6]*FE0_C2_D001[0][k])))) + (2.0*(((K[1]*FE0_C0_D100[0][j] + K[4]*FE0_C0_D010[0][j] + K[7]*FE0_C0_D001[0][j]))*((K[1]*FE0_C0_D100[0][k] + K[4]*FE0_C0_D010[0][k] + K[7]*FE0_C0_D001[0][k]))) + 2.0*(((K[1]*FE0_C1_D100[0][j] + K[4]*FE0_C1_D010[0][j] + K[7]*FE0_C1_D001[0][j]))*((K[1]*FE0_C1_D100[0][k] + K[4]*FE0_C1_D010[0][k] + K[7]*FE0_C1_D001[0][k]))) + 2.0*(((K[1]*FE0_C2_D100[0][j] + K[4]*FE0_C2_D010[0][j] + K[7]*FE0_C2_D001[0][j]))*((K[1]*FE0_C2_D100[0][k] + K[4]*FE0_C2_D010[0][k] + K[7]*FE0_C2_D001[0][k])))) + (2.0*(((K[2]*FE0_C0_D100[0][j] + K[5]*FE0_C0_D010[0][j] + K[8]*FE0_C0_D001[0][j]))*((K[2]*FE0_C0_D100[0][k] + K[5]*FE0_C0_D010[0][k] + K[8]*FE0_C0_D001[0][k]))) + 2.0*(((K[2]*FE0_C1_D100[0][j] + K[5]*FE0_C1_D010[0][j] + K[8]*FE0_C1_D001[0][j]))*((K[2]*FE0_C1_D100[0][k] + K[5]*FE0_C1_D010[0][k] + K[8]*FE0_C1_D001[0][k]))) + 2.0*(((K[2]*FE0_C2_D100[0][j] + K[5]*FE0_C2_D010[0][j] + K[8]*FE0_C2_D001[0][j]))*((K[2]*FE0_C2_D100[0][k] + K[5]*FE0_C2_D010[0][k] + K[8]*FE0_C2_D001[0][k]))))))*F0/(2.0)))*W1*det;
        } // end loop over 'k'
      } // end loop over 'j'
    } // end loop over 'ip'
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class hyperelasticity_form_0: public ufc::form
{
public:

  /// Constructor
  hyperelasticity_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "1ffae2b29e3ce8cf38b12fc29f24442c96dcafb2cef5059fe0cca6ac5c643a02e6b6e88ca96c9a1a08c1eb9c31bea053100d68dc0a4054f6583b50f3a492a55f";
  }


  /// Return the rank of the global tensor (r)
  virtual std::size_t rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual std::size_t num_coefficients() const
  {
    return 5;
  }

  /// Return original coefficient position for each coefficient (0 <= i < n)
  virtual std::size_t original_coefficient_position(std::size_t i) const
  {
    static const std::vector<std::size_t> position({0, 1, 2, 3, 4});
    return position[i];
  }


  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 5:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    case 5:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    }
    
    return 0;
  }


  /// Return the number of cell domains
  virtual std::size_t max_cell_subdomain_id() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual std::size_t max_exterior_facet_subdomain_id() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual std::size_t max_interior_facet_subdomain_id() const
  {
    return 0;
  }

  /// Return the number of vertex domains
  virtual std::size_t max_vertex_subdomain_id() const
  {
    return 0;
  }

  /// Return the number of custom domains
  virtual std::size_t max_custom_subdomain_id() const
  {
    return 0;
  }


  /// Return whether the form has any cell integrals
  virtual bool has_cell_integrals() const
  {
    return true;
  }

  /// Return whether the form has any exterior facet integrals
  virtual bool has_exterior_facet_integrals() const
  {
    return true;
  }

  /// Return whether the form has any interior facet integrals
  virtual bool has_interior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any vertex integrals
  virtual bool has_vertex_integrals() const
  {
    return false;
  }

  /// Return whether the form has any custom integrals
  virtual bool has_custom_integrals() const
  {
    return false;
  }


  /// Create a new cell integral on sub domain subdomain_id
  virtual ufc::cell_integral* create_cell_integral(std::size_t subdomain_id) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain subdomain_id
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(std::size_t subdomain_id) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain subdomain_id
  virtual ufc::interior_facet_integral* create_interior_facet_integral(std::size_t subdomain_id) const
  {
    return 0;
  }

  /// Create a new vertex integral on sub domain subdomain_id
  virtual ufc::vertex_integral* create_vertex_integral(std::size_t subdomain_id) const
  {
    return 0;
  }

  /// Create a new custom integral on sub domain subdomain_id
  virtual ufc::custom_integral* create_custom_integral(std::size_t subdomain_id) const
  {
    return 0;
  }


  /// Create a new cell integral on everywhere else
  virtual ufc::cell_integral* create_default_cell_integral() const
  {
    return new hyperelasticity_cell_integral_0_otherwise();
  }

  /// Create a new exterior facet integral on everywhere else
  virtual ufc::exterior_facet_integral* create_default_exterior_facet_integral() const
  {
    return new hyperelasticity_exterior_facet_integral_0_otherwise();
  }

  /// Create a new interior facet integral on everywhere else
  virtual ufc::interior_facet_integral* create_default_interior_facet_integral() const
  {
    return 0;
  }

  /// Create a new vertex integral on everywhere else
  virtual ufc::vertex_integral* create_default_vertex_integral() const
  {
    return 0;
  }

  /// Create a new custom integral on everywhere else
  virtual ufc::custom_integral* create_default_custom_integral() const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class hyperelasticity_form_1: public ufc::form
{
public:

  /// Constructor
  hyperelasticity_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "55caaffb330df012804263370547325ced2257e2f4bc4310a0290e1571b8cb9e2ca7fca19810676ff019d40c44e4f4205da1b0cd0c42da94c6b4d1264499e2fa";
  }


  /// Return the rank of the global tensor (r)
  virtual std::size_t rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual std::size_t num_coefficients() const
  {
    return 3;
  }

  /// Return original coefficient position for each coefficient (0 <= i < n)
  virtual std::size_t original_coefficient_position(std::size_t i) const
  {
    static const std::vector<std::size_t> position({0, 3, 4});
    return position[i];
  }


  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    }
    
    return 0;
  }


  /// Return the number of cell domains
  virtual std::size_t max_cell_subdomain_id() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual std::size_t max_exterior_facet_subdomain_id() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual std::size_t max_interior_facet_subdomain_id() const
  {
    return 0;
  }

  /// Return the number of vertex domains
  virtual std::size_t max_vertex_subdomain_id() const
  {
    return 0;
  }

  /// Return the number of custom domains
  virtual std::size_t max_custom_subdomain_id() const
  {
    return 0;
  }


  /// Return whether the form has any cell integrals
  virtual bool has_cell_integrals() const
  {
    return true;
  }

  /// Return whether the form has any exterior facet integrals
  virtual bool has_exterior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any interior facet integrals
  virtual bool has_interior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any vertex integrals
  virtual bool has_vertex_integrals() const
  {
    return false;
  }

  /// Return whether the form has any custom integrals
  virtual bool has_custom_integrals() const
  {
    return false;
  }


  /// Create a new cell integral on sub domain subdomain_id
  virtual ufc::cell_integral* create_cell_integral(std::size_t subdomain_id) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain subdomain_id
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(std::size_t subdomain_id) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain subdomain_id
  virtual ufc::interior_facet_integral* create_interior_facet_integral(std::size_t subdomain_id) const
  {
    return 0;
  }

  /// Create a new vertex integral on sub domain subdomain_id
  virtual ufc::vertex_integral* create_vertex_integral(std::size_t subdomain_id) const
  {
    return 0;
  }

  /// Create a new custom integral on sub domain subdomain_id
  virtual ufc::custom_integral* create_custom_integral(std::size_t subdomain_id) const
  {
    return 0;
  }


  /// Create a new cell integral on everywhere else
  virtual ufc::cell_integral* create_default_cell_integral() const
  {
    return new hyperelasticity_cell_integral_1_otherwise();
  }

  /// Create a new exterior facet integral on everywhere else
  virtual ufc::exterior_facet_integral* create_default_exterior_facet_integral() const
  {
    return 0;
  }

  /// Create a new interior facet integral on everywhere else
  virtual ufc::interior_facet_integral* create_default_interior_facet_integral() const
  {
    return 0;
  }

  /// Create a new vertex integral on everywhere else
  virtual ufc::vertex_integral* create_default_vertex_integral() const
  {
    return 0;
  }

  /// Create a new custom integral on everywhere else
  virtual ufc::custom_integral* create_default_custom_integral() const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>

namespace HyperElasticity
{

class CoefficientSpace_B: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_B(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_B(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_B(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_B(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

};

class CoefficientSpace_T: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_T(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_T(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_T(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_T(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

};

class CoefficientSpace_lmbda: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_lmbda(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_lmbda(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_0()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_lmbda(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_0()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_lmbda(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_0()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

};

class CoefficientSpace_mu: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_mu(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_mu(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_0()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_mu(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_0()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_mu(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_0()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_0()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

};

class CoefficientSpace_u: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_u(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_u(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_u(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_u(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

};

class Form_F_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_F_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_F_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_F_FunctionSpace_0(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_F_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

};

typedef CoefficientSpace_u Form_F_FunctionSpace_1;

typedef CoefficientSpace_B Form_F_FunctionSpace_2;

typedef CoefficientSpace_T Form_F_FunctionSpace_3;

typedef CoefficientSpace_mu Form_F_FunctionSpace_4;

typedef CoefficientSpace_lmbda Form_F_FunctionSpace_5;

class Form_F: public dolfin::Form
{
public:

  // Constructor
  Form_F(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = std::shared_ptr<const ufc::form>(new hyperelasticity_form_0());
  }

  // Constructor
  Form_F(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& u, const dolfin::GenericFunction& B, const dolfin::GenericFunction& T, const dolfin::GenericFunction& mu, const dolfin::GenericFunction& lmbda):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->u = u;
    this->B = B;
    this->T = T;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = std::shared_ptr<const ufc::form>(new hyperelasticity_form_0());
  }

  // Constructor
  Form_F(const dolfin::FunctionSpace& V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> B, std::shared_ptr<const dolfin::GenericFunction> T, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->u = *u;
    this->B = *B;
    this->T = *T;
    this->mu = *mu;
    this->lmbda = *lmbda;

    _ufc_form = std::shared_ptr<const ufc::form>(new hyperelasticity_form_0());
  }

  // Constructor
  Form_F(std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = V0;

    _ufc_form = std::shared_ptr<const ufc::form>(new hyperelasticity_form_0());
  }

  // Constructor
  Form_F(std::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& u, const dolfin::GenericFunction& B, const dolfin::GenericFunction& T, const dolfin::GenericFunction& mu, const dolfin::GenericFunction& lmbda):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = V0;

    this->u = u;
    this->B = B;
    this->T = T;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = std::shared_ptr<const ufc::form>(new hyperelasticity_form_0());
  }

  // Constructor
  Form_F(std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> B, std::shared_ptr<const dolfin::GenericFunction> T, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(1, 5), u(*this, 0), B(*this, 1), T(*this, 2), mu(*this, 3), lmbda(*this, 4)
  {
    _function_spaces[0] = V0;

    this->u = *u;
    this->B = *B;
    this->T = *T;
    this->mu = *mu;
    this->lmbda = *lmbda;

    _ufc_form = std::shared_ptr<const ufc::form>(new hyperelasticity_form_0());
  }

  // Destructor
  ~Form_F()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "B")
      return 1;
    else if (name == "T")
      return 2;
    else if (name == "mu")
      return 3;
    else if (name == "lmbda")
      return 4;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "B";
    case 2:
      return "T";
    case 3:
      return "mu";
    case 4:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_F_FunctionSpace_0 TestSpace;
  typedef Form_F_FunctionSpace_1 CoefficientSpace_u;
  typedef Form_F_FunctionSpace_2 CoefficientSpace_B;
  typedef Form_F_FunctionSpace_3 CoefficientSpace_T;
  typedef Form_F_FunctionSpace_4 CoefficientSpace_mu;
  typedef Form_F_FunctionSpace_5 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::CoefficientAssigner u;
  dolfin::CoefficientAssigner B;
  dolfin::CoefficientAssigner T;
  dolfin::CoefficientAssigner mu;
  dolfin::CoefficientAssigner lmbda;
};

class Form_J_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_J_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_J_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_J_FunctionSpace_0(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_J_FunctionSpace_0(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

};

class Form_J_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_J_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_J_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_J_FunctionSpace_1(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_J_FunctionSpace_1(std::shared_ptr<const dolfin::Mesh> mesh, std::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          std::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(std::shared_ptr<ufc::finite_element>(new hyperelasticity_finite_element_2()))),
                          std::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(std::shared_ptr<ufc::dofmap>(new hyperelasticity_dofmap_2()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

};

typedef CoefficientSpace_u Form_J_FunctionSpace_2;

typedef CoefficientSpace_mu Form_J_FunctionSpace_3;

typedef CoefficientSpace_lmbda Form_J_FunctionSpace_4;

class Form_J: public dolfin::Form
{
public:

  // Constructor
  Form_J(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = std::shared_ptr<const ufc::form>(new hyperelasticity_form_1());
  }

  // Constructor
  Form_J(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& u, const dolfin::GenericFunction& mu, const dolfin::GenericFunction& lmbda):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    this->u = u;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = std::shared_ptr<const ufc::form>(new hyperelasticity_form_1());
  }

  // Constructor
  Form_J(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    this->u = *u;
    this->mu = *mu;
    this->lmbda = *lmbda;

    _ufc_form = std::shared_ptr<const ufc::form>(new hyperelasticity_form_1());
  }

  // Constructor
  Form_J(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = std::shared_ptr<const ufc::form>(new hyperelasticity_form_1());
  }

  // Constructor
  Form_J(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& u, const dolfin::GenericFunction& mu, const dolfin::GenericFunction& lmbda):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->u = u;
    this->mu = mu;
    this->lmbda = lmbda;

    _ufc_form = std::shared_ptr<const ufc::form>(new hyperelasticity_form_1());
  }

  // Constructor
  Form_J(std::shared_ptr<const dolfin::FunctionSpace> V1, std::shared_ptr<const dolfin::FunctionSpace> V0, std::shared_ptr<const dolfin::GenericFunction> u, std::shared_ptr<const dolfin::GenericFunction> mu, std::shared_ptr<const dolfin::GenericFunction> lmbda):
    dolfin::Form(2, 3), u(*this, 0), mu(*this, 1), lmbda(*this, 2)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->u = *u;
    this->mu = *mu;
    this->lmbda = *lmbda;

    _ufc_form = std::shared_ptr<const ufc::form>(new hyperelasticity_form_1());
  }

  // Destructor
  ~Form_J()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "u")
      return 0;
    else if (name == "mu")
      return 1;
    else if (name == "lmbda")
      return 2;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "u";
    case 1:
      return "mu";
    case 2:
      return "lmbda";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_J_FunctionSpace_0 TestSpace;
  typedef Form_J_FunctionSpace_1 TrialSpace;
  typedef Form_J_FunctionSpace_2 CoefficientSpace_u;
  typedef Form_J_FunctionSpace_3 CoefficientSpace_mu;
  typedef Form_J_FunctionSpace_4 CoefficientSpace_lmbda;

  // Coefficients
  dolfin::CoefficientAssigner u;
  dolfin::CoefficientAssigner mu;
  dolfin::CoefficientAssigner lmbda;
};

// Class typedefs
typedef Form_J BilinearForm;
typedef Form_J JacobianForm;
typedef Form_F LinearForm;
typedef Form_F ResidualForm;
typedef Form_F::TestSpace FunctionSpace;

}

#endif
