// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=io, header=GenericFile.h)
%feature("docstring")  dolfin::GenericFile::GenericFile "
Constructor
";

// Documentation extracted from: (module=io, header=File.h)
%feature("docstring")  dolfin::File "
A File represents a data file for reading and writing objects.
Unless specified explicitly, the format is determined by the
file name suffix.
A list of objects that can be read/written to file can be found in
GenericFile.h. Compatible file formats include:
    * Binary (.bin)
    * RAW    (.raw)
    * SVG    (.svg)
    * XD3    (.xd3)
    * XDMF   (.xdmf)
    * XML    (.xml)
    * XYZ    (.xyz)
    * VTK    (.pvd)
";

%feature("docstring")  dolfin::File::Type "
File formats
";

%feature("docstring")  dolfin::File::File "
**Overloaded versions**

* File\ (filename, encoding=\"ascii\")

  Create a file with given name
  
  *Arguments*
      filename (str)
          Name of file.
      encoding (str)
          Optional argument specifying encoding, ASCII is default.
  
  *Example*
      .. note::
      
          No example code available for this function.

* File\ (comm, filename, encoding=\"ascii\")

  Create a file with given name with MPI communicator
  
  *Arguments*
      communicator (:py:class:`MPI`)
          The MPI communicator.
      filename (str)
          Name of file.
      encoding (str)
          Optional argument specifying encoding, ascii is default.
  
  *Example*
      .. note::
      
          No example code available for this function.

* File\ (filename, type, encoding=\"ascii\")

  Create a file with given name and type (format)
  
  *Arguments*
      filename (str)
          Name of file.
      type (Type)
          File format.
      encoding (str)
          Optional argument specifying encoding, ascii is default.
  
  *Example*
      .. note::
      
          No example code available for this function.

* File\ (comm, filename, type, encoding=\"ascii\")

  Create a file with given name and type (format) with MPI communicator
  
  *Arguments*
      communicator (:py:class:`MPI`)
          The MPI communicator.
      filename (str)
          Name of file.
      type (Type)
          File format.
      encoding (str)
          Optional argument specifying encoding, ascii is default.
  
  *Example*
      .. note::
      
          No example code available for this function.

* File\ (outstream)

  Create an outfile object writing to stream
  
  *Arguments*
      outstream (std::ostream)
          The stream.
";

%feature("docstring")  dolfin::File::operator>> "
Read from file
";

%feature("docstring")  dolfin::File::operator<< "
**Overloaded versions**

* operator<<\ (Mesh*, mesh)

  Write Mesh to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (MeshFunction<int>*, f)

  Write MeshFunction to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (f)

  Write MeshFunction to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (MeshFunction<double>*, f)

  Write MeshFunction to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (MeshFunction<bool>*, f)

  Write MeshFunction to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (Function*, u)

  Write Function to file with time
  
  *Example*
      .. note::
      
          No example code available for this function.

* operator<<\ (t)

  Write object to file
";

%feature("docstring")  dolfin::File::exists "
Check if file exists

*Arguments*
    filename (str)
        Name of file.

*Returns*
    bool
        True if the file exists.
";

%feature("docstring")  dolfin::File::create_parent_path "

*Arguments*
    filename (str)
        Name of file / path.
";

// Documentation extracted from: (module=io, header=XDMFFile.h)
%feature("docstring")  dolfin::XDMFFile "
This class supports the output of meshes and functions in XDMF
(http://www.xdmf.org) format. It creates an XML file that describes
the data and points to a HDF5 file that stores the actual problem
data. Output of data in parallel is supported.

XDMF is not suitable for checkpointing as it may decimate
some data.
";

%feature("docstring")  dolfin::XDMFFile::XDMFFile "
Constructor
";

%feature("docstring")  dolfin::XDMFFile::operator<< "
**Overloaded versions**

* operator<<\ (mesh)

  Save a mesh for visualisation, with e.g. ParaView. Creates a HDF5
  file to store the mesh, and a related XDMF file with metadata.

* operator<<\ (u)

  Save a Function to XDMF/HDF5 files for visualisation.

* operator<<\ (Function*, ut)

  Save Function + time stamp to file

* operator<<\ (meshfunction)

  Save MeshFunction to file
";

%feature("docstring")  dolfin::XDMFFile::read "
Read in a mesh from the associated HDF5 file,
optionally using stored partitioning, if possible
when the same number of processes are being used.
";

%feature("docstring")  dolfin::XDMFFile::operator>> "
**Overloaded versions**

* operator>>\ (mesh)

  Read in a mesh from the associated HDF5 file

* operator>>\ (meshfunction)

  Read first MeshFunction from file
";

%feature("docstring")  dolfin::XDMFFile::write_quadratic "
Save a quadratic Function to a quadratic Mesh defined
by a geometry Function
";

%feature("docstring")  dolfin::XDMFFile::write "
**Overloaded versions**

* write\ (points)

  Save a cloud of points to file

* write\ (points, values)

  Save a cloud of points, with scalar values
";

// Documentation extracted from: (module=io, header=HDF5File.h)
%feature("docstring")  dolfin::HDF5File::HDF5File "
Constructor. file_mode should \"a\" (append), \"w\" (write) or \"r\"
(read).
";

%feature("docstring")  dolfin::HDF5File::close "
Close file
";

%feature("docstring")  dolfin::HDF5File::write "
**Overloaded versions**

* write\ (points, name)

  Write points to file

* write\ (values, name)

  Write simple vector of double to file

* write\ (x, name)

  Write Vector to file in a format suitable for re-reading

* write\ (mesh, name)

  Write Mesh to file in a format suitable for re-reading

* write\ (mesh, cell_dim, name)

  Write Mesh of given cell dimension to file in a format
  suitable for re-reading

* write\ (u, name)

  Write Function to file in a format suitable for re-reading

* write\ (u, name, timestamp)

  Write Function to file with a timestamp

* write\ (meshfunction, name)

  Write MeshFunction to file in a format suitable for re-reading

* write\ (meshfunction, name)

  Write MeshFunction to file in a format suitable for re-reading

* write\ (meshfunction, name)

  Write MeshFunction to file in a format suitable for re-reading

* write\ (meshfunction, name)

  Write MeshFunction to file in a format suitable for re-reading

* write\ (mesh_values, name)

  Write MeshValueCollection to file

* write\ (mesh_values, name)

  Write MeshValueCollection to file

* write\ (mesh_values, name)

  Write MeshValueCollection to file
";

%feature("docstring")  dolfin::HDF5File::read "
**Overloaded versions**

* read\ (x, dataset_name, use_partition_from_file)

  Read vector from file and optionally re-use any partitioning
  that is available in the file

* read\ (u, name)

  Read Function from file and distribute data according to
  the Mesh and dofmap associated with the Function.
  If the 'name' refers to a HDF5 group, then it is assumed
  that the Function data is stored in the datasets within that group.
  If the 'name' refers to a HDF5 dataset within a group, then
  it is assumed that it is a Vector, and the Function will be filled from
  that Vector

* read\ (mesh, name, use_partition_from_file)

  Read Mesh from file and optionally re-use any partition data
  in the file

* read\ (meshfunction, name)

  Read MeshFunction from file

* read\ (meshfunction, name)

  Read MeshFunction from file

* read\ (meshfunction, name)

  Read MeshFunction from file

* read\ (meshfunction, name)

  Read MeshFunction from file

* read\ (mesh_values, name)

  Read MeshValueCollection from file

* read\ (mesh_values, name)

  Read MeshValueCollection from file

* read\ (mesh_values, name)

  Read MeshValueCollection from file
";

%feature("docstring")  dolfin::HDF5File::has_dataset "
Check if dataset exists in HDF5 file
";

%feature("docstring")  dolfin::HDF5File::flush "
Flush buffered I/O to disk
";

// Documentation extracted from: (module=io, header=HDF5Attribute.h)
%feature("docstring")  dolfin::HDF5Attribute "
HDF5Attribute gives access to the attributes of a dataset
via set() and get() methods
";

%feature("docstring")  dolfin::HDF5Attribute::HDF5Attribute "
Constructor
";

%feature("docstring")  dolfin::HDF5Attribute::exists "
Check for the existence of an attribute on a dataset
";

%feature("docstring")  dolfin::HDF5Attribute::set "
**Overloaded versions**

* set\ (attribute_name, value)

  Set the value of a double attribute in the HDF5 file

* set\ (attribute_name, value)

  Set the value of a double attribute in the HDF5 file

* set\ (attribute_name, value)

  Set the value of an array of float attribute in the HDF5 file

* set\ (attribute_name, value)

  Set the value of an array of float attribute in the HDF5 file

* set\ (attribute_name, value)

  Set the value of a string attribute in the HDF5 file
";

%feature("docstring")  dolfin::HDF5Attribute::get "
**Overloaded versions**

* get\ (attribute_name, value)

  Set the value of a double attribute in the HDF5 file

* get\ (attribute_name, value)

  Get the value of a vector double attribute in the HDF5 file

* get\ (attribute_name, value)

  Set the value of a double attribute in the HDF5 file

* get\ (attribute_name, value)

  Get the value of a vector double attribute in the HDF5 file

* get\ (attribute_name, value)

  Get the value of an attribute in the HDF5 file as a string
";

%feature("docstring")  dolfin::HDF5Attribute::str "
**Overloaded versions**

* str\ (attribute_name)

  Get the value of the attribute in the HDF5 file
  as a string representation

* str\ ()

  Get the names of all the attributes on this dataset
";

%feature("docstring")  dolfin::HDF5Attribute::type_str "
Get the type of the attribute \"string\", \"float\", \"int\"
\"vectorfloat\", \"vectorint\" or \"unsupported\"
";

%feature("docstring")  dolfin::HDF5Attribute::list_attributes "
Get the names of all the attributes on this dataset as a
std::vector<std::string>
";

