"""
This module contains compiletime information about the dolfin python
library, which can be utelized at runtime.

The file is automatically generated by the generateswigcode.py script
in the dolfin/swig directory."""

try:
    from collections import OrderedDict
except ImportError:
    from dolfin_utils.ordereddict import OrderedDict

# A list of shared_ptr declared classes in dolfin
shared_ptr_classes = ['AdaptiveLinearVariationalSolver', 'AdaptiveNonlinearVariationalSolver', 'ErrorControl', 'Hierarchical<dolfin::ErrorControl>', 'GenericAdaptiveVariationalSolver', 'GoalFunctional', 'SpecialFacetFunction', 'TimeSeries', 'TimeSeriesHDF5', 'MeshDisplacement', 'Variable', 'Hierarchical<dolfin::Form>', 'GenericDofMap', 'DofMap', 'MultiMeshDofMap', 'Form', 'FiniteElement', 'BasisFunction', 'MultiStageScheme', 'Hierarchical<dolfin::LinearVariationalProblem>', 'Hierarchical<dolfin::NonlinearVariationalProblem>', 'LinearVariationalProblem', 'NonlinearVariationalProblem', 'LinearVariationalSolver', 'NonlinearVariationalSolver', 'PointIntegralSolver', 'Hierarchical<dolfin::DirichletBC>', 'DirichletBC', 'Hierarchical<dolfin::FunctionSpace>', 'FunctionSpace', 'SubSpace', 'GenericFunction', 'Hierarchical<dolfin::Function>', 'Function', 'Expression', 'FacetArea', 'Constant', 'MeshCoordinates', 'MultiMeshFunctionSpace', 'MultiMeshSubSpace', 'BoundingBoxTree', 'Hierarchical<dolfin::Mesh>', 'BoundaryMesh', 'Mesh', 'Restriction', 'SubMesh', 'UnitTetrahedronMesh', 'UnitCubeMesh', 'UnitIntervalMesh', 'IntervalMesh', 'UnitTriangleMesh', 'UnitSquareMesh', 'UnitQuadMesh', 'UnitHexMesh', 'BoxMesh', 'Box', 'RectangleMesh', 'Rectangle', 'MultiMesh', 'SubDomain', 'DomainBoundary', 'LocalMeshData', 'MeshData', 'MeshHierarchy', 'Hierarchical<dolfin::MeshFunction<std::size_t> >', 'MeshFunction<std::size_t>', 'CellFunction<std::size_t>', 'EdgeFunction<std::size_t>', 'FaceFunction<std::size_t>', 'FacetFunction<std::size_t>', 'VertexFunction<std::size_t>', 'Parameters', 'GlobalParameters', 'GenericLinearOperator', 'GenericMatrix', 'GenericPreconditioner', 'GenericTensor', 'GenericVector', 'LinearAlgebraObject', 'Scalar', 'Matrix', 'Vector', 'LinearOperator', 'STLMatrix', 'EigenKrylovSolver', 'EigenLUSolver', 'EigenMatrix', 'EigenVector', 'PETScBaseMatrix', 'PETScLinearOperator', 'PETScKrylovSolver', 'PETScLUSolver', 'PETScMatrix', 'PETScObject', 'PETScPreconditioner', 'PETScVector', 'PETScUserPreconditioner', 'TpetraVector', 'TpetraMatrix', 'BelosKrylovSolver', 'SLEPcEigenSolver', 'PaStiXLUSolver', 'UmfpackLUSolver', 'CholmodCholeskySolver', 'LinearSolver', 'GenericLinearSolver', 'GenericLUSolver', 'KrylovSolver', 'LUSolver', 'TensorLayout', 'GenericSparsityPattern', 'SparsityPattern', 'Table', 'GenericFile', 'File', 'XDMFFile', 'HDF5File', 'Lagrange', 'NewtonSolver', 'PETScSNESSolver', 'TAOLinearBoundSolver', 'PETScTAOSolver', 'VTKPlotter', 'GenericVTKPlottable', 'VTKPlottableMesh', 'VTKPlottableGenericFunction', 'VTKPlottableMeshFunction', 'ExpressionWrapper', 'Quadrature', 'LobattoQuadrature', 'RadauQuadrature', 'GaussQuadrature', 'GaussianQuadrature', 'MeshPointIntersection']

# An OrderedDict of all dolfin declared and its meta info
dolfin_type_def = OrderedDict([\
('ufc::function', {'header': 'ufc.h', 'submodule': '', 'derived': ['Function', 'MeshDisplacement', 'BasisFunction', 'GenericFunction', 'SpecialFacetFunction', 'MeshCoordinates', 'Constant', 'Expression', 'FacetArea'], 'bases': [], 'module': ''}),
('la_index', {'header': 'dolfin/common/types.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('TimingClear', {'header': 'dolfin/common/timing.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('TimingType', {'header': 'dolfin/common/timing.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('Array', {'header': 'dolfin/common/Array.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('ArrayView', {'header': 'dolfin/common/ArrayView.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('IndexSet', {'header': 'dolfin/common/IndexSet.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('Set', {'header': 'dolfin/common/Set.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('Timer', {'header': 'dolfin/common/Timer.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('Variable', {'header': 'dolfin/common/Variable.h', 'submodule': 'common', 'derived': ['GenericDofMap', 'PETScVector', 'PETScLUSolver', 'EigenKrylovSolver', 'VTKPlotter', 'UnitIntervalMesh', 'GenericLinearOperator', 'FacetFunction', 'GenericTensor', 'FaceFunction', 'AdaptiveNonlinearVariationalSolver', 'UnitSquareMesh', 'BelosKrylovSolver', 'UnitHexMesh', 'XDMFFile', 'Scalar', 'SparsityPattern', 'MeshCoordinates', 'LinearVariationalSolver', 'LinearAlgebraObject', 'GenericSparsityPattern', 'BoundaryMesh', 'AdaptiveLinearVariationalSolver', 'EigenMatrix', 'CellFunction', 'LUSolver', 'BoxMesh', 'SubMesh', 'LinearOperator', 'LinearSolver', 'PETScLinearOperator', 'UnitTetrahedronMesh', 'Lagrange', 'EigenLUSolver', 'Vector', 'MeshValueCollection', 'KrylovSolver', 'GenericLUSolver', 'MeshDisplacement', 'PETScPreconditioner', 'TpetraMatrix', 'Matrix', 'GenericVector', 'VertexFunction', 'MultiStageScheme', 'LocalMeshData', 'GenericMatrix', 'Mesh', 'IntervalMesh', 'MultiMesh', 'MUMPSLUSolver', 'HDF5File', 'TpetraVector', 'SpecialFacetFunction', 'Constant', 'Expression', 'UnitQuadMesh', 'RectangleMesh', 'PETScMatrix', 'DofMap', 'GenericLinearSolver', 'TensorLayout', 'SLEPcEigenSolver', 'UnitCubeMesh', 'SubSpace', 'PointIntegralSolver', 'GenericAdaptiveVariationalSolver', 'ErrorControl', 'DirichletBC', 'EdgeFunction', 'Function', 'UnitTriangleMesh', 'STLMatrix', 'MultiMeshSubSpace', 'PETScBaseMatrix', 'MeshFunction', 'TAOLinearBoundSolver', 'PETScKrylovSolver', 'TimeSeries', 'PaStiXLUSolver', 'FacetArea', 'GenericFunction', 'NewtonSolver', 'MultiMeshFunctionSpace', 'FunctionSpace', 'Table', 'NonlinearVariationalSolver', 'EigenVector', 'MeshData'], 'bases': [], 'module': 'common'}),
('Hierarchical', {'header': 'dolfin/common/Hierarchical.h', 'submodule': 'common', 'derived': ['UnitCubeMesh', 'BoundaryMesh', 'SubSpace', 'UnitQuadMesh', 'LinearVariationalProblem', 'GoalFunctional', 'ErrorControl', 'VertexFunction', 'DirichletBC', 'EdgeFunction', 'Function', 'Form', 'UnitIntervalMesh', 'UnitTriangleMesh', 'CellFunction', 'Mesh', 'BoxMesh', 'IntervalMesh', 'SubMesh', 'MeshFunction', 'FacetFunction', 'UnitTetrahedronMesh', 'FaceFunction', 'UnitSquareMesh', 'UnitHexMesh', 'NonlinearVariationalProblem', 'RectangleMesh', 'FunctionSpace'], 'bases': [], 'module': 'common'}),
('MPI_Comm', {'header': 'dolfin/common/MPI.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('MPI', {'header': 'dolfin/common/MPI.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('MPIInfo', {'header': 'dolfin/common/MPI.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('SubSystemsManager', {'header': 'dolfin/common/SubSystemsManager.h', 'submodule': 'common', 'derived': [], 'bases': [], 'module': 'common'}),
('IntParameter', {'header': 'dolfin/parameter/Parameter.h', 'submodule': 'parameter', 'derived': [], 'bases': ['Parameter'], 'module': 'common'}),
('BoolParameter', {'header': 'dolfin/parameter/Parameter.h', 'submodule': 'parameter', 'derived': [], 'bases': ['Parameter'], 'module': 'common'}),
('StringParameter', {'header': 'dolfin/parameter/Parameter.h', 'submodule': 'parameter', 'derived': [], 'bases': ['Parameter'], 'module': 'common'}),
('Parameter', {'header': 'dolfin/parameter/Parameter.h', 'submodule': 'parameter', 'derived': ['IntParameter', 'BoolParameter', 'StringParameter', 'DoubleParameter'], 'bases': [], 'module': 'common'}),
('DoubleParameter', {'header': 'dolfin/parameter/Parameter.h', 'submodule': 'parameter', 'derived': [], 'bases': ['Parameter'], 'module': 'common'}),
('Parameters', {'header': 'dolfin/parameter/Parameters.h', 'submodule': 'parameter', 'derived': ['GlobalParameters'], 'bases': [], 'module': 'common'}),
('GlobalParameters', {'header': 'dolfin/parameter/GlobalParameters.h', 'submodule': 'parameter', 'derived': [], 'bases': ['Parameters'], 'module': 'common'}),
('Event', {'header': 'dolfin/log/Event.h', 'submodule': 'log', 'derived': [], 'bases': [], 'module': 'common'}),
('Progress', {'header': 'dolfin/log/Progress.h', 'submodule': 'log', 'derived': [], 'bases': [], 'module': 'common'}),
('Table', {'header': 'dolfin/log/Table.h', 'submodule': 'log', 'derived': [], 'bases': ['Variable'], 'module': 'common'}),
('TableEntry', {'header': 'dolfin/log/Table.h', 'submodule': 'log', 'derived': [], 'bases': [], 'module': 'common'}),
('CellType', {'header': 'dolfin/mesh/CellType.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshTopology', {'header': 'dolfin/mesh/MeshTopology.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshGeometry', {'header': 'dolfin/mesh/MeshGeometry.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshDomains', {'header': 'dolfin/mesh/MeshDomains.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshData', {'header': 'dolfin/mesh/MeshData.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable'], 'module': 'mesh'}),
('Mesh', {'header': 'dolfin/mesh/Mesh.h', 'submodule': 'mesh', 'derived': ['UnitCubeMesh', 'BoundaryMesh', 'UnitTetrahedronMesh', 'UnitTriangleMesh', 'UnitQuadMesh', 'UnitSquareMesh', 'UnitHexMesh', 'BoxMesh', 'IntervalMesh', 'UnitIntervalMesh', 'SubMesh', 'RectangleMesh'], 'bases': ['Variable', 'Hierarchical'], 'module': 'mesh'}),
('MeshEntity', {'header': 'dolfin/mesh/MeshEntity.h', 'submodule': 'mesh', 'derived': ['Cell', 'Vertex', 'Face', 'Facet', 'Edge', 'FacetCell'], 'bases': [], 'module': 'mesh'}),
('MeshEntityIterator', {'header': 'dolfin/mesh/MeshEntityIterator.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshEntityIteratorBase', {'header': 'dolfin/mesh/MeshEntityIteratorBase.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('SubsetIterator', {'header': 'dolfin/mesh/SubsetIterator.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('VertexIterator', {'header': 'dolfin/mesh/Vertex.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('VertexFunction', {'header': 'dolfin/mesh/Vertex.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Hierarchical', 'MeshFunction'], 'module': 'mesh'}),
('Vertex', {'header': 'dolfin/mesh/Vertex.h', 'submodule': 'mesh', 'derived': [], 'bases': ['MeshEntity'], 'module': 'mesh'}),
('EdgeIterator', {'header': 'dolfin/mesh/Edge.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('Edge', {'header': 'dolfin/mesh/Edge.h', 'submodule': 'mesh', 'derived': [], 'bases': ['MeshEntity'], 'module': 'mesh'}),
('EdgeFunction', {'header': 'dolfin/mesh/Edge.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Hierarchical', 'MeshFunction'], 'module': 'mesh'}),
('FaceIterator', {'header': 'dolfin/mesh/Face.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('FaceFunction', {'header': 'dolfin/mesh/Face.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Hierarchical', 'MeshFunction'], 'module': 'mesh'}),
('Face', {'header': 'dolfin/mesh/Face.h', 'submodule': 'mesh', 'derived': [], 'bases': ['MeshEntity'], 'module': 'mesh'}),
('FacetIterator', {'header': 'dolfin/mesh/Facet.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('Facet', {'header': 'dolfin/mesh/Facet.h', 'submodule': 'mesh', 'derived': [], 'bases': ['MeshEntity'], 'module': 'mesh'}),
('FacetFunction', {'header': 'dolfin/mesh/Facet.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Hierarchical', 'MeshFunction'], 'module': 'mesh'}),
('CellIterator', {'header': 'dolfin/mesh/Cell.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('Cell', {'header': 'dolfin/mesh/Cell.h', 'submodule': 'mesh', 'derived': ['FacetCell'], 'bases': ['MeshEntity'], 'module': 'mesh'}),
('CellFunction', {'header': 'dolfin/mesh/Cell.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Hierarchical', 'MeshFunction'], 'module': 'mesh'}),
('FacetCell', {'header': 'dolfin/mesh/FacetCell.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Cell', 'MeshEntity'], 'module': 'mesh'}),
('MeshConnectivity', {'header': 'dolfin/mesh/MeshConnectivity.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshEditor', {'header': 'dolfin/mesh/MeshEditor.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('DynamicMeshEditor', {'header': 'dolfin/mesh/DynamicMeshEditor.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('LocalMeshValueCollection', {'header': 'dolfin/mesh/LocalMeshValueCollection.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshFunction', {'header': 'dolfin/mesh/MeshFunction.h', 'submodule': 'mesh', 'derived': ['VertexFunction', 'FacetFunction', 'FaceFunction', 'CellFunction', 'EdgeFunction'], 'bases': ['Variable', 'Hierarchical'], 'module': 'mesh'}),
('MeshValueCollection', {'header': 'dolfin/mesh/MeshValueCollection.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable'], 'module': 'mesh'}),
('MeshColoring', {'header': 'dolfin/mesh/MeshColoring.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshRenumbering', {'header': 'dolfin/mesh/MeshRenumbering.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshTransformation', {'header': 'dolfin/mesh/MeshTransformation.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('LocalMeshData', {'header': 'dolfin/mesh/LocalMeshData.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable'], 'module': 'mesh'}),
('SubDomain', {'header': 'dolfin/mesh/SubDomain.h', 'submodule': 'mesh', 'derived': ['DomainBoundary'], 'bases': [], 'module': 'mesh'}),
('SubMesh', {'header': 'dolfin/mesh/SubMesh.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('Restriction', {'header': 'dolfin/mesh/Restriction.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('DomainBoundary', {'header': 'dolfin/mesh/DomainBoundary.h', 'submodule': 'mesh', 'derived': [], 'bases': ['SubDomain'], 'module': 'mesh'}),
('BoundaryMesh', {'header': 'dolfin/mesh/BoundaryMesh.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('PeriodicBoundaryComputation', {'header': 'dolfin/mesh/PeriodicBoundaryComputation.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshQuality', {'header': 'dolfin/mesh/MeshQuality.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('quadrature_rule', {'header': 'dolfin/mesh/MultiMesh.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MultiMesh', {'header': 'dolfin/mesh/MultiMesh.h', 'submodule': 'mesh', 'derived': [], 'bases': ['Variable'], 'module': 'mesh'}),
('MeshHierarchy', {'header': 'dolfin/mesh/MeshHierarchy.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('MeshPartitioning', {'header': 'dolfin/mesh/MeshPartitioning.h', 'submodule': 'mesh', 'derived': [], 'bases': [], 'module': 'mesh'}),
('BoxMesh', {'header': 'dolfin/generation/BoxMesh.h', 'submodule': 'generation', 'derived': ['UnitCubeMesh'], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('IntervalMesh', {'header': 'dolfin/generation/IntervalMesh.h', 'submodule': 'generation', 'derived': ['UnitIntervalMesh'], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('RectangleMesh', {'header': 'dolfin/generation/RectangleMesh.h', 'submodule': 'generation', 'derived': ['UnitSquareMesh'], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitTetrahedronMesh', {'header': 'dolfin/generation/UnitTetrahedronMesh.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitCubeMesh', {'header': 'dolfin/generation/UnitCubeMesh.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'Mesh', 'Hierarchical', 'BoxMesh'], 'module': 'mesh'}),
('UnitIntervalMesh', {'header': 'dolfin/generation/UnitIntervalMesh.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'Mesh', 'IntervalMesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitTriangleMesh', {'header': 'dolfin/generation/UnitTriangleMesh.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitSquareMesh', {'header': 'dolfin/generation/UnitSquareMesh.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'RectangleMesh', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitQuadMesh', {'header': 'dolfin/generation/UnitQuadMesh.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('UnitHexMesh', {'header': 'dolfin/generation/UnitHexMesh.h', 'submodule': 'generation', 'derived': [], 'bases': ['Variable', 'Mesh', 'Hierarchical'], 'module': 'mesh'}),
('Point', {'header': 'dolfin/geometry/Point.h', 'submodule': 'geometry', 'derived': [], 'bases': [], 'module': 'mesh'}),
('BoundingBoxTree', {'header': 'dolfin/geometry/BoundingBoxTree.h', 'submodule': 'geometry', 'derived': [], 'bases': [], 'module': 'mesh'}),
('GenericBoundingBoxTree', {'header': 'dolfin/geometry/GenericBoundingBoxTree.h', 'submodule': 'geometry', 'derived': ['BoundingBoxTree3D'], 'bases': [], 'module': 'mesh'}),
('BoundingBoxTree3D', {'header': 'dolfin/geometry/BoundingBoxTree3D.h', 'submodule': 'geometry', 'derived': [], 'bases': ['GenericBoundingBoxTree'], 'module': 'mesh'}),
('MeshPointIntersection', {'header': 'dolfin/geometry/MeshPointIntersection.h', 'submodule': 'geometry', 'derived': [], 'bases': [], 'module': 'mesh'}),
('graph_set_type', {'header': 'dolfin/graph/Graph.h', 'submodule': 'graph', 'derived': [], 'bases': [], 'module': 'mesh'}),
('Graph', {'header': 'dolfin/graph/Graph.h', 'submodule': 'graph', 'derived': [], 'bases': [], 'module': 'mesh'}),
('GraphBuilder', {'header': 'dolfin/graph/GraphBuilder.h', 'submodule': 'graph', 'derived': [], 'bases': [], 'module': 'mesh'}),
('BoostGraphOrdering', {'header': 'dolfin/graph/BoostGraphOrdering.h', 'submodule': 'graph', 'derived': [], 'bases': [], 'module': 'mesh'}),
('SCOTCH', {'header': 'dolfin/graph/SCOTCH.h', 'submodule': 'graph', 'derived': [], 'bases': [], 'module': 'mesh'}),
('E', {'header': 'dolfin/la/LinearAlgebraObject.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('LinearAlgebraObject', {'header': 'dolfin/la/LinearAlgebraObject.h', 'submodule': 'la', 'derived': ['GenericVector', 'Matrix', 'GenericMatrix', 'EigenMatrix', 'GenericTensor', 'LinearOperator', 'PETScMatrix', 'PETScVector', 'STLMatrix', 'Scalar', 'Vector', 'TpetraVector', 'TpetraMatrix', 'GenericLinearOperator', 'EigenVector', 'PETScLinearOperator'], 'bases': ['Variable'], 'module': 'la'}),
('GenericLinearOperator', {'header': 'dolfin/la/GenericLinearOperator.h', 'submodule': 'la', 'derived': ['Matrix', 'STLMatrix', 'EigenMatrix', 'PETScMatrix', 'GenericMatrix', 'LinearOperator', 'TpetraMatrix', 'PETScLinearOperator'], 'bases': ['Variable', 'LinearAlgebraObject'], 'module': 'la'}),
('GenericTensor', {'header': 'dolfin/la/GenericTensor.h', 'submodule': 'la', 'derived': ['GenericVector', 'Matrix', 'STLMatrix', 'EigenMatrix', 'PETScMatrix', 'PETScVector', 'GenericMatrix', 'Scalar', 'Vector', 'TpetraVector', 'TpetraMatrix', 'EigenVector'], 'bases': ['Variable', 'LinearAlgebraObject'], 'module': 'la'}),
('GenericMatrix', {'header': 'dolfin/la/GenericMatrix.h', 'submodule': 'la', 'derived': ['EigenMatrix', 'STLMatrix', 'TpetraMatrix', 'PETScMatrix', 'Matrix'], 'bases': ['Variable', 'GenericTensor', 'LinearAlgebraObject', 'GenericLinearOperator'], 'module': 'la'}),
('GenericSparsityPattern', {'header': 'dolfin/la/GenericSparsityPattern.h', 'submodule': 'la', 'derived': ['SparsityPattern'], 'bases': ['Variable'], 'module': 'la'}),
('GenericVector', {'header': 'dolfin/la/GenericVector.h', 'submodule': 'la', 'derived': ['Vector', 'TpetraVector', 'EigenVector', 'PETScVector'], 'bases': ['Variable', 'GenericTensor', 'LinearAlgebraObject'], 'module': 'la'}),
('VectorSpaceBasis', {'header': 'dolfin/la/VectorSpaceBasis.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('GenericLinearSolver', {'header': 'dolfin/la/GenericLinearSolver.h', 'submodule': 'la', 'derived': ['GenericLUSolver', 'LinearSolver', 'EigenKrylovSolver', 'PETScKrylovSolver', 'PETScLUSolver', 'EigenLUSolver', 'LUSolver', 'BelosKrylovSolver', 'KrylovSolver'], 'bases': ['Variable'], 'module': 'la'}),
('GenericLUSolver', {'header': 'dolfin/la/GenericLUSolver.h', 'submodule': 'la', 'derived': ['PETScLUSolver', 'EigenLUSolver', 'LUSolver'], 'bases': ['Variable', 'GenericLinearSolver'], 'module': 'la'}),
('GenericPreconditioner', {'header': 'dolfin/la/GenericPreconditioner.h', 'submodule': 'la', 'derived': ['PETScPreconditioner'], 'bases': [], 'module': 'la'}),
('PETScOptions', {'header': 'dolfin/la/PETScOptions.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('PETScObject', {'header': 'dolfin/la/PETScObject.h', 'submodule': 'la', 'derived': ['PETScUserPreconditioner', 'PETScLinearOperator', 'PETScPreconditioner', 'PETScMatrix', 'PETScKrylovSolver', 'PETScVector', 'PETScLUSolver', 'PETScSNESSolver', 'PETScTAOSolver', 'PETScBaseMatrix', 'TAOLinearBoundSolver', 'SLEPcEigenSolver'], 'bases': [], 'module': 'la'}),
('PETScBaseMatrix', {'header': 'dolfin/la/PETScBaseMatrix.h', 'submodule': 'la', 'derived': ['PETScMatrix', 'PETScLinearOperator'], 'bases': ['Variable', 'PETScObject'], 'module': 'la'}),
('EigenMatrix', {'header': 'dolfin/la/EigenMatrix.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericMatrix', 'LinearAlgebraObject', 'GenericLinearOperator', 'GenericTensor'], 'module': 'la'}),
('PETScMatrix', {'header': 'dolfin/la/PETScMatrix.h', 'submodule': 'la', 'derived': [], 'bases': ['LinearAlgebraObject', 'GenericTensor', 'GenericLinearOperator', 'PETScObject', 'GenericMatrix', 'Variable', 'PETScBaseMatrix'], 'module': 'la'}),
('PETScLinearOperator', {'header': 'dolfin/la/PETScLinearOperator.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'PETScBaseMatrix', 'LinearAlgebraObject', 'GenericLinearOperator', 'PETScObject'], 'module': 'la'}),
('PETScPreconditioner', {'header': 'dolfin/la/PETScPreconditioner.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericPreconditioner', 'PETScObject'], 'module': 'la'}),
('TpetraMatrix', {'header': 'dolfin/la/TpetraMatrix.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericMatrix', 'LinearAlgebraObject', 'GenericLinearOperator', 'GenericTensor'], 'module': 'la'}),
('EigenKrylovSolver', {'header': 'dolfin/la/EigenKrylovSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericLinearSolver'], 'module': 'la'}),
('EigenLUSolver', {'header': 'dolfin/la/EigenLUSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLUSolver', 'Variable', 'GenericLinearSolver'], 'module': 'la'}),
('PETScKrylovSolver', {'header': 'dolfin/la/PETScKrylovSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericLinearSolver', 'PETScObject'], 'module': 'la'}),
('PETScLUSolver', {'header': 'dolfin/la/PETScLUSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLUSolver', 'Variable', 'GenericLinearSolver', 'PETScObject'], 'module': 'la'}),
('BelosKrylovSolver', {'header': 'dolfin/la/BelosKrylovSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericLinearSolver'], 'module': 'la'}),
('MUMPSLUSolver', {'header': 'dolfin/la/MUMPSLUSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable'], 'module': 'la'}),
('PaStiXLUSolver', {'header': 'dolfin/la/PaStiXLUSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable'], 'module': 'la'}),
('STLMatrix', {'header': 'dolfin/la/STLMatrix.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericMatrix', 'LinearAlgebraObject', 'GenericLinearOperator', 'GenericTensor'], 'module': 'la'}),
('CoordinateMatrix', {'header': 'dolfin/la/CoordinateMatrix.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('EigenVector', {'header': 'dolfin/la/EigenVector.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericTensor', 'GenericVector', 'LinearAlgebraObject'], 'module': 'la'}),
('PETScVector', {'header': 'dolfin/la/PETScVector.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericTensor', 'GenericVector', 'LinearAlgebraObject', 'PETScObject'], 'module': 'la'}),
('TpetraVector', {'header': 'dolfin/la/TpetraVector.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericTensor', 'GenericVector', 'LinearAlgebraObject'], 'module': 'la'}),
('TensorLayout', {'header': 'dolfin/la/TensorLayout.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable'], 'module': 'la'}),
('SparsityPattern', {'header': 'dolfin/la/SparsityPattern.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericSparsityPattern'], 'module': 'la'}),
('GenericLinearAlgebraFactory', {'header': 'dolfin/la/GenericLinearAlgebraFactory.h', 'submodule': 'la', 'derived': ['DefaultFactory', 'PETScFactory', 'EigenFactory', 'STLFactory'], 'bases': [], 'module': 'la'}),
('DefaultFactory', {'header': 'dolfin/la/DefaultFactory.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLinearAlgebraFactory'], 'module': 'la'}),
('EigenFactory', {'header': 'dolfin/la/EigenFactory.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLinearAlgebraFactory'], 'module': 'la'}),
('PETScUserPreconditioner', {'header': 'dolfin/la/PETScUserPreconditioner.h', 'submodule': 'la', 'derived': [], 'bases': ['PETScObject'], 'module': 'la'}),
('PETScFactory', {'header': 'dolfin/la/PETScFactory.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLinearAlgebraFactory'], 'module': 'la'}),
('STLFactory', {'header': 'dolfin/la/STLFactory.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLinearAlgebraFactory'], 'module': 'la'}),
('SLEPcEigenSolver', {'header': 'dolfin/la/SLEPcEigenSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'PETScObject'], 'module': 'la'}),
('Vector', {'header': 'dolfin/la/Vector.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericTensor', 'GenericVector', 'LinearAlgebraObject'], 'module': 'la'}),
('Matrix', {'header': 'dolfin/la/Matrix.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericMatrix', 'LinearAlgebraObject', 'GenericLinearOperator', 'GenericTensor'], 'module': 'la'}),
('Scalar', {'header': 'dolfin/la/Scalar.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericTensor', 'LinearAlgebraObject'], 'module': 'la'}),
('LinearSolver', {'header': 'dolfin/la/LinearSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericLinearSolver'], 'module': 'la'}),
('KrylovSolver', {'header': 'dolfin/la/KrylovSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'GenericLinearSolver'], 'module': 'la'}),
('LUSolver', {'header': 'dolfin/la/LUSolver.h', 'submodule': 'la', 'derived': [], 'bases': ['GenericLUSolver', 'Variable', 'GenericLinearSolver'], 'module': 'la'}),
('BlockVector', {'header': 'dolfin/la/BlockVector.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('BlockMatrix', {'header': 'dolfin/la/BlockMatrix.h', 'submodule': 'la', 'derived': [], 'bases': [], 'module': 'la'}),
('LinearOperator', {'header': 'dolfin/la/LinearOperator.h', 'submodule': 'la', 'derived': [], 'bases': ['Variable', 'LinearAlgebraObject', 'GenericLinearOperator'], 'module': 'la'}),
('NonlinearProblem', {'header': 'dolfin/nls/NonlinearProblem.h', 'submodule': 'nls', 'derived': ['OptimisationProblem'], 'bases': [], 'module': 'la'}),
('NewtonSolver', {'header': 'dolfin/nls/NewtonSolver.h', 'submodule': 'nls', 'derived': [], 'bases': ['Variable'], 'module': 'la'}),
('OptimisationProblem', {'header': 'dolfin/nls/OptimisationProblem.h', 'submodule': 'nls', 'derived': [], 'bases': ['NonlinearProblem'], 'module': 'la'}),
('PETScSNESSolver', {'header': 'dolfin/nls/PETScSNESSolver.h', 'submodule': 'nls', 'derived': [], 'bases': ['PETScObject'], 'module': 'la'}),
('PETScTAOSolver', {'header': 'dolfin/nls/PETScTAOSolver.h', 'submodule': 'nls', 'derived': [], 'bases': ['PETScObject'], 'module': 'la'}),
('TAOLinearBoundSolver', {'header': 'dolfin/nls/TAOLinearBoundSolver.h', 'submodule': 'nls', 'derived': [], 'bases': ['Variable', 'PETScObject'], 'module': 'la'}),
('GenericFunction', {'header': 'dolfin/function/GenericFunction.h', 'submodule': 'function', 'derived': ['Function', 'MeshDisplacement', 'Constant', 'SpecialFacetFunction', 'MeshCoordinates', 'Expression', 'FacetArea'], 'bases': ['Variable', 'ufc::function'], 'module': 'function'}),
('Expression', {'header': 'dolfin/function/Expression.h', 'submodule': 'function', 'derived': ['MeshDisplacement', 'FacetArea', 'Constant', 'SpecialFacetFunction', 'MeshCoordinates'], 'bases': ['Variable', 'ufc::function', 'GenericFunction'], 'module': 'function'}),
('FunctionAXPY', {'header': 'dolfin/function/FunctionAXPY.h', 'submodule': 'function', 'derived': [], 'bases': [], 'module': 'function'}),
('Function', {'header': 'dolfin/function/Function.h', 'submodule': 'function', 'derived': [], 'bases': ['Variable', 'ufc::function', 'Hierarchical', 'GenericFunction'], 'module': 'function'}),
('FunctionSpace', {'header': 'dolfin/function/FunctionSpace.h', 'submodule': 'function', 'derived': ['SubSpace'], 'bases': ['Variable', 'Hierarchical'], 'module': 'function'}),
('SubSpace', {'header': 'dolfin/function/SubSpace.h', 'submodule': 'function', 'derived': [], 'bases': ['Variable', 'Hierarchical', 'FunctionSpace'], 'module': 'function'}),
('Constant', {'header': 'dolfin/function/Constant.h', 'submodule': 'function', 'derived': [], 'bases': ['Variable', 'ufc::function', 'Expression', 'GenericFunction'], 'module': 'function'}),
('FacetArea', {'header': 'dolfin/function/SpecialFunctions.h', 'submodule': 'function', 'derived': [], 'bases': ['Variable', 'ufc::function', 'Expression', 'GenericFunction'], 'module': 'function'}),
('MeshCoordinates', {'header': 'dolfin/function/SpecialFunctions.h', 'submodule': 'function', 'derived': [], 'bases': ['Variable', 'ufc::function', 'Expression', 'GenericFunction'], 'module': 'function'}),
('SpecialFacetFunction', {'header': 'dolfin/function/SpecialFacetFunction.h', 'submodule': 'function', 'derived': [], 'bases': ['Variable', 'ufc::function', 'Expression', 'GenericFunction'], 'module': 'function'}),
('MultiMeshFunction', {'header': 'dolfin/function/MultiMeshFunction.h', 'submodule': 'function', 'derived': [], 'bases': [], 'module': 'function'}),
('MultiMeshFunctionSpace', {'header': 'dolfin/function/MultiMeshFunctionSpace.h', 'submodule': 'function', 'derived': ['MultiMeshSubSpace'], 'bases': ['Variable'], 'module': 'function'}),
('MultiMeshSubSpace', {'header': 'dolfin/function/MultiMeshSubSpace.h', 'submodule': 'function', 'derived': [], 'bases': ['MultiMeshFunctionSpace', 'Variable'], 'module': 'function'}),
('FunctionAssigner', {'header': 'dolfin/function/FunctionAssigner.h', 'submodule': 'function', 'derived': [], 'bases': [], 'module': 'function'}),
('LagrangeInterpolator', {'header': 'dolfin/function/LagrangeInterpolator.h', 'submodule': 'function', 'derived': [], 'bases': [], 'module': 'function'}),
('lt_coordinate', {'header': 'dolfin/function/LagrangeInterpolator.h', 'submodule': 'function', 'derived': [], 'bases': [], 'module': 'function'}),
('Lagrange', {'header': 'dolfin/math/Lagrange.h', 'submodule': 'math', 'derived': [], 'bases': ['Variable'], 'module': 'function'}),
('Legendre', {'header': 'dolfin/math/Legendre.h', 'submodule': 'math', 'derived': [], 'bases': [], 'module': 'function'}),
('ALE', {'header': 'dolfin/ale/ALE.h', 'submodule': 'ale', 'derived': [], 'bases': [], 'module': 'function'}),
('MeshDisplacement', {'header': 'dolfin/ale/MeshDisplacement.h', 'submodule': 'ale', 'derived': [], 'bases': ['Variable', 'ufc::function', 'Expression', 'GenericFunction'], 'module': 'function'}),
('GenericDofMap', {'header': 'dolfin/fem/GenericDofMap.h', 'submodule': 'fem', 'derived': ['DofMap'], 'bases': ['Variable'], 'module': 'fem'}),
('DofMap', {'header': 'dolfin/fem/DofMap.h', 'submodule': 'fem', 'derived': [], 'bases': ['Variable', 'GenericDofMap'], 'module': 'fem'}),
('Equation', {'header': 'dolfin/fem/Equation.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('FiniteElement', {'header': 'dolfin/fem/FiniteElement.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('BasisFunction', {'header': 'dolfin/fem/BasisFunction.h', 'submodule': 'fem', 'derived': [], 'bases': ['ufc::function'], 'module': 'fem'}),
('DirichletBC', {'header': 'dolfin/fem/DirichletBC.h', 'submodule': 'fem', 'derived': [], 'bases': ['Variable', 'Hierarchical'], 'module': 'fem'}),
('PointSource', {'header': 'dolfin/fem/PointSource.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('LocalSolver', {'header': 'dolfin/fem/LocalSolver.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('Form', {'header': 'dolfin/fem/Form.h', 'submodule': 'fem', 'derived': ['GoalFunctional'], 'bases': ['Hierarchical'], 'module': 'fem'}),
('AssemblerBase', {'header': 'dolfin/fem/AssemblerBase.h', 'submodule': 'fem', 'derived': ['SystemAssembler', 'MultiMeshAssembler', 'Assembler', 'OpenMpAssembler'], 'bases': [], 'module': 'fem'}),
('Assembler', {'header': 'dolfin/fem/Assembler.h', 'submodule': 'fem', 'derived': [], 'bases': ['AssemblerBase'], 'module': 'fem'}),
('SparsityPatternBuilder', {'header': 'dolfin/fem/SparsityPatternBuilder.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('SystemAssembler', {'header': 'dolfin/fem/SystemAssembler.h', 'submodule': 'fem', 'derived': [], 'bases': ['AssemblerBase'], 'module': 'fem'}),
('LinearVariationalProblem', {'header': 'dolfin/fem/LinearVariationalProblem.h', 'submodule': 'fem', 'derived': [], 'bases': ['Hierarchical'], 'module': 'fem'}),
('LinearVariationalSolver', {'header': 'dolfin/fem/LinearVariationalSolver.h', 'submodule': 'fem', 'derived': [], 'bases': ['Variable'], 'module': 'fem'}),
('NonlinearVariationalProblem', {'header': 'dolfin/fem/NonlinearVariationalProblem.h', 'submodule': 'fem', 'derived': [], 'bases': ['Hierarchical'], 'module': 'fem'}),
('NonlinearVariationalSolver', {'header': 'dolfin/fem/NonlinearVariationalSolver.h', 'submodule': 'fem', 'derived': [], 'bases': ['Variable'], 'module': 'fem'}),
('MultiMeshAssembler', {'header': 'dolfin/fem/MultiMeshAssembler.h', 'submodule': 'fem', 'derived': [], 'bases': ['AssemblerBase'], 'module': 'fem'}),
('MultiMeshDirichletBC', {'header': 'dolfin/fem/MultiMeshDirichletBC.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('MultiMeshDofMap', {'header': 'dolfin/fem/MultiMeshDofMap.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('MultiMeshForm', {'header': 'dolfin/fem/MultiMeshForm.h', 'submodule': 'fem', 'derived': [], 'bases': [], 'module': 'fem'}),
('OpenMpAssembler', {'header': 'dolfin/fem/OpenMpAssembler.h', 'submodule': 'fem', 'derived': [], 'bases': ['AssemblerBase'], 'module': 'fem'}),
('MultiStageScheme', {'header': 'dolfin/multistage/MultiStageScheme.h', 'submodule': 'multistage', 'derived': [], 'bases': ['Variable'], 'module': 'fem'}),
('RKSolver', {'header': 'dolfin/multistage/RKSolver.h', 'submodule': 'multistage', 'derived': [], 'bases': [], 'module': 'fem'}),
('PointIntegralSolver', {'header': 'dolfin/multistage/PointIntegralSolver.h', 'submodule': 'multistage', 'derived': [], 'bases': ['Variable'], 'module': 'fem'}),
('GenericAdaptiveVariationalSolver', {'header': 'dolfin/adaptivity/GenericAdaptiveVariationalSolver.h', 'submodule': 'adaptivity', 'derived': ['AdaptiveLinearVariationalSolver', 'AdaptiveNonlinearVariationalSolver'], 'bases': ['Variable'], 'module': 'fem'}),
('AdaptiveLinearVariationalSolver', {'header': 'dolfin/adaptivity/AdaptiveLinearVariationalSolver.h', 'submodule': 'adaptivity', 'derived': [], 'bases': ['Variable', 'GenericAdaptiveVariationalSolver'], 'module': 'fem'}),
('AdaptiveNonlinearVariationalSolver', {'header': 'dolfin/adaptivity/AdaptiveNonlinearVariationalSolver.h', 'submodule': 'adaptivity', 'derived': [], 'bases': ['Variable', 'GenericAdaptiveVariationalSolver'], 'module': 'fem'}),
('GoalFunctional', {'header': 'dolfin/adaptivity/GoalFunctional.h', 'submodule': 'adaptivity', 'derived': [], 'bases': ['Hierarchical', 'Form'], 'module': 'fem'}),
('ErrorControl', {'header': 'dolfin/adaptivity/ErrorControl.h', 'submodule': 'adaptivity', 'derived': [], 'bases': ['Variable', 'Hierarchical'], 'module': 'fem'}),
('Extrapolation', {'header': 'dolfin/adaptivity/Extrapolation.h', 'submodule': 'adaptivity', 'derived': [], 'bases': [], 'module': 'fem'}),
('LocalAssembler', {'header': 'dolfin/adaptivity/LocalAssembler.h', 'submodule': 'adaptivity', 'derived': [], 'bases': [], 'module': 'fem'}),
('TimeSeries', {'header': 'dolfin/adaptivity/TimeSeries.h', 'submodule': 'adaptivity', 'derived': [], 'bases': ['Variable'], 'module': 'fem'}),
('VTKPlotter', {'header': 'dolfin/plot/VTKPlotter.h', 'submodule': 'plot', 'derived': [], 'bases': ['Variable'], 'module': 'io'}),
('GenericFile', {'header': 'dolfin/io/GenericFile.h', 'submodule': 'io', 'derived': ['XDMFFile'], 'bases': [], 'module': 'io'}),
('File', {'header': 'dolfin/io/File.h', 'submodule': 'io', 'derived': [], 'bases': [], 'module': 'io'}),
('XDMFFile', {'header': 'dolfin/io/XDMFFile.h', 'submodule': 'io', 'derived': [], 'bases': ['Variable', 'GenericFile'], 'module': 'io'}),
('HDF5File', {'header': 'dolfin/io/HDF5File.h', 'submodule': 'io', 'derived': [], 'bases': ['Variable'], 'module': 'io'}),
('HDF5Attribute', {'header': 'dolfin/io/HDF5Attribute.h', 'submodule': 'io', 'derived': [], 'bases': [], 'module': 'io'}),])

# A map between modules and its submodules
module_to_submodules = OrderedDict([\
('common', ['common', 'parameter', 'log']),
('mesh', ['mesh', 'generation', 'geometry', 'refinement', 'graph']),
('la', ['la', 'nls']),
('function', ['function', 'math', 'ale']),
('fem', ['fem', 'multistage', 'adaptivity']),
('io', ['plot', 'io']),])

# A reverse map between submodules and modules
submodule_info = OrderedDict([\
('common', {'headers': ['dolfin/common/init.h', 'dolfin/common/defines.h', 'dolfin/common/version.h', 'dolfin/common/types.h', 'dolfin/common/constants.h', 'dolfin/common/timing.h', 'dolfin/common/Array.h', 'dolfin/common/ArrayView.h', 'dolfin/common/IndexSet.h', 'dolfin/common/Set.h', 'dolfin/common/Timer.h', 'dolfin/common/Variable.h', 'dolfin/common/Hierarchical.h', 'dolfin/common/MPI.h', 'dolfin/common/SubSystemsManager.h'], 'has_post': True, 'module': 'common', 'has_pre': True}),
('parameter', {'headers': ['dolfin/parameter/Parameter.h', 'dolfin/parameter/Parameters.h', 'dolfin/parameter/GlobalParameters.h'], 'has_post': True, 'module': 'common', 'has_pre': True}),
('log', {'headers': ['dolfin/log/log.h', 'dolfin/log/Event.h', 'dolfin/log/Progress.h', 'dolfin/log/Table.h', 'dolfin/log/LogLevel.h'], 'has_post': True, 'module': 'common', 'has_pre': True}),
('mesh', {'headers': ['dolfin/mesh/CellType.h', 'dolfin/mesh/MeshTopology.h', 'dolfin/mesh/MeshGeometry.h', 'dolfin/mesh/MeshDomains.h', 'dolfin/mesh/MeshData.h', 'dolfin/mesh/Mesh.h', 'dolfin/mesh/MeshEntity.h', 'dolfin/mesh/MeshEntityIterator.h', 'dolfin/mesh/MeshEntityIteratorBase.h', 'dolfin/mesh/SubsetIterator.h', 'dolfin/mesh/Vertex.h', 'dolfin/mesh/Edge.h', 'dolfin/mesh/Face.h', 'dolfin/mesh/Facet.h', 'dolfin/mesh/Cell.h', 'dolfin/mesh/FacetCell.h', 'dolfin/mesh/MeshConnectivity.h', 'dolfin/mesh/MeshEditor.h', 'dolfin/mesh/DynamicMeshEditor.h', 'dolfin/mesh/LocalMeshValueCollection.h', 'dolfin/mesh/MeshFunction.h', 'dolfin/mesh/MeshValueCollection.h', 'dolfin/mesh/MeshColoring.h', 'dolfin/mesh/MeshRenumbering.h', 'dolfin/mesh/MeshTransformation.h', 'dolfin/mesh/LocalMeshData.h', 'dolfin/mesh/SubDomain.h', 'dolfin/mesh/SubMesh.h', 'dolfin/mesh/Restriction.h', 'dolfin/mesh/DomainBoundary.h', 'dolfin/mesh/BoundaryMesh.h', 'dolfin/mesh/PeriodicBoundaryComputation.h', 'dolfin/mesh/MeshQuality.h', 'dolfin/mesh/MultiMesh.h', 'dolfin/mesh/MeshHierarchy.h', 'dolfin/mesh/MeshPartitioning.h'], 'has_post': True, 'module': 'mesh', 'has_pre': True}),
('generation', {'headers': ['dolfin/generation/BoxMesh.h', 'dolfin/generation/IntervalMesh.h', 'dolfin/generation/RectangleMesh.h', 'dolfin/generation/UnitTetrahedronMesh.h', 'dolfin/generation/UnitCubeMesh.h', 'dolfin/generation/UnitIntervalMesh.h', 'dolfin/generation/UnitTriangleMesh.h', 'dolfin/generation/UnitSquareMesh.h', 'dolfin/generation/UnitQuadMesh.h', 'dolfin/generation/UnitHexMesh.h'], 'has_post': True, 'module': 'mesh', 'has_pre': False}),
('geometry', {'headers': ['dolfin/geometry/Point.h', 'dolfin/geometry/BoundingBoxTree.h', 'dolfin/geometry/GenericBoundingBoxTree.h', 'dolfin/geometry/BoundingBoxTree3D.h', 'dolfin/geometry/MeshPointIntersection.h', 'dolfin/geometry/intersect.h'], 'has_post': True, 'module': 'mesh', 'has_pre': True}),
('refinement', {'headers': ['dolfin/refinement/refine.h'], 'has_post': False, 'module': 'mesh', 'has_pre': False}),
('graph', {'headers': ['dolfin/graph/Graph.h', 'dolfin/graph/GraphBuilder.h', 'dolfin/graph/BoostGraphOrdering.h', 'dolfin/graph/SCOTCH.h'], 'has_post': True, 'module': 'mesh', 'has_pre': False}),
('la', {'headers': ['dolfin/la/LinearAlgebraObject.h', 'dolfin/la/GenericLinearOperator.h', 'dolfin/la/GenericTensor.h', 'dolfin/la/GenericMatrix.h', 'dolfin/la/GenericSparsityPattern.h', 'dolfin/la/GenericVector.h', 'dolfin/la/VectorSpaceBasis.h', 'dolfin/la/GenericLinearSolver.h', 'dolfin/la/GenericLUSolver.h', 'dolfin/la/GenericPreconditioner.h', 'dolfin/la/PETScOptions.h', 'dolfin/la/PETScObject.h', 'dolfin/la/PETScBaseMatrix.h', 'dolfin/la/EigenMatrix.h', 'dolfin/la/PETScMatrix.h', 'dolfin/la/PETScLinearOperator.h', 'dolfin/la/PETScPreconditioner.h', 'dolfin/la/TpetraMatrix.h', 'dolfin/la/EigenKrylovSolver.h', 'dolfin/la/EigenLUSolver.h', 'dolfin/la/PETScKrylovSolver.h', 'dolfin/la/PETScLUSolver.h', 'dolfin/la/BelosKrylovSolver.h', 'dolfin/la/MUMPSLUSolver.h', 'dolfin/la/PaStiXLUSolver.h', 'dolfin/la/STLMatrix.h', 'dolfin/la/CoordinateMatrix.h', 'dolfin/la/EigenVector.h', 'dolfin/la/PETScVector.h', 'dolfin/la/TpetraVector.h', 'dolfin/la/TensorLayout.h', 'dolfin/la/SparsityPattern.h', 'dolfin/la/GenericLinearAlgebraFactory.h', 'dolfin/la/DefaultFactory.h', 'dolfin/la/EigenFactory.h', 'dolfin/la/PETScUserPreconditioner.h', 'dolfin/la/PETScFactory.h', 'dolfin/la/STLFactory.h', 'dolfin/la/SLEPcEigenSolver.h', 'dolfin/la/Vector.h', 'dolfin/la/Matrix.h', 'dolfin/la/Scalar.h', 'dolfin/la/LinearSolver.h', 'dolfin/la/KrylovSolver.h', 'dolfin/la/LUSolver.h', 'dolfin/la/solve.h', 'dolfin/la/test_nullspace.h', 'dolfin/la/BlockVector.h', 'dolfin/la/BlockMatrix.h', 'dolfin/la/LinearOperator.h'], 'has_post': True, 'module': 'la', 'has_pre': True}),
('nls', {'headers': ['dolfin/nls/NonlinearProblem.h', 'dolfin/nls/NewtonSolver.h', 'dolfin/nls/OptimisationProblem.h', 'dolfin/nls/PETScSNESSolver.h', 'dolfin/nls/PETScTAOSolver.h', 'dolfin/nls/TAOLinearBoundSolver.h'], 'has_post': False, 'module': 'la', 'has_pre': True}),
('function', {'headers': ['dolfin/function/GenericFunction.h', 'dolfin/function/Expression.h', 'dolfin/function/FunctionAXPY.h', 'dolfin/function/Function.h', 'dolfin/function/FunctionSpace.h', 'dolfin/function/SubSpace.h', 'dolfin/function/Constant.h', 'dolfin/function/SpecialFunctions.h', 'dolfin/function/SpecialFacetFunction.h', 'dolfin/function/MultiMeshFunction.h', 'dolfin/function/MultiMeshFunctionSpace.h', 'dolfin/function/MultiMeshSubSpace.h', 'dolfin/function/FunctionAssigner.h', 'dolfin/function/assign.h', 'dolfin/function/LagrangeInterpolator.h'], 'has_post': True, 'module': 'function', 'has_pre': True}),
('math', {'headers': ['dolfin/math/basic.h', 'dolfin/math/Lagrange.h', 'dolfin/math/Legendre.h'], 'has_post': False, 'module': 'function', 'has_pre': False}),
('ale', {'headers': ['dolfin/ale/ALE.h', 'dolfin/ale/MeshDisplacement.h'], 'has_post': False, 'module': 'function', 'has_pre': True}),
('fem', {'headers': ['dolfin/fem/GenericDofMap.h', 'dolfin/fem/DofMap.h', 'dolfin/fem/fem_utils.h', 'dolfin/fem/Equation.h', 'dolfin/fem/FiniteElement.h', 'dolfin/fem/BasisFunction.h', 'dolfin/fem/DirichletBC.h', 'dolfin/fem/PointSource.h', 'dolfin/fem/assemble.h', 'dolfin/fem/LocalSolver.h', 'dolfin/fem/solve.h', 'dolfin/fem/Form.h', 'dolfin/fem/AssemblerBase.h', 'dolfin/fem/Assembler.h', 'dolfin/fem/SparsityPatternBuilder.h', 'dolfin/fem/SystemAssembler.h', 'dolfin/fem/LinearVariationalProblem.h', 'dolfin/fem/LinearVariationalSolver.h', 'dolfin/fem/NonlinearVariationalProblem.h', 'dolfin/fem/NonlinearVariationalSolver.h', 'dolfin/fem/MultiMeshAssembler.h', 'dolfin/fem/MultiMeshDirichletBC.h', 'dolfin/fem/MultiMeshDofMap.h', 'dolfin/fem/MultiMeshForm.h', 'dolfin/fem/OpenMpAssembler.h'], 'has_post': True, 'module': 'fem', 'has_pre': True}),
('multistage', {'headers': ['dolfin/multistage/MultiStageScheme.h', 'dolfin/multistage/RKSolver.h', 'dolfin/multistage/PointIntegralSolver.h'], 'has_post': False, 'module': 'fem', 'has_pre': True}),
('adaptivity', {'headers': ['dolfin/adaptivity/GenericAdaptiveVariationalSolver.h', 'dolfin/adaptivity/AdaptiveLinearVariationalSolver.h', 'dolfin/adaptivity/AdaptiveNonlinearVariationalSolver.h', 'dolfin/adaptivity/GoalFunctional.h', 'dolfin/adaptivity/ErrorControl.h', 'dolfin/adaptivity/Extrapolation.h', 'dolfin/adaptivity/LocalAssembler.h', 'dolfin/adaptivity/TimeSeries.h', 'dolfin/adaptivity/adapt.h', 'dolfin/adaptivity/marking.h', 'dolfin/adaptivity/adaptivesolve.h'], 'has_post': True, 'module': 'fem', 'has_pre': True}),
('plot', {'headers': ['dolfin/plot/plot.h', 'dolfin/plot/VTKPlotter.h'], 'has_post': False, 'module': 'io', 'has_pre': True}),
('io', {'headers': ['dolfin/io/GenericFile.h', 'dolfin/io/File.h', 'dolfin/io/XDMFFile.h', 'dolfin/io/HDF5File.h', 'dolfin/io/HDF5Attribute.h'], 'has_post': True, 'module': 'io', 'has_pre': True}),])
