// License: GPL. For details, see LICENSE file.
package org.openstreetmap.josm.gui.preferences.display;

import static org.junit.Assert.assertNotNull;

import org.junit.BeforeClass;
import org.junit.Test;
import org.openstreetmap.josm.JOSMFixture;
import org.openstreetmap.josm.gui.preferences.PreferencesTestUtils;

/**
 * Unit tests of {@link ColorPreference} class.
 */
public class ColorPreferenceTest {

    /**
     * Setup test.
     */
    @BeforeClass
    public static void setUpBeforeClass() {
        JOSMFixture.createUnitTestFixture().init();
    }

    /**
     * Unit test of {@link ColorPreference#ColorPreference}.
     */
    @Test
    public void testColorPreference()  {
        assertNotNull(new ColorPreference.Factory().createPreferenceSetting());
    }

    /**
     * Unit test of {@link ColorPreference#addGui}.
     */
    @Test
    public void testAddGui() {
        PreferencesTestUtils.doTestPreferenceSettingAddGui(new ColorPreference.Factory(), DisplayPreference.class);
    }
}
