#ifndef TXWIDGET_H
#define TXWIDGET_H

#include <QWidget>
#include "imageviewer.h"
#include "sstvparam.h"
#include "editor/editor.h"
#include "editor/editorscene.h"


namespace Ui {
    class txWidget;
}

class txWidget : public QWidget
{
    Q_OBJECT

public:
  explicit txWidget(QWidget *parent = 0);
    ~txWidget();
  void init();
  void writeSettings();
  void readSettings();
  imageViewer *getImagePtr();
  void repeat(QImage *im,esstvMode sm);
  void setImage(QImage *ima);
  void setImage(QString fn);
  void setProgress(uint prg);
  void setupTemplatesComboBox();
  void setPreviewWidget(QString fn)
;
  QString toCall;
  QString toOperator;
  QString rsv;
  QString comment1;
  QString comment2;
  QString comment3;

public slots:
  void slotGetParams();
  void slotStartTX();
  void slotStopTX();
  void slotDisplayStatusMessage(QString);
  void slotGenerateSignal();
  void slotSweepSignal();
  void slotGenerateRepeaterTone();
  void slotEdit();
//  void slotReplay();
  void slotRepeaterTimer();
  void slotFileOpen();
  void slotModeChanged(int);
  void slotSnapshot();

private:
    Ui::txWidget *ui;
    void initView();
    void setParams();
    editor *ed;
    QTimer *repeaterTimer;
    int repeaterIndex;
    QImage *origImage;
    QImage *resultImage;
    void applyTemplate();
    void addConversion(editorScene &tscene,QChar tag,QString value);
};

#endif // TXWIDGET_H







