/***************************************************************************
 *   Copyright (C) 2005 by Johan Maes   *
 *   on4qz@telenet.be   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 *                                                                         *
 *   In addition, as a special exception, the copyright holders give       *
 *   permission to link the code of this program with any edition of       *
 *   the Qt library by Trolltech AS, Norway (or with modified versions     *
 *   of Qt that use the same license as Qt), and distribute linked         *
 *   combinations including the two.  You must obey the GNU General        *
 *   Public License in all respects for all of the code used other than    *
 *   Qt.  If you modify this file, you may extend this exception to        *
 *   your version of the file, but you are not obligated to do so.  If     *
 *   you do not wish to do so, delete this exception statement from        *
 *   your version.                                                         *
 ***************************************************************************/
#include "scopeview.h"




scopeView::scopeView(QString title) : scopePlot(title)
{
  xOffset=0;
	init();
}


scopeView::~scopeView()
{
}

void scopeView::init()
{
	int i;
	index=0;
	for (i=0;i<SCOPEMAXDATA;i++)
		{
			array1[i]=0.;
			array2[i]=0.;
			array3[i]=0.;
      array4[i]=0.;
		}
  setCurveName("data1",SCDATA1);
  setCurveName("data2",SCDATA2);
  setCurveName("data3",SCDATA3);
  setCurveName("data4",SCDATA4);

}

void scopeView::setOffset (int xoffset)
{
  xOffset=xoffset;
  scopePlot::setOffset(xOffset);
}



void scopeView::addData1(DSPFLOAT *data,unsigned int position,unsigned int len)
{
  unsigned int i,j;
  if((position<xOffset) || ((position+len-xOffset)>=SCOPEMAXDATA)) return;
  for(i=position-xOffset,j=0;i<(position+len-xOffset);i++,j++)
    {
      array1[i]=(double)data[j];
    }
  index=i;
  addToLog(QString("data1 %1").arg(index+xOffset),LOGSCOPE);
}

void scopeView::addData1(int *data,unsigned int position,unsigned int len)
{
  unsigned int i,j;
  if((position<xOffset) || ((position+len-xOffset)>=SCOPEMAXDATA)) return;
  for(i=position-xOffset,j=0;i<(position+len-xOffset);i++,j++)
    {
      array1[i]=(double)data[j];
    }
  index=i;
  addToLog(QString("data1 %1").arg(index+xOffset),LOGSCOPE);
}


void scopeView::addData2(unsigned char *data,unsigned int position,unsigned int len)
{
  unsigned int i,j;
  if((position<xOffset) || ((position+len-xOffset)>=SCOPEMAXDATA)) return;
  for(i=position-xOffset,j=0;i<(position+len-xOffset);i++,j++)
    {
      array2[i]=(double)data[j];
    }
  index=i;
  addToLog(QString("data2 %1").arg(index+xOffset),LOGSCOPE);
}

void scopeView::addData2(DSPFLOAT *data,unsigned int position,unsigned int len)
{
  unsigned int i,j;
  if((position<xOffset) || ((position+len-xOffset)>=SCOPEMAXDATA)) return;
  for(i=position-xOffset,j=0;i<(position+len-xOffset);i++,j++)
    {
      array2[i]=(double)data[j];
    }
  index=i;
  addToLog(QString("data2 %1").arg(index+xOffset),LOGSCOPE);
}

void scopeView::addData2(int *data,unsigned int position,unsigned int len)
{
  unsigned int i,j;
  if((position<xOffset) || ((position+len-xOffset)>=SCOPEMAXDATA)) return;
  for(i=position-xOffset,j=0;i<(position+len-xOffset);i++,j++)
    {
      array2[i]=(double)data[j];
    }
  index=i;
  addToLog(QString("data2 %1").arg(index+xOffset),LOGSCOPE);
}

void scopeView::addData3(unsigned char *data,unsigned int position,unsigned int len)
{
  unsigned int i,j;
  if((position<xOffset) || ((position+len-xOffset)>=SCOPEMAXDATA)) return;
  for(i=position-xOffset,j=0;i<(position+len-xOffset);i++,j++)
    {
      array3[i]=(double)data[j];
    }
  index=i;
  addToLog(QString("data3 %1").arg(index+xOffset),LOGSCOPE);
}

void scopeView::addData3(int *data,unsigned int position,unsigned int len)
{
  unsigned int i,j;
  if((position<xOffset) || ((position+len-xOffset)>=SCOPEMAXDATA)) return;
  for(i=position-xOffset,j=0;i<(position+len-xOffset);i++,j++)
    {
      array3[i]=(double)data[j];
    }
  index=i;
  addToLog(QString("data3 %1").arg(index+xOffset),LOGSCOPE);
}


void scopeView::addData3(short *data,unsigned int position,unsigned int len)
{
  unsigned int i,j;
  if((position<xOffset) || ((position+len-xOffset)>=SCOPEMAXDATA)) return;
  for(i=position-xOffset,j=0;i<(position+len-xOffset);i++,j++)
    {
      array3[i]=(double)data[j];
    }
  index=i;
  addToLog(QString("data3 %1").arg(index+xOffset),LOGSCOPE);
}

void scopeView::addData3(DSPFLOAT *data,unsigned int position,unsigned int len)
{
  unsigned int i,j;
  if((position<xOffset) || ((position+len-xOffset)>=SCOPEMAXDATA)) return;
  for(i=position-xOffset,j=0;i<(position+len-xOffset);i++,j++)
    {
      array3[i]=(double)data[j];
    }
  index=i;
  addToLog(QString("data3 %1").arg(index+xOffset),LOGSCOPE);
}

void scopeView::addData4(DSPFLOAT *data,unsigned int position,unsigned int len)
{
  unsigned int i,j;
  if((position<xOffset) || ((position+len-xOffset)>=SCOPEMAXDATA)) return;
  for(i=position-xOffset,j=0;i<(position+len-xOffset);i++,j++)
    {
      array4[i]=(double)data[j];
    }
  index=i;
  addToLog(QString("data4 %1").arg(index+xOffset),LOGSCOPE);
}

void scopeView::addData4(int *data,unsigned int position,unsigned int len)
{
  unsigned int i,j;
  if((position<xOffset) || ((position+len-xOffset)>=SCOPEMAXDATA)) return;
  for(i=position-xOffset,j=0;i<(position+len-xOffset);i++,j++)
    {
      array4[i]=(double)data[j];
    }
  index=i;
  addToLog(QString("data4 %1").arg(index+xOffset),LOGSCOPE);
}

void scopeView::setCurveName(QString title,int idx)
{
  if((idx>=0)&&(idx<=SCDATA4))
  {
      curveNameArray[idx]=title;
  }
}
void scopeView::show(bool d1,bool d2,bool d3,bool d4)
{
	if(d1)
		{
      plot1D(array1,index,curveNameArray[SCDATA1],yLeftTitle);
		}
	if(d2)
		{
     addYR(array2,index,curveNameArray[SCDATA2],yRightTitle);
		}
	if (d3)
		{
     add3(array3,index,curveNameArray[SCDATA3]);
		}
  if (d4)
    {
     add4(array4,index,curveNameArray[SCDATA4]);
    }

	scopePlot::show();
}
